/*
 * Decompiled with CFR 0.152.
 */
package com.qqt.pool.common.sourcepool;

import com.qqt.pool.common.sourcepool.LocalPoolRoute;
import com.qqt.pool.common.utils.SpringApplicationContextUtils;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.List;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.annotation.Around;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.annotation.Pointcut;
import org.aspectj.lang.reflect.MethodSignature;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Component;

@Component
@Aspect
public class LocalPoolRouteAspect {
    private final Logger log = LoggerFactory.getLogger(LocalPoolRouteAspect.class);
    @Value(value="${localSourcePool.switch:false}")
    private Boolean isSwitch;

    @Pointcut(value="@annotation(com.qqt.pool.common.sourcepool.LocalPoolRoute)")
    public void point() {
    }

    @Around(value="point()")
    public Object process(ProceedingJoinPoint pjp) throws Throwable {
        Object proceed = null;
        Object[] args = pjp.getArgs();
        MethodSignature signature = (MethodSignature)pjp.getSignature();
        Method signatureMethod = signature.getMethod();
        String methodName = pjp.getSignature().getName();
        LocalPoolRoute sourcePoolRoute = signatureMethod.getAnnotation(LocalPoolRoute.class);
        if (this.isSwitch.booleanValue() && sourcePoolRoute.dispatchClass() != Void.class) {
            Class<?> aClass = sourcePoolRoute.dispatchClass();
            Object obj = SpringApplicationContextUtils.getBean(aClass);
            Method method = aClass.getMethod(methodName, this.getClassArray(args));
            proceed = method.invoke(obj, pjp.getArgs());
        } else {
            proceed = pjp.proceed(args);
        }
        return proceed;
    }

    private Class[] getClassArray(Object[] args) {
        List<Object> result = Arrays.asList(args);
        Class[] classes = new Class[args.length];
        for (int i = 0; i < result.size(); ++i) {
            classes[i] = result.get(i).getClass();
        }
        return classes;
    }
}

