/*
 * Decompiled with CFR 0.152.
 */
package com.qqt.pool.common.utils;

import java.lang.annotation.Annotation;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import net.logstash.logback.encoder.org.apache.commons.lang3.StringUtils;
import org.springframework.core.BridgeMethodResolver;
import org.springframework.core.DefaultParameterNameDiscoverer;
import org.springframework.core.MethodParameter;
import org.springframework.core.ParameterNameDiscoverer;
import org.springframework.core.annotation.AnnotatedElementUtils;
import org.springframework.core.annotation.SynthesizingMethodParameter;
import org.springframework.util.ClassUtils;
import org.springframework.web.method.HandlerMethod;

public class ClassUtil
extends ClassUtils {
    private static final ParameterNameDiscoverer PARAMETER_NAME_DISCOVERER = new DefaultParameterNameDiscoverer();

    public static MethodParameter getMethodParameter(Constructor<?> constructor, int parameterIndex) {
        SynthesizingMethodParameter methodParameter = new SynthesizingMethodParameter(constructor, parameterIndex);
        methodParameter.initParameterNameDiscovery(PARAMETER_NAME_DISCOVERER);
        return methodParameter;
    }

    public static MethodParameter getMethodParameter(Method method, int parameterIndex) {
        SynthesizingMethodParameter methodParameter = new SynthesizingMethodParameter(method, parameterIndex);
        methodParameter.initParameterNameDiscovery(PARAMETER_NAME_DISCOVERER);
        return methodParameter;
    }

    public static <A extends Annotation> A getAnnotation(Method method, Class<A> annotationType) {
        Class<?> targetClass = method.getDeclaringClass();
        Method specificMethod = ClassUtil.getMostSpecificMethod((Method)method, targetClass);
        Annotation annotation = AnnotatedElementUtils.findMergedAnnotation((AnnotatedElement)(specificMethod = BridgeMethodResolver.findBridgedMethod((Method)specificMethod)), annotationType);
        if (null != annotation) {
            return (A)annotation;
        }
        return (A)AnnotatedElementUtils.findMergedAnnotation(specificMethod.getDeclaringClass(), annotationType);
    }

    public static <A extends Annotation> A getAnnotation(HandlerMethod handlerMethod, Class<A> annotationType) {
        Annotation annotation = handlerMethod.getMethodAnnotation(annotationType);
        if (null != annotation) {
            return (A)annotation;
        }
        Class beanType = handlerMethod.getBeanType();
        return (A)AnnotatedElementUtils.findMergedAnnotation((AnnotatedElement)beanType, annotationType);
    }

    public static <A extends Annotation> boolean isAnnotated(Method method, Class<A> annotationType) {
        boolean isMethodAnnotated = AnnotatedElementUtils.isAnnotated((AnnotatedElement)method, annotationType);
        if (isMethodAnnotated) {
            return true;
        }
        Class<?> targetClass = method.getDeclaringClass();
        return AnnotatedElementUtils.isAnnotated(targetClass, annotationType);
    }

    public static void checkObjAllFieldsIsNull(Object object1, Object object2) {
        if (null == object1) {
            object1 = object2;
            return;
        }
        try {
            for (Field f1 : object1.getClass().getDeclaredFields()) {
                f1.setAccessible(true);
                String fieldName = f1.getName();
                if (!Objects.isNull(f1.get(object1))) continue;
                for (Field f2 : object2.getClass().getDeclaredFields()) {
                    f2.setAccessible(true);
                    if (!fieldName.equals(f2.getName()) || f2.get(object2) == null || !StringUtils.isNotBlank((CharSequence)f2.get(object2).toString())) continue;
                    f1.set(object1, f2.get(object2));
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static <T> List<T> convertListMapToList(List<Map<String, String>> listMap, Class<T> clazz) throws Exception {
        ArrayList<T> list = new ArrayList<T>();
        for (Map<String, String> map : listMap) {
            T obj = clazz.newInstance();
            for (Map.Entry<String, String> entry : map.entrySet()) {
                Field field = clazz.getDeclaredField(entry.getKey());
                field.setAccessible(true);
                if (field.getType() == Integer.TYPE) {
                    field.setInt(obj, Integer.parseInt(entry.getValue()));
                    continue;
                }
                if (field.getType() == Double.TYPE) {
                    field.setDouble(obj, Double.parseDouble(entry.getValue()));
                    continue;
                }
                if (field.getType() == Float.TYPE) {
                    field.setFloat(obj, Float.parseFloat(entry.getValue()));
                    continue;
                }
                if (field.getType() == Long.TYPE) {
                    field.setLong(obj, Long.parseLong(entry.getValue()));
                    continue;
                }
                if (field.getType() == Short.TYPE) {
                    field.setShort(obj, Short.parseShort(entry.getValue()));
                    continue;
                }
                if (field.getType() == Byte.TYPE) {
                    field.setByte(obj, Byte.parseByte(entry.getValue()));
                    continue;
                }
                if (field.getType() == Boolean.TYPE) {
                    field.setBoolean(obj, Boolean.parseBoolean(entry.getValue()));
                    continue;
                }
                field.set(obj, entry.getValue());
            }
            list.add(obj);
        }
        return list;
    }
}

