/*
 * Decompiled with CFR 0.152.
 */
package com.qqt.pool.common.utils;

import com.alibaba.excel.EasyExcel;
import com.alibaba.excel.ExcelWriter;
import com.alibaba.excel.write.builder.ExcelWriterBuilder;
import com.alibaba.excel.write.handler.WriteHandler;
import com.alibaba.excel.write.metadata.style.WriteCellStyle;
import com.alibaba.excel.write.metadata.style.WriteFont;
import com.alibaba.excel.write.style.HorizontalCellStyleStrategy;
import com.alibaba.excel.write.style.column.LongestMatchColumnWidthStyleStrategy;
import com.qqt.pool.common.utils.ExcelMergeUtil;
import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.util.List;
import javax.servlet.http.HttpServletResponse;
import org.apache.poi.ss.usermodel.BorderStyle;
import org.apache.poi.ss.usermodel.HorizontalAlignment;
import org.apache.poi.ss.usermodel.VerticalAlignment;

public class EasyExcelUtils {
    private static final HorizontalCellStyleStrategy HORIZONTAL_CELL_STYLE_STRATEGY;

    public static <T> void export(HttpServletResponse response, List<T> data, String fileName, Class<T> t) {
        try {
            response.setContentType("application/octet-stream");
            response.setCharacterEncoding(StandardCharsets.UTF_8.name());
            response.setHeader("Content-disposition", "attachment;filename=" + URLEncoder.encode(fileName, "UTF-8") + ".xlsx");
            ((ExcelWriterBuilder)((ExcelWriterBuilder)EasyExcel.write((OutputStream)response.getOutputStream(), t).registerWriteHandler((WriteHandler)HORIZONTAL_CELL_STYLE_STRATEGY)).registerWriteHandler((WriteHandler)new LongestMatchColumnWidthStyleStrategy())).sheet(fileName).doWrite(data);
        }
        catch (Exception e) {
            response.reset();
            throw new RuntimeException("\u4e0b\u8f7d\u5931\u8d25");
        }
    }

    public static <T> ExcelWriter getExcelWriterNew(File file, Class<T> t) {
        FileOutputStream fileOutputStream = null;
        try {
            fileOutputStream = new FileOutputStream(file);
            return ((ExcelWriterBuilder)((ExcelWriterBuilder)EasyExcel.write((OutputStream)fileOutputStream, t).registerWriteHandler((WriteHandler)HORIZONTAL_CELL_STYLE_STRATEGY)).registerWriteHandler((WriteHandler)new LongestMatchColumnWidthStyleStrategy())).build();
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new RuntimeException("\u5bfc\u51fa\u6587\u4ef6\u5931\u8d25!");
        }
    }

    public static <T> ExcelWriter getExcelWriterNew(File file, Class<T> t, ExcelMergeUtil excelFillCellMergeStrategy) {
        FileOutputStream fileOutputStream = null;
        try {
            fileOutputStream = new FileOutputStream(file);
            if (excelFillCellMergeStrategy == null) {
                return ((ExcelWriterBuilder)((ExcelWriterBuilder)EasyExcel.write((OutputStream)fileOutputStream, t).registerWriteHandler((WriteHandler)HORIZONTAL_CELL_STYLE_STRATEGY)).registerWriteHandler((WriteHandler)new LongestMatchColumnWidthStyleStrategy())).build();
            }
            return ((ExcelWriterBuilder)((ExcelWriterBuilder)((ExcelWriterBuilder)EasyExcel.write((OutputStream)fileOutputStream, t).registerWriteHandler((WriteHandler)HORIZONTAL_CELL_STYLE_STRATEGY)).registerWriteHandler((WriteHandler)excelFillCellMergeStrategy)).registerWriteHandler((WriteHandler)new LongestMatchColumnWidthStyleStrategy())).build();
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new RuntimeException("\u5bfc\u51fa\u6587\u4ef6\u5931\u8d25!");
        }
    }

    static {
        WriteCellStyle headWriteCellStyle = new WriteCellStyle();
        WriteFont headWriteFont = new WriteFont();
        headWriteFont.setFontHeightInPoints(Short.valueOf((short)12));
        headWriteCellStyle.setWriteFont(headWriteFont);
        WriteCellStyle contentWriteCellStyle = new WriteCellStyle();
        contentWriteCellStyle.setBorderBottom(BorderStyle.THIN);
        contentWriteCellStyle.setBorderLeft(BorderStyle.THIN);
        contentWriteCellStyle.setBorderRight(BorderStyle.THIN);
        contentWriteCellStyle.setBorderTop(BorderStyle.THIN);
        contentWriteCellStyle.setHorizontalAlignment(HorizontalAlignment.CENTER);
        contentWriteCellStyle.setVerticalAlignment(VerticalAlignment.CENTER);
        WriteFont contentWriteFont = new WriteFont();
        contentWriteFont.setFontHeightInPoints(Short.valueOf((short)11));
        contentWriteCellStyle.setWriteFont(contentWriteFont);
        HORIZONTAL_CELL_STYLE_STRATEGY = new HorizontalCellStyleStrategy(headWriteCellStyle, contentWriteCellStyle);
    }
}

