/*
 * Decompiled with CFR 0.152.
 */
package com.qqt.pool.io.component;

import com.qqt.pool.io.bean.AttachmentBean;
import com.qqt.pool.io.bean.AttachmentBeanVO;
import com.qqt.pool.io.bean.BladeFile;
import com.qqt.pool.io.mapper.AttachmentMapper;
import com.qqt.pool.io.oss.alioss.AliossTemplate;
import java.time.Instant;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Component;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.web.multipart.MultipartFile;

@Component
@Transactional
public class AliossComponent {
    private Logger logger = LoggerFactory.getLogger(AliossComponent.class);
    @Resource
    private AliossTemplate aliossTemplate;
    @Resource
    private AttachmentMapper attachmentMapper;
    @Value(value="${io.ali.bucket:qqt-mall}")
    private String bucket;

    public AttachmentBeanVO uploadImg(MultipartFile file, String account, String bucketNamePrefix, String companyCode) {
        if (bucketNamePrefix == null) {
            bucketNamePrefix = this.bucket;
        }
        BladeFile bladeFile = this.aliossTemplate.putFile(file.getOriginalFilename(), file, bucketNamePrefix + "-" + companyCode);
        return this.doInsert(bladeFile, file, account, "N", 2, null);
    }

    public Long uploadAddFolder(MultipartFile file, String account, String taskId, String folder, String bucketNamePrefix, String companyCode) {
        if (bucketNamePrefix == null) {
            bucketNamePrefix = this.bucket;
        }
        BladeFile bladeFile = this.aliossTemplate.putFileAddFolder(file, folder, bucketNamePrefix + "-" + companyCode);
        AttachmentBeanVO attachmentBeanVO = this.doInsert(bladeFile, file, account, null, 1, taskId);
        return attachmentBeanVO.getId();
    }

    private AttachmentBeanVO doInsert(BladeFile bladeFile, MultipartFile file, String account, String watermark, int type, String taskId) {
        AttachmentBean attachment = new AttachmentBean();
        attachment.setTaskId(taskId);
        attachment.setFileName(bladeFile.getName());
        attachment.setFileSize(file.getSize());
        attachment.setCreateTime(Instant.now());
        attachment.setFilePath(bladeFile.getFilePath());
        attachment.setOriginalName(file.getOriginalFilename());
        attachment.setType(type);
        attachment.setCreateBy(account);
        attachment.setWatermark(watermark);
        this.attachmentMapper.save(attachment);
        this.logger.info("save attachment:{}", (Object)attachment);
        AttachmentBeanVO attachmentBeanVO = new AttachmentBeanVO();
        BeanUtils.copyProperties((Object)attachment, (Object)attachmentBeanVO);
        attachmentBeanVO.setUrl(bladeFile.getLink());
        return attachmentBeanVO;
    }
}

