/*
 * Decompiled with CFR 0.152.
 */
package com.qqt.pool.io.component;

import com.qqt.pool.io.bean.AttachmentBean;
import com.qqt.pool.io.bean.AttachmentBeanVO;
import com.qqt.pool.io.dto.CellInfo;
import com.qqt.pool.io.dto.ImportReport;
import com.qqt.pool.io.dto.ImportResult;
import com.qqt.pool.io.mapper.AttachmentMapper;
import io.minio.MinioClient;
import io.minio.PutObjectOptions;
import io.minio.Result;
import io.minio.errors.ErrorResponseException;
import io.minio.errors.InsufficientDataException;
import io.minio.errors.InternalException;
import io.minio.errors.InvalidBucketNameException;
import io.minio.errors.MinioException;
import io.minio.errors.XmlParserException;
import io.minio.messages.DeleteError;
import io.minio.messages.Item;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import javax.annotation.Resource;
import org.apache.commons.lang3.StringUtils;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Component;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.web.multipart.MultipartFile;

@Component
@Transactional
public class AttachmentComponent {
    private Logger logger = LoggerFactory.getLogger(AttachmentComponent.class);
    @Resource
    private AttachmentMapper attachmentMapper;
    @Value(value="${io.server}")
    private String server;
    @Value(value="${io.accessKey}")
    private String accessKey;
    @Value(value="${io.secretKey}")
    private String secretKey;
    private final String[] exclude = new String[]{"row", "columnOne", "columnTwo"};
    private static final String BUCKET_PUBLIC_POLICY = " {\n     \"Statement\": [\n         {\n             \"Action\": [\n                 \"s3:GetBucketLocation\",\n                 \"s3:ListBucket\"\n             ],\n             \"Effect\": \"Allow\",\n             \"Principal\": \"*\",\n             \"Resource\": \"arn:aws:s3:::%s\"\n         },\n         {\n             \"Action\": \"s3:GetObject\",\n             \"Effect\": \"Allow\",\n             \"Principal\": \"*\",\n             \"Resource\": \"arn:aws:s3:::%s/*\"\n         }\n     ],\n     \"Version\": \"2012-10-17\"\n }";

    public Long upload(MultipartFile file, String account, String taskId) {
        String bucketName = this.getBucketName();
        String originalFilename = file.getOriginalFilename();
        String fileName = this.doUpload(file, bucketName);
        AttachmentBean attachment = new AttachmentBean();
        attachment.setTaskId(taskId);
        attachment.setFileName(fileName);
        attachment.setFileSize(file.getSize());
        attachment.setCreateTime(Instant.now());
        attachment.setFilePath(bucketName + "/" + fileName);
        attachment.setOriginalName(originalFilename);
        attachment.setType(1);
        attachment.setCreateBy(account);
        this.attachmentMapper.save(attachment);
        this.logger.info("save attachment:{}", (Object)attachment);
        return attachment.getId();
    }

    public Long uploadAddFolder(MultipartFile file, String account, String taskId, String folder) {
        String bucketName = this.getBucketName();
        String originalFilename = file.getOriginalFilename();
        String fileName = this.doUploadAddFolder(file, bucketName, folder);
        AttachmentBean attachment = new AttachmentBean();
        attachment.setTaskId(taskId);
        attachment.setFileName(fileName);
        attachment.setFileSize(file.getSize());
        attachment.setCreateTime(Instant.now());
        attachment.setFilePath(bucketName + "/" + fileName);
        attachment.setOriginalName(originalFilename);
        attachment.setType(1);
        attachment.setCreateBy(account);
        this.attachmentMapper.save(attachment);
        this.logger.info("save attachment:{}", (Object)attachment);
        return attachment.getId();
    }

    private String doUploadAddFolder(MultipartFile file, String bucketName, String folder) {
        try {
            MinioClient minioClient = new MinioClient(this.server, this.accessKey, this.secretKey);
            boolean isExist = minioClient.bucketExists(bucketName);
            if (isExist) {
                this.logger.info("Bucket already exists.");
            } else {
                minioClient.makeBucket(bucketName);
                String policy = String.format(BUCKET_PUBLIC_POLICY, bucketName, bucketName);
                minioClient.setBucketPolicy(bucketName, policy);
            }
            String originalFilename = file.getOriginalFilename();
            String fileName = this.getFileName(minioClient, bucketName, folder + originalFilename);
            InputStream inputStream = file.getInputStream();
            minioClient.putObject(bucketName, fileName, inputStream, new PutObjectOptions((long)inputStream.available(), -1L));
            return fileName;
        }
        catch (MinioException | IOException | InvalidKeyException | NoSuchAlgorithmException e) {
            this.logger.error("Error occurred: {}", e);
            return null;
        }
    }

    public AttachmentBean upload(MultipartFile file, String account) {
        String bucketName = this.getBucketName();
        String fileName = this.doUpload(file, bucketName);
        AttachmentBean attachment = new AttachmentBean();
        attachment.setTaskId(null);
        attachment.setFileName(fileName);
        attachment.setFileSize(file.getSize());
        attachment.setCreateTime(Instant.now());
        attachment.setFilePath(bucketName + "/" + fileName);
        attachment.setOriginalName(file.getOriginalFilename());
        attachment.setType(2);
        attachment.setCreateBy(account);
        attachment.setWatermark("N");
        this.attachmentMapper.save(attachment);
        this.logger.info("save attachment:{}", (Object)attachment);
        return attachment;
    }

    public AttachmentBeanVO uploadImg(MultipartFile file, String account) {
        String bucketName = this.getBucketName();
        String fileName = this.doUpload(file, bucketName);
        AttachmentBean attachment = new AttachmentBean();
        attachment.setTaskId(null);
        attachment.setFileName(fileName);
        attachment.setFileSize(file.getSize());
        attachment.setCreateTime(Instant.now());
        attachment.setFilePath(bucketName + "/" + fileName);
        attachment.setOriginalName(file.getOriginalFilename());
        attachment.setType(2);
        attachment.setCreateBy(account);
        attachment.setWatermark("N");
        this.attachmentMapper.save(attachment);
        this.logger.info("save attachment:{}", (Object)attachment);
        AttachmentBeanVO attachmentBeanVO = new AttachmentBeanVO();
        BeanUtils.copyProperties((Object)attachment, (Object)attachmentBeanVO);
        attachmentBeanVO.setUrl(this.server + "/" + attachment.getFilePath());
        return attachmentBeanVO;
    }

    public AttachmentBeanVO uploadImg(MultipartFile file, String account, String bucket) {
        String bucketName;
        String folder = null;
        if (bucket.contains("/")) {
            String[] split = bucket.split("/");
            if (split.length > 1) {
                bucketName = split[0];
                folder = bucket.substring(bucketName.length()).endsWith("/") ? bucket.substring(bucketName.length()) : bucket.substring(bucketName.length()) + "/";
            } else {
                bucketName = this.getBucketName();
            }
        } else {
            bucketName = this.getBucketName();
        }
        String fileName = null;
        if (folder != null) {
            try {
                fileName = this.doUpload(file.getInputStream(), bucketName, "/" + folder + "/" + file.getOriginalFilename());
            }
            catch (Exception e) {
                System.out.println(e.getMessage());
            }
        } else {
            fileName = this.doUpload(file, bucketName);
        }
        AttachmentBean attachment = new AttachmentBean();
        attachment.setTaskId(null);
        attachment.setFileName(fileName);
        attachment.setFileSize(file.getSize());
        attachment.setCreateTime(Instant.now());
        attachment.setFilePath(bucketName + "/" + fileName);
        attachment.setOriginalName(file.getOriginalFilename());
        attachment.setType(2);
        attachment.setCreateBy(account);
        attachment.setWatermark("N");
        this.attachmentMapper.save(attachment);
        this.logger.info("save attachment:{}", (Object)attachment);
        AttachmentBeanVO attachmentBeanVO = new AttachmentBeanVO();
        BeanUtils.copyProperties((Object)attachment, (Object)attachmentBeanVO);
        attachmentBeanVO.setUrl(this.server + "/" + attachment.getFilePath());
        return attachmentBeanVO;
    }

    public InputStream download(Long id) {
        AttachmentBean attachmentBean = this.attachmentMapper.findAttachmentById(id);
        if (null == attachmentBean || StringUtils.isEmpty((CharSequence)attachmentBean.getFilePath())) {
            return null;
        }
        String path = attachmentBean.getFilePath();
        return this.doDownload(path);
    }

    public String getDownloadUrl(Long id) {
        AttachmentBean attachmentBean = this.attachmentMapper.findAttachmentById(id);
        if (null == attachmentBean || StringUtils.isEmpty((CharSequence)attachmentBean.getFilePath())) {
            return null;
        }
        String path = attachmentBean.getFilePath();
        return this.getDownloadUrl(path);
    }

    public InputStream downloadOriginalFileByTaskId(String taskId) {
        AttachmentBean attachmentBean = this.attachmentMapper.findAttachmentByTaskId(taskId);
        if (null == attachmentBean || StringUtils.isEmpty((CharSequence)attachmentBean.getFilePath())) {
            return null;
        }
        String path = attachmentBean.getFilePath();
        return this.doDownload(path);
    }

    public InputStream downloadReportByTaskId(String taskId) {
        AttachmentBean attachmentBean = this.attachmentMapper.findReportByTaskId(taskId);
        if (null == attachmentBean || StringUtils.isEmpty((CharSequence)attachmentBean.getFilePath())) {
            return null;
        }
        String path = attachmentBean.getFilePath();
        return this.doDownload(path);
    }

    public int saveReport(ImportResult importResult, String taskId) {
        ImportReport importReport = importResult.getImportReport();
        List<CellInfo> cellInfos = importReport.getErrorReports();
        List<Map<String, Object>> dataList = importResult.getResultListByMap();
        XSSFWorkbook workbook = new XSSFWorkbook();
        Sheet sheet = workbook.createSheet("\u4e0a\u4f20\u62a5\u544a");
        HashSet<Integer> rowSet = new HashSet<Integer>();
        Row header_0 = sheet.createRow(0);
        header_0.createCell(0).setCellValue("Row Number");
        header_0.createCell(1).setCellValue("Column Number");
        header_0.createCell(2).setCellValue("Message");
        if (!cellInfos.isEmpty()) {
            int rowNum = 1;
            for (CellInfo cellInfo : cellInfos) {
                Row row = sheet.createRow(rowNum);
                if (null == cellInfo.getRow()) continue;
                rowSet.add(cellInfo.getRow());
                row.createCell(0).setCellValue((double)cellInfo.getRow().intValue());
                String field = cellInfo.getField();
                if (null == cellInfo.getColumn()) {
                    int column = this.getColumn(field, dataList.get(0));
                    if (column < 0) {
                        row.createCell(1).setCellValue("");
                    } else {
                        row.createCell(1).setCellValue((double)column);
                    }
                } else {
                    row.createCell(1).setCellValue((double)cellInfo.getColumn().intValue());
                }
                String error = cellInfo.getErrMsg().toString();
                row.createCell(2).setCellValue(error);
                ++rowNum;
            }
        }
        sheet.autoSizeColumn(0);
        sheet.autoSizeColumn(1);
        sheet.autoSizeColumn(2);
        Sheet dataSheet = workbook.createSheet("\u9519\u8bef\u8bb0\u5f55");
        int idx = 0;
        int column = 0;
        Row header_1 = dataSheet.createRow(idx);
        Map data = dataList.get(0);
        for (Map.Entry<String, Object> entry : data.entrySet()) {
            String key = entry.getKey();
            if (Arrays.asList(this.exclude).contains(key)) continue;
            Cell cell = header_1.createCell(column);
            cell.setCellValue(key);
            ++column;
        }
        if (!rowSet.isEmpty()) {
            ++idx;
            for (Integer rowNum : rowSet) {
                for (Map map : dataList) {
                    if (!map.get("row").equals(rowNum)) continue;
                    data = map;
                    break;
                }
                Row row = dataSheet.createRow(idx);
                column = 0;
                for (Map.Entry<String, Object> entry : data.entrySet()) {
                    String key = entry.getKey();
                    if (Arrays.asList(this.exclude).contains(key)) continue;
                    Object object = entry.getValue();
                    Cell cell = row.createCell(column);
                    cell.setCellValue(String.valueOf(object));
                    ++column;
                }
                ++idx;
            }
        }
        try {
            String bucketName = this.getBucketName();
            String table = importReport.getTableName();
            String fileName = "\u4efb\u52a1\u62a5\u544a_" + table + "_" + System.currentTimeMillis() + ".xlsx";
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            workbook.write((OutputStream)byteArrayOutputStream);
            ByteArrayInputStream inputStream = new ByteArrayInputStream(byteArrayOutputStream.toByteArray());
            this.doUpload(inputStream, bucketName, fileName);
            AttachmentBean attachmentBean = new AttachmentBean();
            attachmentBean.setTaskId(taskId);
            attachmentBean.setFilePath(bucketName + "/" + fileName);
            attachmentBean.setType(0);
            attachmentBean.setFileName(fileName);
            attachmentBean.setOriginalName(fileName);
            attachmentBean.setCreateTime(Instant.now());
            this.attachmentMapper.save(attachmentBean);
        }
        catch (IOException e) {
            e.printStackTrace();
            this.logger.error("save report failed:{}", (Throwable)e);
        }
        return cellInfos.size();
    }

    private int getColumn(String field, Map<String, Object> header) {
        ArrayList<String> temp = new ArrayList<String>();
        for (Map.Entry<String, Object> entry : header.entrySet()) {
            String key = entry.getKey();
            if (Arrays.asList(this.exclude).contains(key)) continue;
            temp.add(key);
        }
        return temp.indexOf(field) + 1;
    }

    private String doUpload(MultipartFile file, String bucketName) {
        try {
            MinioClient minioClient = new MinioClient(this.server, this.accessKey, this.secretKey);
            boolean isExist = minioClient.bucketExists(bucketName);
            if (isExist) {
                this.logger.info("Bucket already exists.");
            } else {
                minioClient.makeBucket(bucketName);
                String policy = String.format(BUCKET_PUBLIC_POLICY, bucketName, bucketName);
                minioClient.setBucketPolicy(bucketName, policy);
            }
            String originalFilename = file.getOriginalFilename();
            String fileName = this.getFileName(minioClient, bucketName, originalFilename);
            InputStream inputStream = file.getInputStream();
            minioClient.putObject(bucketName, fileName, inputStream, new PutObjectOptions((long)inputStream.available(), -1L));
            return fileName;
        }
        catch (MinioException | IOException | InvalidKeyException | NoSuchAlgorithmException e) {
            this.logger.error("Error occurred: {}", e);
            return null;
        }
    }

    private String getFileName(MinioClient minioClient, String bucketName, String originalFilename) throws XmlParserException {
        String prefix = originalFilename.substring(0, originalFilename.lastIndexOf("."));
        String suffix = originalFilename.substring(originalFilename.lastIndexOf("."));
        String fileName = originalFilename;
        Iterable iterable = minioClient.listObjects(bucketName, prefix);
        AtomicInteger idx = new AtomicInteger();
        iterable.forEach(itemResult -> {
            try {
                Item item = (Item)itemResult.get();
                String objectName = item.objectName();
                String prefix_q = objectName.substring(0, objectName.lastIndexOf("."));
                String suffix_q = objectName.substring(objectName.lastIndexOf("."));
                if (suffix.equalsIgnoreCase(suffix_q)) {
                    if (prefix_q.equals(prefix)) {
                        idx.getAndIncrement();
                    } else if (prefix_q.contains("_") && prefix_q.substring(0, prefix_q.lastIndexOf("_")).equals(prefix)) {
                        idx.getAndIncrement();
                    }
                }
            }
            catch (ErrorResponseException | InsufficientDataException | InternalException | InvalidBucketNameException | XmlParserException | IOException | InvalidKeyException | NoSuchAlgorithmException e) {
                e.printStackTrace();
                this.logger.error("list object failed: {}");
                idx.set(999);
            }
        });
        int index = idx.get();
        if (index > 0) {
            fileName = prefix + "_" + index + suffix;
        }
        return fileName;
    }

    private String doUpload(File file, String bucketName) {
        try {
            MinioClient minioClient = new MinioClient(this.server, this.accessKey, this.secretKey);
            boolean isExist = minioClient.bucketExists(bucketName);
            if (isExist) {
                this.logger.info("Bucket already exists.");
            } else {
                minioClient.makeBucket(bucketName);
                String policy = String.format(BUCKET_PUBLIC_POLICY, bucketName, bucketName);
                minioClient.setBucketPolicy(bucketName, policy);
            }
            String originalFilename = file.getName();
            String fileName = this.getFileName(minioClient, bucketName, originalFilename);
            FileInputStream inputStream = new FileInputStream(file);
            minioClient.putObject(bucketName, fileName, (InputStream)inputStream, new PutObjectOptions((long)((InputStream)inputStream).available(), -1L));
            return fileName;
        }
        catch (MinioException | IOException | InvalidKeyException | NoSuchAlgorithmException e) {
            this.logger.error("Error occurred: {}", e);
            return null;
        }
    }

    private String doUpload(InputStream inputStream, String bucketName, String fileName) {
        try {
            MinioClient minioClient = new MinioClient(this.server, this.accessKey, this.secretKey);
            boolean isExist = minioClient.bucketExists(bucketName);
            if (isExist) {
                this.logger.info("Bucket already exists.");
            } else {
                minioClient.makeBucket(bucketName);
                String policy = String.format(BUCKET_PUBLIC_POLICY, bucketName, bucketName);
                minioClient.setBucketPolicy(bucketName, policy);
            }
            minioClient.putObject(bucketName, fileName, inputStream, new PutObjectOptions((long)inputStream.available(), -1L));
            return fileName;
        }
        catch (MinioException | IOException | InvalidKeyException | NoSuchAlgorithmException e) {
            this.logger.error("Error occurred: {}", e);
            return null;
        }
    }

    public InputStream doDownload(String path) {
        String bucketName = path.substring(0, path.indexOf("/"));
        String fileName = path.substring(path.indexOf("/") + 1);
        try {
            MinioClient minioClient = new MinioClient(this.server, this.accessKey, this.secretKey);
            boolean isExist = minioClient.bucketExists(bucketName);
            if (!isExist) {
                this.logger.error("Bucket not exists.");
                return null;
            }
            return minioClient.getObject(bucketName, fileName);
        }
        catch (MinioException | IOException | InvalidKeyException | NoSuchAlgorithmException e) {
            this.logger.error("down load file {} failed: {}", (Object)path, (Object)e);
            return null;
        }
    }

    public String getDownloadUrl(String path) {
        String bucketName = path.substring(0, path.indexOf("/"));
        String fileName = path.substring(path.indexOf("/") + 1);
        try {
            MinioClient minioClient = new MinioClient(this.server, this.accessKey, this.secretKey);
            boolean isExist = minioClient.bucketExists(bucketName);
            if (!isExist) {
                this.logger.error("Bucket not exists.");
                return null;
            }
            return minioClient.getObjectUrl(bucketName, fileName);
        }
        catch (MinioException | IOException | InvalidKeyException | NoSuchAlgorithmException e) {
            this.logger.error("down load file {} failed: {}", (Object)path, (Object)e);
            return null;
        }
    }

    private String getBucketName() {
        Calendar calendar = Calendar.getInstance();
        return calendar.get(1) + "-" + (calendar.get(2) + 1);
    }

    public void remove(Long attachmentId) {
        AttachmentBean attachmentBean = this.attachmentMapper.findAttachmentById(attachmentId);
        String filePath = attachmentBean.getFilePath();
        List<Result<DeleteError>> results = this.doRemove(filePath);
        if (!results.isEmpty()) {
            this.attachmentMapper.delete(attachmentId);
        } else {
            this.logger.error("remove attachment {} failed", (Object)attachmentId);
        }
    }

    private List<Result<DeleteError>> doRemove(String path) {
        String bucketName = path.substring(0, path.indexOf("/"));
        String fileName = path.substring(path.indexOf("/") + 1);
        ArrayList<Result<DeleteError>> list = new ArrayList<Result<DeleteError>>();
        try {
            MinioClient minioClient = new MinioClient(this.server, this.accessKey, this.secretKey);
            boolean isExist = minioClient.bucketExists(bucketName);
            if (isExist) {
                this.logger.error("Bucket not exists.");
                LinkedList<String> objectNames = new LinkedList<String>();
                objectNames.add(fileName);
                Iterable results = minioClient.removeObjects(bucketName, objectNames);
                results.forEach(item -> list.add((Result<DeleteError>)item));
            }
        }
        catch (MinioException | IOException | InvalidKeyException | NoSuchAlgorithmException e) {
            this.logger.error("Error occurred: {}", e);
        }
        return list;
    }

    public String getDownloadUrl(String taskId, int type) {
        AttachmentBean attachmentBean = null;
        if (type == 0) {
            attachmentBean = this.attachmentMapper.findReportByTaskId(taskId);
        } else if (type == 1) {
            attachmentBean = this.attachmentMapper.findAttachmentByTaskId(taskId);
        }
        this.logger.info("getDownloadUrl taskId: {},result: {}", (Object)taskId, (Object)attachmentBean);
        if (null == attachmentBean) {
            return null;
        }
        String path = attachmentBean.getFilePath();
        return this.getDownloadUrl(path);
    }

    public List<AttachmentBean> getAttachmentBean() {
        List<AttachmentBean> list = this.attachmentMapper.getAttachmentBean();
        this.logger.info("getAttachmentBean list: {} ", list);
        if (null == list || list.size() == 0) {
            return null;
        }
        return list;
    }

    public void uploadWatermark(MultipartFile file, long id) {
        String bucketName = this.getBucketName();
        String fileName = this.doUpload(file, bucketName);
        if (!"".equals(fileName)) {
            AttachmentBean attachment = new AttachmentBean();
            attachment.setId(id);
            attachment.setFileName(fileName);
            attachment.setFilePath(bucketName + "/" + fileName);
            this.attachmentMapper.updateAttachmentBean(attachment);
        }
    }

    public AttachmentBean findAttachmentById(Long id) {
        return this.attachmentMapper.findAttachmentById(id);
    }

    public List<String> getOriginalFileUrl(String taskId) {
        ArrayList<String> urlList = new ArrayList<String>();
        List<AttachmentBean> attachmentBeanList = this.attachmentMapper.getAttachmentBeanByTaskId(taskId);
        if (attachmentBeanList.size() > 0) {
            for (AttachmentBean attachmentBean : attachmentBeanList) {
                String path = attachmentBean.getFilePath();
                String downloadUrl = this.getDownloadUrl(path);
                urlList.add(downloadUrl);
            }
        }
        return urlList;
    }
}

