/*
 * Decompiled with CFR 0.152.
 */
package com.qqt.pool.io.component;

import com.qqt.pool.io.bean.ExportColumnConfigBean;
import com.qqt.pool.io.bean.ExportConfigBean;
import com.qqt.pool.io.dto.ExportRequest;
import com.qqt.pool.io.dto.ExportTempResult;
import com.qqt.pool.io.mapper.ExportConfigMapper;
import com.qqt.pool.io.service.DataDictionaryInterface;
import com.qqt.pool.io.service.DownloadAfterInterceptorInterface;
import com.qqt.pool.io.util.MapValueHelper;
import com.qqt.pool.io.util.SpringUtils;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.Workbook;
import org.apache.poi.xssf.streaming.SXSSFWorkbook;
import org.springframework.stereotype.Service;

@Service
public class ExportComponent {
    @Resource
    private ExportConfigMapper exportConfigMapper;
    @Resource
    private DownloadAfterInterceptorInterface afterInterceptor;
    @Resource
    private DataDictionaryInterface dataDictionaryInterface;

    public Workbook download(ExportRequest downloadParam) throws Exception {
        int i;
        Object bean;
        String downloadName = downloadParam.getDownloadName();
        ExportConfigBean configBean = this.exportConfigMapper.findExportConfig(downloadName);
        if (null == configBean) {
            return null;
        }
        Map<String, Object> paramMap = downloadParam.getDownloadParamMap();
        Class<?> serviceClass = Class.forName(configBean.getDownloadServiceClass());
        Method downloadMethod = serviceClass.getDeclaredMethod(configBean.getDownloadMethodName(), Map.class);
        ExportTempResult tempResult = (ExportTempResult)downloadMethod.invoke(bean = SpringUtils.getBean(serviceClass), paramMap);
        if (null == tempResult || null == tempResult.getDataList() || tempResult.getDataList().size() < 1) {
            return null;
        }
        List<Map<String, Object>> tempDataList = tempResult.getDataList();
        List<List<String>> tempHeaderList = tempResult.getHeaderList();
        List<String> tempKeyList = tempResult.getKeyList();
        if (null != this.afterInterceptor) {
            tempDataList = this.afterInterceptor.handleDataList(paramMap, tempDataList);
        }
        List<ExportColumnConfigBean> columnConfigList = configBean.getColumnConfigList();
        String language = downloadParam.getLanguage();
        String[] keyList = null;
        keyList = null == tempKeyList || tempKeyList.isEmpty() ? columnConfigList.stream().sorted(Comparator.comparing(ExportColumnConfigBean::getColumnSort)).map(column -> column.getColumnKeyName()).collect(Collectors.toList()).toArray(new String[columnConfigList.size()]) : tempKeyList.toArray(new String[tempKeyList.size()]);
        List<Object> headerList = new ArrayList();
        headerList = "en".equalsIgnoreCase(language) ? columnConfigList.stream().sorted(Comparator.comparing(ExportColumnConfigBean::getColumnSort)).map(column -> column.getColumnHeaderNameEn()).collect(Collectors.toList()) : ("zh".equalsIgnoreCase(language) ? columnConfigList.stream().sorted(Comparator.comparing(ExportColumnConfigBean::getColumnSort)).map(column -> column.getColumnHeaderNameZh()).collect(Collectors.toList()) : columnConfigList.stream().sorted(Comparator.comparing(ExportColumnConfigBean::getColumnSort)).map(column -> column.getColumnHeaderNameEn()).collect(Collectors.toList()));
        List<Object> headerListList = new ArrayList();
        if (null == tempHeaderList || tempHeaderList.isEmpty()) {
            for (Object header : headerList) {
                ArrayList<Object> arrayList = new ArrayList<Object>();
                arrayList.add(header);
                headerListList.add(arrayList);
            }
        } else {
            headerListList = tempHeaderList;
        }
        ArrayList<String> dicCategoryList = new ArrayList<String>();
        for (ExportColumnConfigBean exportColumnConfigBean : columnConfigList) {
            if (!"DIC".equalsIgnoreCase(exportColumnConfigBean.getColumnCategory())) continue;
            String string = exportColumnConfigBean.getColumnDicCategory();
            dicCategoryList.add(string);
        }
        if (null != this.dataDictionaryInterface && dicCategoryList.size() > 0) {
            Map<String, Map<String, String>> dicMap = this.dataDictionaryInterface.loadDataDictionaryMap(dicCategoryList, language);
            for (Map<String, Object> map : tempDataList) {
                for (ExportColumnConfigBean columnConfig : columnConfigList) {
                    String columnCategory = columnConfig.getColumnCategory();
                    String key = columnConfig.getColumnKeyName();
                    if ("DIC".equalsIgnoreCase(columnCategory)) {
                        String dicCategory = columnConfig.getColumnDicCategory();
                        String value = MapValueHelper.getStr(key, map);
                        String dicValue = dicMap.get(dicCategory).get(value);
                        map.put(key, dicValue);
                        continue;
                    }
                    if (!"DATE".equalsIgnoreCase(columnCategory) || !map.containsKey(key) || null == map.get(key)) continue;
                    Date dateValue = MapValueHelper.getDate2(key, map, "yyyy-MM-dd");
                    map.put(key, dateValue);
                }
            }
        }
        List<List<Object>> dataList = this.convertData(tempDataList, keyList);
        SXSSFWorkbook sXSSFWorkbook = new SXSSFWorkbook();
        Sheet sheet = sXSSFWorkbook.createSheet(downloadName);
        String[] head = new String[]{"\u5206\u7ec4", "\u540c\u4e49\u8bcd", "\u5206\u7ec4", "\u654f\u611f\u8bcd"};
        Row titleRow = sheet.createRow(0);
        for (i = 0; i < headerListList.size(); ++i) {
            String header = (String)((List)headerListList.get(i)).get(0);
            Cell titleRowCell = titleRow.createCell(i);
            titleRowCell.setCellValue(header);
        }
        for (i = 0; i < dataList.size(); ++i) {
            Row row = sheet.createRow(i + 1);
            List<Object> fields = dataList.get(i);
            for (int j = 0; j < fields.size(); ++j) {
                Object field = fields.get(j);
                Cell rowCell = row.createCell(j);
                rowCell.setCellValue(String.valueOf(field));
            }
        }
        return sXSSFWorkbook;
    }

    public List<List<Object>> convertData(List<Map<String, Object>> resultList, String[] keyList) {
        if (MapValueHelper.isEmptyList(resultList).booleanValue() || null == keyList || keyList.length < 1) {
            return null;
        }
        ArrayList<List<Object>> result = new ArrayList<List<Object>>();
        for (Map<String, Object> map : resultList) {
            ArrayList<Object> lineList = new ArrayList<Object>();
            for (String key : keyList) {
                lineList.add(map.get(key));
            }
            result.add(lineList);
        }
        return result;
    }
}

