/*
 * Decompiled with CFR 0.152.
 */
package com.qqt.pool.io.component;

import com.qqt.pool.io.bean.TemplateBean;
import com.qqt.pool.io.bean.TemplateDetailBean;
import com.qqt.pool.io.bean.TemplateStaticBean;
import com.qqt.pool.io.dto.CellInfo;
import com.qqt.pool.io.dto.ImportReport;
import com.qqt.pool.io.dto.ImportResult;
import com.qqt.pool.io.dto.TableDataDto;
import com.qqt.pool.io.enumeration.FieldTypeEnum;
import com.qqt.pool.io.mapper.TemplateMapper;
import com.qqt.pool.io.util.ValidateUtils;
import java.io.IOException;
import java.io.InputStream;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.CellType;
import org.apache.poi.ss.usermodel.DateUtil;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.xssf.usermodel.XSSFSheet;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;
import org.springframework.stereotype.Service;
import org.springframework.util.StringUtils;

@Service
public class ImportDynamicComponent {
    @Resource
    private TemplateMapper templateMapper;
    @Resource
    private ImportDynamicComponent importDynamicComponent;
    private static SimpleDateFormat SIMPLE_DATE_FORMAT = new SimpleDateFormat("yyyy-MM-dd");

    public TableDataDto getValBeans(InputStream excelInputStream, TemplateBean templateBean) {
        TableDataDto tableDataDto = new TableDataDto();
        HashMap<Integer, Map<Integer, Map<Integer, Object>>> sheetMap = new HashMap<Integer, Map<Integer, Map<Integer, Object>>>();
        HashMap rowMap = new HashMap();
        HashMap<Integer, Object> coloumMap = null;
        if (null == excelInputStream) {
            return null;
        }
        try {
            XSSFWorkbook workbook = new XSSFWorkbook(excelInputStream);
            String name = workbook.getSheetName(templateBean.getSheetIndex());
            int index = workbook.getSheetIndex(name);
            XSSFSheet sheet = workbook.getSheet(name);
            String sheetName = sheet.getSheetName();
            int rows = sheet.getPhysicalNumberOfRows();
            Integer startLineNumber = templateBean.getStartLineNumber() - 1;
            List<TemplateDetailBean> detailBeanList = templateBean.getDetailBeanList();
            int cellMAXIndex = 0;
            int lastCellNum = 0;
            for (TemplateDetailBean list : detailBeanList) {
                lastCellNum = list.getFileColumnIndex();
                if (lastCellNum <= cellMAXIndex) continue;
                cellMAXIndex = lastCellNum;
            }
            for (int i = startLineNumber.intValue(); i <= rows; ++i) {
                coloumMap = new HashMap<Integer, Object>();
                Row row = sheet.getRow(i);
                if (row == null) {
                    rowMap.put(i, null);
                    continue;
                }
                for (int j = 0; j <= cellMAXIndex; ++j) {
                    Cell cell = row.getCell(j);
                    if (cell == null) {
                        coloumMap.put(j, "");
                        continue;
                    }
                    if (cell.getCellType() == CellType.NUMERIC) {
                        if (DateUtil.isCellDateFormatted((Cell)cell)) {
                            Date date = cell.getDateCellValue();
                            cell.setCellType(CellType.NUMERIC);
                            coloumMap.put(cell.getColumnIndex(), date);
                            continue;
                        }
                        cell.setCellType(CellType.STRING);
                        coloumMap.put(cell.getColumnIndex(), cell.getStringCellValue());
                        continue;
                    }
                    String value = cell.getStringCellValue();
                    Date date = null;
                    if (!StringUtils.isEmpty((Object)value) && value.length() == 10 && value.split("-").length == 3) {
                        try {
                            date = SIMPLE_DATE_FORMAT.parse(value);
                        }
                        catch (ParseException e) {
                            e.printStackTrace();
                        }
                    }
                    if (null != date) {
                        cell.setCellType(CellType.NUMERIC);
                        coloumMap.put(cell.getColumnIndex(), date);
                        continue;
                    }
                    cell.setCellType(CellType.STRING);
                    coloumMap.put(cell.getColumnIndex(), cell.getStringCellValue());
                }
                rowMap.put(i, coloumMap);
            }
            sheetMap.put(index, rowMap);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        tableDataDto.setExcelDataMap(sheetMap);
        return tableDataDto;
    }

    public TemplateBean importTemplateIdToTemplate(int templateId) {
        int count = this.templateMapper.countByTemplateId(templateId);
        TemplateBean templateBean = null;
        templateBean = count != 0 ? this.templateMapper.findAll(templateId) : this.templateMapper.findAllJustBase(templateId);
        return templateBean;
    }

    public ImportResult analyzeExcelThenToMemory(TemplateBean templateBean, TableDataDto tableData) {
        long id = templateBean.getId();
        int templateId = (int)id;
        int count = this.templateMapper.countByTemplateId(templateId);
        Map<Integer, Map<Integer, Map<Integer, Object>>> excelDataMap = tableData.getExcelDataMap();
        ImportResult importResult = new ImportResult();
        ImportReport importReport = new ImportReport();
        Object cellInfo = null;
        int i = 0;
        if (null == excelDataMap || excelDataMap.isEmpty()) {
            ArrayList<String> list = new ArrayList<String>();
            list.add("\u8868\u4fe1\u606f\u4e0d\u5b58\u5728");
            importReport = new ImportReport(0, 0, 0, null, list, null, null, null);
            importResult = new ImportResult(null, importReport, false);
            return importResult;
        }
        int sheetIndex = templateBean.getSheetIndex();
        Map<Integer, Map<Integer, Object>> sheetData = excelDataMap.get(sheetIndex);
        if (null == sheetData || sheetData.isEmpty()) {
            ArrayList<String> list = new ArrayList<String>();
            list.add("Sheet\u4e3a\u7a7a\uff0c\u8bf7\u4e0a\u4f20\u6709\u6548\u7684excel");
            importReport = new ImportReport(0, 0, 0, null, list, null, null, null);
            importResult = new ImportResult(null, importReport, false);
            return importResult;
        }
        List<TemplateDetailBean> detailBeanList = templateBean.getDetailBeanList();
        if (null == detailBeanList || detailBeanList.isEmpty()) {
            ArrayList<String> list = new ArrayList<String>();
            list.add("\u672a\u627e\u5230\u5bf9\u5e94\u7684\u6a21\u677f\u660e\u7ec6\uff0c\u8bf7\u786e\u8ba4\u4e0a\u4f20\u6a21\u677f\u7684\u6b63\u786e\u6027");
            importReport = new ImportReport(0, 0, 0, null, list, null, null, null);
            importResult = new ImportResult(null, importReport, false);
            return importResult;
        }
        ArrayList analyzedList = new ArrayList();
        ArrayList<CellInfo> cellInfoList = new ArrayList<CellInfo>();
        for (Map.Entry<Integer, Map<Integer, Object>> entry : sheetData.entrySet()) {
            Integer currentLineNumber = entry.getKey();
            Map<Integer, Object> currentLineMap = entry.getValue();
            if (null == currentLineMap || currentLineMap.isEmpty()) break;
            HashMap tempMap = new HashMap();
            for (TemplateDetailBean detailBean : detailBeanList) {
                StringBuilder keyBuilder = new StringBuilder();
                LinkedHashMap<String, Object> currentAnalyzedMap = new LinkedHashMap<String, Object>();
                Integer subId = detailBean.getItSubTemplateNuNo();
                int startLine = templateBean.getStartLineNumber() - 1;
                if (currentLineNumber < startLine) break;
                Integer columnIndex = detailBean.getFileColumnIndex() - 1;
                Object cellValue = currentLineMap.get(columnIndex);
                if (detailBean.getIsSaveField() != 1) continue;
                if (detailBean.getFieldType().equals((Object)FieldTypeEnum.UNIONKEY)) {
                    if (null == cellValue || "".equals(cellValue)) continue;
                    keyBuilder = keyBuilder.append(cellValue.toString()).append("_");
                } else if (null != cellValue && !"".equals(cellValue)) {
                    String string = cellValue.toString();
                }
                currentAnalyzedMap.put(detailBean.getBusinessTableFieldName(), cellValue);
                currentAnalyzedMap.put("row", currentLineNumber + 1);
                List<TemplateStaticBean> staticBeanList = detailBean.getStaticBeanList();
                if (null == staticBeanList || staticBeanList.isEmpty()) {
                    if (count != 0) continue;
                    if (tempMap.containsKey(subId)) {
                        ((Map)tempMap.get(subId)).putAll(currentAnalyzedMap);
                        continue;
                    }
                    tempMap.put(subId, currentAnalyzedMap);
                    continue;
                }
                for (TemplateStaticBean staticBean : staticBeanList) {
                    if (staticBean.getFileLineIndexStatic() != null) {
                        int fileLineIndex = staticBean.getFileLineIndexStatic() - 1;
                        int fileColumnIndex = staticBean.getFileColumnIndexStatic() - 1;
                        String value = String.valueOf(ValidateUtils.getCellValue(fileLineIndex, fileColumnIndex, sheetData));
                        staticBean.setValueStatic(value);
                    }
                    if (FieldTypeEnum.UNIONKEY.equals((Object)staticBean.getFileTypeStatic()) && detailBean.getFieldType().equals((Object)FieldTypeEnum.UNIONKEY)) {
                        keyBuilder = keyBuilder.append(staticBean.getValueStatic()).append("_");
                    }
                    if (staticBean.getIsSaveFieldStatic() != 1) continue;
                    currentAnalyzedMap.put(staticBean.getBusinessTableFieldNameStatic(), staticBean.getValueStatic());
                }
                if (tempMap.containsKey(subId)) {
                    ((Map)tempMap.get(subId)).putAll(currentAnalyzedMap);
                    continue;
                }
                tempMap.put(subId, currentAnalyzedMap);
            }
            analyzedList.addAll(tempMap.values());
        }
        importReport.setErrorReports(cellInfoList);
        importReport.setTotalCount(sheetData.size());
        importReport.setIgnoreCount(i);
        importReport.setTableName(templateBean.getTemplateName());
        ArrayList values = analyzedList;
        ArrayList<Map<String, Object>> resultListByMap = new ArrayList<Map<String, Object>>(values);
        importResult.setResultListByMap(resultListByMap);
        importResult.setImportReport(importReport);
        importResult.setSuccess(true);
        return importResult;
    }

    public ImportResult analyzeExcelThenInsertTable(TemplateBean templateBean, TableDataDto tableData) {
        return this.importDynamicComponent.analyzeExcelThenToMemory(templateBean, tableData);
    }
}

