/*
 * Decompiled with CFR 0.152.
 */
package com.qqt.pool.io.component;

import com.qqt.pool.io.bean.AttachmentBean;
import com.qqt.pool.io.bean.AttachmentBeanVO;
import com.qqt.pool.io.bean.BladeFile;
import com.qqt.pool.io.mapper.AttachmentMapper;
import com.qqt.pool.io.oss.minio.MinioTemplate;
import java.io.InputStream;
import java.time.Instant;
import java.util.List;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Component;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.web.multipart.MultipartFile;

@Component
@Transactional
public class MinioComponent {
    private Logger logger = LoggerFactory.getLogger(MinioComponent.class);
    @Resource
    private MinioTemplate minioTemplate;
    @Resource
    private AttachmentMapper attachmentMapper;
    @Value(value="${io.server}")
    private String server;
    @Value(value="${io.accessKey}")
    private String accessKey;
    @Value(value="${io.secretKey}")
    private String secretKey;

    public AttachmentBeanVO uploadImg(MultipartFile file, String account) {
        BladeFile bladeFile = this.minioTemplate.putFile(file);
        return this.doInsert(bladeFile, file, account, "N", 2, null);
    }

    public AttachmentBeanVO uploadImg(MultipartFile file, String account, String bucket) {
        BladeFile bladeFile = new BladeFile();
        if (bucket.contains("/")) {
            String[] split = bucket.split("/");
            if (split.length > 1) {
                String bucketName = split[0];
                String folder = bucket.substring(bucketName.length() + 1).endsWith("/") ? bucket.substring(bucketName.length() + 1) : bucket.substring(bucketName.length() + 1) + "/";
                bladeFile = this.minioTemplate.putFileAddFolder(file, bucketName, folder);
            } else {
                bladeFile = this.minioTemplate.putFile(file, bucket);
            }
        } else {
            bladeFile = this.minioTemplate.putFile(file, bucket);
        }
        return this.doInsert(bladeFile, file, account, "N", 2, null);
    }

    public Long uploadAddFolder(MultipartFile file, String account, String taskId, String folder) {
        String bucketName = this.minioTemplate.getBucketName();
        BladeFile bladeFile = this.minioTemplate.putFileAddFolder(file, bucketName, folder);
        AttachmentBeanVO attachmentBeanVO = this.doInsert(bladeFile, file, account, null, 1, taskId);
        return attachmentBeanVO.getId();
    }

    private AttachmentBeanVO doInsert(BladeFile bladeFile, MultipartFile file, String account, String watermark, int type, String taskId) {
        AttachmentBean attachment = new AttachmentBean();
        attachment.setTaskId(taskId);
        attachment.setFileName(bladeFile.getName());
        attachment.setFileSize(file.getSize());
        attachment.setCreateTime(Instant.now());
        attachment.setFilePath(bladeFile.getFilePath());
        attachment.setOriginalName(file.getOriginalFilename());
        attachment.setType(type);
        attachment.setCreateBy(account);
        attachment.setWatermark(watermark);
        this.attachmentMapper.save(attachment);
        this.logger.info("save attachment:{}", (Object)attachment);
        AttachmentBeanVO attachmentBeanVO = new AttachmentBeanVO();
        BeanUtils.copyProperties((Object)attachment, (Object)attachmentBeanVO);
        attachmentBeanVO.setUrl(bladeFile.getLink());
        return attachmentBeanVO;
    }

    public List<String> download(String bucketName) {
        List<String> pathList = this.minioTemplate.listObjcet(bucketName);
        return pathList;
    }

    public InputStream downloadFile(String bucketName, String path) {
        return this.minioTemplate.downloadFile(bucketName, path);
    }
}

