/*
 * Decompiled with CFR 0.152.
 */
package com.qqt.pool.io.component;

import com.alibaba.fastjson.JSONObject;
import com.qqt.pool.io.dto.CustomerTask;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class ServiceUnitExecuter {
    private Logger logger = LoggerFactory.getLogger(ServiceUnitExecuter.class);

    public Object execute(CustomerTask task) {
        this.logger.info("execute->{}", (Object)task);
        try {
            Object service = task.getService();
            Method[] methods = service.getClass().getDeclaredMethods();
            Method method = null;
            for (Method m : methods) {
                String methodName = m.getName();
                if (!methodName.equals(task.getMethodName())) continue;
                method = m;
                break;
            }
            if (null == method) {
                return null;
            }
            this.logger.info("token->{}", (Object)task.getToken());
            this.logger.info("aaa" + JSONObject.toJSONString((Object)task.getParams()));
            Object object = method.invoke(service, task.getParams());
            this.logger.info("object is " + object);
            Object callbackService = task.getCallbackService();
            this.logger.info("callbackService is " + callbackService);
            Method[] methodz = callbackService.getClass().getDeclaredMethods();
            this.logger.info("methodz " + JSONObject.toJSONString((Object)methodz));
            Method callbackMethod = null;
            for (Method m : methodz) {
                String methodName = m.getName();
                if (!methodName.equals(task.getCallbackMethod())) continue;
                callbackMethod = m;
                break;
            }
            this.logger.info("token->{}", (Object)task.getToken());
            if (null != callbackMethod) {
                this.logger.info("invoke callback Service.method->{}", (Object)(callbackService.getClass().getSimpleName() + "." + callbackMethod));
                object = callbackMethod.invoke(callbackService, object);
            }
            return object;
        }
        catch (IllegalAccessException | InvocationTargetException e) {
            this.logger.error("execute task {} failed->{}", (Object)task.getTaskId(), (Object)e);
            return e;
        }
    }
}

