/*
 * Decompiled with CFR 0.152.
 */
package com.qqt.pool.io.component;

import com.qqt.pool.io.bean.TaskBean;
import com.qqt.pool.io.bean.TaskVO;
import com.qqt.pool.io.dto.TaskRequest;
import com.qqt.pool.io.enumeration.TaskStatus;
import com.qqt.pool.io.mapper.TaskMapper;
import java.time.Instant;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;
import org.springframework.transaction.annotation.Transactional;

@Component
public class TaskComponent {
    @Resource
    private TaskMapper taskMapper;
    private Logger logger = LoggerFactory.getLogger(TaskComponent.class);

    public Map<String, Object> findTask(TaskRequest taskRequest) {
        this.logger.info("find task params->{}", (Object)taskRequest);
        List<TaskBean> list = this.taskMapper.findTask(taskRequest);
        int total = this.taskMapper.count(taskRequest);
        HashMap<String, Object> result = new HashMap<String, Object>();
        result.put("total", total);
        result.put("data", list);
        this.logger.info("find task result->{}", result);
        return result;
    }

    @Transactional
    public void updateStatus(TaskStatus status, String taskId, String remark, Long timeConsuming) {
        TaskBean taskBean = new TaskBean(taskId);
        taskBean.setStatus(status.ordinal());
        taskBean.setRemark(remark);
        taskBean.setUpdateTime(Instant.now());
        taskBean.setTimeConsuming(timeConsuming);
        this.logger.info("update task status->{}", (Object)taskBean);
        this.taskMapper.updateStatus(taskBean);
    }

    public Map<String, Object> findTaskVO(TaskRequest taskRequest) {
        this.logger.info("find task params->{}", (Object)taskRequest);
        List<TaskVO> list = this.taskMapper.findTaskVO(taskRequest);
        int total = this.taskMapper.count(taskRequest);
        HashMap<String, Object> result = new HashMap<String, Object>();
        result.put("total", total);
        result.put("data", list);
        this.logger.info("find task result->{}", result);
        return result;
    }
}

