/*
 * Decompiled with CFR 0.152.
 */
package com.qqt.pool.io.component;

import com.qqt.pool.io.component.AttachmentComponent;
import com.qqt.pool.io.component.ServiceUnitExecuter;
import com.qqt.pool.io.component.TaskComponent;
import com.qqt.pool.io.dto.CustomerTask;
import com.qqt.pool.io.dto.ImportResult;
import com.qqt.pool.io.enumeration.TaskStatus;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.LinkedBlockingQueue;
import javax.annotation.PostConstruct;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Component;
import org.springframework.util.StringUtils;

@Component
public class TaskExecuter {
    private Logger logger = LoggerFactory.getLogger(TaskThread.class);
    @Resource
    private ServiceUnitExecuter executer;
    @Resource
    private TaskComponent taskComponent;
    @Resource
    private AttachmentComponent attachmentComponent;
    @Value(value="${io.taskSwitchOn:false}")
    private Boolean taskSwitchOn;
    private final BlockingQueue<CustomerTask> workQueue = new LinkedBlockingQueue<CustomerTask>();

    @PostConstruct
    public void execute() {
        Thread thread = new Thread(new Runnable(){

            @Override
            public void run() {
                ExecutorService pool = Executors.newFixedThreadPool(1);
                while (true) {
                    if (TaskExecuter.this.workQueue.isEmpty()) {
                        TaskExecuter.this.logger.debug("workQueue is empty");
                        try {
                            Thread.sleep(10000L);
                        }
                        catch (InterruptedException e) {
                            e.printStackTrace();
                            TaskExecuter.this.logger.error("workQueue is empty, sleep failed:{}", (Throwable)e);
                        }
                        continue;
                    }
                    CustomerTask task = (CustomerTask)TaskExecuter.this.workQueue.poll();
                    TaskExecuter.this.logger.info("task->{}", (Object)task);
                    try {
                        TaskExecuter.this.taskComponent.updateStatus(TaskStatus.Wait, task.getTaskId(), "", null);
                        TaskThread command = new TaskThread(task);
                        pool.execute(command);
                        continue;
                    }
                    catch (Exception e) {
                        TaskExecuter.this.taskComponent.updateStatus(TaskStatus.Error, task.getTaskId(), e.getMessage(), null);
                        e.printStackTrace();
                        continue;
                    }
                    break;
                }
            }
        });
        if (this.taskSwitchOn.booleanValue()) {
            thread.start();
        }
    }

    public BlockingQueue<CustomerTask> getWorkQueue() {
        return this.workQueue;
    }

    class TaskThread
    implements Runnable {
        private Logger log = LoggerFactory.getLogger(TaskThread.class);
        private CustomerTask task;

        public TaskThread(CustomerTask task) {
            this.task = task;
        }

        @Override
        public void run() {
            if (this.task != null && !StringUtils.isEmpty((Object)this.task.getTaskId())) {
                String taskId = this.task.getTaskId();
                TaskExecuter.this.taskComponent.updateStatus(TaskStatus.Process, taskId, "", null);
                long startTime = System.currentTimeMillis();
                this.log.info("\u4efb\u52a1:{}\u5f00\u59cb\u6267\u884c\u3002", (Object)taskId);
                Object result = TaskExecuter.this.executer.execute(this.task);
                Long timeConsuming = System.currentTimeMillis() - startTime;
                this.log.info("\u4efb\u52a1:{}\u5b8c\u6210\u3002\u7528\u65f6:{}ms, result->{}", new Object[]{taskId, timeConsuming, result});
                if (null != result) {
                    if (result instanceof ImportResult) {
                        ImportResult importResult = (ImportResult)result;
                        int error = TaskExecuter.this.attachmentComponent.saveReport(importResult, this.task.getTaskId());
                        if (error == 0) {
                            TaskExecuter.this.taskComponent.updateStatus(TaskStatus.End, taskId, "", timeConsuming);
                        } else {
                            TaskExecuter.this.taskComponent.updateStatus(TaskStatus.Error, taskId, "import data failed: has " + error + " error records", timeConsuming);
                        }
                    } else if (result instanceof Exception) {
                        Exception exception = (Exception)result;
                        String cause = exception.getCause().getMessage();
                        if (cause.length() > 128) {
                            cause = cause.substring(0, 128);
                        }
                        TaskExecuter.this.taskComponent.updateStatus(TaskStatus.Error, this.task.getTaskId(), cause, timeConsuming);
                    }
                } else {
                    TaskExecuter.this.taskComponent.updateStatus(TaskStatus.End, taskId, "result is NULL", timeConsuming);
                }
            }
        }
    }
}

