/*
 * Decompiled with CFR 0.152.
 */
package com.qqt.pool.io.config;

import com.aliyun.oss.ClientConfiguration;
import com.aliyun.oss.OSSClient;
import com.aliyun.oss.common.auth.CredentialsProvider;
import com.aliyun.oss.common.auth.DefaultCredentialProvider;
import com.qqt.pool.io.oss.alioss.AliossTemplate;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
public class AliossConfiguration {
    @Value(value="${io.ali.server}")
    private String server;
    @Value(value="${io.ali.accessKey}")
    private String accessKey;
    @Value(value="${io.ali.secretKey}")
    private String secretKey;

    @Bean
    @ConditionalOnMissingBean(value={OSSClient.class})
    public OSSClient ossClient() {
        ClientConfiguration conf = new ClientConfiguration();
        conf.setMaxConnections(1024);
        conf.setSocketTimeout(50000);
        conf.setConnectionTimeout(50000);
        conf.setConnectionRequestTimeout(1000);
        conf.setIdleConnectionTime(60000L);
        conf.setMaxErrorRetry(5);
        DefaultCredentialProvider credentialsProvider = new DefaultCredentialProvider(this.accessKey, this.secretKey);
        return new OSSClient(this.server, (CredentialsProvider)credentialsProvider, conf);
    }

    @Bean
    @ConditionalOnMissingBean(value={AliossTemplate.class})
    public AliossTemplate aliossTemplate(OSSClient ossClient) {
        return new AliossTemplate(ossClient);
    }
}

