/*
 * Decompiled with CFR 0.152.
 */
package com.qqt.pool.io.oss.alioss;

import com.aliyun.oss.OSSClient;
import com.aliyun.oss.common.utils.BinaryUtil;
import com.aliyun.oss.model.MatchMode;
import com.aliyun.oss.model.ObjectListing;
import com.aliyun.oss.model.ObjectMetadata;
import com.aliyun.oss.model.PolicyConditions;
import com.aliyun.oss.model.PutObjectResult;
import com.qqt.pool.io.bean.BladeFile;
import com.qqt.pool.io.bean.OssFile;
import com.qqt.pool.tool.jackson.JsonUtil;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.util.Calendar;
import java.util.Date;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.util.StringUtils;
import org.springframework.web.multipart.MultipartFile;

public class AliossTemplate {
    private final OSSClient ossClient;
    @Value(value="${io.ali.server}")
    private String server;
    @Value(value="${io.ali.accessKey}")
    private String accessKey;
    @Value(value="${io.ali.secretKey}")
    private String secretKey;
    @Value(value="${io.ali.expireTime:3600}")
    private String expireTime;
    @Value(value="${io.ali.contentLengthRange:10485760}")
    private String contentLengthRange;
    private String bucketNamePrefix;

    public AliossTemplate(OSSClient ossClient) {
        this.ossClient = ossClient;
    }

    public void makeBucket(String bucketName) {
        if (!this.bucketExists(bucketName)) {
            this.ossClient.createBucket(bucketName);
        }
    }

    public void removeBucket(String bucketName) {
        this.ossClient.deleteBucket(this.getBucketName());
    }

    public boolean bucketExists(String bucketName) {
        return this.ossClient.doesBucketExist(bucketName);
    }

    public void copyFile(String bucketName, String fileName, String destBucketName) {
        this.ossClient.copyObject(this.getBucketName(), fileName, this.getBucketName(), fileName);
    }

    public void copyFile(String bucketName, String fileName, String destBucketName, String destFileName) {
        this.ossClient.copyObject(this.getBucketName(), fileName, this.getBucketName(), destFileName);
    }

    public OssFile statFile(String fileName) {
        return this.statFile(this.getBucketName(), fileName);
    }

    public OssFile statFile(String bucketName, String fileName) {
        ObjectMetadata stat = this.ossClient.getObjectMetadata(this.getBucketName(), fileName);
        OssFile ossFile = new OssFile();
        ossFile.setName(fileName);
        ossFile.setLink(this.fileLink(ossFile.getName()));
        ossFile.setHash(stat.getContentMD5());
        ossFile.setLength(stat.getContentLength());
        ossFile.setPutTime(stat.getLastModified());
        ossFile.setContentType(stat.getContentType());
        return ossFile;
    }

    public String filePath(String fileName) {
        return this.getOssHost().concat("/").concat(fileName);
    }

    public String filePath(String bucketName, String fileName) {
        return this.getOssHost(bucketName).concat("/").concat(fileName);
    }

    public String fileLink(String fileName) {
        return this.getOssHost().concat("/").concat(fileName);
    }

    public String fileLink(String bucketName, String fileName) {
        return this.getOssHost(bucketName).concat("/").concat(fileName);
    }

    public BladeFile putFile(String fileName, MultipartFile file, String bucketNamePrefix) {
        this.bucketNamePrefix = bucketNamePrefix;
        return this.putFile(this.getBucketName(), fileName, file);
    }

    public BladeFile putFile(String bucketName, String fileName, MultipartFile file) {
        return this.putFile(bucketName, fileName, file.getInputStream());
    }

    public BladeFile putFile(String fileName, InputStream stream) {
        return this.putFile(this.getBucketName(), fileName, stream);
    }

    public BladeFile putFile(String bucketName, String fileName, InputStream stream) {
        return this.put(bucketName, stream, fileName, false);
    }

    public BladeFile putFileAddFolder(MultipartFile file, String folder, String bucketNamePrefix) {
        this.bucketNamePrefix = bucketNamePrefix;
        InputStream inputStream = file.getInputStream();
        String originalName = folder + file.getOriginalFilename();
        return this.putFile(originalName, inputStream);
    }

    public BladeFile put(String bucketName, InputStream stream, String key, boolean cover) {
        try {
            this.makeBucket(bucketName);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        String originalName = key;
        key = this.getFileName(bucketName, key);
        if (cover) {
            this.ossClient.putObject(bucketName, key, stream);
        } else {
            PutObjectResult response = this.ossClient.putObject(bucketName, key, stream);
            int retryCount = 5;
            for (int retry = 0; StringUtils.isEmpty((Object)response.getETag()) && retry < retryCount; ++retry) {
                response = this.ossClient.putObject(bucketName, key, stream);
            }
        }
        String fileName = key.substring(key.lastIndexOf("/") + 1);
        BladeFile file = new BladeFile();
        file.setOriginalName(originalName);
        file.setName(fileName);
        file.setDomain(this.getOssHost(bucketName));
        file.setLink(this.fileLink(bucketName, key));
        file.setFilePath(key);
        return file;
    }

    public void removeFile(String fileName) {
        this.ossClient.deleteObject(this.getBucketName(), fileName);
    }

    public void removeFile(String bucketName, String fileName) {
        this.ossClient.deleteObject(bucketName, fileName);
    }

    public void removeFiles(List<String> fileNames) {
        fileNames.forEach(this::removeFile);
    }

    public void removeFiles(String bucketName, List<String> fileNames) {
        fileNames.forEach(fileName -> this.removeFile(bucketName, (String)fileName));
    }

    private String getBucketName() {
        Calendar calendar = Calendar.getInstance();
        return this.bucketNamePrefix + "-" + calendar.get(1);
    }

    private String getDirectory() {
        Calendar calendar = Calendar.getInstance();
        return calendar.get(1) + "-" + (calendar.get(2) + 1);
    }

    private String getFileName(String originalFilename) {
        return this.getFileName(this.getBucketName(), originalFilename);
    }

    private String getFileName(String bucketName, String originalFilename) {
        int index;
        String prefix = this.getDirectory() + "/" + originalFilename.substring(0, originalFilename.lastIndexOf("."));
        String suffix = originalFilename.substring(originalFilename.lastIndexOf("."));
        String fileName = originalFilename;
        ObjectListing objectListing = this.ossClient.listObjects(bucketName, prefix);
        AtomicInteger idx = new AtomicInteger();
        if (objectListing != null) {
            List objectSummaries = objectListing.getObjectSummaries();
            objectSummaries.forEach(itemResult -> {
                String objectName = itemResult.getKey();
                String prefix_q = objectName.substring(0, objectName.lastIndexOf("."));
                String suffix_q = objectName.substring(objectName.lastIndexOf("."));
                if (suffix.equalsIgnoreCase(suffix_q)) {
                    if (prefix_q.equals(prefix)) {
                        idx.getAndIncrement();
                    } else if (prefix_q.contains("_") && prefix_q.substring(0, prefix_q.lastIndexOf("_")).equals(prefix)) {
                        idx.getAndIncrement();
                    }
                }
            });
        }
        fileName = (index = idx.get()) > 0 ? prefix + "_" + index + suffix : this.getDirectory() + "/" + fileName;
        return fileName;
    }

    public String getUploadToken() {
        return this.getUploadToken(this.getBucketName());
    }

    public String getUploadToken(String bucketName) {
        return this.getUploadToken(bucketName, Long.parseLong(this.expireTime));
    }

    public String getUploadToken(String bucketName, long expireTime) {
        String baseDir = "upload";
        long expireEndTime = System.currentTimeMillis() + expireTime * 1000L;
        Date expiration = new Date(expireEndTime);
        PolicyConditions policyConds = new PolicyConditions();
        policyConds.addConditionItem("content-length-range", 0L, Long.parseLong(this.contentLengthRange));
        policyConds.addConditionItem(MatchMode.StartWith, "key", baseDir);
        String postPolicy = this.ossClient.generatePostPolicy(expiration, policyConds);
        byte[] binaryData = postPolicy.getBytes(StandardCharsets.UTF_8);
        String encodedPolicy = BinaryUtil.toBase64String((byte[])binaryData);
        String postSignature = this.ossClient.calculatePostSignature(postPolicy);
        LinkedHashMap<String, String> respMap = new LinkedHashMap<String, String>(16);
        respMap.put("accessid", this.accessKey);
        respMap.put("policy", encodedPolicy);
        respMap.put("signature", postSignature);
        respMap.put("dir", baseDir);
        respMap.put("host", this.getOssHost(bucketName));
        respMap.put("expire", String.valueOf(expireEndTime / 1000L));
        return JsonUtil.toJson(respMap);
    }

    public String getOssHost(String bucketName) {
        String prefix = this.server.contains("https://") ? "https://" : "http://";
        return prefix + bucketName + "." + this.server.replaceFirst(prefix, "");
    }

    public String getOssHost() {
        return this.getOssHost(this.getBucketName());
    }
}

