/*
 * Decompiled with CFR 0.152.
 */
package com.qqt.pool.io.oss.minio;

import com.qqt.pool.io.bean.BladeFile;
import com.qqt.pool.io.bean.OssFile;
import com.qqt.pool.io.oss.minio.enums.PolicyType;
import com.qqt.pool.tool.utils.Func;
import io.minio.MinioClient;
import io.minio.ObjectStat;
import io.minio.PutObjectOptions;
import io.minio.errors.ErrorResponseException;
import io.minio.errors.InsufficientDataException;
import io.minio.errors.InternalException;
import io.minio.errors.InvalidBucketNameException;
import io.minio.errors.XmlParserException;
import io.minio.messages.Bucket;
import io.minio.messages.Item;
import java.io.IOException;
import java.io.InputStream;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicInteger;
import org.springframework.web.multipart.MultipartFile;

public class MinioTemplate {
    private final MinioClient client;
    private final String server;

    public MinioTemplate(MinioClient client, String server) {
        this.client = client;
        this.server = server;
    }

    public void makeBucket() throws Exception {
        String bucketName = this.getBucketName();
        if (!this.client.bucketExists(bucketName)) {
            this.client.makeBucket(bucketName);
            this.client.setBucketPolicy(bucketName, MinioTemplate.getPolicyType(bucketName, PolicyType.READ));
        }
    }

    public Bucket getBucket() throws Exception {
        return this.getBucket(this.getBucketName());
    }

    public Bucket getBucket(String bucketName) throws Exception {
        Optional<Bucket> bucketOptional = this.client.listBuckets().stream().filter(bucket -> bucket.name().equals(this.getBucketName())).findFirst();
        return bucketOptional.orElse(null);
    }

    public List<Bucket> listBuckets() throws Exception {
        return this.client.listBuckets();
    }

    public void removeBucket(String bucketName) throws Exception {
        this.client.removeBucket(this.getBucketName(bucketName));
    }

    public boolean bucketExists(String bucketName) throws Exception {
        return this.client.bucketExists(this.getBucketName(bucketName));
    }

    public OssFile statFile(String fileName) throws Exception {
        return this.statFile(this.getBucketName(), fileName);
    }

    public OssFile statFile(String bucketName, String fileName) throws Exception {
        ObjectStat stat = this.client.statObject(this.getBucketName(bucketName), fileName);
        OssFile ossFile = new OssFile();
        ossFile.setName(Func.isEmpty((Object)stat.name()) ? fileName : stat.name());
        ossFile.setLink(this.fileLink(ossFile.getName()));
        ossFile.setHash(String.valueOf(stat.hashCode()));
        ossFile.setLength(stat.length());
        ossFile.setContentType(stat.contentType());
        return ossFile;
    }

    public String filePath(String fileName) {
        return this.getBucketName().concat("/").concat(fileName);
    }

    public String filePath(String bucketName, String fileName) {
        return this.getBucketName(bucketName).concat("/").concat(fileName);
    }

    public String fileLink(String fileName) {
        return this.server.concat("/").concat(this.getBucketName()).concat("/").concat(fileName);
    }

    public String fileLink(String bucketName, String fileName) {
        return this.server.concat("/").concat(this.getBucketName(bucketName)).concat("/").concat(fileName);
    }

    public BladeFile putFile(MultipartFile file, String bucket) throws Exception {
        return this.putFile(bucket, file.getOriginalFilename(), file);
    }

    public BladeFile putFile(MultipartFile file) throws Exception {
        return this.putFile(this.getBucketName(), file.getOriginalFilename(), file);
    }

    public BladeFile putFile(String originalName, MultipartFile file) throws Exception {
        return this.putFile(this.getBucketName(), originalName, file);
    }

    public BladeFile putFile(String bucketName, String originalName, MultipartFile file) throws Exception {
        return this.putFile(bucketName, originalName, file.getInputStream());
    }

    public BladeFile putFile(String originalName, InputStream stream) throws Exception {
        return this.putFile(this.getBucketName(), originalName, stream);
    }

    public BladeFile putFileAddFolder(MultipartFile file, String bucketName, String folder) {
        try {
            InputStream inputStream = file.getInputStream();
            String originalFilename = file.getOriginalFilename();
            return this.putFile(bucketName, folder + originalFilename, inputStream);
        }
        catch (Exception e) {
            System.out.println(e.getMessage());
            return null;
        }
    }

    public BladeFile putFile(String bucketName, String originalName, InputStream stream) throws Exception {
        this.makeBucket();
        String fileName = this.getFileName(bucketName, originalName);
        this.client.putObject(bucketName, fileName, stream, new PutObjectOptions((long)stream.available(), -1L));
        BladeFile file = new BladeFile();
        file.setOriginalName(originalName);
        file.setName(fileName);
        file.setDomain(this.getOssHost(bucketName));
        file.setLink(this.fileLink(bucketName, fileName));
        file.setFilePath(bucketName + "/" + fileName);
        return file;
    }

    public void removeFile(String fileName) throws Exception {
        this.removeFile(this.getBucketName(), fileName);
    }

    public void removeFile(String bucketName, String fileName) throws Exception {
        this.client.removeObject(this.getBucketName(bucketName), fileName);
    }

    public void removeFiles(List<String> fileNames) throws Exception {
        this.removeFiles(this.getBucketName(), fileNames);
    }

    public void removeFiles(String bucketName, List<String> fileNames) throws Exception {
        this.client.removeObjects(this.getBucketName(bucketName), fileNames);
    }

    public String getBucketName() {
        Calendar calendar = Calendar.getInstance();
        return calendar.get(1) + "-" + (calendar.get(2) + 1);
    }

    private String getBucketName(String bucketName) {
        if (!this.client.bucketExists(bucketName)) {
            this.makeBucket();
        }
        Bucket bucket = this.getBucket();
        return bucket.name();
    }

    private String getFileName(String originalFilename) {
        return this.getFileName(this.getBucketName(), originalFilename);
    }

    private String getFileName(String bucketName, String originalFilename) throws XmlParserException {
        String prefix = originalFilename.substring(0, originalFilename.lastIndexOf("."));
        String suffix = originalFilename.substring(originalFilename.lastIndexOf("."));
        String fileName = originalFilename;
        Iterable iterable = this.client.listObjects(bucketName, prefix);
        AtomicInteger idx = new AtomicInteger();
        iterable.forEach(itemResult -> {
            try {
                Item item = (Item)itemResult.get();
                String objectName = item.objectName();
                String prefix_q = objectName.substring(0, objectName.lastIndexOf("."));
                String suffix_q = objectName.substring(objectName.lastIndexOf("."));
                if (suffix.equalsIgnoreCase(suffix_q)) {
                    if (prefix_q.equals(prefix)) {
                        idx.getAndIncrement();
                    } else if (prefix_q.contains("_") && prefix_q.substring(0, prefix_q.lastIndexOf("_")).equals(prefix)) {
                        idx.getAndIncrement();
                    }
                }
            }
            catch (ErrorResponseException | InsufficientDataException | InternalException | InvalidBucketNameException | XmlParserException | IOException | InvalidKeyException | NoSuchAlgorithmException e) {
                e.printStackTrace();
                idx.set(999);
            }
        });
        int index = idx.get();
        if (index > 0) {
            fileName = prefix + "_" + index + suffix;
        }
        return fileName;
    }

    public String getPolicyType(PolicyType policyType) {
        return MinioTemplate.getPolicyType(this.getBucketName(), policyType);
    }

    public static String getPolicyType(String bucketName, PolicyType policyType) {
        StringBuilder builder = new StringBuilder();
        builder.append("{\n");
        builder.append("    \"Statement\": [\n");
        builder.append("        {\n");
        builder.append("            \"Action\": [\n");
        switch (policyType) {
            case WRITE: {
                builder.append("                \"s3:GetBucketLocation\",\n");
                builder.append("                \"s3:ListBucketMultipartUploads\"\n");
                break;
            }
            case READ_WRITE: {
                builder.append("                \"s3:GetBucketLocation\",\n");
                builder.append("                \"s3:ListBucket\",\n");
                builder.append("                \"s3:ListBucketMultipartUploads\"\n");
                break;
            }
            default: {
                builder.append("                \"s3:GetBucketLocation\"\n");
            }
        }
        builder.append("            ],\n");
        builder.append("            \"Effect\": \"Allow\",\n");
        builder.append("            \"Principal\": \"*\",\n");
        builder.append("            \"Resource\": \"arn:aws:s3:::");
        builder.append(bucketName);
        builder.append("\"\n");
        builder.append("        },\n");
        if (PolicyType.READ.equals((Object)policyType)) {
            builder.append("        {\n");
            builder.append("            \"Action\": [\n");
            builder.append("                \"s3:ListBucket\"\n");
            builder.append("            ],\n");
            builder.append("            \"Effect\": \"Deny\",\n");
            builder.append("            \"Principal\": \"*\",\n");
            builder.append("            \"Resource\": \"arn:aws:s3:::");
            builder.append(bucketName);
            builder.append("\"\n");
            builder.append("        },\n");
        }
        builder.append("        {\n");
        builder.append("            \"Action\": ");
        switch (policyType) {
            case WRITE: {
                builder.append("[\n");
                builder.append("                \"s3:AbortMultipartUpload\",\n");
                builder.append("                \"s3:DeleteObject\",\n");
                builder.append("                \"s3:ListMultipartUploadParts\",\n");
                builder.append("                \"s3:PutObject\"\n");
                builder.append("            ],\n");
                break;
            }
            case READ_WRITE: {
                builder.append("[\n");
                builder.append("                \"s3:AbortMultipartUpload\",\n");
                builder.append("                \"s3:DeleteObject\",\n");
                builder.append("                \"s3:GetObject\",\n");
                builder.append("                \"s3:ListMultipartUploadParts\",\n");
                builder.append("                \"s3:PutObject\"\n");
                builder.append("            ],\n");
                break;
            }
            default: {
                builder.append("\"s3:GetObject\",\n");
            }
        }
        builder.append("            \"Effect\": \"Allow\",\n");
        builder.append("            \"Principal\": \"*\",\n");
        builder.append("            \"Resource\": \"arn:aws:s3:::");
        builder.append(bucketName);
        builder.append("/*\"\n");
        builder.append("        }\n");
        builder.append("    ],\n");
        builder.append("    \"Version\": \"2012-10-17\"\n");
        builder.append("}\n");
        return builder.toString();
    }

    public String getOssHost(String bucketName) {
        return this.server + "/" + this.getBucketName(bucketName);
    }

    public String getOssHost() {
        return this.getOssHost(this.getBucketName());
    }

    public List<String> listObjcet(String bucketName) {
        ArrayList<String> filePath = new ArrayList<String>();
        try {
            Iterable results = this.client.listObjects(bucketName);
            results.forEach(itemResult -> {
                try {
                    Item item = (Item)itemResult.get();
                    String objectName = item.objectName();
                    filePath.add(objectName);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            });
            return filePath;
        }
        catch (XmlParserException e) {
            e.printStackTrace();
            return null;
        }
    }

    public InputStream downloadFile(String bucketName, String path) {
        try {
            return this.client.getObject(bucketName, path);
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }
}

