/*
 * Decompiled with CFR 0.152.
 */
package com.qqt.pool.io.util;

import com.qqt.pool.io.util.DateUtils;
import java.math.BigDecimal;
import java.util.Date;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;

public class MapValueHelper {
    public static String getStr(String key, Map<String, Object> origin) {
        if (StringUtils.isEmpty((CharSequence)key) || null == origin) {
            return null;
        }
        String value = origin.get(key) != null ? String.valueOf(origin.get(key)) : "";
        return value;
    }

    public static String getStrByDefault(String key, Map<String, Object> origin, String defaultValue) {
        if (StringUtils.isEmpty((CharSequence)key) || null == origin) {
            return defaultValue;
        }
        String value = origin.get(key) != null ? String.valueOf(origin.get(key)) : defaultValue;
        return value;
    }

    public static String nvlStr(String str, String defaultStr) {
        if (StringUtils.isNotBlank((CharSequence)str)) {
            return str;
        }
        return defaultStr;
    }

    public static String getDate(String key, Map<String, Object> origin, String pattern) {
        if (StringUtils.isEmpty((CharSequence)key) || null == origin || origin.isEmpty() || !origin.containsKey(key) || null == origin.get(key)) {
            return null;
        }
        if (origin.get(key) instanceof Date) {
            Date date = (Date)origin.get(key);
            return DateUtils.format(date, pattern);
        }
        String dateStr = MapValueHelper.getStr(key, origin);
        return DateUtils.format(DateUtils.parse(dateStr, pattern), pattern);
    }

    public static Date getDate2(String key, Map<String, Object> origin, String pattern) {
        if (StringUtils.isEmpty((CharSequence)key) || null == origin || origin.isEmpty() || !origin.containsKey(key) || origin.get(key) == null || "".equals(origin.get(key))) {
            return null;
        }
        if (origin.get(key) instanceof Date) {
            Date date = (Date)origin.get(key);
            return DateUtils.parse(DateUtils.format(date, pattern), pattern);
        }
        String dateStr = MapValueHelper.getStr(key, origin);
        return DateUtils.parse(DateUtils.format(DateUtils.parse(dateStr, pattern), pattern), pattern);
    }

    public static Boolean getBoolean(String key, Map<String, Object> origin, Boolean defaultValue) {
        if (StringUtils.isEmpty((CharSequence)key) || null == origin || origin.isEmpty() || !origin.containsKey(key) || null == origin.get(key)) {
            return defaultValue;
        }
        String value = String.valueOf(origin.get(key));
        if (StringUtils.isEmpty((CharSequence)value)) {
            return defaultValue;
        }
        return Boolean.valueOf(value);
    }

    public static Integer getInteger(String key, Map<String, Object> origin, Integer defaultValue) {
        if (StringUtils.isEmpty((CharSequence)key) || null == origin || origin.isEmpty() || !origin.containsKey(key) || null == origin.get(key)) {
            return defaultValue;
        }
        String value = String.valueOf(origin.get(key));
        if (StringUtils.isEmpty((CharSequence)value)) {
            return defaultValue;
        }
        return Integer.valueOf(value);
    }

    public static BigDecimal getBigDecimal(String key, Map<String, Object> origin, BigDecimal defaultValue, Integer scale) {
        if (StringUtils.isEmpty((CharSequence)key) || null == origin || origin.isEmpty() || !origin.containsKey(key) || null == origin.get(key)) {
            return defaultValue;
        }
        try {
            BigDecimal bigD = new BigDecimal(MapValueHelper.getStr(key, origin));
            if (null != scale) {
                bigD = bigD.setScale((int)scale, 4);
            }
            return bigD;
        }
        catch (Exception ex) {
            return defaultValue;
        }
    }

    public static Boolean isEmptyList(List<?> list) {
        return null == list || list.isEmpty();
    }

    public static Boolean isNotEmptyList(List<?> list) {
        return null != list && !list.isEmpty();
    }
}

