/*
 * Decompiled with CFR 0.152.
 */
package com.qqt.sourcepool.xfs.strategy.impl;

import com.alibaba.fastjson.JSON;
import com.qqt.pool.api.request.xfs.ReqXfsOrderCancelDO;
import com.qqt.pool.api.response.ResultDO;
import com.qqt.pool.api.thirdPlatform.request.CommonCancelOrderDO;
import com.qqt.pool.api.thirdPlatform.response.CommonRspResultDO;
import com.qqt.pool.base.response.PoolRespBean;
import com.qqt.pool.common.dto.ResultDTO;
import com.qqt.pool.common.exception.BusinessException;
import com.qqt.pool.common.service.PoolsService;
import com.qqt.pool.common.utils.ThreadLocalUtil;
import com.qqt.sourcepool.xfs.feign.SourcePoolXfsFeignService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="90006_xfs")
public class XfsOrderCancelServiceImpl
implements PoolsService {
    @Autowired
    private SourcePoolXfsFeignService feignService;

    public String service(String content) {
        String type;
        switch (type = (String)ThreadLocalUtil.get((String)"mode")) {
            case "DEFAULT_MODE": {
                ReqXfsOrderCancelDO reqXfsOrderCancelDO = (ReqXfsOrderCancelDO)JSON.parseObject((String)content, ReqXfsOrderCancelDO.class);
                ResultDTO<ResultDO> resultDO = this.feignService.cancelOrder(reqXfsOrderCancelDO);
                if (resultDO.isFail()) {
                    return JSON.toJSONString((Object)PoolRespBean.fail((String)resultDO.getMsg()));
                }
                return JSON.toJSONString((Object)resultDO.getData());
            }
            case "FAST_MODE": {
                CommonCancelOrderDO commonCancelOrderDO = (CommonCancelOrderDO)JSON.parseObject((String)content, CommonCancelOrderDO.class);
                ReqXfsOrderCancelDO cancelOrderDO = new ReqXfsOrderCancelDO();
                cancelOrderDO.setOrderNo(commonCancelOrderDO.getOrderId());
                ResultDTO<ResultDO> resultDO = this.feignService.cancelOrder(cancelOrderDO);
                if (resultDO.isFail()) {
                    return JSON.toJSONString((Object)PoolRespBean.fail((String)resultDO.getMsg()));
                }
                CommonRspResultDO commonRspResultDO = new CommonRspResultDO();
                commonRspResultDO.setMsg(resultDO.getMsg());
                commonRspResultDO.setSuccess(resultDO.isSuccess());
                return JSON.toJSONString((Object)commonRspResultDO);
            }
        }
        throw new BusinessException("Does not support this mode of execution", "\u4e0d\u652f\u6301\u8be5\u6a21\u5f0f\u6267\u884c");
    }
}

