/*
 * Decompiled with CFR 0.152.
 */
package com.qqt.sourcepool.xfs.strategy.impl;

import com.alibaba.fastjson.JSON;
import com.qqt.pool.api.request.xfs.ReqXfsOrderQueryDO;
import com.qqt.pool.api.response.xfs.XfsOrderQueryRespDO;
import com.qqt.pool.api.thirdPlatform.request.ReqCommonQueryOrderDO;
import com.qqt.pool.api.thirdPlatform.response.CommonQueryOrderRespDO;
import com.qqt.pool.base.response.PoolRespBean;
import com.qqt.pool.common.dto.ResultDTO;
import com.qqt.pool.common.exception.BusinessException;
import com.qqt.pool.common.service.PoolsService;
import com.qqt.pool.common.utils.ThreadLocalUtil;
import com.qqt.sourcepool.xfs.feign.SourcePoolXfsFeignService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="90026_xfs")
public class XfsOrderQueryServiceImpl
implements PoolsService {
    @Autowired
    private SourcePoolXfsFeignService feignService;

    public String service(String content) {
        String type;
        switch (type = (String)ThreadLocalUtil.get((String)"mode")) {
            case "DEFAULT_MODE": {
                ReqXfsOrderQueryDO queryOrderDO = (ReqXfsOrderQueryDO)JSON.parseObject((String)content, ReqXfsOrderQueryDO.class);
                ResultDTO<XfsOrderQueryRespDO> resultDTO = this.feignService.queryOrderDetail(queryOrderDO);
                if (resultDTO.isFail()) {
                    return JSON.toJSONString((Object)PoolRespBean.fail((String)resultDTO.getMsg()));
                }
                return JSON.toJSONString((Object)resultDTO.getData());
            }
            case "FAST_MODE": {
                ReqCommonQueryOrderDO queryDO = (ReqCommonQueryOrderDO)JSON.parseObject((String)content, ReqCommonQueryOrderDO.class);
                ResultDTO<CommonQueryOrderRespDO> res = this.feignService.handleSplitOrder(queryDO.getSupplierOrderId(), queryDO.getType());
                if (res.isFail()) {
                    return JSON.toJSONString((Object)PoolRespBean.fail((String)res.getMsg()));
                }
                CommonQueryOrderRespDO data = (CommonQueryOrderRespDO)res.getData();
                return JSON.toJSONString((Object)data);
            }
        }
        throw new BusinessException("Does not support this mode of execution", "\u4e0d\u652f\u6301\u8be5\u6a21\u5f0f\u6267\u884c");
    }
}

