/*
 * Decompiled with CFR 0.152.
 */
package com.qqt.sourcepool.xfs.strategy.impl;

import com.alibaba.fastjson.JSON;
import com.qqt.pool.api.request.xfs.ReqXfsOrderReceiveDO;
import com.qqt.pool.api.response.ResultDO;
import com.qqt.pool.api.thirdPlatform.request.CommonReqOrderCompletionDO;
import com.qqt.pool.api.thirdPlatform.response.CommonRspResultDO;
import com.qqt.pool.base.response.PoolRespBean;
import com.qqt.pool.common.dto.ResultDTO;
import com.qqt.pool.common.exception.BusinessException;
import com.qqt.pool.common.service.PoolsService;
import com.qqt.pool.common.utils.ThreadLocalUtil;
import com.qqt.sourcepool.xfs.feign.SourcePoolXfsFeignService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="90007_xfs")
public class XfsOrderReceiveServiceImpl
implements PoolsService {
    @Autowired
    private SourcePoolXfsFeignService feignService;

    public String service(String content) {
        String type;
        switch (type = (String)ThreadLocalUtil.get((String)"mode")) {
            case "DEFAULT_MODE": {
                ReqXfsOrderReceiveDO reqXfsOrderCancelDO = (ReqXfsOrderReceiveDO)JSON.parseObject((String)content, ReqXfsOrderReceiveDO.class);
                ResultDTO<ResultDO> resultDO = this.feignService.receiveOrder(reqXfsOrderCancelDO);
                if (resultDO.isFail()) {
                    return JSON.toJSONString((Object)PoolRespBean.fail((String)resultDO.getMsg()));
                }
                return JSON.toJSONString((Object)resultDO.getData());
            }
            case "FAST_MODE": {
                CommonReqOrderCompletionDO completionDO = (CommonReqOrderCompletionDO)JSON.parseObject((String)content, CommonReqOrderCompletionDO.class);
                ReqXfsOrderReceiveDO receiveDO = new ReqXfsOrderReceiveDO();
                receiveDO.setOrderNo(completionDO.getOrderId());
                ResultDTO<ResultDO> resultDO = this.feignService.receiveOrder(receiveDO);
                if (resultDO.isFail()) {
                    return JSON.toJSONString((Object)PoolRespBean.fail((String)resultDO.getMsg()));
                }
                CommonRspResultDO commonRspResultDO = new CommonRspResultDO();
                commonRspResultDO.setSuccess(true);
                return JSON.toJSONString((Object)commonRspResultDO);
            }
        }
        throw new BusinessException("Does not support this mode of execution", "\u4e0d\u652f\u6301\u8be5\u6a21\u5f0f\u6267\u884c");
    }
}

