/*
 * Decompiled with CFR 0.152.
 */
package com.qqt.sourcepool.xfs.strategy.impl;

import com.alibaba.fastjson.JSON;
import com.qqt.pool.api.request.xfs.ReqXfsInvoiceApplyDO;
import com.qqt.pool.api.response.ResultDO;
import com.qqt.pool.api.thirdPlatform.request.CommonReqSubmitInvoiceDO;
import com.qqt.pool.api.thirdPlatform.response.CommonRspResultDO;
import com.qqt.pool.base.response.PoolRespBean;
import com.qqt.pool.common.dto.ResultDTO;
import com.qqt.pool.common.exception.BusinessException;
import com.qqt.pool.common.service.PoolsService;
import com.qqt.pool.common.utils.ThreadLocalUtil;
import com.qqt.sourcepool.xfs.feign.SourcePoolXfsFeignService;
import com.qqt.sourcepool.xfs.strategy.mapper.XfsInvoiceApplyDOMapper;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="90024_xfs")
public class XfsInvoiceApplyServiceImpl
implements PoolsService {
    @Autowired
    private SourcePoolXfsFeignService feignService;
    @Autowired
    private XfsInvoiceApplyDOMapper mapper;

    public String service(String content) {
        String type;
        switch (type = (String)ThreadLocalUtil.get((String)"mode")) {
            case "DEFAULT_MODE": {
                ReqXfsInvoiceApplyDO req = (ReqXfsInvoiceApplyDO)JSON.parseObject((String)content, ReqXfsInvoiceApplyDO.class);
                ResultDTO<ResultDO> resultDTO = this.feignService.applyInvoice(req);
                if (resultDTO.isFail()) {
                    return JSON.toJSONString((Object)PoolRespBean.fail((String)resultDTO.getMsg()));
                }
                return JSON.toJSONString((Object)resultDTO.getData());
            }
            case "FAST_MODE": {
                CommonReqSubmitInvoiceDO commonReqSubmitInvoiceDO = (CommonReqSubmitInvoiceDO)JSON.parseObject((String)content, CommonReqSubmitInvoiceDO.class);
                ReqXfsInvoiceApplyDO invoiceApplyDO = this.mapper.toDO(commonReqSubmitInvoiceDO);
                ResultDTO<ResultDO> result = this.feignService.applyInvoice(invoiceApplyDO);
                if (result.isFail()) {
                    return JSON.toJSONString((Object)PoolRespBean.fail((String)result.getMsg()));
                }
                CommonRspResultDO commonRspResultDO = new CommonRspResultDO(result.isSuccess(), result.getMsg());
                return JSON.toJSONString((Object)commonRspResultDO);
            }
        }
        throw new BusinessException("Does not support this mode of execution", "\u4e0d\u652f\u6301\u8be5\u6a21\u5f0f\u6267\u884c");
    }
}

