/*
 * Decompiled with CFR 0.152.
 */
package com.qqt.sourcepool.xfs.strategy.impl;

import com.alibaba.fastjson.JSON;
import com.qqt.pool.api.request.xfs.ReqXfsOrderSubmitDO;
import com.qqt.pool.api.response.xfs.XfsOrderReturnInfoRespDO;
import com.qqt.pool.api.thirdPlatform.request.CommonOrderSubmitDO;
import com.qqt.pool.api.thirdPlatform.response.CommonOrderReturnInfoRespDO;
import com.qqt.pool.base.response.PoolRespBean;
import com.qqt.pool.common.dto.ResultDTO;
import com.qqt.pool.common.exception.BusinessException;
import com.qqt.pool.common.service.PoolsService;
import com.qqt.pool.common.utils.ThreadLocalUtil;
import com.qqt.sourcepool.xfs.feign.SourcePoolXfsFeignService;
import com.qqt.sourcepool.xfs.strategy.mapper.XfsOrderSubmitDOMapper;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="90001_xfs")
public class XfsOrderSubmitServiceImpl
implements PoolsService {
    @Autowired
    private SourcePoolXfsFeignService feignService;
    @Autowired
    private XfsOrderSubmitDOMapper orderSubmitDOMapper;

    public String service(String content) {
        String type;
        switch (type = (String)ThreadLocalUtil.get((String)"mode")) {
            case "DEFAULT_MODE": {
                ReqXfsOrderSubmitDO orderSubmitDO = (ReqXfsOrderSubmitDO)JSON.parseObject((String)content, ReqXfsOrderSubmitDO.class);
                ResultDTO<XfsOrderReturnInfoRespDO> resultDTO = this.feignService.submitOrder(orderSubmitDO);
                if (resultDTO.isFail()) {
                    return JSON.toJSONString((Object)PoolRespBean.fail((String)resultDTO.getMsg()));
                }
                return JSON.toJSONString((Object)resultDTO.getData());
            }
            case "FAST_MODE": {
                CommonOrderSubmitDO commonOrderSubmitDO = (CommonOrderSubmitDO)JSON.parseObject((String)content, CommonOrderSubmitDO.class);
                ReqXfsOrderSubmitDO request = this.orderSubmitDOMapper.toDO(commonOrderSubmitDO);
                ResultDTO<XfsOrderReturnInfoRespDO> resultDTO = this.feignService.submitOrder(request);
                if (resultDTO.isFail()) {
                    return JSON.toJSONString((Object)PoolRespBean.fail((String)resultDTO.getMsg()));
                }
                CommonOrderReturnInfoRespDO commonOrderReturnInfoRespDO = this.orderSubmitDOMapper.toCommonDO((XfsOrderReturnInfoRespDO)resultDTO.getData());
                commonOrderReturnInfoRespDO.setCompanyName(commonOrderSubmitDO.getInvoiceInfoDO().getTitle());
                commonOrderReturnInfoRespDO.setAddress(commonOrderSubmitDO.getCommonRegionInfoSubDO().getAddressLine());
                commonOrderReturnInfoRespDO.setThirdOrder(commonOrderSubmitDO.getThirdOrder());
                return JSON.toJSONString((Object)commonOrderReturnInfoRespDO);
            }
        }
        throw new BusinessException("Does not support this mode of execution", "\u4e0d\u652f\u6301\u8be5\u6a21\u5f0f\u6267\u884c");
    }
}

