/*
 * Decompiled with CFR 0.152.
 */
package com.qqt.sourcepool.xfs.strategy.mapper;

import com.qqt.pool.api.request.xfs.ReqXfsOrderSubmitDO;
import com.qqt.pool.api.response.xfs.XfsOrderReturnInfoRespDO;
import com.qqt.pool.api.thirdPlatform.request.CommonOrderSubmitDO;
import com.qqt.pool.api.thirdPlatform.request.CommonProductSkuInfoDO;
import com.qqt.pool.api.thirdPlatform.response.CommonOrderReturnInfoRespDO;
import com.qqt.pool.api.thirdPlatform.response.CommonOrderReturnSkuInfoDO;
import com.qqt.pool.common.utils.UserUtils;
import java.time.Instant;
import java.time.ZoneId;
import java.time.format.DateTimeFormatter;
import org.mapstruct.AfterMapping;
import org.mapstruct.Mapper;
import org.mapstruct.Mapping;
import org.mapstruct.MappingTarget;
import org.mapstruct.Mappings;

@Mapper(componentModel="spring")
public abstract class XfsOrderSubmitDOMapper {
    @Mappings(value={@Mapping(source="thirdOrder", target="chnOrderNo"), @Mapping(source="invoiceInfoDO.title", target="chnCustomerName"), @Mapping(source="commonRegionInfoSubDO.provinceCode", target="provinceCode"), @Mapping(source="commonRegionInfoSubDO.cityCode", target="cityCode"), @Mapping(source="commonRegionInfoSubDO.countyCode", target="countyCode"), @Mapping(source="commonRegionInfoSubDO.townCode", target="townCode"), @Mapping(source="commonRegionInfoSubDO.addressLine", target="address"), @Mapping(source="mobile", target="receiverPhone"), @Mapping(source="memo", target="remark"), @Mapping(source="orderTime", target="createDate"), @Mapping(source="productSkuList", target="skuInfos")})
    public abstract ReqXfsOrderSubmitDO toDO(CommonOrderSubmitDO var1);

    public String asString(Instant orderTime) {
        return orderTime == null ? null : DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss").format(orderTime.atZone(ZoneId.systemDefault()));
    }

    @Mappings(value={@Mapping(source="skuCode", target="skuNo"), @Mapping(source="quantity", target="buyNum"), @Mapping(source="unitPrice", target="settlePrice")})
    public abstract ReqXfsOrderSubmitDO.ReqXfsOrderSubmitSkuDO toDO(CommonProductSkuInfoDO var1);

    public abstract CommonOrderReturnInfoRespDO toCommonDO(XfsOrderReturnInfoRespDO var1);

    @Mappings(value={@Mapping(target="thirdSkuId", source="skuId"), @Mapping(target="thirdSkuName", source="name")})
    public abstract CommonOrderReturnSkuInfoDO toCommonDO(XfsOrderReturnInfoRespDO.XfsOrderSkuDO var1);

    @AfterMapping
    protected void afterMapping(CommonOrderSubmitDO toDO, @MappingTarget ReqXfsOrderSubmitDO commonDO) {
        commonDO.setProjectId(UserUtils.getSessionService().getElsAccount());
    }
}

