/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cds.ql;

import com.sap.cds.ql.CDS;
import com.sap.cds.ql.Predicate;
import com.sap.cds.ql.Source;
import com.sap.cds.ql.StructuredType;
import com.sap.cds.ql.Value;
import com.sap.cds.ql.cqn.CqnElementRef;
import com.sap.cds.ql.cqn.CqnExpression;
import com.sap.cds.ql.cqn.CqnSelect;
import com.sap.cds.ql.cqn.CqnSelectListItem;
import com.sap.cds.ql.cqn.CqnSortSpecification;
import com.sap.cds.reflect.CdsEntity;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.function.UnaryOperator;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public abstract class Select<T extends StructuredType<?>>
implements Source<T>,
CqnSelect {
    public static Select<StructuredType<?>> from(String entityName) {
        return CDS.QL.builder.select(entityName);
    }

    public static Select<StructuredType<?>> from(String entityName, UnaryOperator<StructuredType<?>> path) {
        return CDS.QL.builder.select(entityName, path);
    }

    public static Select<StructuredType<?>> from(CdsEntity entity) {
        return CDS.QL.builder.select(entity);
    }

    public static Select<StructuredType<?>> from(CdsEntity entity, UnaryOperator<StructuredType<?>> path) {
        return CDS.QL.builder.select(entity, path);
    }

    public static <E extends StructuredType<E>> Select<E> from(Class<E> entity) {
        return CDS.QL.builder.select(entity);
    }

    public static <E extends StructuredType<E>, R extends StructuredType<R>> Select<R> from(Class<E> entity, Function<E, R> path) {
        return CDS.QL.builder.select(entity, path);
    }

    public static Select<StructuredType<?>> cqn(String cqnSelect) {
        return CDS.QL.parser.select(cqnSelect);
    }

    public abstract Select<T> distinct();

    @SafeVarargs
    public final Select<T> columns(CqnSelectListItem ... items) {
        return this.columns(Arrays.asList(items));
    }

    @SafeVarargs
    public final Select<T> columns(Function<T, CqnSelectListItem> ... items) {
        return this.columns(this.applyFunctions(items));
    }

    public abstract Select<T> columns(List<CqnSelectListItem> var1);

    public abstract Select<T> columns(Stream<CqnSelectListItem> var1);

    public abstract Select<T> columns(String ... var1);

    public final Select<T> excluding(String ... slis) {
        return this.excluding(Arrays.asList(slis));
    }

    @SafeVarargs
    public final Select<T> excluding(Function<T, CqnSelectListItem> ... items) {
        return this.excluding(Arrays.stream(items).map(f -> ((CqnSelectListItem)f.apply(this.getRoot())).displayName()).collect(Collectors.toList()));
    }

    public abstract Select<T> excluding(List<String> var1);

    public abstract Select<T> where(Function<T, Predicate> var1);

    public abstract Select<T> matching(Map<String, ?> var1);

    public final Select<T> groupBy(CqnElementRef ... refs) {
        return this.groupBy(Arrays.asList(refs));
    }

    @SafeVarargs
    public final Select<T> groupBy(Function<T, CqnSelectListItem> ... items) {
        return this.groupBy(this.applyFunctions(items));
    }

    public abstract Select<T> groupBy(List<CqnSelectListItem> var1);

    public abstract Select<T> groupBy(String ... var1);

    public abstract Select<T> having(CqnExpression var1);

    public abstract Select<T> having(Function<T, Predicate> var1);

    @SafeVarargs
    public final Select<T> orderBy(Function<T, CqnSortSpecification> ... sortSpec) {
        return this.orderBy(this.applyFunctions(sortSpec));
    }

    public final Select<T> orderBy(CqnSortSpecification ... orderBy) {
        return this.orderBy(Arrays.asList(orderBy));
    }

    public abstract Select<T> orderBy(List<CqnSortSpecification> var1);

    public abstract Select<T> orderBy(String ... var1);

    public abstract Select<T> limit(int var1);

    public abstract Select<T> limit(int var1, int var2);

    public final Select<T> limit(Function<T, Value<Integer>> rows, Function<T, Value<Integer>> offset) {
        return this.limit(rows.apply(this.getRoot()), offset.apply(this.getRoot()));
    }

    public final Select<T> limit(Function<T, Value<Integer>> rows) {
        return this.limit(rows, null);
    }

    public abstract Select<T> limit(Value<Integer> var1, Value<Integer> var2);

    public String toString() {
        return this.toJson();
    }

    @SafeVarargs
    private final <R> List<R> applyFunctions(Function<T, R> ... functions) {
        return Arrays.stream(functions).map(f -> f.apply(this.getRoot())).collect(Collectors.toList());
    }
}

