/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cds.reflect;

import com.sap.cds.reflect.CdsAction;
import com.sap.cds.reflect.CdsAnnotation;
import com.sap.cds.reflect.CdsEntity;
import com.sap.cds.reflect.CdsFunction;
import com.sap.cds.reflect.CdsService;
import com.sap.cds.reflect.CdsType;
import com.sap.cds.reflect.CdsVisitor;
import java.util.Optional;
import java.util.stream.Stream;

public interface CdsModel {
    public Stream<CdsAnnotation<?>> annotations(String var1);

    public Stream<CdsService> services();

    public CdsService getService(String var1);

    public Optional<CdsService> findService(String var1);

    public Stream<CdsType> types();

    public CdsType getType(String var1);

    public Optional<CdsType> findType(String var1);

    public Stream<CdsEntity> entities();

    default public Stream<CdsEntity> concreteEntities() {
        return this.entities().filter(e -> !e.isAbstract());
    }

    public CdsEntity getEntity(String var1);

    public Optional<CdsEntity> findEntity(String var1);

    public Stream<CdsAction> actions();

    public CdsAction getAction(String var1);

    public Optional<CdsAction> findAction(String var1);

    public Stream<CdsFunction> functions();

    public CdsFunction getFunction(String var1);

    public Optional<CdsFunction> findFunction(String var1);

    public <T> T getMeta(String var1);

    public String getVersion();

    default public void accept(CdsVisitor visitor) {
        this.services().forEach(s -> s.accept(visitor));
        this.types().forEach(t -> t.accept(visitor));
        this.entities().forEach(e -> e.accept(visitor));
        visitor.visit(this);
    }
}

