/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cloud.sdk.cloudplatform.connectivity;

import com.sap.cloud.sdk.cloudplatform.logging.CloudLoggerFactory;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.slf4j.Logger;

public enum DestinationType {
    HTTP("HTTP"),
    RFC("RFC"),
    MAIL("MAIL"),
    LDAP("LDAP");

    private static final Logger logger;
    @Nonnull
    private final String identifier;

    private DestinationType(String identifier) {
        this.identifier = identifier;
    }

    public String toString() {
        return this.identifier;
    }

    @Nonnull
    public static DestinationType ofIdentifier(@Nonnull String identifier) throws IllegalArgumentException {
        for (DestinationType destinationType : DestinationType.values()) {
            if (!destinationType.getIdentifier().equals(identifier)) continue;
            return destinationType;
        }
        throw new IllegalArgumentException("Unknown " + DestinationType.class.getSimpleName() + ": " + identifier + ".");
    }

    @Nonnull
    public static DestinationType ofIdentifierOrDefault(@Nullable String identifier, @Nonnull DestinationType defaultDestinationType) {
        if (identifier == null) {
            return defaultDestinationType;
        }
        try {
            return DestinationType.ofIdentifier(identifier);
        }
        catch (IllegalArgumentException e) {
            if (logger.isWarnEnabled()) {
                logger.warn(DestinationType.class.getSimpleName() + " '" + identifier + "' is not supported. Falling back to " + (Object)((Object)defaultDestinationType) + ".");
            }
            return defaultDestinationType;
        }
    }

    @Nonnull
    public String getIdentifier() {
        return this.identifier;
    }

    static {
        logger = CloudLoggerFactory.getLogger(DestinationType.class);
    }
}

