/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cloud.sdk.cloudplatform.connectivity;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.sap.cloud.sdk.cloudplatform.connectivity.AbstractDestinationParser;
import com.sap.cloud.sdk.cloudplatform.connectivity.exception.DestinationAccessException;
import java.util.HashMap;
import java.util.Map;

class EnvironmentVariableDestinationParser
extends AbstractDestinationParser {
    private static final String PROPERTIES = "properties";
    private static final String PROPERTY_KEY = "key";
    private static final String PROPERTY_VALUE = "value";
    private final JsonObject destinationAsJson;

    EnvironmentVariableDestinationParser(JsonObject destinationAsJson) {
        this.destinationAsJson = destinationAsJson;
    }

    private Map<String, String> getStandardProperties() {
        HashMap<String, String> properties = new HashMap<String, String>();
        for (Map.Entry entry : this.destinationAsJson.entrySet()) {
            String key = (String)entry.getKey();
            JsonElement jsonElement = this.destinationAsJson.get(key);
            if (jsonElement == null || !jsonElement.isJsonPrimitive()) continue;
            if ("URL".equalsIgnoreCase(key) || "uri".equalsIgnoreCase(key)) {
                properties.put("URL", jsonElement.getAsString());
                continue;
            }
            if ("User".equalsIgnoreCase(key) || "username".equalsIgnoreCase(key)) {
                properties.put("User", jsonElement.getAsString());
                continue;
            }
            for (String propertyKey : standardPropertyKeys) {
                if (!propertyKey.equalsIgnoreCase(key)) continue;
                properties.put(propertyKey, jsonElement.getAsString());
            }
        }
        return properties;
    }

    @Override
    Map<String, String> getProperties() throws DestinationAccessException {
        Map<String, String> properties = this.getStandardProperties();
        JsonElement jsonElement = this.destinationAsJson.get(PROPERTIES);
        if (jsonElement != null) {
            if (!jsonElement.isJsonArray()) {
                throw new DestinationAccessException("No valid JSON array 'properties' defined.");
            }
            JsonArray jsonArray = jsonElement.getAsJsonArray();
            for (JsonElement nestedElement : jsonArray) {
                if (nestedElement == null || !nestedElement.isJsonObject()) {
                    throw new DestinationAccessException("Destination property is not a JSON object.");
                }
                JsonObject jsonObject = nestedElement.getAsJsonObject();
                JsonElement key = jsonObject.get(PROPERTY_KEY);
                JsonElement value = jsonObject.get(PROPERTY_VALUE);
                if (key != null && key.isJsonPrimitive() && value != null && value.isJsonPrimitive()) {
                    properties.put(key.getAsString(), value.getAsString());
                    continue;
                }
                throw new DestinationAccessException("No valid JSON primitives 'key' and 'value' defined for destination property.");
            }
        }
        return properties;
    }

    JsonObject getDestinationAsJson() {
        return this.destinationAsJson;
    }
}

