/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cloud.sdk.cloudplatform.connectivity;

import com.google.common.cache.Cache;
import com.sap.cloud.sdk.cloudplatform.cache.CacheKey;
import com.sap.cloud.sdk.cloudplatform.connectivity.Destination;
import com.sap.cloud.sdk.cloudplatform.connectivity.DestinationsRequestContextListener;
import com.sap.cloud.sdk.cloudplatform.connectivity.HttpClientCache;
import com.sap.cloud.sdk.cloudplatform.connectivity.exception.HttpClientInstantiationException;
import com.sap.cloud.sdk.cloudplatform.servlet.Property;
import com.sap.cloud.sdk.cloudplatform.servlet.RequestContext;
import com.sap.cloud.sdk.cloudplatform.servlet.RequestContextAccessor;
import com.sap.cloud.sdk.cloudplatform.servlet.exception.RequestContextPropertyException;
import java.util.Optional;
import javax.annotation.Nonnull;
import org.apache.http.client.HttpClient;

public class RequestScopedHttpClientCache
extends HttpClientCache {
    @Override
    @Nonnull
    protected Optional<Cache<CacheKey, HttpClient>> getCache() throws HttpClientInstantiationException {
        Optional requestContext = RequestContextAccessor.getCurrentRequestContext();
        if (requestContext.isPresent()) {
            Optional property;
            try {
                property = ((RequestContext)requestContext.get()).getProperty(DestinationsRequestContextListener.PROPERTY_HTTP_CLIENTS);
            }
            catch (RequestContextPropertyException e) {
                throw new HttpClientInstantiationException("Failed to instantiate " + HttpClient.class.getSimpleName() + ": failed to get " + RequestContext.class.getSimpleName() + " property.", e);
            }
            if (property.isPresent()) {
                Exception exception = ((Property)property.get()).getException();
                if (exception != null) {
                    throw new HttpClientInstantiationException("Failed to get " + HttpClient.class.getSimpleName() + " cache.", exception);
                }
                Cache cache = (Cache)((Property)property.get()).getValue();
                if (cache == null) {
                    throw new HttpClientInstantiationException("Failed to get " + HttpClient.class.getSimpleName() + " cache.");
                }
                return Optional.of(cache);
            }
        }
        return Optional.empty();
    }

    @Override
    @Nonnull
    protected CacheKey getCacheKey(@Nonnull Destination destination) throws HttpClientInstantiationException {
        try {
            return CacheKey.ofNoIsolation().append(new Object[]{destination.getName()});
        }
        catch (IllegalArgumentException e) {
            throw new HttpClientInstantiationException("Failed to get cache key.", e);
        }
    }

    @Override
    @Nonnull
    protected CacheKey getCacheKey() throws HttpClientInstantiationException {
        try {
            return CacheKey.ofNoIsolation();
        }
        catch (IllegalArgumentException e) {
            throw new HttpClientInstantiationException("Failed to get cache key.", e);
        }
    }
}

