/*
 * Copyright (c) 2021 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.cloudplatform.servlet.exception;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;

import com.sap.cloud.sdk.cloudplatform.servlet.response.ForbiddenOperationResponse;
import com.sap.cloud.sdk.cloudplatform.servlet.response.ResponseWithErrorCode;
import com.sap.cloud.sdk.cloudplatform.servlet.response.WithErrorResponse;

import lombok.NoArgsConstructor;

/**
 * Thrown when a certain operation is not permitted.
 */
@NoArgsConstructor
public class ForbiddenOperationException extends Exception implements WithErrorResponse
{
    private static final long serialVersionUID = -905759929374233883L;

    /**
     * Exception constructor.
     * 
     * @param message
     *            The exception message.
     */
    public ForbiddenOperationException( @Nullable final String message )
    {
        super(message);
    }

    /**
     * Exception constructor.
     * 
     * @param cause
     *            The exception cause.
     */
    public ForbiddenOperationException( @Nullable final Throwable cause )
    {
        super(cause);
    }

    /**
     * Exception constructor.
     * 
     * @param message
     *            The exception message.
     * @param cause
     *            The exception cause.
     */
    public ForbiddenOperationException( @Nullable final String message, @Nullable final Throwable cause )
    {
        super(message, cause);
    }

    /**
     * {@inheritDoc}
     */
    @Nonnull
    @Override
    public ResponseWithErrorCode getErrorResponse()
    {
        return new ForbiddenOperationResponse();
    }
}
