/*
 * Copyright (c) 2021 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.cloudplatform.servlet.response;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;

import org.apache.http.HttpStatus;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.gson.annotations.Expose;

import io.vavr.control.Option;

/**
 * Invalid Parameter.
 */
public class InvalidParameterResponse extends ResponseWithErrorCode
{
    @Nullable
    @Expose
    @JsonProperty
    private String parameter;

    /**
     * Get the invalid parameter.
     * 
     * @return The invalid parameter.
     */
    @JsonIgnore
    @Nonnull
    public Option<String> getParameter()
    {
        return Option.of(parameter);
    }

    /**
     * Default constructor.
     */
    public InvalidParameterResponse()
    {
        this(null, null);
    }

    /**
     * Constructor with parameter reference.
     * 
     * @param parameter
     *            The optional parameter name being invalid.
     * @param description
     *            The optional error description.
     */
    public InvalidParameterResponse( @Nullable final String parameter, @Nullable final String description )
    {
        super(HttpStatus.SC_BAD_REQUEST, "invalid_parameter", description);
        this.parameter = parameter;
    }
}
