/*
 * Copyright (c) 2021 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.cloudplatform.servlet.response;

import java.time.LocalDate;
import java.util.Date;

import javax.annotation.Nonnull;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.sap.cloud.sdk.cloudplatform.servlet.response.serializer.DateGsonSerializer;
import com.sap.cloud.sdk.cloudplatform.servlet.response.serializer.LocalDateGsonSerializer;

/**
 * Response GSON Builder.
 */
public class ResponseGsonBuilder
{
    /**
     * Create GSON Builder with date serializer.
     * 
     * @return The newly instantiated GSON Builder.
     */
    @Nonnull
    public GsonBuilder newBuilder()
    {
        final GsonBuilder gsonBuilder = new GsonBuilder().excludeFieldsWithoutExposeAnnotation();
        gsonBuilder.registerTypeAdapter(LocalDate.class, new LocalDateGsonSerializer());
        gsonBuilder.registerTypeAdapter(Date.class, new DateGsonSerializer());
        return gsonBuilder;
    }

    /**
     * Create a GSON utility instance.
     * 
     * @return The GSON reference.
     */
    @Nonnull
    public Gson create()
    {
        return newBuilder().create();
    }
}
