/*
 * Copyright (c) 2021 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.cloudplatform.servlet.response;

import java.io.IOException;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.servlet.http.HttpServletResponse;

import com.google.gson.JsonElement;

/**
 * Servlet Error Response Builder.
 */
public class ServletErrorResponseBuilder
{
    private JsonElement toJson( @Nullable final ResponseWithErrorCode response )
    {
        return new ResponseGsonBuilder().create().toJsonTree(response);
    }

    /**
     * Build and pass the servlet error response.
     * 
     * @param servletResponse
     *            The response reference to be used.
     * @param response
     *            The response being passed as JSON payload.
     * @param <ResponseT>
     *            The generic response type.
     * @throws IOException
     *             When the error could not be passed to the servlet response reference.
     */
    public <ResponseT extends ResponseWithErrorCode> void build(
        @Nonnull final HttpServletResponse servletResponse,
        @Nonnull final ResponseT response )
        throws IOException
    {
        servletResponse.setStatus(response.getHttpStatusCode());
        servletResponse.setContentType("application/json");
        servletResponse.getOutputStream().print(toJson(response).toString());
    }
}
