/*
 * Copyright (c) 2021 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.cloudplatform.servlet.response;

import javax.annotation.Nonnull;

/**
 * Stating the ability to return an response containing an error code.
 * <p>
 * Mainly used by exceptions that want to return an HTTP error code.
 */
public interface WithErrorResponse
{
    /**
     * Gets the response containing an HTTP error code.
     * 
     * @return The error response.
     */
    @Nonnull
    ResponseWithErrorCode getErrorResponse();
}
