/*
 * Copyright (c) 2021 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.cloudplatform.servlet.response.mapper;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;

import com.sap.cloud.sdk.cloudplatform.servlet.response.ResponseWithErrorCode;
import com.sap.cloud.sdk.cloudplatform.servlet.response.UnsupportedOperationResponse;

public class UnsupportedOperationExceptionMapper extends AbstractResponseMapper<UnsupportedOperationException>
{
    @Nonnull
    @Override
    public Class<UnsupportedOperationException> getThrowableClass()
    {
        return UnsupportedOperationException.class;
    }

    @Nullable
    @Override
    public ResponseWithErrorCode toResponse( @Nonnull final Throwable throwable )
    {
        return new UnsupportedOperationResponse("Operation not supported.");
    }
}
