/*
 * Copyright (c) 2021 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odatav4.namespaces.accesssequenceforpricinginsales;

import java.util.List;
import java.util.Map;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;

import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.gson.annotations.JsonAdapter;
import com.sap.cloud.sdk.datamodel.odata.client.request.ODataEntityKey;
import com.sap.cloud.sdk.datamodel.odatav4.core.SimpleProperty;
import com.sap.cloud.sdk.datamodel.odatav4.core.VdmEntity;
import com.sap.cloud.sdk.datamodel.odatav4.core.VdmEntitySet;
import com.sap.cloud.sdk.result.ElementName;
import com.sap.cloud.sdk.s4hana.datamodel.odatav4.services.AccessSequenceForPricingInSalesService;

import io.vavr.control.Option;
import lombok.AccessLevel;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.Getter;
import lombok.NoArgsConstructor;
import lombok.Setter;
import lombok.ToString;

/**
 * Accesses
 * <p>
 * </p>
 * <p>
 * Original entity name from the Odata EDM: <b>SalesPricingAccessType</b>
 * </p>
 * 
 */
@Builder
@Data
@NoArgsConstructor
@AllArgsConstructor
@ToString( doNotUseGetters = true, callSuper = true )
@EqualsAndHashCode( doNotUseGetters = true, callSuper = true )
@JsonAdapter( com.sap.cloud.sdk.datamodel.odatav4.adapter.GsonVdmAdapterFactory.class )
@JsonSerialize( using = com.sap.cloud.sdk.datamodel.odatav4.adapter.JacksonVdmObjectSerializer.class )
@JsonDeserialize( using = com.sap.cloud.sdk.datamodel.odatav4.adapter.JacksonVdmObjectDeserializer.class )
public class SalesPricingAccess extends VdmEntity<SalesPricingAccess> implements VdmEntitySet
{

    @Getter
    private final java.lang.String odataType =
        "com.sap.gateway.srvd_a2x.api_slsprcgaccesssequence.v0001.SalesPricingAccessType";
    /**
     * Selector for all available fields of SalesPricingAccess.
     * 
     */
    public final static SimpleProperty<SalesPricingAccess> ALL_FIELDS = all();
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>ConditionUsage</b>
     * </p>
     * 
     * @return Usage of the condition table
     */
    @Nullable
    @ElementName( "ConditionUsage" )
    private java.lang.String conditionUsage;
    public final static SimpleProperty.String<SalesPricingAccess> CONDITION_USAGE =
        new SimpleProperty.String<SalesPricingAccess>(SalesPricingAccess.class, "ConditionUsage");
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>ConditionApplication</b>
     * </p>
     * 
     * @return Application
     */
    @Nullable
    @ElementName( "ConditionApplication" )
    private java.lang.String conditionApplication;
    public final static SimpleProperty.String<SalesPricingAccess> CONDITION_APPLICATION =
        new SimpleProperty.String<SalesPricingAccess>(SalesPricingAccess.class, "ConditionApplication");
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>AccessSequence</b>
     * </p>
     * 
     * @return Access sequence
     */
    @Nullable
    @ElementName( "AccessSequence" )
    private java.lang.String accessSequence;
    public final static SimpleProperty.String<SalesPricingAccess> ACCESS_SEQUENCE =
        new SimpleProperty.String<SalesPricingAccess>(SalesPricingAccess.class, "AccessSequence");
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>AccessNumberOfAccessSequence</b>
     * </p>
     * 
     * @return Access sequence - Access number
     */
    @Nullable
    @ElementName( "AccessNumberOfAccessSequence" )
    private java.lang.String accessNumberOfAccessSequence;
    public final static SimpleProperty.String<SalesPricingAccess> ACCESS_NUMBER_OF_ACCESS_SEQUENCE =
        new SimpleProperty.String<SalesPricingAccess>(SalesPricingAccess.class, "AccessNumberOfAccessSequence");
    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>ConditionTable</b>
     * </p>
     * 
     * @return Three-digit character field for IDocs
     */
    @Nullable
    @ElementName( "ConditionTable" )
    private java.lang.String conditionTable;
    public final static SimpleProperty.String<SalesPricingAccess> CONDITION_TABLE =
        new SimpleProperty.String<SalesPricingAccess>(SalesPricingAccess.class, "ConditionTable");
    /**
     * Constraints: Not nullable, Maximum length: 7
     * <p>
     * Original property name from the Odata EDM: <b>ConditionRequirement</b>
     * </p>
     * 
     * @return Requirement
     */
    @Nullable
    @ElementName( "ConditionRequirement" )
    private java.lang.String conditionRequirement;
    public final static SimpleProperty.String<SalesPricingAccess> CONDITION_REQUIREMENT =
        new SimpleProperty.String<SalesPricingAccess>(SalesPricingAccess.class, "ConditionRequirement");
    /**
     * Constraints: Not nullable
     * <p>
     * Original property name from the Odata EDM: <b>PrcgConditionAccessIsExclusive</b>
     * </p>
     * 
     * @return Indicator: Exclusive Condition Access
     */
    @Nullable
    @ElementName( "PrcgConditionAccessIsExclusive" )
    private java.lang.Boolean prcgConditionAccessIsExclusive;
    public final static SimpleProperty.Boolean<SalesPricingAccess> PRCG_CONDITION_ACCESS_IS_EXCLUSIVE =
        new SimpleProperty.Boolean<SalesPricingAccess>(SalesPricingAccess.class, "PrcgConditionAccessIsExclusive");
    /**
     * Navigation property <b>_SalesPricingAccessField</b> for <b>SalesPricingAccess</b> to multiple
     * <b>SalesPricingAccessField</b>.
     * 
     */
    @ElementName( "_SalesPricingAccessField" )
    @Getter( AccessLevel.NONE )
    @Setter( AccessLevel.NONE )
    private List<SalesPricingAccessField> to_SalesPricingAccessField;
    /**
     * Navigation property <b>_SalesPricingAccessSequence</b> for <b>SalesPricingAccess</b> to single
     * <b>SalesPricingAccessSequence</b>.
     * 
     */
    @ElementName( "_SalesPricingAccessSequence" )
    @Nullable
    @Getter( AccessLevel.NONE )
    @Setter( AccessLevel.NONE )
    private SalesPricingAccessSequence to_SalesPricingAccessSequence;
    /**
     * Use with available request builders to apply the <b>_SalesPricingAccessField</b> navigation property to query
     * operations.
     * 
     */
    public final static com.sap.cloud.sdk.datamodel.odatav4.core.NavigationProperty.Collection<SalesPricingAccess, SalesPricingAccessField> TO__SALES_PRICING_ACCESS_FIELD =
        new com.sap.cloud.sdk.datamodel.odatav4.core.NavigationProperty.Collection<SalesPricingAccess, SalesPricingAccessField>(
            SalesPricingAccess.class,
            "_SalesPricingAccessField",
            SalesPricingAccessField.class);
    /**
     * Use with available request builders to apply the <b>_SalesPricingAccessSequence</b> navigation property to query
     * operations.
     * 
     */
    public final static com.sap.cloud.sdk.datamodel.odatav4.core.NavigationProperty.Single<SalesPricingAccess, SalesPricingAccessSequence> TO__SALES_PRICING_ACCESS_SEQUENCE =
        new com.sap.cloud.sdk.datamodel.odatav4.core.NavigationProperty.Single<SalesPricingAccess, SalesPricingAccessSequence>(
            SalesPricingAccess.class,
            "_SalesPricingAccessSequence",
            SalesPricingAccessSequence.class);

    /**
     * {@inheritDoc}
     * 
     */
    @Nonnull
    @Override
    public Class<SalesPricingAccess> getType()
    {
        return SalesPricingAccess.class;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>ConditionUsage</b>
     * </p>
     * 
     * @param conditionUsage
     *            Usage of the condition table
     */
    public void setConditionUsage( @Nullable final java.lang.String conditionUsage )
    {
        rememberChangedField("ConditionUsage", this.conditionUsage);
        this.conditionUsage = conditionUsage;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>ConditionApplication</b>
     * </p>
     * 
     * @param conditionApplication
     *            Application
     */
    public void setConditionApplication( @Nullable final java.lang.String conditionApplication )
    {
        rememberChangedField("ConditionApplication", this.conditionApplication);
        this.conditionApplication = conditionApplication;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>AccessSequence</b>
     * </p>
     * 
     * @param accessSequence
     *            Access sequence
     */
    public void setAccessSequence( @Nullable final java.lang.String accessSequence )
    {
        rememberChangedField("AccessSequence", this.accessSequence);
        this.accessSequence = accessSequence;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>AccessNumberOfAccessSequence</b>
     * </p>
     * 
     * @param accessNumberOfAccessSequence
     *            Access sequence - Access number
     */
    public void setAccessNumberOfAccessSequence( @Nullable final java.lang.String accessNumberOfAccessSequence )
    {
        rememberChangedField("AccessNumberOfAccessSequence", this.accessNumberOfAccessSequence);
        this.accessNumberOfAccessSequence = accessNumberOfAccessSequence;
    }

    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>ConditionTable</b>
     * </p>
     * 
     * @param conditionTable
     *            Three-digit character field for IDocs
     */
    public void setConditionTable( @Nullable final java.lang.String conditionTable )
    {
        rememberChangedField("ConditionTable", this.conditionTable);
        this.conditionTable = conditionTable;
    }

    /**
     * Constraints: Not nullable, Maximum length: 7
     * <p>
     * Original property name from the Odata EDM: <b>ConditionRequirement</b>
     * </p>
     * 
     * @param conditionRequirement
     *            Requirement
     */
    public void setConditionRequirement( @Nullable final java.lang.String conditionRequirement )
    {
        rememberChangedField("ConditionRequirement", this.conditionRequirement);
        this.conditionRequirement = conditionRequirement;
    }

    /**
     * Constraints: Not nullable
     * <p>
     * Original property name from the Odata EDM: <b>PrcgConditionAccessIsExclusive</b>
     * </p>
     * 
     * @param prcgConditionAccessIsExclusive
     *            Indicator: Exclusive Condition Access
     */
    public void setPrcgConditionAccessIsExclusive( @Nullable final java.lang.Boolean prcgConditionAccessIsExclusive )
    {
        rememberChangedField("PrcgConditionAccessIsExclusive", this.prcgConditionAccessIsExclusive);
        this.prcgConditionAccessIsExclusive = prcgConditionAccessIsExclusive;
    }

    @Override
    protected java.lang.String getEntityCollection()
    {
        return "SalesPricingAccess";
    }

    @Nonnull
    @Override
    protected ODataEntityKey getKey()
    {
        final ODataEntityKey entityKey = super.getKey();
        entityKey.addKeyProperty("ConditionUsage", getConditionUsage());
        entityKey.addKeyProperty("ConditionApplication", getConditionApplication());
        entityKey.addKeyProperty("AccessSequence", getAccessSequence());
        entityKey.addKeyProperty("AccessNumberOfAccessSequence", getAccessNumberOfAccessSequence());
        return entityKey;
    }

    @Nonnull
    @Override
    protected Map<java.lang.String, Object> toMapOfFields()
    {
        final Map<java.lang.String, Object> values = super.toMapOfFields();
        values.put("ConditionUsage", getConditionUsage());
        values.put("ConditionApplication", getConditionApplication());
        values.put("AccessSequence", getAccessSequence());
        values.put("AccessNumberOfAccessSequence", getAccessNumberOfAccessSequence());
        values.put("ConditionTable", getConditionTable());
        values.put("ConditionRequirement", getConditionRequirement());
        values.put("PrcgConditionAccessIsExclusive", getPrcgConditionAccessIsExclusive());
        return values;
    }

    @Override
    protected void fromMap( final Map<java.lang.String, Object> inputValues )
    {
        final Map<java.lang.String, Object> values = Maps.newHashMap(inputValues);
        // simple properties
        {
            if( values.containsKey("ConditionUsage") ) {
                final Object value = values.remove("ConditionUsage");
                if( (value == null) || (!value.equals(getConditionUsage())) ) {
                    setConditionUsage(((java.lang.String) value));
                }
            }
            if( values.containsKey("ConditionApplication") ) {
                final Object value = values.remove("ConditionApplication");
                if( (value == null) || (!value.equals(getConditionApplication())) ) {
                    setConditionApplication(((java.lang.String) value));
                }
            }
            if( values.containsKey("AccessSequence") ) {
                final Object value = values.remove("AccessSequence");
                if( (value == null) || (!value.equals(getAccessSequence())) ) {
                    setAccessSequence(((java.lang.String) value));
                }
            }
            if( values.containsKey("AccessNumberOfAccessSequence") ) {
                final Object value = values.remove("AccessNumberOfAccessSequence");
                if( (value == null) || (!value.equals(getAccessNumberOfAccessSequence())) ) {
                    setAccessNumberOfAccessSequence(((java.lang.String) value));
                }
            }
            if( values.containsKey("ConditionTable") ) {
                final Object value = values.remove("ConditionTable");
                if( (value == null) || (!value.equals(getConditionTable())) ) {
                    setConditionTable(((java.lang.String) value));
                }
            }
            if( values.containsKey("ConditionRequirement") ) {
                final Object value = values.remove("ConditionRequirement");
                if( (value == null) || (!value.equals(getConditionRequirement())) ) {
                    setConditionRequirement(((java.lang.String) value));
                }
            }
            if( values.containsKey("PrcgConditionAccessIsExclusive") ) {
                final Object value = values.remove("PrcgConditionAccessIsExclusive");
                if( (value == null) || (!value.equals(getPrcgConditionAccessIsExclusive())) ) {
                    setPrcgConditionAccessIsExclusive(((java.lang.Boolean) value));
                }
            }
        }
        // structured properties
        {
        }
        // navigation properties
        {
            if( (values).containsKey("_SalesPricingAccessField") ) {
                final Object value = (values).remove("_SalesPricingAccessField");
                if( value instanceof Iterable ) {
                    if( to_SalesPricingAccessField == null ) {
                        to_SalesPricingAccessField = Lists.newArrayList();
                    } else {
                        to_SalesPricingAccessField = Lists.newArrayList(to_SalesPricingAccessField);
                    }
                    int i = 0;
                    for( Object item : ((Iterable<?>) value) ) {
                        if( !(item instanceof Map) ) {
                            continue;
                        }
                        SalesPricingAccessField entity;
                        if( to_SalesPricingAccessField.size() > i ) {
                            entity = to_SalesPricingAccessField.get(i);
                        } else {
                            entity = new SalesPricingAccessField();
                            to_SalesPricingAccessField.add(entity);
                        }
                        i = (i + 1);
                        @SuppressWarnings( "unchecked" )
                        final Map<java.lang.String, Object> inputMap = ((Map<java.lang.String, Object>) item);
                        entity.fromMap(inputMap);
                    }
                }
            }
            if( (values).containsKey("_SalesPricingAccessSequence") ) {
                final Object value = (values).remove("_SalesPricingAccessSequence");
                if( value instanceof Map ) {
                    if( to_SalesPricingAccessSequence == null ) {
                        to_SalesPricingAccessSequence = new SalesPricingAccessSequence();
                    }
                    @SuppressWarnings( "unchecked" )
                    final Map<java.lang.String, Object> inputMap = ((Map<java.lang.String, Object>) value);
                    to_SalesPricingAccessSequence.fromMap(inputMap);
                }
            }
        }
        super.fromMap(values);
    }

    @Override
    protected java.lang.String getDefaultServicePath()
    {
        return AccessSequenceForPricingInSalesService.DEFAULT_SERVICE_PATH;
    }

    @Nonnull
    @Override
    protected Map<java.lang.String, Object> toMapOfNavigationProperties()
    {
        final Map<java.lang.String, Object> values = super.toMapOfNavigationProperties();
        if( to_SalesPricingAccessField != null ) {
            (values).put("_SalesPricingAccessField", to_SalesPricingAccessField);
        }
        if( to_SalesPricingAccessSequence != null ) {
            (values).put("_SalesPricingAccessSequence", to_SalesPricingAccessSequence);
        }
        return values;
    }

    /**
     * Retrieval of associated <b>SalesPricingAccessField</b> entities (one to many). This corresponds to the OData
     * navigation property <b>_SalesPricingAccessField</b>.
     * <p>
     * If the navigation property for an entity <b>SalesPricingAccess</b> has not been resolved yet, this method will
     * <b>not query</b> further information. Instead its <code>Option</code> result state will be <code>empty</code>.
     * 
     * @return If the information for navigation property <b>_SalesPricingAccessField</b> is already loaded, the result
     *         will contain the <b>SalesPricingAccessField</b> entities. If not, an <code>Option</code> with result
     *         state <code>empty</code> is returned.
     */
    @Nonnull
    public Option<List<SalesPricingAccessField>> getSalesPricingAccessFieldIfPresent()
    {
        return Option.of(to_SalesPricingAccessField);
    }

    /**
     * Overwrites the list of associated <b>SalesPricingAccessField</b> entities for the loaded navigation property
     * <b>_SalesPricingAccessField</b>.
     * <p>
     * If the navigation property <b>_SalesPricingAccessField</b> of a queried <b>SalesPricingAccess</b> is operated
     * lazily, an <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     * 
     * @param value
     *            List of <b>SalesPricingAccessField</b> entities.
     */
    public void setSalesPricingAccessField( @Nonnull final List<SalesPricingAccessField> value )
    {
        if( to_SalesPricingAccessField == null ) {
            to_SalesPricingAccessField = Lists.newArrayList();
        }
        to_SalesPricingAccessField.clear();
        to_SalesPricingAccessField.addAll(value);
    }

    /**
     * Adds elements to the list of associated <b>SalesPricingAccessField</b> entities. This corresponds to the OData
     * navigation property <b>_SalesPricingAccessField</b>.
     * <p>
     * If the navigation property <b>_SalesPricingAccessField</b> of a queried <b>SalesPricingAccess</b> is operated
     * lazily, an <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     * 
     * @param entity
     *            Array of <b>SalesPricingAccessField</b> entities.
     */
    public void addSalesPricingAccessField( SalesPricingAccessField... entity )
    {
        if( to_SalesPricingAccessField == null ) {
            to_SalesPricingAccessField = Lists.newArrayList();
        }
        to_SalesPricingAccessField.addAll(Lists.newArrayList(entity));
    }

    /**
     * Retrieval of associated <b>SalesPricingAccessSequence</b> entity (one to one). This corresponds to the OData
     * navigation property <b>_SalesPricingAccessSequence</b>.
     * <p>
     * If the navigation property for an entity <b>SalesPricingAccess</b> has not been resolved yet, this method will
     * <b>not query</b> further information. Instead its <code>Option</code> result state will be <code>empty</code>.
     * 
     * @return If the information for navigation property <b>_SalesPricingAccessSequence</b> is already loaded, the
     *         result will contain the <b>SalesPricingAccessSequence</b> entity. If not, an <code>Option</code> with
     *         result state <code>empty</code> is returned.
     */
    @Nonnull
    public Option<SalesPricingAccessSequence> getSalesPricingAccessSequenceIfPresent()
    {
        return Option.of(to_SalesPricingAccessSequence);
    }

    /**
     * Overwrites the associated <b>SalesPricingAccessSequence</b> entity for the loaded navigation property
     * <b>_SalesPricingAccessSequence</b>.
     * 
     * @param value
     *            New <b>SalesPricingAccessSequence</b> entity.
     */
    public void setSalesPricingAccessSequence( final SalesPricingAccessSequence value )
    {
        to_SalesPricingAccessSequence = value;
    }

    /**
     * Helper class to allow for fluent creation of SalesPricingAccess instances.
     * 
     */
    public final static class SalesPricingAccessBuilder
    {

        private List<SalesPricingAccessField> to_SalesPricingAccessField = Lists.newArrayList();
        private SalesPricingAccessSequence to_SalesPricingAccessSequence;

        private SalesPricingAccess.SalesPricingAccessBuilder to_SalesPricingAccessField(
            final List<SalesPricingAccessField> value )
        {
            to_SalesPricingAccessField.addAll(value);
            return this;
        }

        /**
         * Navigation property <b>_SalesPricingAccessField</b> for <b>SalesPricingAccess</b> to multiple
         * <b>SalesPricingAccessField</b>.
         * 
         * @param value
         *            The SalesPricingAccessFields to build this SalesPricingAccess with.
         * @return This Builder to allow for a fluent interface.
         */
        @Nonnull
        public SalesPricingAccess.SalesPricingAccessBuilder salesPricingAccessField( SalesPricingAccessField... value )
        {
            return to_SalesPricingAccessField(Lists.newArrayList(value));
        }

        private SalesPricingAccess.SalesPricingAccessBuilder to_SalesPricingAccessSequence(
            final SalesPricingAccessSequence value )
        {
            to_SalesPricingAccessSequence = value;
            return this;
        }

        /**
         * Navigation property <b>_SalesPricingAccessSequence</b> for <b>SalesPricingAccess</b> to single
         * <b>SalesPricingAccessSequence</b>.
         * 
         * @param value
         *            The SalesPricingAccessSequence to build this SalesPricingAccess with.
         * @return This Builder to allow for a fluent interface.
         */
        @Nonnull
        public SalesPricingAccess.SalesPricingAccessBuilder salesPricingAccessSequence(
            final SalesPricingAccessSequence value )
        {
            return to_SalesPricingAccessSequence(value);
        }

    }

}
