/*
 * Copyright (c) 2021 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odatav4.namespaces.accesssequenceforpricinginsales;

import java.util.Map;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;

import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.google.common.collect.Maps;
import com.google.gson.annotations.JsonAdapter;
import com.sap.cloud.sdk.datamodel.odata.client.request.ODataEntityKey;
import com.sap.cloud.sdk.datamodel.odatav4.core.SimpleProperty;
import com.sap.cloud.sdk.datamodel.odatav4.core.VdmEntity;
import com.sap.cloud.sdk.datamodel.odatav4.core.VdmEntitySet;
import com.sap.cloud.sdk.result.ElementName;
import com.sap.cloud.sdk.s4hana.datamodel.odatav4.services.AccessSequenceForPricingInSalesService;

import io.vavr.control.Option;
import lombok.AccessLevel;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.Getter;
import lombok.NoArgsConstructor;
import lombok.Setter;
import lombok.ToString;

/**
 * Fields
 * <p>
 * </p>
 * <p>
 * Original entity name from the Odata EDM: <b>SalesPricingAccessFieldType</b>
 * </p>
 * 
 */
@Builder
@Data
@NoArgsConstructor
@AllArgsConstructor
@ToString( doNotUseGetters = true, callSuper = true )
@EqualsAndHashCode( doNotUseGetters = true, callSuper = true )
@JsonAdapter( com.sap.cloud.sdk.datamodel.odatav4.adapter.GsonVdmAdapterFactory.class )
@JsonSerialize( using = com.sap.cloud.sdk.datamodel.odatav4.adapter.JacksonVdmObjectSerializer.class )
@JsonDeserialize( using = com.sap.cloud.sdk.datamodel.odatav4.adapter.JacksonVdmObjectDeserializer.class )
public class SalesPricingAccessField extends VdmEntity<SalesPricingAccessField> implements VdmEntitySet
{

    @Getter
    private final java.lang.String odataType =
        "com.sap.gateway.srvd_a2x.api_slsprcgaccesssequence.v0001.SalesPricingAccessFieldType";
    /**
     * Selector for all available fields of SalesPricingAccessField.
     * 
     */
    public final static SimpleProperty<SalesPricingAccessField> ALL_FIELDS = all();
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>ConditionUsage</b>
     * </p>
     * 
     * @return Usage of the condition table
     */
    @Nullable
    @ElementName( "ConditionUsage" )
    private java.lang.String conditionUsage;
    public final static SimpleProperty.String<SalesPricingAccessField> CONDITION_USAGE =
        new SimpleProperty.String<SalesPricingAccessField>(SalesPricingAccessField.class, "ConditionUsage");
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>ConditionApplication</b>
     * </p>
     * 
     * @return Application
     */
    @Nullable
    @ElementName( "ConditionApplication" )
    private java.lang.String conditionApplication;
    public final static SimpleProperty.String<SalesPricingAccessField> CONDITION_APPLICATION =
        new SimpleProperty.String<SalesPricingAccessField>(SalesPricingAccessField.class, "ConditionApplication");
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>AccessSequence</b>
     * </p>
     * 
     * @return Access sequence
     */
    @Nullable
    @ElementName( "AccessSequence" )
    private java.lang.String accessSequence;
    public final static SimpleProperty.String<SalesPricingAccessField> ACCESS_SEQUENCE =
        new SimpleProperty.String<SalesPricingAccessField>(SalesPricingAccessField.class, "AccessSequence");
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>AccessNumberOfAccessSequence</b>
     * </p>
     * 
     * @return Access sequence - Access number
     */
    @Nullable
    @ElementName( "AccessNumberOfAccessSequence" )
    private java.lang.String accessNumberOfAccessSequence;
    public final static SimpleProperty.String<SalesPricingAccessField> ACCESS_NUMBER_OF_ACCESS_SEQUENCE =
        new SimpleProperty.String<SalesPricingAccessField>(
            SalesPricingAccessField.class,
            "AccessNumberOfAccessSequence");
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>ConditionTable</b>
     * </p>
     * 
     * @return Three-digit character field for IDocs
     */
    @Nullable
    @ElementName( "ConditionTable" )
    private java.lang.String conditionTable;
    public final static SimpleProperty.String<SalesPricingAccessField> CONDITION_TABLE =
        new SimpleProperty.String<SalesPricingAccessField>(SalesPricingAccessField.class, "ConditionTable");
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 30
     * <p>
     * Original property name from the Odata EDM: <b>PricingConditionField</b>
     * </p>
     * 
     * @return Field for condition table
     */
    @Nullable
    @ElementName( "PricingConditionField" )
    private java.lang.String pricingConditionField;
    public final static SimpleProperty.String<SalesPricingAccessField> PRICING_CONDITION_FIELD =
        new SimpleProperty.String<SalesPricingAccessField>(SalesPricingAccessField.class, "PricingConditionField");
    /**
     * Constraints: Not nullable, Maximum length: 30
     * <p>
     * Original property name from the Odata EDM: <b>PrcgCndnAccDocumentStructure</b>
     * </p>
     * 
     * @return Table Name of the Document Structure
     */
    @Nullable
    @ElementName( "PrcgCndnAccDocumentStructure" )
    private java.lang.String prcgCndnAccDocumentStructure;
    public final static SimpleProperty.String<SalesPricingAccessField> PRCG_CNDN_ACC_DOCUMENT_STRUCTURE =
        new SimpleProperty.String<SalesPricingAccessField>(
            SalesPricingAccessField.class,
            "PrcgCndnAccDocumentStructure");
    /**
     * Constraints: Not nullable, Maximum length: 30
     * <p>
     * Original property name from the Odata EDM: <b>PrcgCndnAccessDocumentField</b>
     * </p>
     * 
     * @return Table Field for Document Structure
     */
    @Nullable
    @ElementName( "PrcgCndnAccessDocumentField" )
    private java.lang.String prcgCndnAccessDocumentField;
    public final static SimpleProperty.String<SalesPricingAccessField> PRCG_CNDN_ACCESS_DOCUMENT_FIELD =
        new SimpleProperty.String<SalesPricingAccessField>(
            SalesPricingAccessField.class,
            "PrcgCndnAccessDocumentField");
    /**
     * Constraints: Not nullable, Maximum length: 50
     * <p>
     * Original property name from the Odata EDM: <b>PrcgCndnAccConstantValueSource</b>
     * </p>
     * 
     * @return Constant Value Source
     */
    @Nullable
    @ElementName( "PrcgCndnAccConstantValueSource" )
    private java.lang.String prcgCndnAccConstantValueSource;
    public final static SimpleProperty.String<SalesPricingAccessField> PRCG_CNDN_ACC_CONSTANT_VALUE_SOURCE =
        new SimpleProperty.String<SalesPricingAccessField>(
            SalesPricingAccessField.class,
            "PrcgCndnAccConstantValueSource");
    /**
     * Constraints: Not nullable
     * <p>
     * Original property name from the Odata EDM: <b>PrcgCndnValueInitialIsAllowed</b>
     * </p>
     * 
     * @return Initial Value Allowed
     */
    @Nullable
    @ElementName( "PrcgCndnValueInitialIsAllowed" )
    private java.lang.Boolean prcgCndnValueInitialIsAllowed;
    public final static SimpleProperty.Boolean<SalesPricingAccessField> PRCG_CNDN_VALUE_INITIAL_IS_ALLOWED =
        new SimpleProperty.Boolean<SalesPricingAccessField>(
            SalesPricingAccessField.class,
            "PrcgCndnValueInitialIsAllowed");
    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>PricingConditionAccessType</b>
     * </p>
     * 
     * @return Processing Type in Access
     */
    @Nullable
    @ElementName( "PricingConditionAccessType" )
    private java.lang.String pricingConditionAccessType;
    public final static SimpleProperty.String<SalesPricingAccessField> PRICING_CONDITION_ACCESS_TYPE =
        new SimpleProperty.String<SalesPricingAccessField>(SalesPricingAccessField.class, "PricingConditionAccessType");
    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>PricingConditionAccessPriority</b>
     * </p>
     * 
     * @return Characteristic Values
     */
    @Nullable
    @ElementName( "PricingConditionAccessPriority" )
    private java.lang.String pricingConditionAccessPriority;
    public final static SimpleProperty.String<SalesPricingAccessField> PRICING_CONDITION_ACCESS_PRIORITY =
        new SimpleProperty.String<SalesPricingAccessField>(
            SalesPricingAccessField.class,
            "PricingConditionAccessPriority");
    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>PrcgConditionAccessDirection</b>
     * </p>
     * 
     * @return Direction of Hierarchy Evaluation
     */
    @Nullable
    @ElementName( "PrcgConditionAccessDirection" )
    private java.lang.String prcgConditionAccessDirection;
    public final static SimpleProperty.String<SalesPricingAccessField> PRCG_CONDITION_ACCESS_DIRECTION =
        new SimpleProperty.String<SalesPricingAccessField>(
            SalesPricingAccessField.class,
            "PrcgConditionAccessDirection");
    /**
     * Constraints: Not nullable, Maximum length: 6
     * <p>
     * Original property name from the Odata EDM: <b>PrcgCndnAccessDistanceValue</b>
     * </p>
     * 
     * @return Distance (Measured in Number of Hierarchy Levels)
     */
    @Nullable
    @ElementName( "PrcgCndnAccessDistanceValue" )
    private java.lang.String prcgCndnAccessDistanceValue;
    public final static SimpleProperty.String<SalesPricingAccessField> PRCG_CNDN_ACCESS_DISTANCE_VALUE =
        new SimpleProperty.String<SalesPricingAccessField>(
            SalesPricingAccessField.class,
            "PrcgCndnAccessDistanceValue");
    /**
     * Navigation property <b>_SalesPricingAccess</b> for <b>SalesPricingAccessField</b> to single
     * <b>SalesPricingAccess</b>.
     * 
     */
    @ElementName( "_SalesPricingAccess" )
    @Nullable
    @Getter( AccessLevel.NONE )
    @Setter( AccessLevel.NONE )
    private SalesPricingAccess to_SalesPricingAccess;
    /**
     * Use with available request builders to apply the <b>_SalesPricingAccess</b> navigation property to query
     * operations.
     * 
     */
    public final static com.sap.cloud.sdk.datamodel.odatav4.core.NavigationProperty.Single<SalesPricingAccessField, SalesPricingAccess> TO__SALES_PRICING_ACCESS =
        new com.sap.cloud.sdk.datamodel.odatav4.core.NavigationProperty.Single<SalesPricingAccessField, SalesPricingAccess>(
            SalesPricingAccessField.class,
            "_SalesPricingAccess",
            SalesPricingAccess.class);

    /**
     * {@inheritDoc}
     * 
     */
    @Nonnull
    @Override
    public Class<SalesPricingAccessField> getType()
    {
        return SalesPricingAccessField.class;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>ConditionUsage</b>
     * </p>
     * 
     * @param conditionUsage
     *            Usage of the condition table
     */
    public void setConditionUsage( @Nullable final java.lang.String conditionUsage )
    {
        rememberChangedField("ConditionUsage", this.conditionUsage);
        this.conditionUsage = conditionUsage;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>ConditionApplication</b>
     * </p>
     * 
     * @param conditionApplication
     *            Application
     */
    public void setConditionApplication( @Nullable final java.lang.String conditionApplication )
    {
        rememberChangedField("ConditionApplication", this.conditionApplication);
        this.conditionApplication = conditionApplication;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>AccessSequence</b>
     * </p>
     * 
     * @param accessSequence
     *            Access sequence
     */
    public void setAccessSequence( @Nullable final java.lang.String accessSequence )
    {
        rememberChangedField("AccessSequence", this.accessSequence);
        this.accessSequence = accessSequence;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>AccessNumberOfAccessSequence</b>
     * </p>
     * 
     * @param accessNumberOfAccessSequence
     *            Access sequence - Access number
     */
    public void setAccessNumberOfAccessSequence( @Nullable final java.lang.String accessNumberOfAccessSequence )
    {
        rememberChangedField("AccessNumberOfAccessSequence", this.accessNumberOfAccessSequence);
        this.accessNumberOfAccessSequence = accessNumberOfAccessSequence;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>ConditionTable</b>
     * </p>
     * 
     * @param conditionTable
     *            Three-digit character field for IDocs
     */
    public void setConditionTable( @Nullable final java.lang.String conditionTable )
    {
        rememberChangedField("ConditionTable", this.conditionTable);
        this.conditionTable = conditionTable;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 30
     * <p>
     * Original property name from the Odata EDM: <b>PricingConditionField</b>
     * </p>
     * 
     * @param pricingConditionField
     *            Field for condition table
     */
    public void setPricingConditionField( @Nullable final java.lang.String pricingConditionField )
    {
        rememberChangedField("PricingConditionField", this.pricingConditionField);
        this.pricingConditionField = pricingConditionField;
    }

    /**
     * Constraints: Not nullable, Maximum length: 30
     * <p>
     * Original property name from the Odata EDM: <b>PrcgCndnAccDocumentStructure</b>
     * </p>
     * 
     * @param prcgCndnAccDocumentStructure
     *            Table Name of the Document Structure
     */
    public void setPrcgCndnAccDocumentStructure( @Nullable final java.lang.String prcgCndnAccDocumentStructure )
    {
        rememberChangedField("PrcgCndnAccDocumentStructure", this.prcgCndnAccDocumentStructure);
        this.prcgCndnAccDocumentStructure = prcgCndnAccDocumentStructure;
    }

    /**
     * Constraints: Not nullable, Maximum length: 30
     * <p>
     * Original property name from the Odata EDM: <b>PrcgCndnAccessDocumentField</b>
     * </p>
     * 
     * @param prcgCndnAccessDocumentField
     *            Table Field for Document Structure
     */
    public void setPrcgCndnAccessDocumentField( @Nullable final java.lang.String prcgCndnAccessDocumentField )
    {
        rememberChangedField("PrcgCndnAccessDocumentField", this.prcgCndnAccessDocumentField);
        this.prcgCndnAccessDocumentField = prcgCndnAccessDocumentField;
    }

    /**
     * Constraints: Not nullable, Maximum length: 50
     * <p>
     * Original property name from the Odata EDM: <b>PrcgCndnAccConstantValueSource</b>
     * </p>
     * 
     * @param prcgCndnAccConstantValueSource
     *            Constant Value Source
     */
    public void setPrcgCndnAccConstantValueSource( @Nullable final java.lang.String prcgCndnAccConstantValueSource )
    {
        rememberChangedField("PrcgCndnAccConstantValueSource", this.prcgCndnAccConstantValueSource);
        this.prcgCndnAccConstantValueSource = prcgCndnAccConstantValueSource;
    }

    /**
     * Constraints: Not nullable
     * <p>
     * Original property name from the Odata EDM: <b>PrcgCndnValueInitialIsAllowed</b>
     * </p>
     * 
     * @param prcgCndnValueInitialIsAllowed
     *            Initial Value Allowed
     */
    public void setPrcgCndnValueInitialIsAllowed( @Nullable final java.lang.Boolean prcgCndnValueInitialIsAllowed )
    {
        rememberChangedField("PrcgCndnValueInitialIsAllowed", this.prcgCndnValueInitialIsAllowed);
        this.prcgCndnValueInitialIsAllowed = prcgCndnValueInitialIsAllowed;
    }

    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>PricingConditionAccessType</b>
     * </p>
     * 
     * @param pricingConditionAccessType
     *            Processing Type in Access
     */
    public void setPricingConditionAccessType( @Nullable final java.lang.String pricingConditionAccessType )
    {
        rememberChangedField("PricingConditionAccessType", this.pricingConditionAccessType);
        this.pricingConditionAccessType = pricingConditionAccessType;
    }

    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>PricingConditionAccessPriority</b>
     * </p>
     * 
     * @param pricingConditionAccessPriority
     *            Characteristic Values
     */
    public void setPricingConditionAccessPriority( @Nullable final java.lang.String pricingConditionAccessPriority )
    {
        rememberChangedField("PricingConditionAccessPriority", this.pricingConditionAccessPriority);
        this.pricingConditionAccessPriority = pricingConditionAccessPriority;
    }

    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>PrcgConditionAccessDirection</b>
     * </p>
     * 
     * @param prcgConditionAccessDirection
     *            Direction of Hierarchy Evaluation
     */
    public void setPrcgConditionAccessDirection( @Nullable final java.lang.String prcgConditionAccessDirection )
    {
        rememberChangedField("PrcgConditionAccessDirection", this.prcgConditionAccessDirection);
        this.prcgConditionAccessDirection = prcgConditionAccessDirection;
    }

    /**
     * Constraints: Not nullable, Maximum length: 6
     * <p>
     * Original property name from the Odata EDM: <b>PrcgCndnAccessDistanceValue</b>
     * </p>
     * 
     * @param prcgCndnAccessDistanceValue
     *            Distance (Measured in Number of Hierarchy Levels)
     */
    public void setPrcgCndnAccessDistanceValue( @Nullable final java.lang.String prcgCndnAccessDistanceValue )
    {
        rememberChangedField("PrcgCndnAccessDistanceValue", this.prcgCndnAccessDistanceValue);
        this.prcgCndnAccessDistanceValue = prcgCndnAccessDistanceValue;
    }

    @Override
    protected java.lang.String getEntityCollection()
    {
        return "SalesPricingAccessField";
    }

    @Nonnull
    @Override
    protected ODataEntityKey getKey()
    {
        final ODataEntityKey entityKey = super.getKey();
        entityKey.addKeyProperty("ConditionUsage", getConditionUsage());
        entityKey.addKeyProperty("ConditionApplication", getConditionApplication());
        entityKey.addKeyProperty("AccessSequence", getAccessSequence());
        entityKey.addKeyProperty("AccessNumberOfAccessSequence", getAccessNumberOfAccessSequence());
        entityKey.addKeyProperty("ConditionTable", getConditionTable());
        entityKey.addKeyProperty("PricingConditionField", getPricingConditionField());
        return entityKey;
    }

    @Nonnull
    @Override
    protected Map<java.lang.String, Object> toMapOfFields()
    {
        final Map<java.lang.String, Object> values = super.toMapOfFields();
        values.put("ConditionUsage", getConditionUsage());
        values.put("ConditionApplication", getConditionApplication());
        values.put("AccessSequence", getAccessSequence());
        values.put("AccessNumberOfAccessSequence", getAccessNumberOfAccessSequence());
        values.put("ConditionTable", getConditionTable());
        values.put("PricingConditionField", getPricingConditionField());
        values.put("PrcgCndnAccDocumentStructure", getPrcgCndnAccDocumentStructure());
        values.put("PrcgCndnAccessDocumentField", getPrcgCndnAccessDocumentField());
        values.put("PrcgCndnAccConstantValueSource", getPrcgCndnAccConstantValueSource());
        values.put("PrcgCndnValueInitialIsAllowed", getPrcgCndnValueInitialIsAllowed());
        values.put("PricingConditionAccessType", getPricingConditionAccessType());
        values.put("PricingConditionAccessPriority", getPricingConditionAccessPriority());
        values.put("PrcgConditionAccessDirection", getPrcgConditionAccessDirection());
        values.put("PrcgCndnAccessDistanceValue", getPrcgCndnAccessDistanceValue());
        return values;
    }

    @Override
    protected void fromMap( final Map<java.lang.String, Object> inputValues )
    {
        final Map<java.lang.String, Object> values = Maps.newHashMap(inputValues);
        // simple properties
        {
            if( values.containsKey("ConditionUsage") ) {
                final Object value = values.remove("ConditionUsage");
                if( (value == null) || (!value.equals(getConditionUsage())) ) {
                    setConditionUsage(((java.lang.String) value));
                }
            }
            if( values.containsKey("ConditionApplication") ) {
                final Object value = values.remove("ConditionApplication");
                if( (value == null) || (!value.equals(getConditionApplication())) ) {
                    setConditionApplication(((java.lang.String) value));
                }
            }
            if( values.containsKey("AccessSequence") ) {
                final Object value = values.remove("AccessSequence");
                if( (value == null) || (!value.equals(getAccessSequence())) ) {
                    setAccessSequence(((java.lang.String) value));
                }
            }
            if( values.containsKey("AccessNumberOfAccessSequence") ) {
                final Object value = values.remove("AccessNumberOfAccessSequence");
                if( (value == null) || (!value.equals(getAccessNumberOfAccessSequence())) ) {
                    setAccessNumberOfAccessSequence(((java.lang.String) value));
                }
            }
            if( values.containsKey("ConditionTable") ) {
                final Object value = values.remove("ConditionTable");
                if( (value == null) || (!value.equals(getConditionTable())) ) {
                    setConditionTable(((java.lang.String) value));
                }
            }
            if( values.containsKey("PricingConditionField") ) {
                final Object value = values.remove("PricingConditionField");
                if( (value == null) || (!value.equals(getPricingConditionField())) ) {
                    setPricingConditionField(((java.lang.String) value));
                }
            }
            if( values.containsKey("PrcgCndnAccDocumentStructure") ) {
                final Object value = values.remove("PrcgCndnAccDocumentStructure");
                if( (value == null) || (!value.equals(getPrcgCndnAccDocumentStructure())) ) {
                    setPrcgCndnAccDocumentStructure(((java.lang.String) value));
                }
            }
            if( values.containsKey("PrcgCndnAccessDocumentField") ) {
                final Object value = values.remove("PrcgCndnAccessDocumentField");
                if( (value == null) || (!value.equals(getPrcgCndnAccessDocumentField())) ) {
                    setPrcgCndnAccessDocumentField(((java.lang.String) value));
                }
            }
            if( values.containsKey("PrcgCndnAccConstantValueSource") ) {
                final Object value = values.remove("PrcgCndnAccConstantValueSource");
                if( (value == null) || (!value.equals(getPrcgCndnAccConstantValueSource())) ) {
                    setPrcgCndnAccConstantValueSource(((java.lang.String) value));
                }
            }
            if( values.containsKey("PrcgCndnValueInitialIsAllowed") ) {
                final Object value = values.remove("PrcgCndnValueInitialIsAllowed");
                if( (value == null) || (!value.equals(getPrcgCndnValueInitialIsAllowed())) ) {
                    setPrcgCndnValueInitialIsAllowed(((java.lang.Boolean) value));
                }
            }
            if( values.containsKey("PricingConditionAccessType") ) {
                final Object value = values.remove("PricingConditionAccessType");
                if( (value == null) || (!value.equals(getPricingConditionAccessType())) ) {
                    setPricingConditionAccessType(((java.lang.String) value));
                }
            }
            if( values.containsKey("PricingConditionAccessPriority") ) {
                final Object value = values.remove("PricingConditionAccessPriority");
                if( (value == null) || (!value.equals(getPricingConditionAccessPriority())) ) {
                    setPricingConditionAccessPriority(((java.lang.String) value));
                }
            }
            if( values.containsKey("PrcgConditionAccessDirection") ) {
                final Object value = values.remove("PrcgConditionAccessDirection");
                if( (value == null) || (!value.equals(getPrcgConditionAccessDirection())) ) {
                    setPrcgConditionAccessDirection(((java.lang.String) value));
                }
            }
            if( values.containsKey("PrcgCndnAccessDistanceValue") ) {
                final Object value = values.remove("PrcgCndnAccessDistanceValue");
                if( (value == null) || (!value.equals(getPrcgCndnAccessDistanceValue())) ) {
                    setPrcgCndnAccessDistanceValue(((java.lang.String) value));
                }
            }
        }
        // structured properties
        {
        }
        // navigation properties
        {
            if( (values).containsKey("_SalesPricingAccess") ) {
                final Object value = (values).remove("_SalesPricingAccess");
                if( value instanceof Map ) {
                    if( to_SalesPricingAccess == null ) {
                        to_SalesPricingAccess = new SalesPricingAccess();
                    }
                    @SuppressWarnings( "unchecked" )
                    final Map<java.lang.String, Object> inputMap = ((Map<java.lang.String, Object>) value);
                    to_SalesPricingAccess.fromMap(inputMap);
                }
            }
        }
        super.fromMap(values);
    }

    @Override
    protected java.lang.String getDefaultServicePath()
    {
        return AccessSequenceForPricingInSalesService.DEFAULT_SERVICE_PATH;
    }

    @Nonnull
    @Override
    protected Map<java.lang.String, Object> toMapOfNavigationProperties()
    {
        final Map<java.lang.String, Object> values = super.toMapOfNavigationProperties();
        if( to_SalesPricingAccess != null ) {
            (values).put("_SalesPricingAccess", to_SalesPricingAccess);
        }
        return values;
    }

    /**
     * Retrieval of associated <b>SalesPricingAccess</b> entity (one to one). This corresponds to the OData navigation
     * property <b>_SalesPricingAccess</b>.
     * <p>
     * If the navigation property for an entity <b>SalesPricingAccessField</b> has not been resolved yet, this method
     * will <b>not query</b> further information. Instead its <code>Option</code> result state will be
     * <code>empty</code>.
     * 
     * @return If the information for navigation property <b>_SalesPricingAccess</b> is already loaded, the result will
     *         contain the <b>SalesPricingAccess</b> entity. If not, an <code>Option</code> with result state
     *         <code>empty</code> is returned.
     */
    @Nonnull
    public Option<SalesPricingAccess> getSalesPricingAccessIfPresent()
    {
        return Option.of(to_SalesPricingAccess);
    }

    /**
     * Overwrites the associated <b>SalesPricingAccess</b> entity for the loaded navigation property
     * <b>_SalesPricingAccess</b>.
     * 
     * @param value
     *            New <b>SalesPricingAccess</b> entity.
     */
    public void setSalesPricingAccess( final SalesPricingAccess value )
    {
        to_SalesPricingAccess = value;
    }

    /**
     * Helper class to allow for fluent creation of SalesPricingAccessField instances.
     * 
     */
    public final static class SalesPricingAccessFieldBuilder
    {

        private SalesPricingAccess to_SalesPricingAccess;

        private SalesPricingAccessField.SalesPricingAccessFieldBuilder to_SalesPricingAccess(
            final SalesPricingAccess value )
        {
            to_SalesPricingAccess = value;
            return this;
        }

        /**
         * Navigation property <b>_SalesPricingAccess</b> for <b>SalesPricingAccessField</b> to single
         * <b>SalesPricingAccess</b>.
         * 
         * @param value
         *            The SalesPricingAccess to build this SalesPricingAccessField with.
         * @return This Builder to allow for a fluent interface.
         */
        @Nonnull
        public SalesPricingAccessField.SalesPricingAccessFieldBuilder salesPricingAccess(
            final SalesPricingAccess value )
        {
            return to_SalesPricingAccess(value);
        }

    }

}
