/*
 * Copyright (c) 2021 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odatav4.namespaces.accesssequenceforpricinginsales;

import java.util.List;
import java.util.Map;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;

import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.gson.annotations.JsonAdapter;
import com.sap.cloud.sdk.datamodel.odata.client.request.ODataEntityKey;
import com.sap.cloud.sdk.datamodel.odatav4.core.SimpleProperty;
import com.sap.cloud.sdk.datamodel.odatav4.core.VdmEntity;
import com.sap.cloud.sdk.datamodel.odatav4.core.VdmEntitySet;
import com.sap.cloud.sdk.result.ElementName;
import com.sap.cloud.sdk.s4hana.datamodel.odatav4.services.AccessSequenceForPricingInSalesService;

import io.vavr.control.Option;
import lombok.AccessLevel;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.Getter;
import lombok.NoArgsConstructor;
import lombok.Setter;
import lombok.ToString;

/**
 * Access Sequences
 * <p>
 * </p>
 * <p>
 * Original entity name from the Odata EDM: <b>SalesPricingAccessSequenceType</b>
 * </p>
 * 
 */
@Builder
@Data
@NoArgsConstructor
@AllArgsConstructor
@ToString( doNotUseGetters = true, callSuper = true )
@EqualsAndHashCode( doNotUseGetters = true, callSuper = true )
@JsonAdapter( com.sap.cloud.sdk.datamodel.odatav4.adapter.GsonVdmAdapterFactory.class )
@JsonSerialize( using = com.sap.cloud.sdk.datamodel.odatav4.adapter.JacksonVdmObjectSerializer.class )
@JsonDeserialize( using = com.sap.cloud.sdk.datamodel.odatav4.adapter.JacksonVdmObjectDeserializer.class )
public class SalesPricingAccessSequence extends VdmEntity<SalesPricingAccessSequence> implements VdmEntitySet
{

    @Getter
    private final java.lang.String odataType =
        "com.sap.gateway.srvd_a2x.api_slsprcgaccesssequence.v0001.SalesPricingAccessSequenceType";
    /**
     * Selector for all available fields of SalesPricingAccessSequence.
     * 
     */
    public final static SimpleProperty<SalesPricingAccessSequence> ALL_FIELDS = all();
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>ConditionUsage</b>
     * </p>
     * 
     * @return Usage of the condition table
     */
    @Nullable
    @ElementName( "ConditionUsage" )
    private java.lang.String conditionUsage;
    public final static SimpleProperty.String<SalesPricingAccessSequence> CONDITION_USAGE =
        new SimpleProperty.String<SalesPricingAccessSequence>(SalesPricingAccessSequence.class, "ConditionUsage");
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>ConditionApplication</b>
     * </p>
     * 
     * @return Application
     */
    @Nullable
    @ElementName( "ConditionApplication" )
    private java.lang.String conditionApplication;
    public final static SimpleProperty.String<SalesPricingAccessSequence> CONDITION_APPLICATION =
        new SimpleProperty.String<SalesPricingAccessSequence>(SalesPricingAccessSequence.class, "ConditionApplication");
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>AccessSequence</b>
     * </p>
     * 
     * @return Access sequence
     */
    @Nullable
    @ElementName( "AccessSequence" )
    private java.lang.String accessSequence;
    public final static SimpleProperty.String<SalesPricingAccessSequence> ACCESS_SEQUENCE =
        new SimpleProperty.String<SalesPricingAccessSequence>(SalesPricingAccessSequence.class, "AccessSequence");
    /**
     * Navigation property <b>_SalesPricingAccess</b> for <b>SalesPricingAccessSequence</b> to multiple
     * <b>SalesPricingAccess</b>.
     * 
     */
    @ElementName( "_SalesPricingAccess" )
    @Getter( AccessLevel.NONE )
    @Setter( AccessLevel.NONE )
    private List<SalesPricingAccess> to_SalesPricingAccess;
    /**
     * Navigation property <b>_Text</b> for <b>SalesPricingAccessSequence</b> to multiple
     * <b>SlsPricingAccessSequenceText</b>.
     * 
     */
    @ElementName( "_Text" )
    @Getter( AccessLevel.NONE )
    @Setter( AccessLevel.NONE )
    private List<SlsPricingAccessSequenceText> to_Text;
    /**
     * Use with available request builders to apply the <b>_SalesPricingAccess</b> navigation property to query
     * operations.
     * 
     */
    public final static com.sap.cloud.sdk.datamodel.odatav4.core.NavigationProperty.Collection<SalesPricingAccessSequence, SalesPricingAccess> TO__SALES_PRICING_ACCESS =
        new com.sap.cloud.sdk.datamodel.odatav4.core.NavigationProperty.Collection<SalesPricingAccessSequence, SalesPricingAccess>(
            SalesPricingAccessSequence.class,
            "_SalesPricingAccess",
            SalesPricingAccess.class);
    /**
     * Use with available request builders to apply the <b>_Text</b> navigation property to query operations.
     * 
     */
    public final static com.sap.cloud.sdk.datamodel.odatav4.core.NavigationProperty.Collection<SalesPricingAccessSequence, SlsPricingAccessSequenceText> TO__TEXT =
        new com.sap.cloud.sdk.datamodel.odatav4.core.NavigationProperty.Collection<SalesPricingAccessSequence, SlsPricingAccessSequenceText>(
            SalesPricingAccessSequence.class,
            "_Text",
            SlsPricingAccessSequenceText.class);

    /**
     * {@inheritDoc}
     * 
     */
    @Nonnull
    @Override
    public Class<SalesPricingAccessSequence> getType()
    {
        return SalesPricingAccessSequence.class;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>ConditionUsage</b>
     * </p>
     * 
     * @param conditionUsage
     *            Usage of the condition table
     */
    public void setConditionUsage( @Nullable final java.lang.String conditionUsage )
    {
        rememberChangedField("ConditionUsage", this.conditionUsage);
        this.conditionUsage = conditionUsage;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>ConditionApplication</b>
     * </p>
     * 
     * @param conditionApplication
     *            Application
     */
    public void setConditionApplication( @Nullable final java.lang.String conditionApplication )
    {
        rememberChangedField("ConditionApplication", this.conditionApplication);
        this.conditionApplication = conditionApplication;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>AccessSequence</b>
     * </p>
     * 
     * @param accessSequence
     *            Access sequence
     */
    public void setAccessSequence( @Nullable final java.lang.String accessSequence )
    {
        rememberChangedField("AccessSequence", this.accessSequence);
        this.accessSequence = accessSequence;
    }

    @Override
    protected java.lang.String getEntityCollection()
    {
        return "SalesPricingAccessSequence";
    }

    @Nonnull
    @Override
    protected ODataEntityKey getKey()
    {
        final ODataEntityKey entityKey = super.getKey();
        entityKey.addKeyProperty("ConditionUsage", getConditionUsage());
        entityKey.addKeyProperty("ConditionApplication", getConditionApplication());
        entityKey.addKeyProperty("AccessSequence", getAccessSequence());
        return entityKey;
    }

    @Nonnull
    @Override
    protected Map<java.lang.String, Object> toMapOfFields()
    {
        final Map<java.lang.String, Object> values = super.toMapOfFields();
        values.put("ConditionUsage", getConditionUsage());
        values.put("ConditionApplication", getConditionApplication());
        values.put("AccessSequence", getAccessSequence());
        return values;
    }

    @Override
    protected void fromMap( final Map<java.lang.String, Object> inputValues )
    {
        final Map<java.lang.String, Object> values = Maps.newHashMap(inputValues);
        // simple properties
        {
            if( values.containsKey("ConditionUsage") ) {
                final Object value = values.remove("ConditionUsage");
                if( (value == null) || (!value.equals(getConditionUsage())) ) {
                    setConditionUsage(((java.lang.String) value));
                }
            }
            if( values.containsKey("ConditionApplication") ) {
                final Object value = values.remove("ConditionApplication");
                if( (value == null) || (!value.equals(getConditionApplication())) ) {
                    setConditionApplication(((java.lang.String) value));
                }
            }
            if( values.containsKey("AccessSequence") ) {
                final Object value = values.remove("AccessSequence");
                if( (value == null) || (!value.equals(getAccessSequence())) ) {
                    setAccessSequence(((java.lang.String) value));
                }
            }
        }
        // structured properties
        {
        }
        // navigation properties
        {
            if( (values).containsKey("_SalesPricingAccess") ) {
                final Object value = (values).remove("_SalesPricingAccess");
                if( value instanceof Iterable ) {
                    if( to_SalesPricingAccess == null ) {
                        to_SalesPricingAccess = Lists.newArrayList();
                    } else {
                        to_SalesPricingAccess = Lists.newArrayList(to_SalesPricingAccess);
                    }
                    int i = 0;
                    for( Object item : ((Iterable<?>) value) ) {
                        if( !(item instanceof Map) ) {
                            continue;
                        }
                        SalesPricingAccess entity;
                        if( to_SalesPricingAccess.size() > i ) {
                            entity = to_SalesPricingAccess.get(i);
                        } else {
                            entity = new SalesPricingAccess();
                            to_SalesPricingAccess.add(entity);
                        }
                        i = (i + 1);
                        @SuppressWarnings( "unchecked" )
                        final Map<java.lang.String, Object> inputMap = ((Map<java.lang.String, Object>) item);
                        entity.fromMap(inputMap);
                    }
                }
            }
            if( (values).containsKey("_Text") ) {
                final Object value = (values).remove("_Text");
                if( value instanceof Iterable ) {
                    if( to_Text == null ) {
                        to_Text = Lists.newArrayList();
                    } else {
                        to_Text = Lists.newArrayList(to_Text);
                    }
                    int i = 0;
                    for( Object item : ((Iterable<?>) value) ) {
                        if( !(item instanceof Map) ) {
                            continue;
                        }
                        SlsPricingAccessSequenceText entity;
                        if( to_Text.size() > i ) {
                            entity = to_Text.get(i);
                        } else {
                            entity = new SlsPricingAccessSequenceText();
                            to_Text.add(entity);
                        }
                        i = (i + 1);
                        @SuppressWarnings( "unchecked" )
                        final Map<java.lang.String, Object> inputMap = ((Map<java.lang.String, Object>) item);
                        entity.fromMap(inputMap);
                    }
                }
            }
        }
        super.fromMap(values);
    }

    @Override
    protected java.lang.String getDefaultServicePath()
    {
        return AccessSequenceForPricingInSalesService.DEFAULT_SERVICE_PATH;
    }

    @Nonnull
    @Override
    protected Map<java.lang.String, Object> toMapOfNavigationProperties()
    {
        final Map<java.lang.String, Object> values = super.toMapOfNavigationProperties();
        if( to_SalesPricingAccess != null ) {
            (values).put("_SalesPricingAccess", to_SalesPricingAccess);
        }
        if( to_Text != null ) {
            (values).put("_Text", to_Text);
        }
        return values;
    }

    /**
     * Retrieval of associated <b>SalesPricingAccess</b> entities (one to many). This corresponds to the OData
     * navigation property <b>_SalesPricingAccess</b>.
     * <p>
     * If the navigation property for an entity <b>SalesPricingAccessSequence</b> has not been resolved yet, this method
     * will <b>not query</b> further information. Instead its <code>Option</code> result state will be
     * <code>empty</code>.
     * 
     * @return If the information for navigation property <b>_SalesPricingAccess</b> is already loaded, the result will
     *         contain the <b>SalesPricingAccess</b> entities. If not, an <code>Option</code> with result state
     *         <code>empty</code> is returned.
     */
    @Nonnull
    public Option<List<SalesPricingAccess>> getSalesPricingAccessIfPresent()
    {
        return Option.of(to_SalesPricingAccess);
    }

    /**
     * Overwrites the list of associated <b>SalesPricingAccess</b> entities for the loaded navigation property
     * <b>_SalesPricingAccess</b>.
     * <p>
     * If the navigation property <b>_SalesPricingAccess</b> of a queried <b>SalesPricingAccessSequence</b> is operated
     * lazily, an <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     * 
     * @param value
     *            List of <b>SalesPricingAccess</b> entities.
     */
    public void setSalesPricingAccess( @Nonnull final List<SalesPricingAccess> value )
    {
        if( to_SalesPricingAccess == null ) {
            to_SalesPricingAccess = Lists.newArrayList();
        }
        to_SalesPricingAccess.clear();
        to_SalesPricingAccess.addAll(value);
    }

    /**
     * Adds elements to the list of associated <b>SalesPricingAccess</b> entities. This corresponds to the OData
     * navigation property <b>_SalesPricingAccess</b>.
     * <p>
     * If the navigation property <b>_SalesPricingAccess</b> of a queried <b>SalesPricingAccessSequence</b> is operated
     * lazily, an <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     * 
     * @param entity
     *            Array of <b>SalesPricingAccess</b> entities.
     */
    public void addSalesPricingAccess( SalesPricingAccess... entity )
    {
        if( to_SalesPricingAccess == null ) {
            to_SalesPricingAccess = Lists.newArrayList();
        }
        to_SalesPricingAccess.addAll(Lists.newArrayList(entity));
    }

    /**
     * Retrieval of associated <b>SlsPricingAccessSequenceText</b> entities (one to many). This corresponds to the OData
     * navigation property <b>_Text</b>.
     * <p>
     * If the navigation property for an entity <b>SalesPricingAccessSequence</b> has not been resolved yet, this method
     * will <b>not query</b> further information. Instead its <code>Option</code> result state will be
     * <code>empty</code>.
     * 
     * @return If the information for navigation property <b>_Text</b> is already loaded, the result will contain the
     *         <b>SlsPricingAccessSequenceText</b> entities. If not, an <code>Option</code> with result state
     *         <code>empty</code> is returned.
     */
    @Nonnull
    public Option<List<SlsPricingAccessSequenceText>> getTextIfPresent()
    {
        return Option.of(to_Text);
    }

    /**
     * Overwrites the list of associated <b>SlsPricingAccessSequenceText</b> entities for the loaded navigation property
     * <b>_Text</b>.
     * <p>
     * If the navigation property <b>_Text</b> of a queried <b>SalesPricingAccessSequence</b> is operated lazily, an
     * <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     * 
     * @param value
     *            List of <b>SlsPricingAccessSequenceText</b> entities.
     */
    public void setText( @Nonnull final List<SlsPricingAccessSequenceText> value )
    {
        if( to_Text == null ) {
            to_Text = Lists.newArrayList();
        }
        to_Text.clear();
        to_Text.addAll(value);
    }

    /**
     * Adds elements to the list of associated <b>SlsPricingAccessSequenceText</b> entities. This corresponds to the
     * OData navigation property <b>_Text</b>.
     * <p>
     * If the navigation property <b>_Text</b> of a queried <b>SalesPricingAccessSequence</b> is operated lazily, an
     * <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     * 
     * @param entity
     *            Array of <b>SlsPricingAccessSequenceText</b> entities.
     */
    public void addText( SlsPricingAccessSequenceText... entity )
    {
        if( to_Text == null ) {
            to_Text = Lists.newArrayList();
        }
        to_Text.addAll(Lists.newArrayList(entity));
    }

    /**
     * Helper class to allow for fluent creation of SalesPricingAccessSequence instances.
     * 
     */
    public final static class SalesPricingAccessSequenceBuilder
    {

        private List<SalesPricingAccess> to_SalesPricingAccess = Lists.newArrayList();
        private List<SlsPricingAccessSequenceText> to_Text = Lists.newArrayList();

        private SalesPricingAccessSequence.SalesPricingAccessSequenceBuilder to_SalesPricingAccess(
            final List<SalesPricingAccess> value )
        {
            to_SalesPricingAccess.addAll(value);
            return this;
        }

        /**
         * Navigation property <b>_SalesPricingAccess</b> for <b>SalesPricingAccessSequence</b> to multiple
         * <b>SalesPricingAccess</b>.
         * 
         * @param value
         *            The SalesPricingAccesss to build this SalesPricingAccessSequence with.
         * @return This Builder to allow for a fluent interface.
         */
        @Nonnull
        public SalesPricingAccessSequence.SalesPricingAccessSequenceBuilder salesPricingAccess(
            SalesPricingAccess... value )
        {
            return to_SalesPricingAccess(Lists.newArrayList(value));
        }

        private SalesPricingAccessSequence.SalesPricingAccessSequenceBuilder to_Text(
            final List<SlsPricingAccessSequenceText> value )
        {
            to_Text.addAll(value);
            return this;
        }

        /**
         * Navigation property <b>_Text</b> for <b>SalesPricingAccessSequence</b> to multiple
         * <b>SlsPricingAccessSequenceText</b>.
         * 
         * @param value
         *            The SlsPricingAccessSequenceTexts to build this SalesPricingAccessSequence with.
         * @return This Builder to allow for a fluent interface.
         */
        @Nonnull
        public SalesPricingAccessSequence.SalesPricingAccessSequenceBuilder text(
            SlsPricingAccessSequenceText... value )
        {
            return to_Text(Lists.newArrayList(value));
        }

    }

}
