/*
 * Copyright (c) 2021 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odatav4.namespaces.accesssequenceforpricinginsales;

import java.util.Map;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;

import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.google.common.collect.Maps;
import com.google.gson.annotations.JsonAdapter;
import com.sap.cloud.sdk.datamodel.odata.client.request.ODataEntityKey;
import com.sap.cloud.sdk.datamodel.odatav4.core.SimpleProperty;
import com.sap.cloud.sdk.datamodel.odatav4.core.VdmEntity;
import com.sap.cloud.sdk.datamodel.odatav4.core.VdmEntitySet;
import com.sap.cloud.sdk.result.ElementName;
import com.sap.cloud.sdk.s4hana.datamodel.odatav4.services.AccessSequenceForPricingInSalesService;

import io.vavr.control.Option;
import lombok.AccessLevel;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.Getter;
import lombok.NoArgsConstructor;
import lombok.Setter;
import lombok.ToString;

/**
 * <p>
 * Original entity name from the Odata EDM: <b>SlsPricingAccessSequenceTextType</b>
 * </p>
 * 
 */
@Builder
@Data
@NoArgsConstructor
@AllArgsConstructor
@ToString( doNotUseGetters = true, callSuper = true )
@EqualsAndHashCode( doNotUseGetters = true, callSuper = true )
@JsonAdapter( com.sap.cloud.sdk.datamodel.odatav4.adapter.GsonVdmAdapterFactory.class )
@JsonSerialize( using = com.sap.cloud.sdk.datamodel.odatav4.adapter.JacksonVdmObjectSerializer.class )
@JsonDeserialize( using = com.sap.cloud.sdk.datamodel.odatav4.adapter.JacksonVdmObjectDeserializer.class )
public class SlsPricingAccessSequenceText extends VdmEntity<SlsPricingAccessSequenceText> implements VdmEntitySet
{

    @Getter
    private final java.lang.String odataType =
        "com.sap.gateway.srvd_a2x.api_slsprcgaccesssequence.v0001.SlsPricingAccessSequenceTextType";
    /**
     * Selector for all available fields of SlsPricingAccessSequenceText.
     * 
     */
    public final static SimpleProperty<SlsPricingAccessSequenceText> ALL_FIELDS = all();
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>Language</b>
     * </p>
     * 
     * @return Language Key
     */
    @Nullable
    @ElementName( "Language" )
    private java.lang.String language;
    public final static SimpleProperty.String<SlsPricingAccessSequenceText> LANGUAGE =
        new SimpleProperty.String<SlsPricingAccessSequenceText>(SlsPricingAccessSequenceText.class, "Language");
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>ConditionUsage</b>
     * </p>
     * 
     * @return Usage of the condition table
     */
    @Nullable
    @ElementName( "ConditionUsage" )
    private java.lang.String conditionUsage;
    public final static SimpleProperty.String<SlsPricingAccessSequenceText> CONDITION_USAGE =
        new SimpleProperty.String<SlsPricingAccessSequenceText>(SlsPricingAccessSequenceText.class, "ConditionUsage");
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>ConditionApplication</b>
     * </p>
     * 
     * @return Application
     */
    @Nullable
    @ElementName( "ConditionApplication" )
    private java.lang.String conditionApplication;
    public final static SimpleProperty.String<SlsPricingAccessSequenceText> CONDITION_APPLICATION =
        new SimpleProperty.String<SlsPricingAccessSequenceText>(
            SlsPricingAccessSequenceText.class,
            "ConditionApplication");
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>AccessSequence</b>
     * </p>
     * 
     * @return Access sequence
     */
    @Nullable
    @ElementName( "AccessSequence" )
    private java.lang.String accessSequence;
    public final static SimpleProperty.String<SlsPricingAccessSequenceText> ACCESS_SEQUENCE =
        new SimpleProperty.String<SlsPricingAccessSequenceText>(SlsPricingAccessSequenceText.class, "AccessSequence");
    /**
     * Constraints: Not nullable, Maximum length: 30
     * <p>
     * Original property name from the Odata EDM: <b>AccessSequenceText</b>
     * </p>
     * 
     * @return Description
     */
    @Nullable
    @ElementName( "AccessSequenceText" )
    private java.lang.String accessSequenceText;
    public final static SimpleProperty.String<SlsPricingAccessSequenceText> ACCESS_SEQUENCE_TEXT =
        new SimpleProperty.String<SlsPricingAccessSequenceText>(
            SlsPricingAccessSequenceText.class,
            "AccessSequenceText");
    /**
     * Navigation property <b>_SalesPricingAccessSequence</b> for <b>SlsPricingAccessSequenceText</b> to single
     * <b>SalesPricingAccessSequence</b>.
     * 
     */
    @ElementName( "_SalesPricingAccessSequence" )
    @Nullable
    @Getter( AccessLevel.NONE )
    @Setter( AccessLevel.NONE )
    private SalesPricingAccessSequence to_SalesPricingAccessSequence;
    /**
     * Use with available request builders to apply the <b>_SalesPricingAccessSequence</b> navigation property to query
     * operations.
     * 
     */
    public final static com.sap.cloud.sdk.datamodel.odatav4.core.NavigationProperty.Single<SlsPricingAccessSequenceText, SalesPricingAccessSequence> TO__SALES_PRICING_ACCESS_SEQUENCE =
        new com.sap.cloud.sdk.datamodel.odatav4.core.NavigationProperty.Single<SlsPricingAccessSequenceText, SalesPricingAccessSequence>(
            SlsPricingAccessSequenceText.class,
            "_SalesPricingAccessSequence",
            SalesPricingAccessSequence.class);

    /**
     * {@inheritDoc}
     * 
     */
    @Nonnull
    @Override
    public Class<SlsPricingAccessSequenceText> getType()
    {
        return SlsPricingAccessSequenceText.class;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>Language</b>
     * </p>
     * 
     * @param language
     *            Language Key
     */
    public void setLanguage( @Nullable final java.lang.String language )
    {
        rememberChangedField("Language", this.language);
        this.language = language;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>ConditionUsage</b>
     * </p>
     * 
     * @param conditionUsage
     *            Usage of the condition table
     */
    public void setConditionUsage( @Nullable final java.lang.String conditionUsage )
    {
        rememberChangedField("ConditionUsage", this.conditionUsage);
        this.conditionUsage = conditionUsage;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>ConditionApplication</b>
     * </p>
     * 
     * @param conditionApplication
     *            Application
     */
    public void setConditionApplication( @Nullable final java.lang.String conditionApplication )
    {
        rememberChangedField("ConditionApplication", this.conditionApplication);
        this.conditionApplication = conditionApplication;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>AccessSequence</b>
     * </p>
     * 
     * @param accessSequence
     *            Access sequence
     */
    public void setAccessSequence( @Nullable final java.lang.String accessSequence )
    {
        rememberChangedField("AccessSequence", this.accessSequence);
        this.accessSequence = accessSequence;
    }

    /**
     * Constraints: Not nullable, Maximum length: 30
     * <p>
     * Original property name from the Odata EDM: <b>AccessSequenceText</b>
     * </p>
     * 
     * @param accessSequenceText
     *            Description
     */
    public void setAccessSequenceText( @Nullable final java.lang.String accessSequenceText )
    {
        rememberChangedField("AccessSequenceText", this.accessSequenceText);
        this.accessSequenceText = accessSequenceText;
    }

    @Override
    protected java.lang.String getEntityCollection()
    {
        return "SlsPricingAccessSequenceText";
    }

    @Nonnull
    @Override
    protected ODataEntityKey getKey()
    {
        final ODataEntityKey entityKey = super.getKey();
        entityKey.addKeyProperty("Language", getLanguage());
        entityKey.addKeyProperty("ConditionUsage", getConditionUsage());
        entityKey.addKeyProperty("ConditionApplication", getConditionApplication());
        entityKey.addKeyProperty("AccessSequence", getAccessSequence());
        return entityKey;
    }

    @Nonnull
    @Override
    protected Map<java.lang.String, Object> toMapOfFields()
    {
        final Map<java.lang.String, Object> values = super.toMapOfFields();
        values.put("Language", getLanguage());
        values.put("ConditionUsage", getConditionUsage());
        values.put("ConditionApplication", getConditionApplication());
        values.put("AccessSequence", getAccessSequence());
        values.put("AccessSequenceText", getAccessSequenceText());
        return values;
    }

    @Override
    protected void fromMap( final Map<java.lang.String, Object> inputValues )
    {
        final Map<java.lang.String, Object> values = Maps.newHashMap(inputValues);
        // simple properties
        {
            if( values.containsKey("Language") ) {
                final Object value = values.remove("Language");
                if( (value == null) || (!value.equals(getLanguage())) ) {
                    setLanguage(((java.lang.String) value));
                }
            }
            if( values.containsKey("ConditionUsage") ) {
                final Object value = values.remove("ConditionUsage");
                if( (value == null) || (!value.equals(getConditionUsage())) ) {
                    setConditionUsage(((java.lang.String) value));
                }
            }
            if( values.containsKey("ConditionApplication") ) {
                final Object value = values.remove("ConditionApplication");
                if( (value == null) || (!value.equals(getConditionApplication())) ) {
                    setConditionApplication(((java.lang.String) value));
                }
            }
            if( values.containsKey("AccessSequence") ) {
                final Object value = values.remove("AccessSequence");
                if( (value == null) || (!value.equals(getAccessSequence())) ) {
                    setAccessSequence(((java.lang.String) value));
                }
            }
            if( values.containsKey("AccessSequenceText") ) {
                final Object value = values.remove("AccessSequenceText");
                if( (value == null) || (!value.equals(getAccessSequenceText())) ) {
                    setAccessSequenceText(((java.lang.String) value));
                }
            }
        }
        // structured properties
        {
        }
        // navigation properties
        {
            if( (values).containsKey("_SalesPricingAccessSequence") ) {
                final Object value = (values).remove("_SalesPricingAccessSequence");
                if( value instanceof Map ) {
                    if( to_SalesPricingAccessSequence == null ) {
                        to_SalesPricingAccessSequence = new SalesPricingAccessSequence();
                    }
                    @SuppressWarnings( "unchecked" )
                    final Map<java.lang.String, Object> inputMap = ((Map<java.lang.String, Object>) value);
                    to_SalesPricingAccessSequence.fromMap(inputMap);
                }
            }
        }
        super.fromMap(values);
    }

    @Override
    protected java.lang.String getDefaultServicePath()
    {
        return AccessSequenceForPricingInSalesService.DEFAULT_SERVICE_PATH;
    }

    @Nonnull
    @Override
    protected Map<java.lang.String, Object> toMapOfNavigationProperties()
    {
        final Map<java.lang.String, Object> values = super.toMapOfNavigationProperties();
        if( to_SalesPricingAccessSequence != null ) {
            (values).put("_SalesPricingAccessSequence", to_SalesPricingAccessSequence);
        }
        return values;
    }

    /**
     * Retrieval of associated <b>SalesPricingAccessSequence</b> entity (one to one). This corresponds to the OData
     * navigation property <b>_SalesPricingAccessSequence</b>.
     * <p>
     * If the navigation property for an entity <b>SlsPricingAccessSequenceText</b> has not been resolved yet, this
     * method will <b>not query</b> further information. Instead its <code>Option</code> result state will be
     * <code>empty</code>.
     * 
     * @return If the information for navigation property <b>_SalesPricingAccessSequence</b> is already loaded, the
     *         result will contain the <b>SalesPricingAccessSequence</b> entity. If not, an <code>Option</code> with
     *         result state <code>empty</code> is returned.
     */
    @Nonnull
    public Option<SalesPricingAccessSequence> getSalesPricingAccessSequenceIfPresent()
    {
        return Option.of(to_SalesPricingAccessSequence);
    }

    /**
     * Overwrites the associated <b>SalesPricingAccessSequence</b> entity for the loaded navigation property
     * <b>_SalesPricingAccessSequence</b>.
     * 
     * @param value
     *            New <b>SalesPricingAccessSequence</b> entity.
     */
    public void setSalesPricingAccessSequence( final SalesPricingAccessSequence value )
    {
        to_SalesPricingAccessSequence = value;
    }

    /**
     * Helper class to allow for fluent creation of SlsPricingAccessSequenceText instances.
     * 
     */
    public final static class SlsPricingAccessSequenceTextBuilder
    {

        private SalesPricingAccessSequence to_SalesPricingAccessSequence;

        private SlsPricingAccessSequenceText.SlsPricingAccessSequenceTextBuilder to_SalesPricingAccessSequence(
            final SalesPricingAccessSequence value )
        {
            to_SalesPricingAccessSequence = value;
            return this;
        }

        /**
         * Navigation property <b>_SalesPricingAccessSequence</b> for <b>SlsPricingAccessSequenceText</b> to single
         * <b>SalesPricingAccessSequence</b>.
         * 
         * @param value
         *            The SalesPricingAccessSequence to build this SlsPricingAccessSequenceText with.
         * @return This Builder to allow for a fluent interface.
         */
        @Nonnull
        public SlsPricingAccessSequenceText.SlsPricingAccessSequenceTextBuilder salesPricingAccessSequence(
            final SalesPricingAccessSequence value )
        {
            return to_SalesPricingAccessSequence(value);
        }

    }

}
