/*
 * Copyright (c) 2021 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odatav4.namespaces.bank;

import java.util.LinkedList;
import java.util.Map;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;

import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.google.common.collect.Maps;
import com.google.gson.annotations.JsonAdapter;
import com.sap.cloud.sdk.datamodel.odata.client.request.ODataEntityKey;
import com.sap.cloud.sdk.datamodel.odatav4.core.SimpleProperty;
import com.sap.cloud.sdk.datamodel.odatav4.core.VdmEntity;
import com.sap.cloud.sdk.datamodel.odatav4.core.VdmEntitySet;
import com.sap.cloud.sdk.result.ElementName;
import com.sap.cloud.sdk.s4hana.datamodel.odatav4.services.BankService;

import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.Getter;
import lombok.NoArgsConstructor;
import lombok.ToString;

/**
 * Bank
 * <p>
 * </p>
 * <p>
 * Original entity name from the Odata EDM: <b>BankType</b>
 * </p>
 * 
 */
@Builder
@Data
@NoArgsConstructor
@AllArgsConstructor
@ToString( doNotUseGetters = true, callSuper = true )
@EqualsAndHashCode( doNotUseGetters = true, callSuper = true )
@JsonAdapter( com.sap.cloud.sdk.datamodel.odatav4.adapter.GsonVdmAdapterFactory.class )
@JsonSerialize( using = com.sap.cloud.sdk.datamodel.odatav4.adapter.JacksonVdmObjectSerializer.class )
@JsonDeserialize( using = com.sap.cloud.sdk.datamodel.odatav4.adapter.JacksonVdmObjectDeserializer.class )
public class Bank extends VdmEntity<Bank> implements VdmEntitySet
{

    @Getter
    private final java.lang.String odataType = "com.sap.gateway.srvd_a2x.api_bank.v0001.BankType";
    /**
     * Selector for all available fields of Bank.
     * 
     */
    public final static SimpleProperty<Bank> ALL_FIELDS = all();
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>BankCountry</b>
     * </p>
     * 
     * @return Country/Region Key of Bank
     */
    @Nullable
    @ElementName( "BankCountry" )
    private java.lang.String bankCountry;
    public final static SimpleProperty.String<Bank> BANK_COUNTRY =
        new SimpleProperty.String<Bank>(Bank.class, "BankCountry");
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 15
     * <p>
     * Original property name from the Odata EDM: <b>BankInternalID</b>
     * </p>
     * 
     * @return Bank Keys
     */
    @Nullable
    @ElementName( "BankInternalID" )
    private java.lang.String bankInternalID;
    public final static SimpleProperty.String<Bank> BANK_INTERNAL_ID =
        new SimpleProperty.String<Bank>(Bank.class, "BankInternalID");
    /**
     * Constraints: Not nullable, Maximum length: 60
     * <p>
     * Original property name from the Odata EDM: <b>BankName</b>
     * </p>
     * 
     * @return Name of Bank
     */
    @Nullable
    @ElementName( "BankName" )
    private java.lang.String bankName;
    public final static SimpleProperty.String<Bank> BANK_NAME = new SimpleProperty.String<Bank>(Bank.class, "BankName");
    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>Region</b>
     * </p>
     * 
     * @return Region (State, Province, County)
     */
    @Nullable
    @ElementName( "Region" )
    private java.lang.String region;
    public final static SimpleProperty.String<Bank> REGION = new SimpleProperty.String<Bank>(Bank.class, "Region");
    /**
     * Constraints: Not nullable, Maximum length: 35
     * <p>
     * Original property name from the Odata EDM: <b>StreetName</b>
     * </p>
     * 
     * @return Street and House Number
     */
    @Nullable
    @ElementName( "StreetName" )
    private java.lang.String streetName;
    public final static SimpleProperty.String<Bank> STREET_NAME =
        new SimpleProperty.String<Bank>(Bank.class, "StreetName");
    /**
     * Constraints: Not nullable, Maximum length: 35
     * <p>
     * Original property name from the Odata EDM: <b>CityName</b>
     * </p>
     * 
     * @return City
     */
    @Nullable
    @ElementName( "CityName" )
    private java.lang.String cityName;
    public final static SimpleProperty.String<Bank> CITY_NAME = new SimpleProperty.String<Bank>(Bank.class, "CityName");
    /**
     * Constraints: Not nullable, Maximum length: 11
     * <p>
     * Original property name from the Odata EDM: <b>SWIFTCode</b>
     * </p>
     * 
     * @return SWIFT/BIC for International Payments
     */
    @Nullable
    @ElementName( "SWIFTCode" )
    private java.lang.String sWIFTCode;
    public final static SimpleProperty.String<Bank> SWIFT_CODE =
        new SimpleProperty.String<Bank>(Bank.class, "SWIFTCode");
    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>BankNetworkGrouping</b>
     * </p>
     * 
     * @return Bank group (bank network)
     */
    @Nullable
    @ElementName( "BankNetworkGrouping" )
    private java.lang.String bankNetworkGrouping;
    public final static SimpleProperty.String<Bank> BANK_NETWORK_GROUPING =
        new SimpleProperty.String<Bank>(Bank.class, "BankNetworkGrouping");
    /**
     * Constraints: Not nullable
     * <p>
     * Original property name from the Odata EDM: <b>IsMarkedForDeletion</b>
     * </p>
     * 
     * @return Deletion Indicator
     */
    @Nullable
    @ElementName( "IsMarkedForDeletion" )
    private java.lang.Boolean isMarkedForDeletion;
    public final static SimpleProperty.Boolean<Bank> IS_MARKED_FOR_DELETION =
        new SimpleProperty.Boolean<Bank>(Bank.class, "IsMarkedForDeletion");
    /**
     * Constraints: Not nullable, Maximum length: 15
     * <p>
     * Original property name from the Odata EDM: <b>Bank</b>
     * </p>
     * 
     * @return Bank Number
     */
    @Nullable
    @ElementName( "Bank" )
    private java.lang.String bank;
    public final static SimpleProperty.String<Bank> BANK = new SimpleProperty.String<Bank>(Bank.class, "Bank");
    /**
     * Constraints: Not nullable, Maximum length: 40
     * <p>
     * Original property name from the Odata EDM: <b>Branch</b>
     * </p>
     * 
     * @return Bank Branch
     */
    @Nullable
    @ElementName( "Branch" )
    private java.lang.String branch;
    public final static SimpleProperty.String<Bank> BRANCH = new SimpleProperty.String<Bank>(Bank.class, "Branch");
    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>BankCategory</b>
     * </p>
     * 
     * @return Internal bank category
     */
    @Nullable
    @ElementName( "BankCategory" )
    private java.lang.String bankCategory;
    public final static SimpleProperty.String<Bank> BANK_CATEGORY =
        new SimpleProperty.String<Bank>(Bank.class, "BankCategory");
    /**
     * Constraints: Not nullable
     * <p>
     * Original property name from the Odata EDM: <b>SAP__Messages</b>
     * </p>
     * 
     * @return The _Messages contained in this {@link VdmEntity}.
     */
    @Nullable
    @ElementName( "SAP__Messages" )
    private java.util.Collection<SAP__Message> _Messages;
    /**
     * Use with available request builders to apply the <b>SAP__Messages</b> complex property to query operations.
     * 
     */
    public final static com.sap.cloud.sdk.datamodel.odatav4.core.ComplexProperty.Collection<Bank, SAP__Message> _MESSAGES =
        new com.sap.cloud.sdk.datamodel.odatav4.core.ComplexProperty.Collection<Bank, SAP__Message>(
            Bank.class,
            "SAP__Messages",
            SAP__Message.class);

    /**
     * {@inheritDoc}
     * 
     */
    @Nonnull
    @Override
    public Class<Bank> getType()
    {
        return Bank.class;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>BankCountry</b>
     * </p>
     * 
     * @param bankCountry
     *            Country/Region Key of Bank
     */
    public void setBankCountry( @Nullable final java.lang.String bankCountry )
    {
        rememberChangedField("BankCountry", this.bankCountry);
        this.bankCountry = bankCountry;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 15
     * <p>
     * Original property name from the Odata EDM: <b>BankInternalID</b>
     * </p>
     * 
     * @param bankInternalID
     *            Bank Keys
     */
    public void setBankInternalID( @Nullable final java.lang.String bankInternalID )
    {
        rememberChangedField("BankInternalID", this.bankInternalID);
        this.bankInternalID = bankInternalID;
    }

    /**
     * Constraints: Not nullable, Maximum length: 60
     * <p>
     * Original property name from the Odata EDM: <b>BankName</b>
     * </p>
     * 
     * @param bankName
     *            Name of Bank
     */
    public void setBankName( @Nullable final java.lang.String bankName )
    {
        rememberChangedField("BankName", this.bankName);
        this.bankName = bankName;
    }

    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>Region</b>
     * </p>
     * 
     * @param region
     *            Region (State, Province, County)
     */
    public void setRegion( @Nullable final java.lang.String region )
    {
        rememberChangedField("Region", this.region);
        this.region = region;
    }

    /**
     * Constraints: Not nullable, Maximum length: 35
     * <p>
     * Original property name from the Odata EDM: <b>StreetName</b>
     * </p>
     * 
     * @param streetName
     *            Street and House Number
     */
    public void setStreetName( @Nullable final java.lang.String streetName )
    {
        rememberChangedField("StreetName", this.streetName);
        this.streetName = streetName;
    }

    /**
     * Constraints: Not nullable, Maximum length: 35
     * <p>
     * Original property name from the Odata EDM: <b>CityName</b>
     * </p>
     * 
     * @param cityName
     *            City
     */
    public void setCityName( @Nullable final java.lang.String cityName )
    {
        rememberChangedField("CityName", this.cityName);
        this.cityName = cityName;
    }

    /**
     * Constraints: Not nullable, Maximum length: 11
     * <p>
     * Original property name from the Odata EDM: <b>SWIFTCode</b>
     * </p>
     * 
     * @param sWIFTCode
     *            SWIFT/BIC for International Payments
     */
    public void setSWIFTCode( @Nullable final java.lang.String sWIFTCode )
    {
        rememberChangedField("SWIFTCode", this.sWIFTCode);
        this.sWIFTCode = sWIFTCode;
    }

    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>BankNetworkGrouping</b>
     * </p>
     * 
     * @param bankNetworkGrouping
     *            Bank group (bank network)
     */
    public void setBankNetworkGrouping( @Nullable final java.lang.String bankNetworkGrouping )
    {
        rememberChangedField("BankNetworkGrouping", this.bankNetworkGrouping);
        this.bankNetworkGrouping = bankNetworkGrouping;
    }

    /**
     * Constraints: Not nullable
     * <p>
     * Original property name from the Odata EDM: <b>IsMarkedForDeletion</b>
     * </p>
     * 
     * @param isMarkedForDeletion
     *            Deletion Indicator
     */
    public void setIsMarkedForDeletion( @Nullable final java.lang.Boolean isMarkedForDeletion )
    {
        rememberChangedField("IsMarkedForDeletion", this.isMarkedForDeletion);
        this.isMarkedForDeletion = isMarkedForDeletion;
    }

    /**
     * Constraints: Not nullable, Maximum length: 15
     * <p>
     * Original property name from the Odata EDM: <b>Bank</b>
     * </p>
     * 
     * @param bank
     *            Bank Number
     */
    public void setBank( @Nullable final java.lang.String bank )
    {
        rememberChangedField("Bank", this.bank);
        this.bank = bank;
    }

    /**
     * Constraints: Not nullable, Maximum length: 40
     * <p>
     * Original property name from the Odata EDM: <b>Branch</b>
     * </p>
     * 
     * @param branch
     *            Bank Branch
     */
    public void setBranch( @Nullable final java.lang.String branch )
    {
        rememberChangedField("Branch", this.branch);
        this.branch = branch;
    }

    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>BankCategory</b>
     * </p>
     * 
     * @param bankCategory
     *            Internal bank category
     */
    public void setBankCategory( @Nullable final java.lang.String bankCategory )
    {
        rememberChangedField("BankCategory", this.bankCategory);
        this.bankCategory = bankCategory;
    }

    /**
     * Constraints: Not nullable
     * <p>
     * Original property name from the Odata EDM: <b>SAP__Messages</b>
     * </p>
     * 
     * @param _Messages
     *            The _Messages to set.
     */
    public void set_Messages( @Nullable final java.util.Collection<SAP__Message> _Messages )
    {
        rememberChangedField("SAP__Messages", this._Messages);
        this._Messages = _Messages;
    }

    @Override
    protected java.lang.String getEntityCollection()
    {
        return "Bank";
    }

    @Nonnull
    @Override
    protected ODataEntityKey getKey()
    {
        final ODataEntityKey entityKey = super.getKey();
        entityKey.addKeyProperty("BankCountry", getBankCountry());
        entityKey.addKeyProperty("BankInternalID", getBankInternalID());
        return entityKey;
    }

    @Nonnull
    @Override
    protected Map<java.lang.String, Object> toMapOfFields()
    {
        final Map<java.lang.String, Object> values = super.toMapOfFields();
        values.put("BankCountry", getBankCountry());
        values.put("BankInternalID", getBankInternalID());
        values.put("BankName", getBankName());
        values.put("Region", getRegion());
        values.put("StreetName", getStreetName());
        values.put("CityName", getCityName());
        values.put("SWIFTCode", getSWIFTCode());
        values.put("BankNetworkGrouping", getBankNetworkGrouping());
        values.put("IsMarkedForDeletion", getIsMarkedForDeletion());
        values.put("Bank", getBank());
        values.put("Branch", getBranch());
        values.put("BankCategory", getBankCategory());
        values.put("SAP__Messages", get_Messages());
        return values;
    }

    @Override
    protected void fromMap( final Map<java.lang.String, Object> inputValues )
    {
        final Map<java.lang.String, Object> values = Maps.newHashMap(inputValues);
        // simple properties
        {
            if( values.containsKey("BankCountry") ) {
                final Object value = values.remove("BankCountry");
                if( (value == null) || (!value.equals(getBankCountry())) ) {
                    setBankCountry(((java.lang.String) value));
                }
            }
            if( values.containsKey("BankInternalID") ) {
                final Object value = values.remove("BankInternalID");
                if( (value == null) || (!value.equals(getBankInternalID())) ) {
                    setBankInternalID(((java.lang.String) value));
                }
            }
            if( values.containsKey("BankName") ) {
                final Object value = values.remove("BankName");
                if( (value == null) || (!value.equals(getBankName())) ) {
                    setBankName(((java.lang.String) value));
                }
            }
            if( values.containsKey("Region") ) {
                final Object value = values.remove("Region");
                if( (value == null) || (!value.equals(getRegion())) ) {
                    setRegion(((java.lang.String) value));
                }
            }
            if( values.containsKey("StreetName") ) {
                final Object value = values.remove("StreetName");
                if( (value == null) || (!value.equals(getStreetName())) ) {
                    setStreetName(((java.lang.String) value));
                }
            }
            if( values.containsKey("CityName") ) {
                final Object value = values.remove("CityName");
                if( (value == null) || (!value.equals(getCityName())) ) {
                    setCityName(((java.lang.String) value));
                }
            }
            if( values.containsKey("SWIFTCode") ) {
                final Object value = values.remove("SWIFTCode");
                if( (value == null) || (!value.equals(getSWIFTCode())) ) {
                    setSWIFTCode(((java.lang.String) value));
                }
            }
            if( values.containsKey("BankNetworkGrouping") ) {
                final Object value = values.remove("BankNetworkGrouping");
                if( (value == null) || (!value.equals(getBankNetworkGrouping())) ) {
                    setBankNetworkGrouping(((java.lang.String) value));
                }
            }
            if( values.containsKey("IsMarkedForDeletion") ) {
                final Object value = values.remove("IsMarkedForDeletion");
                if( (value == null) || (!value.equals(getIsMarkedForDeletion())) ) {
                    setIsMarkedForDeletion(((java.lang.Boolean) value));
                }
            }
            if( values.containsKey("Bank") ) {
                final Object value = values.remove("Bank");
                if( (value == null) || (!value.equals(getBank())) ) {
                    setBank(((java.lang.String) value));
                }
            }
            if( values.containsKey("Branch") ) {
                final Object value = values.remove("Branch");
                if( (value == null) || (!value.equals(getBranch())) ) {
                    setBranch(((java.lang.String) value));
                }
            }
            if( values.containsKey("BankCategory") ) {
                final Object value = values.remove("BankCategory");
                if( (value == null) || (!value.equals(getBankCategory())) ) {
                    setBankCategory(((java.lang.String) value));
                }
            }
        }
        // structured properties
        {
            if( values.containsKey("SAP__Messages") ) {
                final Object value = values.remove("SAP__Messages");
                if( value instanceof Iterable ) {
                    final LinkedList<SAP__Message> _Messages = new LinkedList<SAP__Message>();
                    for( Object properties : ((Iterable<?>) value) ) {
                        if( properties instanceof Map ) {
                            final SAP__Message item = new SAP__Message();
                            @SuppressWarnings( "unchecked" )
                            final Map<java.lang.String, Object> inputMap = ((Map<java.lang.String, Object>) value);
                            item.fromMap(inputMap);
                            _Messages.add(item);
                        }
                    }
                    set_Messages(_Messages);
                }
                if( (value == null) && (get_Messages() != null) ) {
                    set_Messages(null);
                }
            }
        }
        // navigation properties
        {
        }
        super.fromMap(values);
    }

    @Override
    protected java.lang.String getDefaultServicePath()
    {
        return BankService.DEFAULT_SERVICE_PATH;
    }

}
