/*
 * Copyright (c) 2021 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odatav4.namespaces.cashsecuritydeposit;

import java.math.BigDecimal;
import java.time.LocalDate;
import java.time.LocalTime;
import java.util.Map;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;

import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.google.common.collect.Maps;
import com.google.gson.annotations.JsonAdapter;
import com.sap.cloud.sdk.datamodel.odata.client.request.ODataEntityKey;
import com.sap.cloud.sdk.datamodel.odatav4.core.DecimalDescriptor;
import com.sap.cloud.sdk.datamodel.odatav4.core.SimpleProperty;
import com.sap.cloud.sdk.datamodel.odatav4.core.VdmEntity;
import com.sap.cloud.sdk.datamodel.odatav4.core.VdmEntitySet;
import com.sap.cloud.sdk.result.ElementName;
import com.sap.cloud.sdk.s4hana.datamodel.odatav4.services.CashSecurityDepositService;

import io.vavr.control.Option;
import lombok.AccessLevel;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.Getter;
import lombok.NoArgsConstructor;
import lombok.Setter;
import lombok.ToString;

/**
 * Document Flow
 * <p>
 * </p>
 * <p>
 * Original entity name from the Odata EDM: <b>CAScrtyDepDocumentFlowType</b>
 * </p>
 * 
 */
@Builder
@Data
@NoArgsConstructor
@AllArgsConstructor
@ToString( doNotUseGetters = true, callSuper = true )
@EqualsAndHashCode( doNotUseGetters = true, callSuper = true )
@JsonAdapter( com.sap.cloud.sdk.datamodel.odatav4.adapter.GsonVdmAdapterFactory.class )
@JsonSerialize( using = com.sap.cloud.sdk.datamodel.odatav4.adapter.JacksonVdmObjectSerializer.class )
@JsonDeserialize( using = com.sap.cloud.sdk.datamodel.odatav4.adapter.JacksonVdmObjectDeserializer.class )
public class CAScrtyDepDocumentFlow extends VdmEntity<CAScrtyDepDocumentFlow> implements VdmEntitySet
{

    @Getter
    private final java.lang.String odataType =
        "com.sap.gateway.srvd_a2x.api_casecuritydeposit.v0001.CAScrtyDepDocumentFlowType";
    /**
     * Selector for all available fields of CAScrtyDepDocumentFlow.
     * 
     */
    public final static SimpleProperty<CAScrtyDepDocumentFlow> ALL_FIELDS = all();
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 12
     * <p>
     * Original property name from the Odata EDM: <b>CASecurityDeposit</b>
     * </p>
     * 
     * @return Security Deposit
     */
    @Nullable
    @ElementName( "CASecurityDeposit" )
    private java.lang.String cASecurityDeposit;
    public final static SimpleProperty.String<CAScrtyDepDocumentFlow> CA_SECURITY_DEPOSIT =
        new SimpleProperty.String<CAScrtyDepDocumentFlow>(CAScrtyDepDocumentFlow.class, "CASecurityDeposit");
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 12
     * <p>
     * Original property name from the Odata EDM: <b>CADocumentNumber</b>
     * </p>
     * 
     * @return The cADocumentNumber contained in this {@link VdmEntity}.
     */
    @Nullable
    @ElementName( "CADocumentNumber" )
    private java.lang.String cADocumentNumber;
    public final static SimpleProperty.String<CAScrtyDepDocumentFlow> CA_DOCUMENT_NUMBER =
        new SimpleProperty.String<CAScrtyDepDocumentFlow>(CAScrtyDepDocumentFlow.class, "CADocumentNumber");
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 12
     * <p>
     * Original property name from the Odata EDM: <b>CAScrtyDepositClearedDocument</b>
     * </p>
     * 
     * @return Number of Cleared Document
     */
    @Nullable
    @ElementName( "CAScrtyDepositClearedDocument" )
    private java.lang.String cAScrtyDepositClearedDocument;
    public final static SimpleProperty.String<CAScrtyDepDocumentFlow> CA_SCRTY_DEPOSIT_CLEARED_DOCUMENT =
        new SimpleProperty.String<CAScrtyDepDocumentFlow>(
            CAScrtyDepDocumentFlow.class,
            "CAScrtyDepositClearedDocument");
    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>CAAuthorizationGroup</b>
     * </p>
     * 
     * @return Authorization Group
     */
    @Nullable
    @ElementName( "CAAuthorizationGroup" )
    private java.lang.String cAAuthorizationGroup;
    public final static SimpleProperty.String<CAScrtyDepDocumentFlow> CA_AUTHORIZATION_GROUP =
        new SimpleProperty.String<CAScrtyDepDocumentFlow>(CAScrtyDepDocumentFlow.class, "CAAuthorizationGroup");
    /**
     * Constraints: Not nullable, Maximum length: 12
     * <p>
     * Original property name from the Odata EDM: <b>CASecurityDepositDocument</b>
     * </p>
     * 
     * @return The cASecurityDepositDocument contained in this {@link VdmEntity}.
     */
    @Nullable
    @ElementName( "CASecurityDepositDocument" )
    private java.lang.String cASecurityDepositDocument;
    public final static SimpleProperty.String<CAScrtyDepDocumentFlow> CA_SECURITY_DEPOSIT_DOCUMENT =
        new SimpleProperty.String<CAScrtyDepDocumentFlow>(CAScrtyDepDocumentFlow.class, "CASecurityDepositDocument");
    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>CASecurityDepositDocCategory</b>
     * </p>
     * 
     * @return Document Category of Security Deposit
     */
    @Nullable
    @ElementName( "CASecurityDepositDocCategory" )
    private java.lang.String cASecurityDepositDocCategory;
    public final static SimpleProperty.String<CAScrtyDepDocumentFlow> CA_SECURITY_DEPOSIT_DOC_CATEGORY =
        new SimpleProperty.String<CAScrtyDepDocumentFlow>(CAScrtyDepDocumentFlow.class, "CASecurityDepositDocCategory");
    /**
     * Constraints: Not nullable, Maximum length: 60
     * <p>
     * Original property name from the Odata EDM: <b>CASecurityDepositDocCatText</b>
     * </p>
     * 
     * @return Short Text for Fixed Values
     */
    @Nullable
    @ElementName( "CASecurityDepositDocCatText" )
    private java.lang.String cASecurityDepositDocCatText;
    public final static SimpleProperty.String<CAScrtyDepDocumentFlow> CA_SECURITY_DEPOSIT_DOC_CAT_TEXT =
        new SimpleProperty.String<CAScrtyDepDocumentFlow>(CAScrtyDepDocumentFlow.class, "CASecurityDepositDocCatText");
    /**
     * Constraints: Not nullable, Precision: 13, Scale: 0
     * <p>
     * Original property name from the Odata EDM: <b>CAAmountInTransactionCurrency</b>
     * </p>
     * 
     * @return The cAAmountInTransactionCurrency contained in this {@link VdmEntity}.
     */
    @Nullable
    @ElementName( "CAAmountInTransactionCurrency" )
    @DecimalDescriptor( precision = 13, scale = 0 )
    private BigDecimal cAAmountInTransactionCurrency;
    public final static SimpleProperty.NumericDecimal<CAScrtyDepDocumentFlow> CA_AMOUNT_IN_TRANSACTION_CURRENCY =
        new SimpleProperty.NumericDecimal<CAScrtyDepDocumentFlow>(
            CAScrtyDepDocumentFlow.class,
            "CAAmountInTransactionCurrency");
    /**
     * Constraints: Not nullable, Maximum length: 5
     * <p>
     * Original property name from the Odata EDM: <b>TransactionCurrency</b>
     * </p>
     * 
     * @return Transaction Currency
     */
    @Nullable
    @ElementName( "TransactionCurrency" )
    private java.lang.String transactionCurrency;
    public final static SimpleProperty.String<CAScrtyDepDocumentFlow> TRANSACTION_CURRENCY =
        new SimpleProperty.String<CAScrtyDepDocumentFlow>(CAScrtyDepDocumentFlow.class, "TransactionCurrency");
    /**
     * Constraints: Not nullable, Precision: 11, Scale: 0
     * <p>
     * Original property name from the Odata EDM: <b>CAReleasedAmtInPaymentCurrency</b>
     * </p>
     * 
     * @return The cAReleasedAmtInPaymentCurrency contained in this {@link VdmEntity}.
     */
    @Nullable
    @ElementName( "CAReleasedAmtInPaymentCurrency" )
    @DecimalDescriptor( precision = 11, scale = 0 )
    private BigDecimal cAReleasedAmtInPaymentCurrency;
    public final static SimpleProperty.NumericDecimal<CAScrtyDepDocumentFlow> CA_RELEASED_AMT_IN_PAYMENT_CURRENCY =
        new SimpleProperty.NumericDecimal<CAScrtyDepDocumentFlow>(
            CAScrtyDepDocumentFlow.class,
            "CAReleasedAmtInPaymentCurrency");
    /**
     * Constraints: Not nullable, Maximum length: 5
     * <p>
     * Original property name from the Odata EDM: <b>PaymentCurrency</b>
     * </p>
     * 
     * @return Transaction Currency
     */
    @Nullable
    @ElementName( "PaymentCurrency" )
    private java.lang.String paymentCurrency;
    public final static SimpleProperty.String<CAScrtyDepDocumentFlow> PAYMENT_CURRENCY =
        new SimpleProperty.String<CAScrtyDepDocumentFlow>(CAScrtyDepDocumentFlow.class, "PaymentCurrency");
    /**
     * Constraints: Not nullable, Maximum length: 12
     * <p>
     * Original property name from the Odata EDM: <b>CreatedByUser</b>
     * </p>
     * 
     * @return Created By
     */
    @Nullable
    @ElementName( "CreatedByUser" )
    private java.lang.String createdByUser;
    public final static SimpleProperty.String<CAScrtyDepDocumentFlow> CREATED_BY_USER =
        new SimpleProperty.String<CAScrtyDepDocumentFlow>(CAScrtyDepDocumentFlow.class, "CreatedByUser");
    /**
     * Constraints: Not nullable, Maximum length: 80
     * <p>
     * Original property name from the Odata EDM: <b>CreatedByUserDescription</b>
     * </p>
     * 
     * @return User Description
     */
    @Nullable
    @ElementName( "CreatedByUserDescription" )
    private java.lang.String createdByUserDescription;
    public final static SimpleProperty.String<CAScrtyDepDocumentFlow> CREATED_BY_USER_DESCRIPTION =
        new SimpleProperty.String<CAScrtyDepDocumentFlow>(CAScrtyDepDocumentFlow.class, "CreatedByUserDescription");
    /**
     * Constraints: Nullable
     * <p>
     * Original property name from the Odata EDM: <b>CreationDate</b>
     * </p>
     * 
     * @return Date on Which Record Was Created
     */
    @Nullable
    @ElementName( "CreationDate" )
    private LocalDate creationDate;
    public final static SimpleProperty.Date<CAScrtyDepDocumentFlow> CREATION_DATE =
        new SimpleProperty.Date<CAScrtyDepDocumentFlow>(CAScrtyDepDocumentFlow.class, "CreationDate");
    /**
     * Constraints: Not nullable
     * <p>
     * Original property name from the Odata EDM: <b>CreationTime</b>
     * </p>
     * 
     * @return Time at Which the Object Was Created
     */
    @Nullable
    @ElementName( "CreationTime" )
    private LocalTime creationTime;
    public final static SimpleProperty.Time<CAScrtyDepDocumentFlow> CREATION_TIME =
        new SimpleProperty.Time<CAScrtyDepDocumentFlow>(CAScrtyDepDocumentFlow.class, "CreationTime");
    /**
     * Navigation property <b>_CAScrtyDepRequestDetail</b> for <b>CAScrtyDepDocumentFlow</b> to single
     * <b>CASecurityDepositReqDetail</b>.
     * 
     */
    @ElementName( "_CAScrtyDepRequestDetail" )
    @Nullable
    @Getter( AccessLevel.NONE )
    @Setter( AccessLevel.NONE )
    private CASecurityDepositReqDetail to_CAScrtyDepRequestDetail;
    /**
     * Use with available request builders to apply the <b>_CAScrtyDepRequestDetail</b> navigation property to query
     * operations.
     * 
     */
    public final static com.sap.cloud.sdk.datamodel.odatav4.core.NavigationProperty.Single<CAScrtyDepDocumentFlow, CASecurityDepositReqDetail> TO__C_A_SCRTY_DEP_REQUEST_DETAIL =
        new com.sap.cloud.sdk.datamodel.odatav4.core.NavigationProperty.Single<CAScrtyDepDocumentFlow, CASecurityDepositReqDetail>(
            CAScrtyDepDocumentFlow.class,
            "_CAScrtyDepRequestDetail",
            CASecurityDepositReqDetail.class);

    /**
     * {@inheritDoc}
     * 
     */
    @Nonnull
    @Override
    public Class<CAScrtyDepDocumentFlow> getType()
    {
        return CAScrtyDepDocumentFlow.class;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 12
     * <p>
     * Original property name from the Odata EDM: <b>CASecurityDeposit</b>
     * </p>
     * 
     * @param cASecurityDeposit
     *            Security Deposit
     */
    public void setCASecurityDeposit( @Nullable final java.lang.String cASecurityDeposit )
    {
        rememberChangedField("CASecurityDeposit", this.cASecurityDeposit);
        this.cASecurityDeposit = cASecurityDeposit;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 12
     * <p>
     * Original property name from the Odata EDM: <b>CADocumentNumber</b>
     * </p>
     * 
     * @param cADocumentNumber
     *            The cADocumentNumber to set.
     */
    public void setCADocumentNumber( @Nullable final java.lang.String cADocumentNumber )
    {
        rememberChangedField("CADocumentNumber", this.cADocumentNumber);
        this.cADocumentNumber = cADocumentNumber;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 12
     * <p>
     * Original property name from the Odata EDM: <b>CAScrtyDepositClearedDocument</b>
     * </p>
     * 
     * @param cAScrtyDepositClearedDocument
     *            Number of Cleared Document
     */
    public void setCAScrtyDepositClearedDocument( @Nullable final java.lang.String cAScrtyDepositClearedDocument )
    {
        rememberChangedField("CAScrtyDepositClearedDocument", this.cAScrtyDepositClearedDocument);
        this.cAScrtyDepositClearedDocument = cAScrtyDepositClearedDocument;
    }

    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>CAAuthorizationGroup</b>
     * </p>
     * 
     * @param cAAuthorizationGroup
     *            Authorization Group
     */
    public void setCAAuthorizationGroup( @Nullable final java.lang.String cAAuthorizationGroup )
    {
        rememberChangedField("CAAuthorizationGroup", this.cAAuthorizationGroup);
        this.cAAuthorizationGroup = cAAuthorizationGroup;
    }

    /**
     * Constraints: Not nullable, Maximum length: 12
     * <p>
     * Original property name from the Odata EDM: <b>CASecurityDepositDocument</b>
     * </p>
     * 
     * @param cASecurityDepositDocument
     *            The cASecurityDepositDocument to set.
     */
    public void setCASecurityDepositDocument( @Nullable final java.lang.String cASecurityDepositDocument )
    {
        rememberChangedField("CASecurityDepositDocument", this.cASecurityDepositDocument);
        this.cASecurityDepositDocument = cASecurityDepositDocument;
    }

    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>CASecurityDepositDocCategory</b>
     * </p>
     * 
     * @param cASecurityDepositDocCategory
     *            Document Category of Security Deposit
     */
    public void setCASecurityDepositDocCategory( @Nullable final java.lang.String cASecurityDepositDocCategory )
    {
        rememberChangedField("CASecurityDepositDocCategory", this.cASecurityDepositDocCategory);
        this.cASecurityDepositDocCategory = cASecurityDepositDocCategory;
    }

    /**
     * Constraints: Not nullable, Maximum length: 60
     * <p>
     * Original property name from the Odata EDM: <b>CASecurityDepositDocCatText</b>
     * </p>
     * 
     * @param cASecurityDepositDocCatText
     *            Short Text for Fixed Values
     */
    public void setCASecurityDepositDocCatText( @Nullable final java.lang.String cASecurityDepositDocCatText )
    {
        rememberChangedField("CASecurityDepositDocCatText", this.cASecurityDepositDocCatText);
        this.cASecurityDepositDocCatText = cASecurityDepositDocCatText;
    }

    /**
     * Constraints: Not nullable, Precision: 13, Scale: 0
     * <p>
     * Original property name from the Odata EDM: <b>CAAmountInTransactionCurrency</b>
     * </p>
     * 
     * @param cAAmountInTransactionCurrency
     *            The cAAmountInTransactionCurrency to set.
     */
    public void setCAAmountInTransactionCurrency( @Nullable final BigDecimal cAAmountInTransactionCurrency )
    {
        rememberChangedField("CAAmountInTransactionCurrency", this.cAAmountInTransactionCurrency);
        this.cAAmountInTransactionCurrency = cAAmountInTransactionCurrency;
    }

    /**
     * Constraints: Not nullable, Maximum length: 5
     * <p>
     * Original property name from the Odata EDM: <b>TransactionCurrency</b>
     * </p>
     * 
     * @param transactionCurrency
     *            Transaction Currency
     */
    public void setTransactionCurrency( @Nullable final java.lang.String transactionCurrency )
    {
        rememberChangedField("TransactionCurrency", this.transactionCurrency);
        this.transactionCurrency = transactionCurrency;
    }

    /**
     * Constraints: Not nullable, Precision: 11, Scale: 0
     * <p>
     * Original property name from the Odata EDM: <b>CAReleasedAmtInPaymentCurrency</b>
     * </p>
     * 
     * @param cAReleasedAmtInPaymentCurrency
     *            The cAReleasedAmtInPaymentCurrency to set.
     */
    public void setCAReleasedAmtInPaymentCurrency( @Nullable final BigDecimal cAReleasedAmtInPaymentCurrency )
    {
        rememberChangedField("CAReleasedAmtInPaymentCurrency", this.cAReleasedAmtInPaymentCurrency);
        this.cAReleasedAmtInPaymentCurrency = cAReleasedAmtInPaymentCurrency;
    }

    /**
     * Constraints: Not nullable, Maximum length: 5
     * <p>
     * Original property name from the Odata EDM: <b>PaymentCurrency</b>
     * </p>
     * 
     * @param paymentCurrency
     *            Transaction Currency
     */
    public void setPaymentCurrency( @Nullable final java.lang.String paymentCurrency )
    {
        rememberChangedField("PaymentCurrency", this.paymentCurrency);
        this.paymentCurrency = paymentCurrency;
    }

    /**
     * Constraints: Not nullable, Maximum length: 12
     * <p>
     * Original property name from the Odata EDM: <b>CreatedByUser</b>
     * </p>
     * 
     * @param createdByUser
     *            Created By
     */
    public void setCreatedByUser( @Nullable final java.lang.String createdByUser )
    {
        rememberChangedField("CreatedByUser", this.createdByUser);
        this.createdByUser = createdByUser;
    }

    /**
     * Constraints: Not nullable, Maximum length: 80
     * <p>
     * Original property name from the Odata EDM: <b>CreatedByUserDescription</b>
     * </p>
     * 
     * @param createdByUserDescription
     *            User Description
     */
    public void setCreatedByUserDescription( @Nullable final java.lang.String createdByUserDescription )
    {
        rememberChangedField("CreatedByUserDescription", this.createdByUserDescription);
        this.createdByUserDescription = createdByUserDescription;
    }

    /**
     * Constraints: Nullable
     * <p>
     * Original property name from the Odata EDM: <b>CreationDate</b>
     * </p>
     * 
     * @param creationDate
     *            Date on Which Record Was Created
     */
    public void setCreationDate( @Nullable final LocalDate creationDate )
    {
        rememberChangedField("CreationDate", this.creationDate);
        this.creationDate = creationDate;
    }

    /**
     * Constraints: Not nullable
     * <p>
     * Original property name from the Odata EDM: <b>CreationTime</b>
     * </p>
     * 
     * @param creationTime
     *            Time at Which the Object Was Created
     */
    public void setCreationTime( @Nullable final LocalTime creationTime )
    {
        rememberChangedField("CreationTime", this.creationTime);
        this.creationTime = creationTime;
    }

    @Override
    protected java.lang.String getEntityCollection()
    {
        return "CAScrtyDepDocumentFlow";
    }

    @Nonnull
    @Override
    protected ODataEntityKey getKey()
    {
        final ODataEntityKey entityKey = super.getKey();
        entityKey.addKeyProperty("CASecurityDeposit", getCASecurityDeposit());
        entityKey.addKeyProperty("CADocumentNumber", getCADocumentNumber());
        entityKey.addKeyProperty("CAScrtyDepositClearedDocument", getCAScrtyDepositClearedDocument());
        return entityKey;
    }

    @Nonnull
    @Override
    protected Map<java.lang.String, Object> toMapOfFields()
    {
        final Map<java.lang.String, Object> values = super.toMapOfFields();
        values.put("CASecurityDeposit", getCASecurityDeposit());
        values.put("CADocumentNumber", getCADocumentNumber());
        values.put("CAScrtyDepositClearedDocument", getCAScrtyDepositClearedDocument());
        values.put("CAAuthorizationGroup", getCAAuthorizationGroup());
        values.put("CASecurityDepositDocument", getCASecurityDepositDocument());
        values.put("CASecurityDepositDocCategory", getCASecurityDepositDocCategory());
        values.put("CASecurityDepositDocCatText", getCASecurityDepositDocCatText());
        values.put("CAAmountInTransactionCurrency", getCAAmountInTransactionCurrency());
        values.put("TransactionCurrency", getTransactionCurrency());
        values.put("CAReleasedAmtInPaymentCurrency", getCAReleasedAmtInPaymentCurrency());
        values.put("PaymentCurrency", getPaymentCurrency());
        values.put("CreatedByUser", getCreatedByUser());
        values.put("CreatedByUserDescription", getCreatedByUserDescription());
        values.put("CreationDate", getCreationDate());
        values.put("CreationTime", getCreationTime());
        return values;
    }

    @Override
    protected void fromMap( final Map<java.lang.String, Object> inputValues )
    {
        final Map<java.lang.String, Object> values = Maps.newHashMap(inputValues);
        // simple properties
        {
            if( values.containsKey("CASecurityDeposit") ) {
                final Object value = values.remove("CASecurityDeposit");
                if( (value == null) || (!value.equals(getCASecurityDeposit())) ) {
                    setCASecurityDeposit(((java.lang.String) value));
                }
            }
            if( values.containsKey("CADocumentNumber") ) {
                final Object value = values.remove("CADocumentNumber");
                if( (value == null) || (!value.equals(getCADocumentNumber())) ) {
                    setCADocumentNumber(((java.lang.String) value));
                }
            }
            if( values.containsKey("CAScrtyDepositClearedDocument") ) {
                final Object value = values.remove("CAScrtyDepositClearedDocument");
                if( (value == null) || (!value.equals(getCAScrtyDepositClearedDocument())) ) {
                    setCAScrtyDepositClearedDocument(((java.lang.String) value));
                }
            }
            if( values.containsKey("CAAuthorizationGroup") ) {
                final Object value = values.remove("CAAuthorizationGroup");
                if( (value == null) || (!value.equals(getCAAuthorizationGroup())) ) {
                    setCAAuthorizationGroup(((java.lang.String) value));
                }
            }
            if( values.containsKey("CASecurityDepositDocument") ) {
                final Object value = values.remove("CASecurityDepositDocument");
                if( (value == null) || (!value.equals(getCASecurityDepositDocument())) ) {
                    setCASecurityDepositDocument(((java.lang.String) value));
                }
            }
            if( values.containsKey("CASecurityDepositDocCategory") ) {
                final Object value = values.remove("CASecurityDepositDocCategory");
                if( (value == null) || (!value.equals(getCASecurityDepositDocCategory())) ) {
                    setCASecurityDepositDocCategory(((java.lang.String) value));
                }
            }
            if( values.containsKey("CASecurityDepositDocCatText") ) {
                final Object value = values.remove("CASecurityDepositDocCatText");
                if( (value == null) || (!value.equals(getCASecurityDepositDocCatText())) ) {
                    setCASecurityDepositDocCatText(((java.lang.String) value));
                }
            }
            if( values.containsKey("CAAmountInTransactionCurrency") ) {
                final Object value = values.remove("CAAmountInTransactionCurrency");
                if( (value == null) || (!value.equals(getCAAmountInTransactionCurrency())) ) {
                    setCAAmountInTransactionCurrency(((BigDecimal) value));
                }
            }
            if( values.containsKey("TransactionCurrency") ) {
                final Object value = values.remove("TransactionCurrency");
                if( (value == null) || (!value.equals(getTransactionCurrency())) ) {
                    setTransactionCurrency(((java.lang.String) value));
                }
            }
            if( values.containsKey("CAReleasedAmtInPaymentCurrency") ) {
                final Object value = values.remove("CAReleasedAmtInPaymentCurrency");
                if( (value == null) || (!value.equals(getCAReleasedAmtInPaymentCurrency())) ) {
                    setCAReleasedAmtInPaymentCurrency(((BigDecimal) value));
                }
            }
            if( values.containsKey("PaymentCurrency") ) {
                final Object value = values.remove("PaymentCurrency");
                if( (value == null) || (!value.equals(getPaymentCurrency())) ) {
                    setPaymentCurrency(((java.lang.String) value));
                }
            }
            if( values.containsKey("CreatedByUser") ) {
                final Object value = values.remove("CreatedByUser");
                if( (value == null) || (!value.equals(getCreatedByUser())) ) {
                    setCreatedByUser(((java.lang.String) value));
                }
            }
            if( values.containsKey("CreatedByUserDescription") ) {
                final Object value = values.remove("CreatedByUserDescription");
                if( (value == null) || (!value.equals(getCreatedByUserDescription())) ) {
                    setCreatedByUserDescription(((java.lang.String) value));
                }
            }
            if( values.containsKey("CreationDate") ) {
                final Object value = values.remove("CreationDate");
                if( (value == null) || (!value.equals(getCreationDate())) ) {
                    setCreationDate(((LocalDate) value));
                }
            }
            if( values.containsKey("CreationTime") ) {
                final Object value = values.remove("CreationTime");
                if( (value == null) || (!value.equals(getCreationTime())) ) {
                    setCreationTime(((LocalTime) value));
                }
            }
        }
        // structured properties
        {
        }
        // navigation properties
        {
            if( (values).containsKey("_CAScrtyDepRequestDetail") ) {
                final Object value = (values).remove("_CAScrtyDepRequestDetail");
                if( value instanceof Map ) {
                    if( to_CAScrtyDepRequestDetail == null ) {
                        to_CAScrtyDepRequestDetail = new CASecurityDepositReqDetail();
                    }
                    @SuppressWarnings( "unchecked" )
                    final Map<java.lang.String, Object> inputMap = ((Map<java.lang.String, Object>) value);
                    to_CAScrtyDepRequestDetail.fromMap(inputMap);
                }
            }
        }
        super.fromMap(values);
    }

    @Override
    protected java.lang.String getDefaultServicePath()
    {
        return CashSecurityDepositService.DEFAULT_SERVICE_PATH;
    }

    @Nonnull
    @Override
    protected Map<java.lang.String, Object> toMapOfNavigationProperties()
    {
        final Map<java.lang.String, Object> values = super.toMapOfNavigationProperties();
        if( to_CAScrtyDepRequestDetail != null ) {
            (values).put("_CAScrtyDepRequestDetail", to_CAScrtyDepRequestDetail);
        }
        return values;
    }

    /**
     * Retrieval of associated <b>CASecurityDepositReqDetail</b> entity (one to one). This corresponds to the OData
     * navigation property <b>_CAScrtyDepRequestDetail</b>.
     * <p>
     * If the navigation property for an entity <b>CAScrtyDepDocumentFlow</b> has not been resolved yet, this method
     * will <b>not query</b> further information. Instead its <code>Option</code> result state will be
     * <code>empty</code>.
     * 
     * @return If the information for navigation property <b>_CAScrtyDepRequestDetail</b> is already loaded, the result
     *         will contain the <b>CASecurityDepositReqDetail</b> entity. If not, an <code>Option</code> with result
     *         state <code>empty</code> is returned.
     */
    @Nonnull
    public Option<CASecurityDepositReqDetail> getCAScrtyDepRequestDetailIfPresent()
    {
        return Option.of(to_CAScrtyDepRequestDetail);
    }

    /**
     * Overwrites the associated <b>CASecurityDepositReqDetail</b> entity for the loaded navigation property
     * <b>_CAScrtyDepRequestDetail</b>.
     * 
     * @param value
     *            New <b>CASecurityDepositReqDetail</b> entity.
     */
    public void setCAScrtyDepRequestDetail( final CASecurityDepositReqDetail value )
    {
        to_CAScrtyDepRequestDetail = value;
    }

    /**
     * Helper class to allow for fluent creation of CAScrtyDepDocumentFlow instances.
     * 
     */
    public final static class CAScrtyDepDocumentFlowBuilder
    {

        private CASecurityDepositReqDetail to_CAScrtyDepRequestDetail;

        private CAScrtyDepDocumentFlow.CAScrtyDepDocumentFlowBuilder to_CAScrtyDepRequestDetail(
            final CASecurityDepositReqDetail value )
        {
            to_CAScrtyDepRequestDetail = value;
            return this;
        }

        /**
         * Navigation property <b>_CAScrtyDepRequestDetail</b> for <b>CAScrtyDepDocumentFlow</b> to single
         * <b>CASecurityDepositReqDetail</b>.
         * 
         * @param value
         *            The CASecurityDepositReqDetail to build this CAScrtyDepDocumentFlow with.
         * @return This Builder to allow for a fluent interface.
         */
        @Nonnull
        public CAScrtyDepDocumentFlow.CAScrtyDepDocumentFlowBuilder caScrtyDepRequestDetail(
            final CASecurityDepositReqDetail value )
        {
            return to_CAScrtyDepRequestDetail(value);
        }

    }

}
