/*
 * Copyright (c) 2021 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odatav4.namespaces.cashsecuritydeposit;

import java.math.BigDecimal;
import java.time.LocalDate;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;

import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.gson.annotations.JsonAdapter;
import com.sap.cloud.sdk.datamodel.odata.client.request.ODataEntityKey;
import com.sap.cloud.sdk.datamodel.odatav4.core.DecimalDescriptor;
import com.sap.cloud.sdk.datamodel.odatav4.core.SimpleProperty;
import com.sap.cloud.sdk.datamodel.odatav4.core.VdmEntity;
import com.sap.cloud.sdk.datamodel.odatav4.core.VdmEntitySet;
import com.sap.cloud.sdk.result.ElementName;
import com.sap.cloud.sdk.s4hana.datamodel.odatav4.services.CashSecurityDepositService;

import io.vavr.control.Option;
import lombok.AccessLevel;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.Getter;
import lombok.NoArgsConstructor;
import lombok.Setter;
import lombok.ToString;

/**
 * Security Deposit Management
 * <p>
 * </p>
 * <p>
 * Original entity name from the Odata EDM: <b>CASecurityDepositType</b>
 * </p>
 * 
 */
@Builder
@Data
@NoArgsConstructor
@AllArgsConstructor
@ToString( doNotUseGetters = true, callSuper = true )
@EqualsAndHashCode( doNotUseGetters = true, callSuper = true )
@JsonAdapter( com.sap.cloud.sdk.datamodel.odatav4.adapter.GsonVdmAdapterFactory.class )
@JsonSerialize( using = com.sap.cloud.sdk.datamodel.odatav4.adapter.JacksonVdmObjectSerializer.class )
@JsonDeserialize( using = com.sap.cloud.sdk.datamodel.odatav4.adapter.JacksonVdmObjectDeserializer.class )
public class CASecurityDeposit extends VdmEntity<CASecurityDeposit> implements VdmEntitySet
{

    @Getter
    private final java.lang.String odataType =
        "com.sap.gateway.srvd_a2x.api_casecuritydeposit.v0001.CASecurityDepositType";
    /**
     * Selector for all available fields of CASecurityDeposit.
     * 
     */
    public final static SimpleProperty<CASecurityDeposit> ALL_FIELDS = all();
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 12
     * <p>
     * Original property name from the Odata EDM: <b>CASecurityDeposit</b>
     * </p>
     * 
     * @return Security Deposit
     */
    @Nullable
    @ElementName( "CASecurityDeposit" )
    private java.lang.String cASecurityDeposit;
    public final static SimpleProperty.String<CASecurityDeposit> CA_SECURITY_DEPOSIT =
        new SimpleProperty.String<CASecurityDeposit>(CASecurityDeposit.class, "CASecurityDeposit");
    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>CAAuthorizationGroup</b>
     * </p>
     * 
     * @return Authorization Group
     */
    @Nullable
    @ElementName( "CAAuthorizationGroup" )
    private java.lang.String cAAuthorizationGroup;
    public final static SimpleProperty.String<CASecurityDeposit> CA_AUTHORIZATION_GROUP =
        new SimpleProperty.String<CASecurityDeposit>(CASecurityDeposit.class, "CAAuthorizationGroup");
    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>CASecurityDepositRequestReason</b>
     * </p>
     * 
     * @return Reason for Requesting a Security Deposit
     */
    @Nullable
    @ElementName( "CASecurityDepositRequestReason" )
    private java.lang.String cASecurityDepositRequestReason;
    public final static SimpleProperty.String<CASecurityDeposit> CA_SECURITY_DEPOSIT_REQUEST_REASON =
        new SimpleProperty.String<CASecurityDeposit>(CASecurityDeposit.class, "CASecurityDepositRequestReason");
    /**
     * Constraints: Not nullable, Maximum length: 40
     * <p>
     * Original property name from the Odata EDM: <b>CASecurityDepositReqReasonText</b>
     * </p>
     * 
     * @return Text, Length 40
     */
    @Nullable
    @ElementName( "CASecurityDepositReqReasonText" )
    private java.lang.String cASecurityDepositReqReasonText;
    public final static SimpleProperty.String<CASecurityDeposit> CA_SECURITY_DEPOSIT_REQ_REASON_TEXT =
        new SimpleProperty.String<CASecurityDeposit>(CASecurityDeposit.class, "CASecurityDepositReqReasonText");
    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>CACashSecurityDepositStatus</b>
     * </p>
     * 
     * @return Cash security deposit status
     */
    @Nullable
    @ElementName( "CACashSecurityDepositStatus" )
    private java.lang.String cACashSecurityDepositStatus;
    public final static SimpleProperty.String<CASecurityDeposit> CA_CASH_SECURITY_DEPOSIT_STATUS =
        new SimpleProperty.String<CASecurityDeposit>(CASecurityDeposit.class, "CACashSecurityDepositStatus");
    /**
     * Constraints: Not nullable, Maximum length: 128
     * <p>
     * Original property name from the Odata EDM: <b>CACashSecurityDepositStatusTxt</b>
     * </p>
     * 
     * @return Status Text of Security Deposit
     */
    @Nullable
    @ElementName( "CACashSecurityDepositStatusTxt" )
    private java.lang.String cACashSecurityDepositStatusTxt;
    public final static SimpleProperty.String<CASecurityDeposit> CA_CASH_SECURITY_DEPOSIT_STATUS_TXT =
        new SimpleProperty.String<CASecurityDeposit>(CASecurityDeposit.class, "CACashSecurityDepositStatusTxt");
    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>BusinessPartner</b>
     * </p>
     * 
     * @return Business Partner Number
     */
    @Nullable
    @ElementName( "BusinessPartner" )
    private java.lang.String businessPartner;
    public final static SimpleProperty.String<CASecurityDeposit> BUSINESS_PARTNER =
        new SimpleProperty.String<CASecurityDeposit>(CASecurityDeposit.class, "BusinessPartner");
    /**
     * Constraints: Not nullable, Maximum length: 128
     * <p>
     * Original property name from the Odata EDM: <b>BusinessPartnerFullName</b>
     * </p>
     * 
     * @return Character String - 128 User-Defined Characters
     */
    @Nullable
    @ElementName( "BusinessPartnerFullName" )
    private java.lang.String businessPartnerFullName;
    public final static SimpleProperty.String<CASecurityDeposit> BUSINESS_PARTNER_FULL_NAME =
        new SimpleProperty.String<CASecurityDeposit>(CASecurityDeposit.class, "BusinessPartnerFullName");
    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>IsBusinessPurposeCompleted</b>
     * </p>
     * 
     * @return Business Purpose Completed Flag
     */
    @Nullable
    @ElementName( "IsBusinessPurposeCompleted" )
    private java.lang.String isBusinessPurposeCompleted;
    public final static SimpleProperty.String<CASecurityDeposit> IS_BUSINESS_PURPOSE_COMPLETED =
        new SimpleProperty.String<CASecurityDeposit>(CASecurityDeposit.class, "IsBusinessPurposeCompleted");
    /**
     * Constraints: Not nullable, Maximum length: 70
     * <p>
     * Original property name from the Odata EDM: <b>HouseNumber</b>
     * </p>
     * 
     * @return Street/House Number
     */
    @Nullable
    @ElementName( "HouseNumber" )
    private java.lang.String houseNumber;
    public final static SimpleProperty.String<CASecurityDeposit> HOUSE_NUMBER =
        new SimpleProperty.String<CASecurityDeposit>(CASecurityDeposit.class, "HouseNumber");
    /**
     * Constraints: Not nullable, Maximum length: 50
     * <p>
     * Original property name from the Odata EDM: <b>HomeTown</b>
     * </p>
     * 
     * @return Postal Code/City
     */
    @Nullable
    @ElementName( "HomeTown" )
    private java.lang.String homeTown;
    public final static SimpleProperty.String<CASecurityDeposit> HOME_TOWN =
        new SimpleProperty.String<CASecurityDeposit>(CASecurityDeposit.class, "HomeTown");
    /**
     * Constraints: Not nullable, Maximum length: 50
     * <p>
     * Original property name from the Odata EDM: <b>Country</b>
     * </p>
     * 
     * @return Country Description
     */
    @Nullable
    @ElementName( "Country" )
    private java.lang.String country;
    public final static SimpleProperty.String<CASecurityDeposit> COUNTRY =
        new SimpleProperty.String<CASecurityDeposit>(CASecurityDeposit.class, "Country");
    /**
     * Constraints: Not nullable, Maximum length: 50
     * <p>
     * Original property name from the Odata EDM: <b>CountryName</b>
     * </p>
     * 
     * @return Country Name (Max. 50 Characters)
     */
    @Nullable
    @ElementName( "CountryName" )
    private java.lang.String countryName;
    public final static SimpleProperty.String<CASecurityDeposit> COUNTRY_NAME =
        new SimpleProperty.String<CASecurityDeposit>(CASecurityDeposit.class, "CountryName");
    /**
     * Constraints: Not nullable, Maximum length: 12
     * <p>
     * Original property name from the Odata EDM: <b>ContractAccount</b>
     * </p>
     * 
     * @return Contract Account Number
     */
    @Nullable
    @ElementName( "ContractAccount" )
    private java.lang.String contractAccount;
    public final static SimpleProperty.String<CASecurityDeposit> CONTRACT_ACCOUNT =
        new SimpleProperty.String<CASecurityDeposit>(CASecurityDeposit.class, "ContractAccount");
    /**
     * Constraints: Not nullable, Maximum length: 35
     * <p>
     * Original property name from the Odata EDM: <b>ContractAccountName</b>
     * </p>
     * 
     * @return The contractAccountName contained in this {@link VdmEntity}.
     */
    @Nullable
    @ElementName( "ContractAccountName" )
    private java.lang.String contractAccountName;
    public final static SimpleProperty.String<CASecurityDeposit> CONTRACT_ACCOUNT_NAME =
        new SimpleProperty.String<CASecurityDeposit>(CASecurityDeposit.class, "ContractAccountName");
    /**
     * Constraints: Not nullable, Maximum length: 20
     * <p>
     * Original property name from the Odata EDM: <b>CAContract</b>
     * </p>
     * 
     * @return Reference Specifications from Contract
     */
    @Nullable
    @ElementName( "CAContract" )
    private java.lang.String cAContract;
    public final static SimpleProperty.String<CASecurityDeposit> CA_CONTRACT =
        new SimpleProperty.String<CASecurityDeposit>(CASecurityDeposit.class, "CAContract");
    /**
     * Constraints: Not nullable
     * <p>
     * Original property name from the Odata EDM: <b>CASecurityDepositIsReversed</b>
     * </p>
     * 
     * @return Security Deposit Reversed
     */
    @Nullable
    @ElementName( "CASecurityDepositIsReversed" )
    private java.lang.Boolean cASecurityDepositIsReversed;
    public final static SimpleProperty.Boolean<CASecurityDeposit> CA_SECURITY_DEPOSIT_IS_REVERSED =
        new SimpleProperty.Boolean<CASecurityDeposit>(CASecurityDeposit.class, "CASecurityDepositIsReversed");
    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>CASecurityDepositReversalRsn</b>
     * </p>
     * 
     * @return Reversal reason for security deposit
     */
    @Nullable
    @ElementName( "CASecurityDepositReversalRsn" )
    private java.lang.String cASecurityDepositReversalRsn;
    public final static SimpleProperty.String<CASecurityDeposit> CA_SECURITY_DEPOSIT_REVERSAL_RSN =
        new SimpleProperty.String<CASecurityDeposit>(CASecurityDeposit.class, "CASecurityDepositReversalRsn");
    /**
     * Constraints: Not nullable, Maximum length: 40
     * <p>
     * Original property name from the Odata EDM: <b>CASecurityDepositRvslRsnText</b>
     * </p>
     * 
     * @return Text, Length 40
     */
    @Nullable
    @ElementName( "CASecurityDepositRvslRsnText" )
    private java.lang.String cASecurityDepositRvslRsnText;
    public final static SimpleProperty.String<CASecurityDeposit> CA_SECURITY_DEPOSIT_RVSL_RSN_TEXT =
        new SimpleProperty.String<CASecurityDeposit>(CASecurityDeposit.class, "CASecurityDepositRvslRsnText");
    /**
     * Constraints: Not nullable, Maximum length: 35
     * <p>
     * Original property name from the Odata EDM: <b>CASecurityDepositExtReference</b>
     * </p>
     * 
     * @return External Reference Number of Security Deposit
     */
    @Nullable
    @ElementName( "CASecurityDepositExtReference" )
    private java.lang.String cASecurityDepositExtReference;
    public final static SimpleProperty.String<CASecurityDeposit> CA_SECURITY_DEPOSIT_EXT_REFERENCE =
        new SimpleProperty.String<CASecurityDeposit>(CASecurityDeposit.class, "CASecurityDepositExtReference");
    /**
     * Constraints: Nullable
     * <p>
     * Original property name from the Odata EDM: <b>CASecurityDepositStartDate</b>
     * </p>
     * 
     * @return Start date for security deposit
     */
    @Nullable
    @ElementName( "CASecurityDepositStartDate" )
    private LocalDate cASecurityDepositStartDate;
    public final static SimpleProperty.Date<CASecurityDeposit> CA_SECURITY_DEPOSIT_START_DATE =
        new SimpleProperty.Date<CASecurityDeposit>(CASecurityDeposit.class, "CASecurityDepositStartDate");
    /**
     * Constraints: Nullable
     * <p>
     * Original property name from the Odata EDM: <b>CASecurityDepositReturnDate</b>
     * </p>
     * 
     * @return Return date for security deposit
     */
    @Nullable
    @ElementName( "CASecurityDepositReturnDate" )
    private LocalDate cASecurityDepositReturnDate;
    public final static SimpleProperty.Date<CASecurityDeposit> CA_SECURITY_DEPOSIT_RETURN_DATE =
        new SimpleProperty.Date<CASecurityDeposit>(CASecurityDeposit.class, "CASecurityDepositReturnDate");
    /**
     * Constraints: Not nullable, Maximum length: 5
     * <p>
     * Original property name from the Odata EDM: <b>TransactionCurrency</b>
     * </p>
     * 
     * @return Transaction Currency
     */
    @Nullable
    @ElementName( "TransactionCurrency" )
    private java.lang.String transactionCurrency;
    public final static SimpleProperty.String<CASecurityDeposit> TRANSACTION_CURRENCY =
        new SimpleProperty.String<CASecurityDeposit>(CASecurityDeposit.class, "TransactionCurrency");
    /**
     * Constraints: Not nullable, Maximum length: 5
     * <p>
     * Original property name from the Odata EDM: <b>PaymentCurrency</b>
     * </p>
     * 
     * @return Payment Currency Key
     */
    @Nullable
    @ElementName( "PaymentCurrency" )
    private java.lang.String paymentCurrency;
    public final static SimpleProperty.String<CASecurityDeposit> PAYMENT_CURRENCY =
        new SimpleProperty.String<CASecurityDeposit>(CASecurityDeposit.class, "PaymentCurrency");
    /**
     * Constraints: Not nullable, Maximum length: 5
     * <p>
     * Original property name from the Odata EDM: <b>RefundCurrency</b>
     * </p>
     * 
     * @return Return Currency
     */
    @Nullable
    @ElementName( "RefundCurrency" )
    private java.lang.String refundCurrency;
    public final static SimpleProperty.String<CASecurityDeposit> REFUND_CURRENCY =
        new SimpleProperty.String<CASecurityDeposit>(CASecurityDeposit.class, "RefundCurrency");
    /**
     * Constraints: Not nullable, Precision: 11, Scale: 0
     * <p>
     * Original property name from the Odata EDM: <b>CASecurityDepositRequestAmount</b>
     * </p>
     * 
     * @return The cASecurityDepositRequestAmount contained in this {@link VdmEntity}.
     */
    @Nullable
    @ElementName( "CASecurityDepositRequestAmount" )
    @DecimalDescriptor( precision = 11, scale = 0 )
    private BigDecimal cASecurityDepositRequestAmount;
    public final static SimpleProperty.NumericDecimal<CASecurityDeposit> CA_SECURITY_DEPOSIT_REQUEST_AMOUNT =
        new SimpleProperty.NumericDecimal<CASecurityDeposit>(CASecurityDeposit.class, "CASecurityDepositRequestAmount");
    /**
     * Constraints: Not nullable, Precision: 11, Scale: 0
     * <p>
     * Original property name from the Odata EDM: <b>CAReleasedAmtInPaymentCurrency</b>
     * </p>
     * 
     * @return The cAReleasedAmtInPaymentCurrency contained in this {@link VdmEntity}.
     */
    @Nullable
    @ElementName( "CAReleasedAmtInPaymentCurrency" )
    @DecimalDescriptor( precision = 11, scale = 0 )
    private BigDecimal cAReleasedAmtInPaymentCurrency;
    public final static SimpleProperty.NumericDecimal<CASecurityDeposit> CA_RELEASED_AMT_IN_PAYMENT_CURRENCY =
        new SimpleProperty.NumericDecimal<CASecurityDeposit>(CASecurityDeposit.class, "CAReleasedAmtInPaymentCurrency");
    /**
     * Constraints: Not nullable, Precision: 11, Scale: 0
     * <p>
     * Original property name from the Odata EDM: <b>CAPaymentAmountInPaytCurrency</b>
     * </p>
     * 
     * @return The cAPaymentAmountInPaytCurrency contained in this {@link VdmEntity}.
     */
    @Nullable
    @ElementName( "CAPaymentAmountInPaytCurrency" )
    @DecimalDescriptor( precision = 11, scale = 0 )
    private BigDecimal cAPaymentAmountInPaytCurrency;
    public final static SimpleProperty.NumericDecimal<CASecurityDeposit> CA_PAYMENT_AMOUNT_IN_PAYT_CURRENCY =
        new SimpleProperty.NumericDecimal<CASecurityDeposit>(CASecurityDeposit.class, "CAPaymentAmountInPaytCurrency");
    /**
     * Constraints: Not nullable, Precision: 11, Scale: 0
     * <p>
     * Original property name from the Odata EDM: <b>AmountInRefundCurrency</b>
     * </p>
     * 
     * @return The amountInRefundCurrency contained in this {@link VdmEntity}.
     */
    @Nullable
    @ElementName( "AmountInRefundCurrency" )
    @DecimalDescriptor( precision = 11, scale = 0 )
    private BigDecimal amountInRefundCurrency;
    public final static SimpleProperty.NumericDecimal<CASecurityDeposit> AMOUNT_IN_REFUND_CURRENCY =
        new SimpleProperty.NumericDecimal<CASecurityDeposit>(CASecurityDeposit.class, "AmountInRefundCurrency");
    /**
     * Constraints: Not nullable, Precision: 13, Scale: 0
     * <p>
     * Original property name from the Odata EDM: <b>CAReversedAmtInTransCurrency</b>
     * </p>
     * 
     * @return The cAReversedAmtInTransCurrency contained in this {@link VdmEntity}.
     */
    @Nullable
    @ElementName( "CAReversedAmtInTransCurrency" )
    @DecimalDescriptor( precision = 13, scale = 0 )
    private BigDecimal cAReversedAmtInTransCurrency;
    public final static SimpleProperty.NumericDecimal<CASecurityDeposit> CA_REVERSED_AMT_IN_TRANS_CURRENCY =
        new SimpleProperty.NumericDecimal<CASecurityDeposit>(CASecurityDeposit.class, "CAReversedAmtInTransCurrency");
    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>CAInterestCode</b>
     * </p>
     * 
     * @return Interest Key
     */
    @Nullable
    @ElementName( "CAInterestCode" )
    private java.lang.String cAInterestCode;
    public final static SimpleProperty.String<CASecurityDeposit> CA_INTEREST_CODE =
        new SimpleProperty.String<CASecurityDeposit>(CASecurityDeposit.class, "CAInterestCode");
    /**
     * Constraints: Not nullable, Maximum length: 30
     * <p>
     * Original property name from the Odata EDM: <b>CAInterestCodeName</b>
     * </p>
     * 
     * @return Interest Key Description
     */
    @Nullable
    @ElementName( "CAInterestCodeName" )
    private java.lang.String cAInterestCodeName;
    public final static SimpleProperty.String<CASecurityDeposit> CA_INTEREST_CODE_NAME =
        new SimpleProperty.String<CASecurityDeposit>(CASecurityDeposit.class, "CAInterestCodeName");
    /**
     * Constraints: Not nullable
     * <p>
     * Original property name from the Odata EDM: <b>CASecurityDepositIsReleased</b>
     * </p>
     * 
     * @return Security Deposits Released
     */
    @Nullable
    @ElementName( "CASecurityDepositIsReleased" )
    private java.lang.Boolean cASecurityDepositIsReleased;
    public final static SimpleProperty.Boolean<CASecurityDeposit> CA_SECURITY_DEPOSIT_IS_RELEASED =
        new SimpleProperty.Boolean<CASecurityDeposit>(CASecurityDeposit.class, "CASecurityDepositIsReleased");
    /**
     * Constraints: Nullable
     * <p>
     * Original property name from the Odata EDM: <b>CreationDate</b>
     * </p>
     * 
     * @return Date on Which Record Was Created
     */
    @Nullable
    @ElementName( "CreationDate" )
    private LocalDate creationDate;
    public final static SimpleProperty.Date<CASecurityDeposit> CREATION_DATE =
        new SimpleProperty.Date<CASecurityDeposit>(CASecurityDeposit.class, "CreationDate");
    /**
     * Constraints: Not nullable, Maximum length: 12
     * <p>
     * Original property name from the Odata EDM: <b>CreatedByUser</b>
     * </p>
     * 
     * @return Name of Person Who Created Object
     */
    @Nullable
    @ElementName( "CreatedByUser" )
    private java.lang.String createdByUser;
    public final static SimpleProperty.String<CASecurityDeposit> CREATED_BY_USER =
        new SimpleProperty.String<CASecurityDeposit>(CASecurityDeposit.class, "CreatedByUser");
    /**
     * Constraints: Not nullable, Maximum length: 80
     * <p>
     * Original property name from the Odata EDM: <b>CreatedByUserDescription</b>
     * </p>
     * 
     * @return User Description
     */
    @Nullable
    @ElementName( "CreatedByUserDescription" )
    private java.lang.String createdByUserDescription;
    public final static SimpleProperty.String<CASecurityDeposit> CREATED_BY_USER_DESCRIPTION =
        new SimpleProperty.String<CASecurityDeposit>(CASecurityDeposit.class, "CreatedByUserDescription");
    /**
     * Constraints: Nullable
     * <p>
     * Original property name from the Odata EDM: <b>LastChangedDate</b>
     * </p>
     * 
     * @return Date of Last Change
     */
    @Nullable
    @ElementName( "LastChangedDate" )
    private LocalDate lastChangedDate;
    public final static SimpleProperty.Date<CASecurityDeposit> LAST_CHANGED_DATE =
        new SimpleProperty.Date<CASecurityDeposit>(CASecurityDeposit.class, "LastChangedDate");
    /**
     * Constraints: Not nullable, Maximum length: 12
     * <p>
     * Original property name from the Odata EDM: <b>LastChangedByUser</b>
     * </p>
     * 
     * @return Changed By
     */
    @Nullable
    @ElementName( "LastChangedByUser" )
    private java.lang.String lastChangedByUser;
    public final static SimpleProperty.String<CASecurityDeposit> LAST_CHANGED_BY_USER =
        new SimpleProperty.String<CASecurityDeposit>(CASecurityDeposit.class, "LastChangedByUser");
    /**
     * Constraints: Not nullable, Maximum length: 80
     * <p>
     * Original property name from the Odata EDM: <b>LastChangedByUserDescription</b>
     * </p>
     * 
     * @return User Description
     */
    @Nullable
    @ElementName( "LastChangedByUserDescription" )
    private java.lang.String lastChangedByUserDescription;
    public final static SimpleProperty.String<CASecurityDeposit> LAST_CHANGED_BY_USER_DESCRIPTION =
        new SimpleProperty.String<CASecurityDeposit>(CASecurityDeposit.class, "LastChangedByUserDescription");
    /**
     * Navigation property <b>_CAScrtyDepRequestDetail</b> for <b>CASecurityDeposit</b> to multiple
     * <b>CASecurityDepositReqDetail</b>.
     * 
     */
    @ElementName( "_CAScrtyDepRequestDetail" )
    @Getter( AccessLevel.NONE )
    @Setter( AccessLevel.NONE )
    private List<CASecurityDepositReqDetail> to_CAScrtyDepRequestDetail;
    /**
     * Use with available request builders to apply the <b>_CAScrtyDepRequestDetail</b> navigation property to query
     * operations.
     * 
     */
    public final static com.sap.cloud.sdk.datamodel.odatav4.core.NavigationProperty.Collection<CASecurityDeposit, CASecurityDepositReqDetail> TO__C_A_SCRTY_DEP_REQUEST_DETAIL =
        new com.sap.cloud.sdk.datamodel.odatav4.core.NavigationProperty.Collection<CASecurityDeposit, CASecurityDepositReqDetail>(
            CASecurityDeposit.class,
            "_CAScrtyDepRequestDetail",
            CASecurityDepositReqDetail.class);

    /**
     * {@inheritDoc}
     * 
     */
    @Nonnull
    @Override
    public Class<CASecurityDeposit> getType()
    {
        return CASecurityDeposit.class;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 12
     * <p>
     * Original property name from the Odata EDM: <b>CASecurityDeposit</b>
     * </p>
     * 
     * @param cASecurityDeposit
     *            Security Deposit
     */
    public void setCASecurityDeposit( @Nullable final java.lang.String cASecurityDeposit )
    {
        rememberChangedField("CASecurityDeposit", this.cASecurityDeposit);
        this.cASecurityDeposit = cASecurityDeposit;
    }

    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>CAAuthorizationGroup</b>
     * </p>
     * 
     * @param cAAuthorizationGroup
     *            Authorization Group
     */
    public void setCAAuthorizationGroup( @Nullable final java.lang.String cAAuthorizationGroup )
    {
        rememberChangedField("CAAuthorizationGroup", this.cAAuthorizationGroup);
        this.cAAuthorizationGroup = cAAuthorizationGroup;
    }

    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>CASecurityDepositRequestReason</b>
     * </p>
     * 
     * @param cASecurityDepositRequestReason
     *            Reason for Requesting a Security Deposit
     */
    public void setCASecurityDepositRequestReason( @Nullable final java.lang.String cASecurityDepositRequestReason )
    {
        rememberChangedField("CASecurityDepositRequestReason", this.cASecurityDepositRequestReason);
        this.cASecurityDepositRequestReason = cASecurityDepositRequestReason;
    }

    /**
     * Constraints: Not nullable, Maximum length: 40
     * <p>
     * Original property name from the Odata EDM: <b>CASecurityDepositReqReasonText</b>
     * </p>
     * 
     * @param cASecurityDepositReqReasonText
     *            Text, Length 40
     */
    public void setCASecurityDepositReqReasonText( @Nullable final java.lang.String cASecurityDepositReqReasonText )
    {
        rememberChangedField("CASecurityDepositReqReasonText", this.cASecurityDepositReqReasonText);
        this.cASecurityDepositReqReasonText = cASecurityDepositReqReasonText;
    }

    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>CACashSecurityDepositStatus</b>
     * </p>
     * 
     * @param cACashSecurityDepositStatus
     *            Cash security deposit status
     */
    public void setCACashSecurityDepositStatus( @Nullable final java.lang.String cACashSecurityDepositStatus )
    {
        rememberChangedField("CACashSecurityDepositStatus", this.cACashSecurityDepositStatus);
        this.cACashSecurityDepositStatus = cACashSecurityDepositStatus;
    }

    /**
     * Constraints: Not nullable, Maximum length: 128
     * <p>
     * Original property name from the Odata EDM: <b>CACashSecurityDepositStatusTxt</b>
     * </p>
     * 
     * @param cACashSecurityDepositStatusTxt
     *            Status Text of Security Deposit
     */
    public void setCACashSecurityDepositStatusTxt( @Nullable final java.lang.String cACashSecurityDepositStatusTxt )
    {
        rememberChangedField("CACashSecurityDepositStatusTxt", this.cACashSecurityDepositStatusTxt);
        this.cACashSecurityDepositStatusTxt = cACashSecurityDepositStatusTxt;
    }

    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>BusinessPartner</b>
     * </p>
     * 
     * @param businessPartner
     *            Business Partner Number
     */
    public void setBusinessPartner( @Nullable final java.lang.String businessPartner )
    {
        rememberChangedField("BusinessPartner", this.businessPartner);
        this.businessPartner = businessPartner;
    }

    /**
     * Constraints: Not nullable, Maximum length: 128
     * <p>
     * Original property name from the Odata EDM: <b>BusinessPartnerFullName</b>
     * </p>
     * 
     * @param businessPartnerFullName
     *            Character String - 128 User-Defined Characters
     */
    public void setBusinessPartnerFullName( @Nullable final java.lang.String businessPartnerFullName )
    {
        rememberChangedField("BusinessPartnerFullName", this.businessPartnerFullName);
        this.businessPartnerFullName = businessPartnerFullName;
    }

    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>IsBusinessPurposeCompleted</b>
     * </p>
     * 
     * @param isBusinessPurposeCompleted
     *            Business Purpose Completed Flag
     */
    public void setIsBusinessPurposeCompleted( @Nullable final java.lang.String isBusinessPurposeCompleted )
    {
        rememberChangedField("IsBusinessPurposeCompleted", this.isBusinessPurposeCompleted);
        this.isBusinessPurposeCompleted = isBusinessPurposeCompleted;
    }

    /**
     * Constraints: Not nullable, Maximum length: 70
     * <p>
     * Original property name from the Odata EDM: <b>HouseNumber</b>
     * </p>
     * 
     * @param houseNumber
     *            Street/House Number
     */
    public void setHouseNumber( @Nullable final java.lang.String houseNumber )
    {
        rememberChangedField("HouseNumber", this.houseNumber);
        this.houseNumber = houseNumber;
    }

    /**
     * Constraints: Not nullable, Maximum length: 50
     * <p>
     * Original property name from the Odata EDM: <b>HomeTown</b>
     * </p>
     * 
     * @param homeTown
     *            Postal Code/City
     */
    public void setHomeTown( @Nullable final java.lang.String homeTown )
    {
        rememberChangedField("HomeTown", this.homeTown);
        this.homeTown = homeTown;
    }

    /**
     * Constraints: Not nullable, Maximum length: 50
     * <p>
     * Original property name from the Odata EDM: <b>Country</b>
     * </p>
     * 
     * @param country
     *            Country Description
     */
    public void setCountry( @Nullable final java.lang.String country )
    {
        rememberChangedField("Country", this.country);
        this.country = country;
    }

    /**
     * Constraints: Not nullable, Maximum length: 50
     * <p>
     * Original property name from the Odata EDM: <b>CountryName</b>
     * </p>
     * 
     * @param countryName
     *            Country Name (Max. 50 Characters)
     */
    public void setCountryName( @Nullable final java.lang.String countryName )
    {
        rememberChangedField("CountryName", this.countryName);
        this.countryName = countryName;
    }

    /**
     * Constraints: Not nullable, Maximum length: 12
     * <p>
     * Original property name from the Odata EDM: <b>ContractAccount</b>
     * </p>
     * 
     * @param contractAccount
     *            Contract Account Number
     */
    public void setContractAccount( @Nullable final java.lang.String contractAccount )
    {
        rememberChangedField("ContractAccount", this.contractAccount);
        this.contractAccount = contractAccount;
    }

    /**
     * Constraints: Not nullable, Maximum length: 35
     * <p>
     * Original property name from the Odata EDM: <b>ContractAccountName</b>
     * </p>
     * 
     * @param contractAccountName
     *            The contractAccountName to set.
     */
    public void setContractAccountName( @Nullable final java.lang.String contractAccountName )
    {
        rememberChangedField("ContractAccountName", this.contractAccountName);
        this.contractAccountName = contractAccountName;
    }

    /**
     * Constraints: Not nullable, Maximum length: 20
     * <p>
     * Original property name from the Odata EDM: <b>CAContract</b>
     * </p>
     * 
     * @param cAContract
     *            Reference Specifications from Contract
     */
    public void setCAContract( @Nullable final java.lang.String cAContract )
    {
        rememberChangedField("CAContract", this.cAContract);
        this.cAContract = cAContract;
    }

    /**
     * Constraints: Not nullable
     * <p>
     * Original property name from the Odata EDM: <b>CASecurityDepositIsReversed</b>
     * </p>
     * 
     * @param cASecurityDepositIsReversed
     *            Security Deposit Reversed
     */
    public void setCASecurityDepositIsReversed( @Nullable final java.lang.Boolean cASecurityDepositIsReversed )
    {
        rememberChangedField("CASecurityDepositIsReversed", this.cASecurityDepositIsReversed);
        this.cASecurityDepositIsReversed = cASecurityDepositIsReversed;
    }

    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>CASecurityDepositReversalRsn</b>
     * </p>
     * 
     * @param cASecurityDepositReversalRsn
     *            Reversal reason for security deposit
     */
    public void setCASecurityDepositReversalRsn( @Nullable final java.lang.String cASecurityDepositReversalRsn )
    {
        rememberChangedField("CASecurityDepositReversalRsn", this.cASecurityDepositReversalRsn);
        this.cASecurityDepositReversalRsn = cASecurityDepositReversalRsn;
    }

    /**
     * Constraints: Not nullable, Maximum length: 40
     * <p>
     * Original property name from the Odata EDM: <b>CASecurityDepositRvslRsnText</b>
     * </p>
     * 
     * @param cASecurityDepositRvslRsnText
     *            Text, Length 40
     */
    public void setCASecurityDepositRvslRsnText( @Nullable final java.lang.String cASecurityDepositRvslRsnText )
    {
        rememberChangedField("CASecurityDepositRvslRsnText", this.cASecurityDepositRvslRsnText);
        this.cASecurityDepositRvslRsnText = cASecurityDepositRvslRsnText;
    }

    /**
     * Constraints: Not nullable, Maximum length: 35
     * <p>
     * Original property name from the Odata EDM: <b>CASecurityDepositExtReference</b>
     * </p>
     * 
     * @param cASecurityDepositExtReference
     *            External Reference Number of Security Deposit
     */
    public void setCASecurityDepositExtReference( @Nullable final java.lang.String cASecurityDepositExtReference )
    {
        rememberChangedField("CASecurityDepositExtReference", this.cASecurityDepositExtReference);
        this.cASecurityDepositExtReference = cASecurityDepositExtReference;
    }

    /**
     * Constraints: Nullable
     * <p>
     * Original property name from the Odata EDM: <b>CASecurityDepositStartDate</b>
     * </p>
     * 
     * @param cASecurityDepositStartDate
     *            Start date for security deposit
     */
    public void setCASecurityDepositStartDate( @Nullable final LocalDate cASecurityDepositStartDate )
    {
        rememberChangedField("CASecurityDepositStartDate", this.cASecurityDepositStartDate);
        this.cASecurityDepositStartDate = cASecurityDepositStartDate;
    }

    /**
     * Constraints: Nullable
     * <p>
     * Original property name from the Odata EDM: <b>CASecurityDepositReturnDate</b>
     * </p>
     * 
     * @param cASecurityDepositReturnDate
     *            Return date for security deposit
     */
    public void setCASecurityDepositReturnDate( @Nullable final LocalDate cASecurityDepositReturnDate )
    {
        rememberChangedField("CASecurityDepositReturnDate", this.cASecurityDepositReturnDate);
        this.cASecurityDepositReturnDate = cASecurityDepositReturnDate;
    }

    /**
     * Constraints: Not nullable, Maximum length: 5
     * <p>
     * Original property name from the Odata EDM: <b>TransactionCurrency</b>
     * </p>
     * 
     * @param transactionCurrency
     *            Transaction Currency
     */
    public void setTransactionCurrency( @Nullable final java.lang.String transactionCurrency )
    {
        rememberChangedField("TransactionCurrency", this.transactionCurrency);
        this.transactionCurrency = transactionCurrency;
    }

    /**
     * Constraints: Not nullable, Maximum length: 5
     * <p>
     * Original property name from the Odata EDM: <b>PaymentCurrency</b>
     * </p>
     * 
     * @param paymentCurrency
     *            Payment Currency Key
     */
    public void setPaymentCurrency( @Nullable final java.lang.String paymentCurrency )
    {
        rememberChangedField("PaymentCurrency", this.paymentCurrency);
        this.paymentCurrency = paymentCurrency;
    }

    /**
     * Constraints: Not nullable, Maximum length: 5
     * <p>
     * Original property name from the Odata EDM: <b>RefundCurrency</b>
     * </p>
     * 
     * @param refundCurrency
     *            Return Currency
     */
    public void setRefundCurrency( @Nullable final java.lang.String refundCurrency )
    {
        rememberChangedField("RefundCurrency", this.refundCurrency);
        this.refundCurrency = refundCurrency;
    }

    /**
     * Constraints: Not nullable, Precision: 11, Scale: 0
     * <p>
     * Original property name from the Odata EDM: <b>CASecurityDepositRequestAmount</b>
     * </p>
     * 
     * @param cASecurityDepositRequestAmount
     *            The cASecurityDepositRequestAmount to set.
     */
    public void setCASecurityDepositRequestAmount( @Nullable final BigDecimal cASecurityDepositRequestAmount )
    {
        rememberChangedField("CASecurityDepositRequestAmount", this.cASecurityDepositRequestAmount);
        this.cASecurityDepositRequestAmount = cASecurityDepositRequestAmount;
    }

    /**
     * Constraints: Not nullable, Precision: 11, Scale: 0
     * <p>
     * Original property name from the Odata EDM: <b>CAReleasedAmtInPaymentCurrency</b>
     * </p>
     * 
     * @param cAReleasedAmtInPaymentCurrency
     *            The cAReleasedAmtInPaymentCurrency to set.
     */
    public void setCAReleasedAmtInPaymentCurrency( @Nullable final BigDecimal cAReleasedAmtInPaymentCurrency )
    {
        rememberChangedField("CAReleasedAmtInPaymentCurrency", this.cAReleasedAmtInPaymentCurrency);
        this.cAReleasedAmtInPaymentCurrency = cAReleasedAmtInPaymentCurrency;
    }

    /**
     * Constraints: Not nullable, Precision: 11, Scale: 0
     * <p>
     * Original property name from the Odata EDM: <b>CAPaymentAmountInPaytCurrency</b>
     * </p>
     * 
     * @param cAPaymentAmountInPaytCurrency
     *            The cAPaymentAmountInPaytCurrency to set.
     */
    public void setCAPaymentAmountInPaytCurrency( @Nullable final BigDecimal cAPaymentAmountInPaytCurrency )
    {
        rememberChangedField("CAPaymentAmountInPaytCurrency", this.cAPaymentAmountInPaytCurrency);
        this.cAPaymentAmountInPaytCurrency = cAPaymentAmountInPaytCurrency;
    }

    /**
     * Constraints: Not nullable, Precision: 11, Scale: 0
     * <p>
     * Original property name from the Odata EDM: <b>AmountInRefundCurrency</b>
     * </p>
     * 
     * @param amountInRefundCurrency
     *            The amountInRefundCurrency to set.
     */
    public void setAmountInRefundCurrency( @Nullable final BigDecimal amountInRefundCurrency )
    {
        rememberChangedField("AmountInRefundCurrency", this.amountInRefundCurrency);
        this.amountInRefundCurrency = amountInRefundCurrency;
    }

    /**
     * Constraints: Not nullable, Precision: 13, Scale: 0
     * <p>
     * Original property name from the Odata EDM: <b>CAReversedAmtInTransCurrency</b>
     * </p>
     * 
     * @param cAReversedAmtInTransCurrency
     *            The cAReversedAmtInTransCurrency to set.
     */
    public void setCAReversedAmtInTransCurrency( @Nullable final BigDecimal cAReversedAmtInTransCurrency )
    {
        rememberChangedField("CAReversedAmtInTransCurrency", this.cAReversedAmtInTransCurrency);
        this.cAReversedAmtInTransCurrency = cAReversedAmtInTransCurrency;
    }

    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>CAInterestCode</b>
     * </p>
     * 
     * @param cAInterestCode
     *            Interest Key
     */
    public void setCAInterestCode( @Nullable final java.lang.String cAInterestCode )
    {
        rememberChangedField("CAInterestCode", this.cAInterestCode);
        this.cAInterestCode = cAInterestCode;
    }

    /**
     * Constraints: Not nullable, Maximum length: 30
     * <p>
     * Original property name from the Odata EDM: <b>CAInterestCodeName</b>
     * </p>
     * 
     * @param cAInterestCodeName
     *            Interest Key Description
     */
    public void setCAInterestCodeName( @Nullable final java.lang.String cAInterestCodeName )
    {
        rememberChangedField("CAInterestCodeName", this.cAInterestCodeName);
        this.cAInterestCodeName = cAInterestCodeName;
    }

    /**
     * Constraints: Not nullable
     * <p>
     * Original property name from the Odata EDM: <b>CASecurityDepositIsReleased</b>
     * </p>
     * 
     * @param cASecurityDepositIsReleased
     *            Security Deposits Released
     */
    public void setCASecurityDepositIsReleased( @Nullable final java.lang.Boolean cASecurityDepositIsReleased )
    {
        rememberChangedField("CASecurityDepositIsReleased", this.cASecurityDepositIsReleased);
        this.cASecurityDepositIsReleased = cASecurityDepositIsReleased;
    }

    /**
     * Constraints: Nullable
     * <p>
     * Original property name from the Odata EDM: <b>CreationDate</b>
     * </p>
     * 
     * @param creationDate
     *            Date on Which Record Was Created
     */
    public void setCreationDate( @Nullable final LocalDate creationDate )
    {
        rememberChangedField("CreationDate", this.creationDate);
        this.creationDate = creationDate;
    }

    /**
     * Constraints: Not nullable, Maximum length: 12
     * <p>
     * Original property name from the Odata EDM: <b>CreatedByUser</b>
     * </p>
     * 
     * @param createdByUser
     *            Name of Person Who Created Object
     */
    public void setCreatedByUser( @Nullable final java.lang.String createdByUser )
    {
        rememberChangedField("CreatedByUser", this.createdByUser);
        this.createdByUser = createdByUser;
    }

    /**
     * Constraints: Not nullable, Maximum length: 80
     * <p>
     * Original property name from the Odata EDM: <b>CreatedByUserDescription</b>
     * </p>
     * 
     * @param createdByUserDescription
     *            User Description
     */
    public void setCreatedByUserDescription( @Nullable final java.lang.String createdByUserDescription )
    {
        rememberChangedField("CreatedByUserDescription", this.createdByUserDescription);
        this.createdByUserDescription = createdByUserDescription;
    }

    /**
     * Constraints: Nullable
     * <p>
     * Original property name from the Odata EDM: <b>LastChangedDate</b>
     * </p>
     * 
     * @param lastChangedDate
     *            Date of Last Change
     */
    public void setLastChangedDate( @Nullable final LocalDate lastChangedDate )
    {
        rememberChangedField("LastChangedDate", this.lastChangedDate);
        this.lastChangedDate = lastChangedDate;
    }

    /**
     * Constraints: Not nullable, Maximum length: 12
     * <p>
     * Original property name from the Odata EDM: <b>LastChangedByUser</b>
     * </p>
     * 
     * @param lastChangedByUser
     *            Changed By
     */
    public void setLastChangedByUser( @Nullable final java.lang.String lastChangedByUser )
    {
        rememberChangedField("LastChangedByUser", this.lastChangedByUser);
        this.lastChangedByUser = lastChangedByUser;
    }

    /**
     * Constraints: Not nullable, Maximum length: 80
     * <p>
     * Original property name from the Odata EDM: <b>LastChangedByUserDescription</b>
     * </p>
     * 
     * @param lastChangedByUserDescription
     *            User Description
     */
    public void setLastChangedByUserDescription( @Nullable final java.lang.String lastChangedByUserDescription )
    {
        rememberChangedField("LastChangedByUserDescription", this.lastChangedByUserDescription);
        this.lastChangedByUserDescription = lastChangedByUserDescription;
    }

    @Override
    protected java.lang.String getEntityCollection()
    {
        return "CASecurityDeposit";
    }

    @Nonnull
    @Override
    protected ODataEntityKey getKey()
    {
        final ODataEntityKey entityKey = super.getKey();
        entityKey.addKeyProperty("CASecurityDeposit", getCASecurityDeposit());
        return entityKey;
    }

    @Nonnull
    @Override
    protected Map<java.lang.String, Object> toMapOfFields()
    {
        final Map<java.lang.String, Object> values = super.toMapOfFields();
        values.put("CASecurityDeposit", getCASecurityDeposit());
        values.put("CAAuthorizationGroup", getCAAuthorizationGroup());
        values.put("CASecurityDepositRequestReason", getCASecurityDepositRequestReason());
        values.put("CASecurityDepositReqReasonText", getCASecurityDepositReqReasonText());
        values.put("CACashSecurityDepositStatus", getCACashSecurityDepositStatus());
        values.put("CACashSecurityDepositStatusTxt", getCACashSecurityDepositStatusTxt());
        values.put("BusinessPartner", getBusinessPartner());
        values.put("BusinessPartnerFullName", getBusinessPartnerFullName());
        values.put("IsBusinessPurposeCompleted", getIsBusinessPurposeCompleted());
        values.put("HouseNumber", getHouseNumber());
        values.put("HomeTown", getHomeTown());
        values.put("Country", getCountry());
        values.put("CountryName", getCountryName());
        values.put("ContractAccount", getContractAccount());
        values.put("ContractAccountName", getContractAccountName());
        values.put("CAContract", getCAContract());
        values.put("CASecurityDepositIsReversed", getCASecurityDepositIsReversed());
        values.put("CASecurityDepositReversalRsn", getCASecurityDepositReversalRsn());
        values.put("CASecurityDepositRvslRsnText", getCASecurityDepositRvslRsnText());
        values.put("CASecurityDepositExtReference", getCASecurityDepositExtReference());
        values.put("CASecurityDepositStartDate", getCASecurityDepositStartDate());
        values.put("CASecurityDepositReturnDate", getCASecurityDepositReturnDate());
        values.put("TransactionCurrency", getTransactionCurrency());
        values.put("PaymentCurrency", getPaymentCurrency());
        values.put("RefundCurrency", getRefundCurrency());
        values.put("CASecurityDepositRequestAmount", getCASecurityDepositRequestAmount());
        values.put("CAReleasedAmtInPaymentCurrency", getCAReleasedAmtInPaymentCurrency());
        values.put("CAPaymentAmountInPaytCurrency", getCAPaymentAmountInPaytCurrency());
        values.put("AmountInRefundCurrency", getAmountInRefundCurrency());
        values.put("CAReversedAmtInTransCurrency", getCAReversedAmtInTransCurrency());
        values.put("CAInterestCode", getCAInterestCode());
        values.put("CAInterestCodeName", getCAInterestCodeName());
        values.put("CASecurityDepositIsReleased", getCASecurityDepositIsReleased());
        values.put("CreationDate", getCreationDate());
        values.put("CreatedByUser", getCreatedByUser());
        values.put("CreatedByUserDescription", getCreatedByUserDescription());
        values.put("LastChangedDate", getLastChangedDate());
        values.put("LastChangedByUser", getLastChangedByUser());
        values.put("LastChangedByUserDescription", getLastChangedByUserDescription());
        return values;
    }

    @Override
    protected void fromMap( final Map<java.lang.String, Object> inputValues )
    {
        final Map<java.lang.String, Object> values = Maps.newHashMap(inputValues);
        // simple properties
        {
            if( values.containsKey("CASecurityDeposit") ) {
                final Object value = values.remove("CASecurityDeposit");
                if( (value == null) || (!value.equals(getCASecurityDeposit())) ) {
                    setCASecurityDeposit(((java.lang.String) value));
                }
            }
            if( values.containsKey("CAAuthorizationGroup") ) {
                final Object value = values.remove("CAAuthorizationGroup");
                if( (value == null) || (!value.equals(getCAAuthorizationGroup())) ) {
                    setCAAuthorizationGroup(((java.lang.String) value));
                }
            }
            if( values.containsKey("CASecurityDepositRequestReason") ) {
                final Object value = values.remove("CASecurityDepositRequestReason");
                if( (value == null) || (!value.equals(getCASecurityDepositRequestReason())) ) {
                    setCASecurityDepositRequestReason(((java.lang.String) value));
                }
            }
            if( values.containsKey("CASecurityDepositReqReasonText") ) {
                final Object value = values.remove("CASecurityDepositReqReasonText");
                if( (value == null) || (!value.equals(getCASecurityDepositReqReasonText())) ) {
                    setCASecurityDepositReqReasonText(((java.lang.String) value));
                }
            }
            if( values.containsKey("CACashSecurityDepositStatus") ) {
                final Object value = values.remove("CACashSecurityDepositStatus");
                if( (value == null) || (!value.equals(getCACashSecurityDepositStatus())) ) {
                    setCACashSecurityDepositStatus(((java.lang.String) value));
                }
            }
            if( values.containsKey("CACashSecurityDepositStatusTxt") ) {
                final Object value = values.remove("CACashSecurityDepositStatusTxt");
                if( (value == null) || (!value.equals(getCACashSecurityDepositStatusTxt())) ) {
                    setCACashSecurityDepositStatusTxt(((java.lang.String) value));
                }
            }
            if( values.containsKey("BusinessPartner") ) {
                final Object value = values.remove("BusinessPartner");
                if( (value == null) || (!value.equals(getBusinessPartner())) ) {
                    setBusinessPartner(((java.lang.String) value));
                }
            }
            if( values.containsKey("BusinessPartnerFullName") ) {
                final Object value = values.remove("BusinessPartnerFullName");
                if( (value == null) || (!value.equals(getBusinessPartnerFullName())) ) {
                    setBusinessPartnerFullName(((java.lang.String) value));
                }
            }
            if( values.containsKey("IsBusinessPurposeCompleted") ) {
                final Object value = values.remove("IsBusinessPurposeCompleted");
                if( (value == null) || (!value.equals(getIsBusinessPurposeCompleted())) ) {
                    setIsBusinessPurposeCompleted(((java.lang.String) value));
                }
            }
            if( values.containsKey("HouseNumber") ) {
                final Object value = values.remove("HouseNumber");
                if( (value == null) || (!value.equals(getHouseNumber())) ) {
                    setHouseNumber(((java.lang.String) value));
                }
            }
            if( values.containsKey("HomeTown") ) {
                final Object value = values.remove("HomeTown");
                if( (value == null) || (!value.equals(getHomeTown())) ) {
                    setHomeTown(((java.lang.String) value));
                }
            }
            if( values.containsKey("Country") ) {
                final Object value = values.remove("Country");
                if( (value == null) || (!value.equals(getCountry())) ) {
                    setCountry(((java.lang.String) value));
                }
            }
            if( values.containsKey("CountryName") ) {
                final Object value = values.remove("CountryName");
                if( (value == null) || (!value.equals(getCountryName())) ) {
                    setCountryName(((java.lang.String) value));
                }
            }
            if( values.containsKey("ContractAccount") ) {
                final Object value = values.remove("ContractAccount");
                if( (value == null) || (!value.equals(getContractAccount())) ) {
                    setContractAccount(((java.lang.String) value));
                }
            }
            if( values.containsKey("ContractAccountName") ) {
                final Object value = values.remove("ContractAccountName");
                if( (value == null) || (!value.equals(getContractAccountName())) ) {
                    setContractAccountName(((java.lang.String) value));
                }
            }
            if( values.containsKey("CAContract") ) {
                final Object value = values.remove("CAContract");
                if( (value == null) || (!value.equals(getCAContract())) ) {
                    setCAContract(((java.lang.String) value));
                }
            }
            if( values.containsKey("CASecurityDepositIsReversed") ) {
                final Object value = values.remove("CASecurityDepositIsReversed");
                if( (value == null) || (!value.equals(getCASecurityDepositIsReversed())) ) {
                    setCASecurityDepositIsReversed(((java.lang.Boolean) value));
                }
            }
            if( values.containsKey("CASecurityDepositReversalRsn") ) {
                final Object value = values.remove("CASecurityDepositReversalRsn");
                if( (value == null) || (!value.equals(getCASecurityDepositReversalRsn())) ) {
                    setCASecurityDepositReversalRsn(((java.lang.String) value));
                }
            }
            if( values.containsKey("CASecurityDepositRvslRsnText") ) {
                final Object value = values.remove("CASecurityDepositRvslRsnText");
                if( (value == null) || (!value.equals(getCASecurityDepositRvslRsnText())) ) {
                    setCASecurityDepositRvslRsnText(((java.lang.String) value));
                }
            }
            if( values.containsKey("CASecurityDepositExtReference") ) {
                final Object value = values.remove("CASecurityDepositExtReference");
                if( (value == null) || (!value.equals(getCASecurityDepositExtReference())) ) {
                    setCASecurityDepositExtReference(((java.lang.String) value));
                }
            }
            if( values.containsKey("CASecurityDepositStartDate") ) {
                final Object value = values.remove("CASecurityDepositStartDate");
                if( (value == null) || (!value.equals(getCASecurityDepositStartDate())) ) {
                    setCASecurityDepositStartDate(((LocalDate) value));
                }
            }
            if( values.containsKey("CASecurityDepositReturnDate") ) {
                final Object value = values.remove("CASecurityDepositReturnDate");
                if( (value == null) || (!value.equals(getCASecurityDepositReturnDate())) ) {
                    setCASecurityDepositReturnDate(((LocalDate) value));
                }
            }
            if( values.containsKey("TransactionCurrency") ) {
                final Object value = values.remove("TransactionCurrency");
                if( (value == null) || (!value.equals(getTransactionCurrency())) ) {
                    setTransactionCurrency(((java.lang.String) value));
                }
            }
            if( values.containsKey("PaymentCurrency") ) {
                final Object value = values.remove("PaymentCurrency");
                if( (value == null) || (!value.equals(getPaymentCurrency())) ) {
                    setPaymentCurrency(((java.lang.String) value));
                }
            }
            if( values.containsKey("RefundCurrency") ) {
                final Object value = values.remove("RefundCurrency");
                if( (value == null) || (!value.equals(getRefundCurrency())) ) {
                    setRefundCurrency(((java.lang.String) value));
                }
            }
            if( values.containsKey("CASecurityDepositRequestAmount") ) {
                final Object value = values.remove("CASecurityDepositRequestAmount");
                if( (value == null) || (!value.equals(getCASecurityDepositRequestAmount())) ) {
                    setCASecurityDepositRequestAmount(((BigDecimal) value));
                }
            }
            if( values.containsKey("CAReleasedAmtInPaymentCurrency") ) {
                final Object value = values.remove("CAReleasedAmtInPaymentCurrency");
                if( (value == null) || (!value.equals(getCAReleasedAmtInPaymentCurrency())) ) {
                    setCAReleasedAmtInPaymentCurrency(((BigDecimal) value));
                }
            }
            if( values.containsKey("CAPaymentAmountInPaytCurrency") ) {
                final Object value = values.remove("CAPaymentAmountInPaytCurrency");
                if( (value == null) || (!value.equals(getCAPaymentAmountInPaytCurrency())) ) {
                    setCAPaymentAmountInPaytCurrency(((BigDecimal) value));
                }
            }
            if( values.containsKey("AmountInRefundCurrency") ) {
                final Object value = values.remove("AmountInRefundCurrency");
                if( (value == null) || (!value.equals(getAmountInRefundCurrency())) ) {
                    setAmountInRefundCurrency(((BigDecimal) value));
                }
            }
            if( values.containsKey("CAReversedAmtInTransCurrency") ) {
                final Object value = values.remove("CAReversedAmtInTransCurrency");
                if( (value == null) || (!value.equals(getCAReversedAmtInTransCurrency())) ) {
                    setCAReversedAmtInTransCurrency(((BigDecimal) value));
                }
            }
            if( values.containsKey("CAInterestCode") ) {
                final Object value = values.remove("CAInterestCode");
                if( (value == null) || (!value.equals(getCAInterestCode())) ) {
                    setCAInterestCode(((java.lang.String) value));
                }
            }
            if( values.containsKey("CAInterestCodeName") ) {
                final Object value = values.remove("CAInterestCodeName");
                if( (value == null) || (!value.equals(getCAInterestCodeName())) ) {
                    setCAInterestCodeName(((java.lang.String) value));
                }
            }
            if( values.containsKey("CASecurityDepositIsReleased") ) {
                final Object value = values.remove("CASecurityDepositIsReleased");
                if( (value == null) || (!value.equals(getCASecurityDepositIsReleased())) ) {
                    setCASecurityDepositIsReleased(((java.lang.Boolean) value));
                }
            }
            if( values.containsKey("CreationDate") ) {
                final Object value = values.remove("CreationDate");
                if( (value == null) || (!value.equals(getCreationDate())) ) {
                    setCreationDate(((LocalDate) value));
                }
            }
            if( values.containsKey("CreatedByUser") ) {
                final Object value = values.remove("CreatedByUser");
                if( (value == null) || (!value.equals(getCreatedByUser())) ) {
                    setCreatedByUser(((java.lang.String) value));
                }
            }
            if( values.containsKey("CreatedByUserDescription") ) {
                final Object value = values.remove("CreatedByUserDescription");
                if( (value == null) || (!value.equals(getCreatedByUserDescription())) ) {
                    setCreatedByUserDescription(((java.lang.String) value));
                }
            }
            if( values.containsKey("LastChangedDate") ) {
                final Object value = values.remove("LastChangedDate");
                if( (value == null) || (!value.equals(getLastChangedDate())) ) {
                    setLastChangedDate(((LocalDate) value));
                }
            }
            if( values.containsKey("LastChangedByUser") ) {
                final Object value = values.remove("LastChangedByUser");
                if( (value == null) || (!value.equals(getLastChangedByUser())) ) {
                    setLastChangedByUser(((java.lang.String) value));
                }
            }
            if( values.containsKey("LastChangedByUserDescription") ) {
                final Object value = values.remove("LastChangedByUserDescription");
                if( (value == null) || (!value.equals(getLastChangedByUserDescription())) ) {
                    setLastChangedByUserDescription(((java.lang.String) value));
                }
            }
        }
        // structured properties
        {
        }
        // navigation properties
        {
            if( (values).containsKey("_CAScrtyDepRequestDetail") ) {
                final Object value = (values).remove("_CAScrtyDepRequestDetail");
                if( value instanceof Iterable ) {
                    if( to_CAScrtyDepRequestDetail == null ) {
                        to_CAScrtyDepRequestDetail = Lists.newArrayList();
                    } else {
                        to_CAScrtyDepRequestDetail = Lists.newArrayList(to_CAScrtyDepRequestDetail);
                    }
                    int i = 0;
                    for( Object item : ((Iterable<?>) value) ) {
                        if( !(item instanceof Map) ) {
                            continue;
                        }
                        CASecurityDepositReqDetail entity;
                        if( to_CAScrtyDepRequestDetail.size() > i ) {
                            entity = to_CAScrtyDepRequestDetail.get(i);
                        } else {
                            entity = new CASecurityDepositReqDetail();
                            to_CAScrtyDepRequestDetail.add(entity);
                        }
                        i = (i + 1);
                        @SuppressWarnings( "unchecked" )
                        final Map<java.lang.String, Object> inputMap = ((Map<java.lang.String, Object>) item);
                        entity.fromMap(inputMap);
                    }
                }
            }
        }
        super.fromMap(values);
    }

    @Override
    protected java.lang.String getDefaultServicePath()
    {
        return CashSecurityDepositService.DEFAULT_SERVICE_PATH;
    }

    @Nonnull
    @Override
    protected Map<java.lang.String, Object> toMapOfNavigationProperties()
    {
        final Map<java.lang.String, Object> values = super.toMapOfNavigationProperties();
        if( to_CAScrtyDepRequestDetail != null ) {
            (values).put("_CAScrtyDepRequestDetail", to_CAScrtyDepRequestDetail);
        }
        return values;
    }

    /**
     * Retrieval of associated <b>CASecurityDepositReqDetail</b> entities (one to many). This corresponds to the OData
     * navigation property <b>_CAScrtyDepRequestDetail</b>.
     * <p>
     * If the navigation property for an entity <b>CASecurityDeposit</b> has not been resolved yet, this method will
     * <b>not query</b> further information. Instead its <code>Option</code> result state will be <code>empty</code>.
     * 
     * @return If the information for navigation property <b>_CAScrtyDepRequestDetail</b> is already loaded, the result
     *         will contain the <b>CASecurityDepositReqDetail</b> entities. If not, an <code>Option</code> with result
     *         state <code>empty</code> is returned.
     */
    @Nonnull
    public Option<List<CASecurityDepositReqDetail>> getCAScrtyDepRequestDetailIfPresent()
    {
        return Option.of(to_CAScrtyDepRequestDetail);
    }

    /**
     * Overwrites the list of associated <b>CASecurityDepositReqDetail</b> entities for the loaded navigation property
     * <b>_CAScrtyDepRequestDetail</b>.
     * <p>
     * If the navigation property <b>_CAScrtyDepRequestDetail</b> of a queried <b>CASecurityDeposit</b> is operated
     * lazily, an <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     * 
     * @param value
     *            List of <b>CASecurityDepositReqDetail</b> entities.
     */
    public void setCAScrtyDepRequestDetail( @Nonnull final List<CASecurityDepositReqDetail> value )
    {
        if( to_CAScrtyDepRequestDetail == null ) {
            to_CAScrtyDepRequestDetail = Lists.newArrayList();
        }
        to_CAScrtyDepRequestDetail.clear();
        to_CAScrtyDepRequestDetail.addAll(value);
    }

    /**
     * Adds elements to the list of associated <b>CASecurityDepositReqDetail</b> entities. This corresponds to the OData
     * navigation property <b>_CAScrtyDepRequestDetail</b>.
     * <p>
     * If the navigation property <b>_CAScrtyDepRequestDetail</b> of a queried <b>CASecurityDeposit</b> is operated
     * lazily, an <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     * 
     * @param entity
     *            Array of <b>CASecurityDepositReqDetail</b> entities.
     */
    public void addCAScrtyDepRequestDetail( CASecurityDepositReqDetail... entity )
    {
        if( to_CAScrtyDepRequestDetail == null ) {
            to_CAScrtyDepRequestDetail = Lists.newArrayList();
        }
        to_CAScrtyDepRequestDetail.addAll(Lists.newArrayList(entity));
    }

    /**
     * Action that can be applied to a collection of entities of this class.
     * </p>
     * 
     * @param cASecurityDepositStartDate
     *            Constraints: Not nullable
     *            <p>
     *            Original parameter name from the Odata EDM: <b>CASecurityDepositStartDate</b>
     *            </p>
     * @param transactionCurrency
     *            Constraints: Not nullable, Maximum length: 5
     *            <p>
     *            Original parameter name from the Odata EDM: <b>TransactionCurrency</b>
     *            </p>
     * @param cASecurityDepositReturnDate
     *            Constraints: Not nullable
     *            <p>
     *            Original parameter name from the Odata EDM: <b>CASecurityDepositReturnDate</b>
     *            </p>
     * @param cASecurityDepositRequestReason
     *            Constraints: Not nullable, Maximum length: 4
     *            <p>
     *            Original parameter name from the Odata EDM: <b>CASecurityDepositRequestReason</b>
     *            </p>
     * @param cAContract
     *            Constraints: Not nullable, Maximum length: 20
     *            <p>
     *            Original parameter name from the Odata EDM: <b>CAContract</b>
     *            </p>
     * @param cASecurityDepositRequestAmount
     *            Constraints: Not nullable, Precision: 11, Scale: 0
     *            <p>
     *            Original parameter name from the Odata EDM: <b>CASecurityDepositRequestAmount</b>
     *            </p>
     * @param cASecurityDepositExtReference
     *            Constraints: Not nullable, Maximum length: 35
     *            <p>
     *            Original parameter name from the Odata EDM: <b>CASecurityDepositExtReference</b>
     *            </p>
     * @param contractAccount
     *            Constraints: Not nullable, Maximum length: 12
     *            <p>
     *            Original parameter name from the Odata EDM: <b>ContractAccount</b>
     *            </p>
     * @param cAInterestCode
     *            Constraints: Not nullable, Maximum length: 2
     *            <p>
     *            Original parameter name from the Odata EDM: <b>CAInterestCode</b>
     *            </p>
     * @return Action object prepared with the given parameters to be applied to a collection of entities of this class.
     *         </p>
     *         To execute it use the {@code service.forEntity(entity).applyAction(thisAction)} API.
     */
    @Nonnull
    public static
        com.sap.cloud.sdk.datamodel.odatav4.core.BoundAction.CollectionToSingle<CASecurityDeposit, D_CAScrtyDepCreateResult>
        create(
            @Nonnull final java.lang.String contractAccount,
            @Nonnull final java.lang.String cAContract,
            @Nonnull final LocalDate cASecurityDepositStartDate,
            @Nonnull final LocalDate cASecurityDepositReturnDate,
            @Nonnull final java.lang.String transactionCurrency,
            @Nonnull final BigDecimal cASecurityDepositRequestAmount,
            @Nonnull final java.lang.String cASecurityDepositRequestReason,
            @Nonnull final java.lang.String cASecurityDepositExtReference,
            @Nonnull final java.lang.String cAInterestCode )
    {
        final Map<java.lang.String, Object> parameters = new HashMap<java.lang.String, Object>();
        parameters.put("ContractAccount", contractAccount);
        parameters.put("CAContract", cAContract);
        parameters.put("CASecurityDepositStartDate", cASecurityDepositStartDate);
        parameters.put("CASecurityDepositReturnDate", cASecurityDepositReturnDate);
        parameters.put("TransactionCurrency", transactionCurrency);
        parameters.put("CASecurityDepositRequestAmount", cASecurityDepositRequestAmount);
        parameters.put("CASecurityDepositRequestReason", cASecurityDepositRequestReason);
        parameters.put("CASecurityDepositExtReference", cASecurityDepositExtReference);
        parameters.put("CAInterestCode", cAInterestCode);
        return new com.sap.cloud.sdk.datamodel.odatav4.core.BoundAction.CollectionToSingle<CASecurityDeposit, D_CAScrtyDepCreateResult>(
            CASecurityDeposit.class,
            D_CAScrtyDepCreateResult.class,
            "com.sap.gateway.srvd_a2x.api_casecuritydeposit.v0001.Create",
            parameters);
    }

    /**
     * Action that can be applied to any entity object of this class.
     * </p>
     * 
     * @param cASecurityDepositReversalRsn
     *            Constraints: Not nullable, Maximum length: 4
     *            <p>
     *            Original parameter name from the Odata EDM: <b>CASecurityDepositReversalRsn</b>
     *            </p>
     * @return Action object prepared with the given parameters to be applied to any entity object of this class.
     *         </p>
     *         To execute it use the {@code service.forEntity(entity).applyAction(thisAction)} API.
     */
    @Nonnull
    public static
        com.sap.cloud.sdk.datamodel.odatav4.core.BoundAction.SingleToSingle<CASecurityDeposit, D_CAScrtyDepReverseResult>
        reverse( @Nonnull final java.lang.String cASecurityDepositReversalRsn )
    {
        final Map<java.lang.String, Object> parameters = new HashMap<java.lang.String, Object>();
        parameters.put("CASecurityDepositReversalRsn", cASecurityDepositReversalRsn);
        return new com.sap.cloud.sdk.datamodel.odatav4.core.BoundAction.SingleToSingle<CASecurityDeposit, D_CAScrtyDepReverseResult>(
            CASecurityDeposit.class,
            D_CAScrtyDepReverseResult.class,
            "com.sap.gateway.srvd_a2x.api_casecuritydeposit.v0001.Reverse",
            parameters);
    }

    /**
     * Action that can be applied to any entity object of this class.
     * </p>
     * 
     * @return Action object prepared with the given parameters to be applied to any entity object of this class.
     *         </p>
     *         To execute it use the {@code service.forEntity(entity).applyAction(thisAction)} API.
     */
    @Nonnull
    public static
        com.sap.cloud.sdk.datamodel.odatav4.core.BoundAction.SingleToSingle<CASecurityDeposit, D_CAScrtyDepClearResult>
        clear()
    {
        final Map<java.lang.String, Object> parameters = Collections.emptyMap();
        return new com.sap.cloud.sdk.datamodel.odatav4.core.BoundAction.SingleToSingle<CASecurityDeposit, D_CAScrtyDepClearResult>(
            CASecurityDeposit.class,
            D_CAScrtyDepClearResult.class,
            "com.sap.gateway.srvd_a2x.api_casecuritydeposit.v0001.Clear",
            parameters);
    }

    /**
     * Action that can be applied to any entity object of this class.
     * </p>
     * 
     * @param cASecurityDepositStartDate
     *            Constraints: Not nullable
     *            <p>
     *            Original parameter name from the Odata EDM: <b>CASecurityDepositStartDate</b>
     *            </p>
     * @param cASecurityDepositReturnDate
     *            Constraints: Not nullable
     *            <p>
     *            Original parameter name from the Odata EDM: <b>CASecurityDepositReturnDate</b>
     *            </p>
     * @param cAInterestCode
     *            Constraints: Not nullable, Maximum length: 2
     *            <p>
     *            Original parameter name from the Odata EDM: <b>CAInterestCode</b>
     *            </p>
     * @return Action object prepared with the given parameters to be applied to any entity object of this class.
     *         </p>
     *         To execute it use the {@code service.forEntity(entity).applyAction(thisAction)} API.
     */
    @Nonnull
    public static
        com.sap.cloud.sdk.datamodel.odatav4.core.BoundAction.SingleToSingle<CASecurityDeposit, D_CAScrtyDepChangeResult>
        change(
            @Nonnull final LocalDate cASecurityDepositStartDate,
            @Nonnull final LocalDate cASecurityDepositReturnDate,
            @Nonnull final java.lang.String cAInterestCode )
    {
        final Map<java.lang.String, Object> parameters = new HashMap<java.lang.String, Object>();
        parameters.put("CASecurityDepositStartDate", cASecurityDepositStartDate);
        parameters.put("CASecurityDepositReturnDate", cASecurityDepositReturnDate);
        parameters.put("CAInterestCode", cAInterestCode);
        return new com.sap.cloud.sdk.datamodel.odatav4.core.BoundAction.SingleToSingle<CASecurityDeposit, D_CAScrtyDepChangeResult>(
            CASecurityDeposit.class,
            D_CAScrtyDepChangeResult.class,
            "com.sap.gateway.srvd_a2x.api_casecuritydeposit.v0001.Change",
            parameters);
    }

    /**
     * Action that can be applied to any entity object of this class.
     * </p>
     * 
     * @param transactionCurrency
     *            Constraints: Not nullable, Maximum length: 5
     *            <p>
     *            Original parameter name from the Odata EDM: <b>TransactionCurrency</b>
     *            </p>
     * @param cASecurityDepositRequestReason
     *            Constraints: Not nullable, Maximum length: 4
     *            <p>
     *            Original parameter name from the Odata EDM: <b>CASecurityDepositRequestReason</b>
     *            </p>
     * @param cAAmountInTransactionCurrency
     *            Constraints: Not nullable, Precision: 13, Scale: 0
     *            <p>
     *            Original parameter name from the Odata EDM: <b>CAAmountInTransactionCurrency</b>
     *            </p>
     * @return Action object prepared with the given parameters to be applied to any entity object of this class.
     *         </p>
     *         To execute it use the {@code service.forEntity(entity).applyAction(thisAction)} API.
     */
    @Nonnull
    public static
        com.sap.cloud.sdk.datamodel.odatav4.core.BoundAction.SingleToSingle<CASecurityDeposit, D_CAScrtyDepAddReqResult>
        createRequest(
            @Nonnull final BigDecimal cAAmountInTransactionCurrency,
            @Nonnull final java.lang.String transactionCurrency,
            @Nonnull final java.lang.String cASecurityDepositRequestReason )
    {
        final Map<java.lang.String, Object> parameters = new HashMap<java.lang.String, Object>();
        parameters.put("CAAmountInTransactionCurrency", cAAmountInTransactionCurrency);
        parameters.put("TransactionCurrency", transactionCurrency);
        parameters.put("CASecurityDepositRequestReason", cASecurityDepositRequestReason);
        return new com.sap.cloud.sdk.datamodel.odatav4.core.BoundAction.SingleToSingle<CASecurityDeposit, D_CAScrtyDepAddReqResult>(
            CASecurityDeposit.class,
            D_CAScrtyDepAddReqResult.class,
            "com.sap.gateway.srvd_a2x.api_casecuritydeposit.v0001.CreateRequest",
            parameters);
    }

    /**
     * Action that can be applied to any entity object of this class.
     * </p>
     * 
     * @return Action object prepared with the given parameters to be applied to any entity object of this class.
     *         </p>
     *         To execute it use the {@code service.forEntity(entity).applyAction(thisAction)} API.
     */
    @Nonnull
    public static
        com.sap.cloud.sdk.datamodel.odatav4.core.BoundAction.SingleToSingle<CASecurityDeposit, D_CAScrtyDepReleaseResult>
        release()
    {
        final Map<java.lang.String, Object> parameters = Collections.emptyMap();
        return new com.sap.cloud.sdk.datamodel.odatav4.core.BoundAction.SingleToSingle<CASecurityDeposit, D_CAScrtyDepReleaseResult>(
            CASecurityDeposit.class,
            D_CAScrtyDepReleaseResult.class,
            "com.sap.gateway.srvd_a2x.api_casecuritydeposit.v0001.Release",
            parameters);
    }

    /**
     * Action that can be applied to any entity object of this class.
     * </p>
     * 
     * @return Action object prepared with the given parameters to be applied to any entity object of this class.
     *         </p>
     *         To execute it use the {@code service.forEntity(entity).applyAction(thisAction)} API.
     */
    @Nonnull
    public static
        com.sap.cloud.sdk.datamodel.odatav4.core.BoundAction.SingleToSingle<CASecurityDeposit, D_CAScrtyDepResetRelResult>
        resetRelease()
    {
        final Map<java.lang.String, Object> parameters = Collections.emptyMap();
        return new com.sap.cloud.sdk.datamodel.odatav4.core.BoundAction.SingleToSingle<CASecurityDeposit, D_CAScrtyDepResetRelResult>(
            CASecurityDeposit.class,
            D_CAScrtyDepResetRelResult.class,
            "com.sap.gateway.srvd_a2x.api_casecuritydeposit.v0001.ResetRelease",
            parameters);
    }

    /**
     * Helper class to allow for fluent creation of CASecurityDeposit instances.
     * 
     */
    public final static class CASecurityDepositBuilder
    {

        private List<CASecurityDepositReqDetail> to_CAScrtyDepRequestDetail = Lists.newArrayList();

        private CASecurityDeposit.CASecurityDepositBuilder to_CAScrtyDepRequestDetail(
            final List<CASecurityDepositReqDetail> value )
        {
            to_CAScrtyDepRequestDetail.addAll(value);
            return this;
        }

        /**
         * Navigation property <b>_CAScrtyDepRequestDetail</b> for <b>CASecurityDeposit</b> to multiple
         * <b>CASecurityDepositReqDetail</b>.
         * 
         * @param value
         *            The CASecurityDepositReqDetails to build this CASecurityDeposit with.
         * @return This Builder to allow for a fluent interface.
         */
        @Nonnull
        public CASecurityDeposit.CASecurityDepositBuilder caScrtyDepRequestDetail( CASecurityDepositReqDetail... value )
        {
            return to_CAScrtyDepRequestDetail(Lists.newArrayList(value));
        }

    }

}
