/*
 * Copyright (c) 2021 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odatav4.namespaces.cashsecuritydeposit;

import java.math.BigDecimal;
import java.time.LocalDate;
import java.time.LocalTime;
import java.util.List;
import java.util.Map;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;

import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.gson.annotations.JsonAdapter;
import com.sap.cloud.sdk.datamodel.odata.client.request.ODataEntityKey;
import com.sap.cloud.sdk.datamodel.odatav4.core.DecimalDescriptor;
import com.sap.cloud.sdk.datamodel.odatav4.core.SimpleProperty;
import com.sap.cloud.sdk.datamodel.odatav4.core.VdmEntity;
import com.sap.cloud.sdk.datamodel.odatav4.core.VdmEntitySet;
import com.sap.cloud.sdk.result.ElementName;
import com.sap.cloud.sdk.s4hana.datamodel.odatav4.services.CashSecurityDepositService;

import io.vavr.control.Option;
import lombok.AccessLevel;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.Getter;
import lombok.NoArgsConstructor;
import lombok.Setter;
import lombok.ToString;

/**
 * Request Detail
 * <p>
 * </p>
 * <p>
 * Original entity name from the Odata EDM: <b>CASecurityDepositReqDetailType</b>
 * </p>
 * 
 */
@Builder
@Data
@NoArgsConstructor
@AllArgsConstructor
@ToString( doNotUseGetters = true, callSuper = true )
@EqualsAndHashCode( doNotUseGetters = true, callSuper = true )
@JsonAdapter( com.sap.cloud.sdk.datamodel.odatav4.adapter.GsonVdmAdapterFactory.class )
@JsonSerialize( using = com.sap.cloud.sdk.datamodel.odatav4.adapter.JacksonVdmObjectSerializer.class )
@JsonDeserialize( using = com.sap.cloud.sdk.datamodel.odatav4.adapter.JacksonVdmObjectDeserializer.class )
public class CASecurityDepositReqDetail extends VdmEntity<CASecurityDepositReqDetail> implements VdmEntitySet
{

    @Getter
    private final java.lang.String odataType =
        "com.sap.gateway.srvd_a2x.api_casecuritydeposit.v0001.CASecurityDepositReqDetailType";
    /**
     * Selector for all available fields of CASecurityDepositReqDetail.
     * 
     */
    public final static SimpleProperty<CASecurityDepositReqDetail> ALL_FIELDS = all();
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 12
     * <p>
     * Original property name from the Odata EDM: <b>CASecurityDeposit</b>
     * </p>
     * 
     * @return Security Deposit
     */
    @Nullable
    @ElementName( "CASecurityDeposit" )
    private java.lang.String cASecurityDeposit;
    public final static SimpleProperty.String<CASecurityDepositReqDetail> CA_SECURITY_DEPOSIT =
        new SimpleProperty.String<CASecurityDepositReqDetail>(CASecurityDepositReqDetail.class, "CASecurityDeposit");
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 12
     * <p>
     * Original property name from the Odata EDM: <b>CADocumentNumber</b>
     * </p>
     * 
     * @return The cADocumentNumber contained in this {@link VdmEntity}.
     */
    @Nullable
    @ElementName( "CADocumentNumber" )
    private java.lang.String cADocumentNumber;
    public final static SimpleProperty.String<CASecurityDepositReqDetail> CA_DOCUMENT_NUMBER =
        new SimpleProperty.String<CASecurityDepositReqDetail>(CASecurityDepositReqDetail.class, "CADocumentNumber");
    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>CAAuthorizationGroup</b>
     * </p>
     * 
     * @return Authorization Group
     */
    @Nullable
    @ElementName( "CAAuthorizationGroup" )
    private java.lang.String cAAuthorizationGroup;
    public final static SimpleProperty.String<CASecurityDepositReqDetail> CA_AUTHORIZATION_GROUP =
        new SimpleProperty.String<CASecurityDepositReqDetail>(CASecurityDepositReqDetail.class, "CAAuthorizationGroup");
    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>CASecDepDocBPItemStatus</b>
     * </p>
     * 
     * @return Payment Status of a Contract Accounting Document
     */
    @Nullable
    @ElementName( "CASecDepDocBPItemStatus" )
    private java.lang.String cASecDepDocBPItemStatus;
    public final static SimpleProperty.String<CASecurityDepositReqDetail> CA_SEC_DEP_DOC_BP_ITEM_STATUS =
        new SimpleProperty.String<CASecurityDepositReqDetail>(
            CASecurityDepositReqDetail.class,
            "CASecDepDocBPItemStatus");
    /**
     * Constraints: Not nullable, Maximum length: 60
     * <p>
     * Original property name from the Odata EDM: <b>CASecDepDocBPItemStatusText</b>
     * </p>
     * 
     * @return Short Text for Fixed Values
     */
    @Nullable
    @ElementName( "CASecDepDocBPItemStatusText" )
    private java.lang.String cASecDepDocBPItemStatusText;
    public final static SimpleProperty.String<CASecurityDepositReqDetail> CA_SEC_DEP_DOC_BP_ITEM_STATUS_TEXT =
        new SimpleProperty.String<CASecurityDepositReqDetail>(
            CASecurityDepositReqDetail.class,
            "CASecDepDocBPItemStatusText");
    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>CASecurityDepositRequestReason</b>
     * </p>
     * 
     * @return Document Request Reason
     */
    @Nullable
    @ElementName( "CASecurityDepositRequestReason" )
    private java.lang.String cASecurityDepositRequestReason;
    public final static SimpleProperty.String<CASecurityDepositReqDetail> CA_SECURITY_DEPOSIT_REQUEST_REASON =
        new SimpleProperty.String<CASecurityDepositReqDetail>(
            CASecurityDepositReqDetail.class,
            "CASecurityDepositRequestReason");
    /**
     * Constraints: Not nullable, Maximum length: 40
     * <p>
     * Original property name from the Odata EDM: <b>CASecurityDepositReqReasonText</b>
     * </p>
     * 
     * @return Text, Length 40
     */
    @Nullable
    @ElementName( "CASecurityDepositReqReasonText" )
    private java.lang.String cASecurityDepositReqReasonText;
    public final static SimpleProperty.String<CASecurityDepositReqDetail> CA_SECURITY_DEPOSIT_REQ_REASON_TEXT =
        new SimpleProperty.String<CASecurityDepositReqDetail>(
            CASecurityDepositReqDetail.class,
            "CASecurityDepositReqReasonText");
    /**
     * Constraints: Not nullable, Precision: 13, Scale: 0
     * <p>
     * Original property name from the Odata EDM: <b>CAAmountInTransactionCurrency</b>
     * </p>
     * 
     * @return The cAAmountInTransactionCurrency contained in this {@link VdmEntity}.
     */
    @Nullable
    @ElementName( "CAAmountInTransactionCurrency" )
    @DecimalDescriptor( precision = 13, scale = 0 )
    private BigDecimal cAAmountInTransactionCurrency;
    public final static SimpleProperty.NumericDecimal<CASecurityDepositReqDetail> CA_AMOUNT_IN_TRANSACTION_CURRENCY =
        new SimpleProperty.NumericDecimal<CASecurityDepositReqDetail>(
            CASecurityDepositReqDetail.class,
            "CAAmountInTransactionCurrency");
    /**
     * Constraints: Not nullable, Precision: 11, Scale: 0
     * <p>
     * Original property name from the Odata EDM: <b>AmountInRefundCurrency</b>
     * </p>
     * 
     * @return The amountInRefundCurrency contained in this {@link VdmEntity}.
     */
    @Nullable
    @ElementName( "AmountInRefundCurrency" )
    @DecimalDescriptor( precision = 11, scale = 0 )
    private BigDecimal amountInRefundCurrency;
    public final static SimpleProperty.NumericDecimal<CASecurityDepositReqDetail> AMOUNT_IN_REFUND_CURRENCY =
        new SimpleProperty.NumericDecimal<CASecurityDepositReqDetail>(
            CASecurityDepositReqDetail.class,
            "AmountInRefundCurrency");
    /**
     * Constraints: Not nullable, Precision: 11, Scale: 0
     * <p>
     * Original property name from the Odata EDM: <b>CAPaymentAmountInPaytCurrency</b>
     * </p>
     * 
     * @return The cAPaymentAmountInPaytCurrency contained in this {@link VdmEntity}.
     */
    @Nullable
    @ElementName( "CAPaymentAmountInPaytCurrency" )
    @DecimalDescriptor( precision = 11, scale = 0 )
    private BigDecimal cAPaymentAmountInPaytCurrency;
    public final static SimpleProperty.NumericDecimal<CASecurityDepositReqDetail> CA_PAYMENT_AMOUNT_IN_PAYT_CURRENCY =
        new SimpleProperty.NumericDecimal<CASecurityDepositReqDetail>(
            CASecurityDepositReqDetail.class,
            "CAPaymentAmountInPaytCurrency");
    /**
     * Constraints: Not nullable, Precision: 11, Scale: 0
     * <p>
     * Original property name from the Odata EDM: <b>CAReleasedAmtInPaymentCurrency</b>
     * </p>
     * 
     * @return The cAReleasedAmtInPaymentCurrency contained in this {@link VdmEntity}.
     */
    @Nullable
    @ElementName( "CAReleasedAmtInPaymentCurrency" )
    @DecimalDescriptor( precision = 11, scale = 0 )
    private BigDecimal cAReleasedAmtInPaymentCurrency;
    public final static SimpleProperty.NumericDecimal<CASecurityDepositReqDetail> CA_RELEASED_AMT_IN_PAYMENT_CURRENCY =
        new SimpleProperty.NumericDecimal<CASecurityDepositReqDetail>(
            CASecurityDepositReqDetail.class,
            "CAReleasedAmtInPaymentCurrency");
    /**
     * Constraints: Not nullable, Precision: 13, Scale: 0
     * <p>
     * Original property name from the Odata EDM: <b>CAReversedAmtInTransCurrency</b>
     * </p>
     * 
     * @return The cAReversedAmtInTransCurrency contained in this {@link VdmEntity}.
     */
    @Nullable
    @ElementName( "CAReversedAmtInTransCurrency" )
    @DecimalDescriptor( precision = 13, scale = 0 )
    private BigDecimal cAReversedAmtInTransCurrency;
    public final static SimpleProperty.NumericDecimal<CASecurityDepositReqDetail> CA_REVERSED_AMT_IN_TRANS_CURRENCY =
        new SimpleProperty.NumericDecimal<CASecurityDepositReqDetail>(
            CASecurityDepositReqDetail.class,
            "CAReversedAmtInTransCurrency");
    /**
     * Constraints: Not nullable, Precision: 11, Scale: 0
     * <p>
     * Original property name from the Odata EDM: <b>CAScrtyDepReqDocRequestAmount</b>
     * </p>
     * 
     * @return The cAScrtyDepReqDocRequestAmount contained in this {@link VdmEntity}.
     */
    @Nullable
    @ElementName( "CAScrtyDepReqDocRequestAmount" )
    @DecimalDescriptor( precision = 11, scale = 0 )
    private BigDecimal cAScrtyDepReqDocRequestAmount;
    public final static SimpleProperty.NumericDecimal<CASecurityDepositReqDetail> CA_SCRTY_DEP_REQ_DOC_REQUEST_AMOUNT =
        new SimpleProperty.NumericDecimal<CASecurityDepositReqDetail>(
            CASecurityDepositReqDetail.class,
            "CAScrtyDepReqDocRequestAmount");
    /**
     * Constraints: Not nullable, Maximum length: 5
     * <p>
     * Original property name from the Odata EDM: <b>TransactionCurrency</b>
     * </p>
     * 
     * @return Transaction Currency
     */
    @Nullable
    @ElementName( "TransactionCurrency" )
    private java.lang.String transactionCurrency;
    public final static SimpleProperty.String<CASecurityDepositReqDetail> TRANSACTION_CURRENCY =
        new SimpleProperty.String<CASecurityDepositReqDetail>(CASecurityDepositReqDetail.class, "TransactionCurrency");
    /**
     * Constraints: Not nullable, Maximum length: 5
     * <p>
     * Original property name from the Odata EDM: <b>PaymentCurrency</b>
     * </p>
     * 
     * @return Payment Currency Key
     */
    @Nullable
    @ElementName( "PaymentCurrency" )
    private java.lang.String paymentCurrency;
    public final static SimpleProperty.String<CASecurityDepositReqDetail> PAYMENT_CURRENCY =
        new SimpleProperty.String<CASecurityDepositReqDetail>(CASecurityDepositReqDetail.class, "PaymentCurrency");
    /**
     * Constraints: Not nullable, Maximum length: 5
     * <p>
     * Original property name from the Odata EDM: <b>RefundCurrency</b>
     * </p>
     * 
     * @return Return Currency
     */
    @Nullable
    @ElementName( "RefundCurrency" )
    private java.lang.String refundCurrency;
    public final static SimpleProperty.String<CASecurityDepositReqDetail> REFUND_CURRENCY =
        new SimpleProperty.String<CASecurityDepositReqDetail>(CASecurityDepositReqDetail.class, "RefundCurrency");
    /**
     * Constraints: Not nullable, Maximum length: 12
     * <p>
     * Original property name from the Odata EDM: <b>CreatedByUser</b>
     * </p>
     * 
     * @return Created By
     */
    @Nullable
    @ElementName( "CreatedByUser" )
    private java.lang.String createdByUser;
    public final static SimpleProperty.String<CASecurityDepositReqDetail> CREATED_BY_USER =
        new SimpleProperty.String<CASecurityDepositReqDetail>(CASecurityDepositReqDetail.class, "CreatedByUser");
    /**
     * Constraints: Not nullable, Maximum length: 80
     * <p>
     * Original property name from the Odata EDM: <b>CreatedByUserDescription</b>
     * </p>
     * 
     * @return User Description
     */
    @Nullable
    @ElementName( "CreatedByUserDescription" )
    private java.lang.String createdByUserDescription;
    public final static SimpleProperty.String<CASecurityDepositReqDetail> CREATED_BY_USER_DESCRIPTION =
        new SimpleProperty.String<CASecurityDepositReqDetail>(
            CASecurityDepositReqDetail.class,
            "CreatedByUserDescription");
    /**
     * Constraints: Nullable
     * <p>
     * Original property name from the Odata EDM: <b>CreationDate</b>
     * </p>
     * 
     * @return Date on Which Record Was Created
     */
    @Nullable
    @ElementName( "CreationDate" )
    private LocalDate creationDate;
    public final static SimpleProperty.Date<CASecurityDepositReqDetail> CREATION_DATE =
        new SimpleProperty.Date<CASecurityDepositReqDetail>(CASecurityDepositReqDetail.class, "CreationDate");
    /**
     * Constraints: Not nullable
     * <p>
     * Original property name from the Odata EDM: <b>CreationTime</b>
     * </p>
     * 
     * @return Time at Which the Object Was Created
     */
    @Nullable
    @ElementName( "CreationTime" )
    private LocalTime creationTime;
    public final static SimpleProperty.Time<CASecurityDepositReqDetail> CREATION_TIME =
        new SimpleProperty.Time<CASecurityDepositReqDetail>(CASecurityDepositReqDetail.class, "CreationTime");
    /**
     * Constraints: Nullable
     * <p>
     * Original property name from the Odata EDM: <b>CAPostingDate</b>
     * </p>
     * 
     * @return Posting Date in the Document
     */
    @Nullable
    @ElementName( "CAPostingDate" )
    private LocalDate cAPostingDate;
    public final static SimpleProperty.Date<CASecurityDepositReqDetail> CA_POSTING_DATE =
        new SimpleProperty.Date<CASecurityDepositReqDetail>(CASecurityDepositReqDetail.class, "CAPostingDate");
    /**
     * Navigation property <b>_CAScrtyDepDocumentFlow</b> for <b>CASecurityDepositReqDetail</b> to multiple
     * <b>CAScrtyDepDocumentFlow</b>.
     * 
     */
    @ElementName( "_CAScrtyDepDocumentFlow" )
    @Getter( AccessLevel.NONE )
    @Setter( AccessLevel.NONE )
    private List<CAScrtyDepDocumentFlow> to_CAScrtyDepDocumentFlow;
    /**
     * Navigation property <b>_CASecurityDeposit</b> for <b>CASecurityDepositReqDetail</b> to single
     * <b>CASecurityDeposit</b>.
     * 
     */
    @ElementName( "_CASecurityDeposit" )
    @Nullable
    @Getter( AccessLevel.NONE )
    @Setter( AccessLevel.NONE )
    private CASecurityDeposit to_CASecurityDeposit;
    /**
     * Use with available request builders to apply the <b>_CAScrtyDepDocumentFlow</b> navigation property to query
     * operations.
     * 
     */
    public final static com.sap.cloud.sdk.datamodel.odatav4.core.NavigationProperty.Collection<CASecurityDepositReqDetail, CAScrtyDepDocumentFlow> TO__C_A_SCRTY_DEP_DOCUMENT_FLOW =
        new com.sap.cloud.sdk.datamodel.odatav4.core.NavigationProperty.Collection<CASecurityDepositReqDetail, CAScrtyDepDocumentFlow>(
            CASecurityDepositReqDetail.class,
            "_CAScrtyDepDocumentFlow",
            CAScrtyDepDocumentFlow.class);
    /**
     * Use with available request builders to apply the <b>_CASecurityDeposit</b> navigation property to query
     * operations.
     * 
     */
    public final static com.sap.cloud.sdk.datamodel.odatav4.core.NavigationProperty.Single<CASecurityDepositReqDetail, CASecurityDeposit> TO__C_A_SECURITY_DEPOSIT =
        new com.sap.cloud.sdk.datamodel.odatav4.core.NavigationProperty.Single<CASecurityDepositReqDetail, CASecurityDeposit>(
            CASecurityDepositReqDetail.class,
            "_CASecurityDeposit",
            CASecurityDeposit.class);

    /**
     * {@inheritDoc}
     * 
     */
    @Nonnull
    @Override
    public Class<CASecurityDepositReqDetail> getType()
    {
        return CASecurityDepositReqDetail.class;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 12
     * <p>
     * Original property name from the Odata EDM: <b>CASecurityDeposit</b>
     * </p>
     * 
     * @param cASecurityDeposit
     *            Security Deposit
     */
    public void setCASecurityDeposit( @Nullable final java.lang.String cASecurityDeposit )
    {
        rememberChangedField("CASecurityDeposit", this.cASecurityDeposit);
        this.cASecurityDeposit = cASecurityDeposit;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 12
     * <p>
     * Original property name from the Odata EDM: <b>CADocumentNumber</b>
     * </p>
     * 
     * @param cADocumentNumber
     *            The cADocumentNumber to set.
     */
    public void setCADocumentNumber( @Nullable final java.lang.String cADocumentNumber )
    {
        rememberChangedField("CADocumentNumber", this.cADocumentNumber);
        this.cADocumentNumber = cADocumentNumber;
    }

    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>CAAuthorizationGroup</b>
     * </p>
     * 
     * @param cAAuthorizationGroup
     *            Authorization Group
     */
    public void setCAAuthorizationGroup( @Nullable final java.lang.String cAAuthorizationGroup )
    {
        rememberChangedField("CAAuthorizationGroup", this.cAAuthorizationGroup);
        this.cAAuthorizationGroup = cAAuthorizationGroup;
    }

    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>CASecDepDocBPItemStatus</b>
     * </p>
     * 
     * @param cASecDepDocBPItemStatus
     *            Payment Status of a Contract Accounting Document
     */
    public void setCASecDepDocBPItemStatus( @Nullable final java.lang.String cASecDepDocBPItemStatus )
    {
        rememberChangedField("CASecDepDocBPItemStatus", this.cASecDepDocBPItemStatus);
        this.cASecDepDocBPItemStatus = cASecDepDocBPItemStatus;
    }

    /**
     * Constraints: Not nullable, Maximum length: 60
     * <p>
     * Original property name from the Odata EDM: <b>CASecDepDocBPItemStatusText</b>
     * </p>
     * 
     * @param cASecDepDocBPItemStatusText
     *            Short Text for Fixed Values
     */
    public void setCASecDepDocBPItemStatusText( @Nullable final java.lang.String cASecDepDocBPItemStatusText )
    {
        rememberChangedField("CASecDepDocBPItemStatusText", this.cASecDepDocBPItemStatusText);
        this.cASecDepDocBPItemStatusText = cASecDepDocBPItemStatusText;
    }

    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>CASecurityDepositRequestReason</b>
     * </p>
     * 
     * @param cASecurityDepositRequestReason
     *            Document Request Reason
     */
    public void setCASecurityDepositRequestReason( @Nullable final java.lang.String cASecurityDepositRequestReason )
    {
        rememberChangedField("CASecurityDepositRequestReason", this.cASecurityDepositRequestReason);
        this.cASecurityDepositRequestReason = cASecurityDepositRequestReason;
    }

    /**
     * Constraints: Not nullable, Maximum length: 40
     * <p>
     * Original property name from the Odata EDM: <b>CASecurityDepositReqReasonText</b>
     * </p>
     * 
     * @param cASecurityDepositReqReasonText
     *            Text, Length 40
     */
    public void setCASecurityDepositReqReasonText( @Nullable final java.lang.String cASecurityDepositReqReasonText )
    {
        rememberChangedField("CASecurityDepositReqReasonText", this.cASecurityDepositReqReasonText);
        this.cASecurityDepositReqReasonText = cASecurityDepositReqReasonText;
    }

    /**
     * Constraints: Not nullable, Precision: 13, Scale: 0
     * <p>
     * Original property name from the Odata EDM: <b>CAAmountInTransactionCurrency</b>
     * </p>
     * 
     * @param cAAmountInTransactionCurrency
     *            The cAAmountInTransactionCurrency to set.
     */
    public void setCAAmountInTransactionCurrency( @Nullable final BigDecimal cAAmountInTransactionCurrency )
    {
        rememberChangedField("CAAmountInTransactionCurrency", this.cAAmountInTransactionCurrency);
        this.cAAmountInTransactionCurrency = cAAmountInTransactionCurrency;
    }

    /**
     * Constraints: Not nullable, Precision: 11, Scale: 0
     * <p>
     * Original property name from the Odata EDM: <b>AmountInRefundCurrency</b>
     * </p>
     * 
     * @param amountInRefundCurrency
     *            The amountInRefundCurrency to set.
     */
    public void setAmountInRefundCurrency( @Nullable final BigDecimal amountInRefundCurrency )
    {
        rememberChangedField("AmountInRefundCurrency", this.amountInRefundCurrency);
        this.amountInRefundCurrency = amountInRefundCurrency;
    }

    /**
     * Constraints: Not nullable, Precision: 11, Scale: 0
     * <p>
     * Original property name from the Odata EDM: <b>CAPaymentAmountInPaytCurrency</b>
     * </p>
     * 
     * @param cAPaymentAmountInPaytCurrency
     *            The cAPaymentAmountInPaytCurrency to set.
     */
    public void setCAPaymentAmountInPaytCurrency( @Nullable final BigDecimal cAPaymentAmountInPaytCurrency )
    {
        rememberChangedField("CAPaymentAmountInPaytCurrency", this.cAPaymentAmountInPaytCurrency);
        this.cAPaymentAmountInPaytCurrency = cAPaymentAmountInPaytCurrency;
    }

    /**
     * Constraints: Not nullable, Precision: 11, Scale: 0
     * <p>
     * Original property name from the Odata EDM: <b>CAReleasedAmtInPaymentCurrency</b>
     * </p>
     * 
     * @param cAReleasedAmtInPaymentCurrency
     *            The cAReleasedAmtInPaymentCurrency to set.
     */
    public void setCAReleasedAmtInPaymentCurrency( @Nullable final BigDecimal cAReleasedAmtInPaymentCurrency )
    {
        rememberChangedField("CAReleasedAmtInPaymentCurrency", this.cAReleasedAmtInPaymentCurrency);
        this.cAReleasedAmtInPaymentCurrency = cAReleasedAmtInPaymentCurrency;
    }

    /**
     * Constraints: Not nullable, Precision: 13, Scale: 0
     * <p>
     * Original property name from the Odata EDM: <b>CAReversedAmtInTransCurrency</b>
     * </p>
     * 
     * @param cAReversedAmtInTransCurrency
     *            The cAReversedAmtInTransCurrency to set.
     */
    public void setCAReversedAmtInTransCurrency( @Nullable final BigDecimal cAReversedAmtInTransCurrency )
    {
        rememberChangedField("CAReversedAmtInTransCurrency", this.cAReversedAmtInTransCurrency);
        this.cAReversedAmtInTransCurrency = cAReversedAmtInTransCurrency;
    }

    /**
     * Constraints: Not nullable, Precision: 11, Scale: 0
     * <p>
     * Original property name from the Odata EDM: <b>CAScrtyDepReqDocRequestAmount</b>
     * </p>
     * 
     * @param cAScrtyDepReqDocRequestAmount
     *            The cAScrtyDepReqDocRequestAmount to set.
     */
    public void setCAScrtyDepReqDocRequestAmount( @Nullable final BigDecimal cAScrtyDepReqDocRequestAmount )
    {
        rememberChangedField("CAScrtyDepReqDocRequestAmount", this.cAScrtyDepReqDocRequestAmount);
        this.cAScrtyDepReqDocRequestAmount = cAScrtyDepReqDocRequestAmount;
    }

    /**
     * Constraints: Not nullable, Maximum length: 5
     * <p>
     * Original property name from the Odata EDM: <b>TransactionCurrency</b>
     * </p>
     * 
     * @param transactionCurrency
     *            Transaction Currency
     */
    public void setTransactionCurrency( @Nullable final java.lang.String transactionCurrency )
    {
        rememberChangedField("TransactionCurrency", this.transactionCurrency);
        this.transactionCurrency = transactionCurrency;
    }

    /**
     * Constraints: Not nullable, Maximum length: 5
     * <p>
     * Original property name from the Odata EDM: <b>PaymentCurrency</b>
     * </p>
     * 
     * @param paymentCurrency
     *            Payment Currency Key
     */
    public void setPaymentCurrency( @Nullable final java.lang.String paymentCurrency )
    {
        rememberChangedField("PaymentCurrency", this.paymentCurrency);
        this.paymentCurrency = paymentCurrency;
    }

    /**
     * Constraints: Not nullable, Maximum length: 5
     * <p>
     * Original property name from the Odata EDM: <b>RefundCurrency</b>
     * </p>
     * 
     * @param refundCurrency
     *            Return Currency
     */
    public void setRefundCurrency( @Nullable final java.lang.String refundCurrency )
    {
        rememberChangedField("RefundCurrency", this.refundCurrency);
        this.refundCurrency = refundCurrency;
    }

    /**
     * Constraints: Not nullable, Maximum length: 12
     * <p>
     * Original property name from the Odata EDM: <b>CreatedByUser</b>
     * </p>
     * 
     * @param createdByUser
     *            Created By
     */
    public void setCreatedByUser( @Nullable final java.lang.String createdByUser )
    {
        rememberChangedField("CreatedByUser", this.createdByUser);
        this.createdByUser = createdByUser;
    }

    /**
     * Constraints: Not nullable, Maximum length: 80
     * <p>
     * Original property name from the Odata EDM: <b>CreatedByUserDescription</b>
     * </p>
     * 
     * @param createdByUserDescription
     *            User Description
     */
    public void setCreatedByUserDescription( @Nullable final java.lang.String createdByUserDescription )
    {
        rememberChangedField("CreatedByUserDescription", this.createdByUserDescription);
        this.createdByUserDescription = createdByUserDescription;
    }

    /**
     * Constraints: Nullable
     * <p>
     * Original property name from the Odata EDM: <b>CreationDate</b>
     * </p>
     * 
     * @param creationDate
     *            Date on Which Record Was Created
     */
    public void setCreationDate( @Nullable final LocalDate creationDate )
    {
        rememberChangedField("CreationDate", this.creationDate);
        this.creationDate = creationDate;
    }

    /**
     * Constraints: Not nullable
     * <p>
     * Original property name from the Odata EDM: <b>CreationTime</b>
     * </p>
     * 
     * @param creationTime
     *            Time at Which the Object Was Created
     */
    public void setCreationTime( @Nullable final LocalTime creationTime )
    {
        rememberChangedField("CreationTime", this.creationTime);
        this.creationTime = creationTime;
    }

    /**
     * Constraints: Nullable
     * <p>
     * Original property name from the Odata EDM: <b>CAPostingDate</b>
     * </p>
     * 
     * @param cAPostingDate
     *            Posting Date in the Document
     */
    public void setCAPostingDate( @Nullable final LocalDate cAPostingDate )
    {
        rememberChangedField("CAPostingDate", this.cAPostingDate);
        this.cAPostingDate = cAPostingDate;
    }

    @Override
    protected java.lang.String getEntityCollection()
    {
        return "CASecurityDepositReqDetail";
    }

    @Nonnull
    @Override
    protected ODataEntityKey getKey()
    {
        final ODataEntityKey entityKey = super.getKey();
        entityKey.addKeyProperty("CASecurityDeposit", getCASecurityDeposit());
        entityKey.addKeyProperty("CADocumentNumber", getCADocumentNumber());
        return entityKey;
    }

    @Nonnull
    @Override
    protected Map<java.lang.String, Object> toMapOfFields()
    {
        final Map<java.lang.String, Object> values = super.toMapOfFields();
        values.put("CASecurityDeposit", getCASecurityDeposit());
        values.put("CADocumentNumber", getCADocumentNumber());
        values.put("CAAuthorizationGroup", getCAAuthorizationGroup());
        values.put("CASecDepDocBPItemStatus", getCASecDepDocBPItemStatus());
        values.put("CASecDepDocBPItemStatusText", getCASecDepDocBPItemStatusText());
        values.put("CASecurityDepositRequestReason", getCASecurityDepositRequestReason());
        values.put("CASecurityDepositReqReasonText", getCASecurityDepositReqReasonText());
        values.put("CAAmountInTransactionCurrency", getCAAmountInTransactionCurrency());
        values.put("AmountInRefundCurrency", getAmountInRefundCurrency());
        values.put("CAPaymentAmountInPaytCurrency", getCAPaymentAmountInPaytCurrency());
        values.put("CAReleasedAmtInPaymentCurrency", getCAReleasedAmtInPaymentCurrency());
        values.put("CAReversedAmtInTransCurrency", getCAReversedAmtInTransCurrency());
        values.put("CAScrtyDepReqDocRequestAmount", getCAScrtyDepReqDocRequestAmount());
        values.put("TransactionCurrency", getTransactionCurrency());
        values.put("PaymentCurrency", getPaymentCurrency());
        values.put("RefundCurrency", getRefundCurrency());
        values.put("CreatedByUser", getCreatedByUser());
        values.put("CreatedByUserDescription", getCreatedByUserDescription());
        values.put("CreationDate", getCreationDate());
        values.put("CreationTime", getCreationTime());
        values.put("CAPostingDate", getCAPostingDate());
        return values;
    }

    @Override
    protected void fromMap( final Map<java.lang.String, Object> inputValues )
    {
        final Map<java.lang.String, Object> values = Maps.newHashMap(inputValues);
        // simple properties
        {
            if( values.containsKey("CASecurityDeposit") ) {
                final Object value = values.remove("CASecurityDeposit");
                if( (value == null) || (!value.equals(getCASecurityDeposit())) ) {
                    setCASecurityDeposit(((java.lang.String) value));
                }
            }
            if( values.containsKey("CADocumentNumber") ) {
                final Object value = values.remove("CADocumentNumber");
                if( (value == null) || (!value.equals(getCADocumentNumber())) ) {
                    setCADocumentNumber(((java.lang.String) value));
                }
            }
            if( values.containsKey("CAAuthorizationGroup") ) {
                final Object value = values.remove("CAAuthorizationGroup");
                if( (value == null) || (!value.equals(getCAAuthorizationGroup())) ) {
                    setCAAuthorizationGroup(((java.lang.String) value));
                }
            }
            if( values.containsKey("CASecDepDocBPItemStatus") ) {
                final Object value = values.remove("CASecDepDocBPItemStatus");
                if( (value == null) || (!value.equals(getCASecDepDocBPItemStatus())) ) {
                    setCASecDepDocBPItemStatus(((java.lang.String) value));
                }
            }
            if( values.containsKey("CASecDepDocBPItemStatusText") ) {
                final Object value = values.remove("CASecDepDocBPItemStatusText");
                if( (value == null) || (!value.equals(getCASecDepDocBPItemStatusText())) ) {
                    setCASecDepDocBPItemStatusText(((java.lang.String) value));
                }
            }
            if( values.containsKey("CASecurityDepositRequestReason") ) {
                final Object value = values.remove("CASecurityDepositRequestReason");
                if( (value == null) || (!value.equals(getCASecurityDepositRequestReason())) ) {
                    setCASecurityDepositRequestReason(((java.lang.String) value));
                }
            }
            if( values.containsKey("CASecurityDepositReqReasonText") ) {
                final Object value = values.remove("CASecurityDepositReqReasonText");
                if( (value == null) || (!value.equals(getCASecurityDepositReqReasonText())) ) {
                    setCASecurityDepositReqReasonText(((java.lang.String) value));
                }
            }
            if( values.containsKey("CAAmountInTransactionCurrency") ) {
                final Object value = values.remove("CAAmountInTransactionCurrency");
                if( (value == null) || (!value.equals(getCAAmountInTransactionCurrency())) ) {
                    setCAAmountInTransactionCurrency(((BigDecimal) value));
                }
            }
            if( values.containsKey("AmountInRefundCurrency") ) {
                final Object value = values.remove("AmountInRefundCurrency");
                if( (value == null) || (!value.equals(getAmountInRefundCurrency())) ) {
                    setAmountInRefundCurrency(((BigDecimal) value));
                }
            }
            if( values.containsKey("CAPaymentAmountInPaytCurrency") ) {
                final Object value = values.remove("CAPaymentAmountInPaytCurrency");
                if( (value == null) || (!value.equals(getCAPaymentAmountInPaytCurrency())) ) {
                    setCAPaymentAmountInPaytCurrency(((BigDecimal) value));
                }
            }
            if( values.containsKey("CAReleasedAmtInPaymentCurrency") ) {
                final Object value = values.remove("CAReleasedAmtInPaymentCurrency");
                if( (value == null) || (!value.equals(getCAReleasedAmtInPaymentCurrency())) ) {
                    setCAReleasedAmtInPaymentCurrency(((BigDecimal) value));
                }
            }
            if( values.containsKey("CAReversedAmtInTransCurrency") ) {
                final Object value = values.remove("CAReversedAmtInTransCurrency");
                if( (value == null) || (!value.equals(getCAReversedAmtInTransCurrency())) ) {
                    setCAReversedAmtInTransCurrency(((BigDecimal) value));
                }
            }
            if( values.containsKey("CAScrtyDepReqDocRequestAmount") ) {
                final Object value = values.remove("CAScrtyDepReqDocRequestAmount");
                if( (value == null) || (!value.equals(getCAScrtyDepReqDocRequestAmount())) ) {
                    setCAScrtyDepReqDocRequestAmount(((BigDecimal) value));
                }
            }
            if( values.containsKey("TransactionCurrency") ) {
                final Object value = values.remove("TransactionCurrency");
                if( (value == null) || (!value.equals(getTransactionCurrency())) ) {
                    setTransactionCurrency(((java.lang.String) value));
                }
            }
            if( values.containsKey("PaymentCurrency") ) {
                final Object value = values.remove("PaymentCurrency");
                if( (value == null) || (!value.equals(getPaymentCurrency())) ) {
                    setPaymentCurrency(((java.lang.String) value));
                }
            }
            if( values.containsKey("RefundCurrency") ) {
                final Object value = values.remove("RefundCurrency");
                if( (value == null) || (!value.equals(getRefundCurrency())) ) {
                    setRefundCurrency(((java.lang.String) value));
                }
            }
            if( values.containsKey("CreatedByUser") ) {
                final Object value = values.remove("CreatedByUser");
                if( (value == null) || (!value.equals(getCreatedByUser())) ) {
                    setCreatedByUser(((java.lang.String) value));
                }
            }
            if( values.containsKey("CreatedByUserDescription") ) {
                final Object value = values.remove("CreatedByUserDescription");
                if( (value == null) || (!value.equals(getCreatedByUserDescription())) ) {
                    setCreatedByUserDescription(((java.lang.String) value));
                }
            }
            if( values.containsKey("CreationDate") ) {
                final Object value = values.remove("CreationDate");
                if( (value == null) || (!value.equals(getCreationDate())) ) {
                    setCreationDate(((LocalDate) value));
                }
            }
            if( values.containsKey("CreationTime") ) {
                final Object value = values.remove("CreationTime");
                if( (value == null) || (!value.equals(getCreationTime())) ) {
                    setCreationTime(((LocalTime) value));
                }
            }
            if( values.containsKey("CAPostingDate") ) {
                final Object value = values.remove("CAPostingDate");
                if( (value == null) || (!value.equals(getCAPostingDate())) ) {
                    setCAPostingDate(((LocalDate) value));
                }
            }
        }
        // structured properties
        {
        }
        // navigation properties
        {
            if( (values).containsKey("_CAScrtyDepDocumentFlow") ) {
                final Object value = (values).remove("_CAScrtyDepDocumentFlow");
                if( value instanceof Iterable ) {
                    if( to_CAScrtyDepDocumentFlow == null ) {
                        to_CAScrtyDepDocumentFlow = Lists.newArrayList();
                    } else {
                        to_CAScrtyDepDocumentFlow = Lists.newArrayList(to_CAScrtyDepDocumentFlow);
                    }
                    int i = 0;
                    for( Object item : ((Iterable<?>) value) ) {
                        if( !(item instanceof Map) ) {
                            continue;
                        }
                        CAScrtyDepDocumentFlow entity;
                        if( to_CAScrtyDepDocumentFlow.size() > i ) {
                            entity = to_CAScrtyDepDocumentFlow.get(i);
                        } else {
                            entity = new CAScrtyDepDocumentFlow();
                            to_CAScrtyDepDocumentFlow.add(entity);
                        }
                        i = (i + 1);
                        @SuppressWarnings( "unchecked" )
                        final Map<java.lang.String, Object> inputMap = ((Map<java.lang.String, Object>) item);
                        entity.fromMap(inputMap);
                    }
                }
            }
            if( (values).containsKey("_CASecurityDeposit") ) {
                final Object value = (values).remove("_CASecurityDeposit");
                if( value instanceof Map ) {
                    if( to_CASecurityDeposit == null ) {
                        to_CASecurityDeposit = new CASecurityDeposit();
                    }
                    @SuppressWarnings( "unchecked" )
                    final Map<java.lang.String, Object> inputMap = ((Map<java.lang.String, Object>) value);
                    to_CASecurityDeposit.fromMap(inputMap);
                }
            }
        }
        super.fromMap(values);
    }

    @Override
    protected java.lang.String getDefaultServicePath()
    {
        return CashSecurityDepositService.DEFAULT_SERVICE_PATH;
    }

    @Nonnull
    @Override
    protected Map<java.lang.String, Object> toMapOfNavigationProperties()
    {
        final Map<java.lang.String, Object> values = super.toMapOfNavigationProperties();
        if( to_CAScrtyDepDocumentFlow != null ) {
            (values).put("_CAScrtyDepDocumentFlow", to_CAScrtyDepDocumentFlow);
        }
        if( to_CASecurityDeposit != null ) {
            (values).put("_CASecurityDeposit", to_CASecurityDeposit);
        }
        return values;
    }

    /**
     * Retrieval of associated <b>CAScrtyDepDocumentFlow</b> entities (one to many). This corresponds to the OData
     * navigation property <b>_CAScrtyDepDocumentFlow</b>.
     * <p>
     * If the navigation property for an entity <b>CASecurityDepositReqDetail</b> has not been resolved yet, this method
     * will <b>not query</b> further information. Instead its <code>Option</code> result state will be
     * <code>empty</code>.
     * 
     * @return If the information for navigation property <b>_CAScrtyDepDocumentFlow</b> is already loaded, the result
     *         will contain the <b>CAScrtyDepDocumentFlow</b> entities. If not, an <code>Option</code> with result state
     *         <code>empty</code> is returned.
     */
    @Nonnull
    public Option<List<CAScrtyDepDocumentFlow>> getCAScrtyDepDocumentFlowIfPresent()
    {
        return Option.of(to_CAScrtyDepDocumentFlow);
    }

    /**
     * Overwrites the list of associated <b>CAScrtyDepDocumentFlow</b> entities for the loaded navigation property
     * <b>_CAScrtyDepDocumentFlow</b>.
     * <p>
     * If the navigation property <b>_CAScrtyDepDocumentFlow</b> of a queried <b>CASecurityDepositReqDetail</b> is
     * operated lazily, an <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     * 
     * @param value
     *            List of <b>CAScrtyDepDocumentFlow</b> entities.
     */
    public void setCAScrtyDepDocumentFlow( @Nonnull final List<CAScrtyDepDocumentFlow> value )
    {
        if( to_CAScrtyDepDocumentFlow == null ) {
            to_CAScrtyDepDocumentFlow = Lists.newArrayList();
        }
        to_CAScrtyDepDocumentFlow.clear();
        to_CAScrtyDepDocumentFlow.addAll(value);
    }

    /**
     * Adds elements to the list of associated <b>CAScrtyDepDocumentFlow</b> entities. This corresponds to the OData
     * navigation property <b>_CAScrtyDepDocumentFlow</b>.
     * <p>
     * If the navigation property <b>_CAScrtyDepDocumentFlow</b> of a queried <b>CASecurityDepositReqDetail</b> is
     * operated lazily, an <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     * 
     * @param entity
     *            Array of <b>CAScrtyDepDocumentFlow</b> entities.
     */
    public void addCAScrtyDepDocumentFlow( CAScrtyDepDocumentFlow... entity )
    {
        if( to_CAScrtyDepDocumentFlow == null ) {
            to_CAScrtyDepDocumentFlow = Lists.newArrayList();
        }
        to_CAScrtyDepDocumentFlow.addAll(Lists.newArrayList(entity));
    }

    /**
     * Retrieval of associated <b>CASecurityDeposit</b> entity (one to one). This corresponds to the OData navigation
     * property <b>_CASecurityDeposit</b>.
     * <p>
     * If the navigation property for an entity <b>CASecurityDepositReqDetail</b> has not been resolved yet, this method
     * will <b>not query</b> further information. Instead its <code>Option</code> result state will be
     * <code>empty</code>.
     * 
     * @return If the information for navigation property <b>_CASecurityDeposit</b> is already loaded, the result will
     *         contain the <b>CASecurityDeposit</b> entity. If not, an <code>Option</code> with result state
     *         <code>empty</code> is returned.
     */
    @Nonnull
    public Option<CASecurityDeposit> getCASecurityDepositIfPresent()
    {
        return Option.of(to_CASecurityDeposit);
    }

    /**
     * Overwrites the associated <b>CASecurityDeposit</b> entity for the loaded navigation property
     * <b>_CASecurityDeposit</b>.
     * 
     * @param value
     *            New <b>CASecurityDeposit</b> entity.
     */
    public void setCASecurityDeposit( final CASecurityDeposit value )
    {
        to_CASecurityDeposit = value;
    }

    /**
     * Helper class to allow for fluent creation of CASecurityDepositReqDetail instances.
     * 
     */
    public final static class CASecurityDepositReqDetailBuilder
    {

        private List<CAScrtyDepDocumentFlow> to_CAScrtyDepDocumentFlow = Lists.newArrayList();
        private CASecurityDeposit to_CASecurityDeposit;

        private CASecurityDepositReqDetail.CASecurityDepositReqDetailBuilder to_CAScrtyDepDocumentFlow(
            final List<CAScrtyDepDocumentFlow> value )
        {
            to_CAScrtyDepDocumentFlow.addAll(value);
            return this;
        }

        /**
         * Navigation property <b>_CAScrtyDepDocumentFlow</b> for <b>CASecurityDepositReqDetail</b> to multiple
         * <b>CAScrtyDepDocumentFlow</b>.
         * 
         * @param value
         *            The CAScrtyDepDocumentFlows to build this CASecurityDepositReqDetail with.
         * @return This Builder to allow for a fluent interface.
         */
        @Nonnull
        public CASecurityDepositReqDetail.CASecurityDepositReqDetailBuilder caScrtyDepDocumentFlow(
            CAScrtyDepDocumentFlow... value )
        {
            return to_CAScrtyDepDocumentFlow(Lists.newArrayList(value));
        }

        private CASecurityDepositReqDetail.CASecurityDepositReqDetailBuilder to_CASecurityDeposit(
            final CASecurityDeposit value )
        {
            to_CASecurityDeposit = value;
            return this;
        }

        /**
         * Navigation property <b>_CASecurityDeposit</b> for <b>CASecurityDepositReqDetail</b> to single
         * <b>CASecurityDeposit</b>.
         * 
         * @param value
         *            The CASecurityDeposit to build this CASecurityDepositReqDetail with.
         * @return This Builder to allow for a fluent interface.
         */
        @Nonnull
        public CASecurityDepositReqDetail.CASecurityDepositReqDetailBuilder caSecurityDeposit(
            final CASecurityDeposit value )
        {
            return to_CASecurityDeposit(value);
        }

    }

}
