/*
 * Copyright (c) 2021 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odatav4.namespaces.cashsecuritydeposit;

import java.util.Map;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;

import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.google.common.collect.Maps;
import com.google.gson.annotations.JsonAdapter;
import com.sap.cloud.sdk.datamodel.odata.client.request.ODataEntityKey;
import com.sap.cloud.sdk.datamodel.odatav4.core.VdmComplex;
import com.sap.cloud.sdk.result.ElementName;

import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.Getter;
import lombok.NoArgsConstructor;
import lombok.ToString;

/**
 * <p>
 * Original complex type name from the Odata EDM: <b>D_CAScrtyDepAddReqResult</b>
 * </p>
 * 
 */
@Builder
@Data
@NoArgsConstructor
@AllArgsConstructor
@ToString( doNotUseGetters = true, callSuper = true )
@EqualsAndHashCode( doNotUseGetters = true, callSuper = true )
@JsonAdapter( com.sap.cloud.sdk.datamodel.odatav4.adapter.GsonVdmAdapterFactory.class )
@JsonSerialize( using = com.sap.cloud.sdk.datamodel.odatav4.adapter.JacksonVdmObjectSerializer.class )
@JsonDeserialize( using = com.sap.cloud.sdk.datamodel.odatav4.adapter.JacksonVdmObjectDeserializer.class )
public class D_CAScrtyDepAddReqResult extends VdmComplex<D_CAScrtyDepAddReqResult>
{

    @Getter
    private final java.lang.String odataType =
        "com.sap.gateway.srvd_a2x.api_casecuritydeposit.v0001.D_CAScrtyDepAddReqResult";
    /**
     * Constraints: Not nullable, Maximum length: 12
     * <p>
     * Original property name from the Odata EDM: <b>CADocumentNumber</b>
     * </p>
     * 
     * @return The cADocumentNumber contained in this {@link VdmComplex}.
     */
    @Nullable
    @ElementName( "CADocumentNumber" )
    private java.lang.String cADocumentNumber;
    public final static com.sap.cloud.sdk.datamodel.odatav4.core.SimpleProperty.String<D_CAScrtyDepAddReqResult> CA_DOCUMENT_NUMBER =
        new com.sap.cloud.sdk.datamodel.odatav4.core.SimpleProperty.String<D_CAScrtyDepAddReqResult>(
            D_CAScrtyDepAddReqResult.class,
            "CADocumentNumber");
    /**
     * Constraints: Not nullable, Maximum length: 12
     * <p>
     * Original property name from the Odata EDM: <b>CASecurityDeposit</b>
     * </p>
     * 
     * @return The cASecurityDeposit contained in this {@link VdmComplex}.
     */
    @Nullable
    @ElementName( "CASecurityDeposit" )
    private java.lang.String cASecurityDeposit;
    public final static com.sap.cloud.sdk.datamodel.odatav4.core.SimpleProperty.String<D_CAScrtyDepAddReqResult> CA_SECURITY_DEPOSIT =
        new com.sap.cloud.sdk.datamodel.odatav4.core.SimpleProperty.String<D_CAScrtyDepAddReqResult>(
            D_CAScrtyDepAddReqResult.class,
            "CASecurityDeposit");

    /**
     * {@inheritDoc}
     * 
     */
    @Nonnull
    @Override
    public Class<D_CAScrtyDepAddReqResult> getType()
    {
        return D_CAScrtyDepAddReqResult.class;
    }

    @Nonnull
    @Override
    protected Map<java.lang.String, Object> toMapOfFields()
    {
        final Map<java.lang.String, Object> values = super.toMapOfFields();
        values.put("CADocumentNumber", getCADocumentNumber());
        values.put("CASecurityDeposit", getCASecurityDeposit());
        return values;
    }

    @Override
    protected void fromMap( final Map<java.lang.String, Object> inputValues )
    {
        final Map<java.lang.String, Object> values = Maps.newHashMap(inputValues);
        // simple properties
        {
            if( values.containsKey("CADocumentNumber") ) {
                final Object value = values.remove("CADocumentNumber");
                if( (value == null) || (!value.equals(getCADocumentNumber())) ) {
                    setCADocumentNumber(((java.lang.String) value));
                }
            }
            if( values.containsKey("CASecurityDeposit") ) {
                final Object value = values.remove("CASecurityDeposit");
                if( (value == null) || (!value.equals(getCASecurityDeposit())) ) {
                    setCASecurityDeposit(((java.lang.String) value));
                }
            }
        }
        // structured properties
        {
        }
        // navigation properties
        {
        }
        super.fromMap(values);
    }

    @Nonnull
    @Override
    protected ODataEntityKey getKey()
    {
        final ODataEntityKey entityKey = super.getKey();
        return entityKey;
    }

    /**
     * Constraints: Not nullable, Maximum length: 12
     * <p>
     * Original property name from the Odata EDM: <b>CADocumentNumber</b>
     * </p>
     * 
     * @param cADocumentNumber
     *            The cADocumentNumber to set.
     */
    public void setCADocumentNumber( @Nullable final java.lang.String cADocumentNumber )
    {
        rememberChangedField("CADocumentNumber", this.cADocumentNumber);
        this.cADocumentNumber = cADocumentNumber;
    }

    /**
     * Constraints: Not nullable, Maximum length: 12
     * <p>
     * Original property name from the Odata EDM: <b>CASecurityDeposit</b>
     * </p>
     * 
     * @param cASecurityDeposit
     *            The cASecurityDeposit to set.
     */
    public void setCASecurityDeposit( @Nullable final java.lang.String cASecurityDeposit )
    {
        rememberChangedField("CASecurityDeposit", this.cASecurityDeposit);
        this.cASecurityDeposit = cASecurityDeposit;
    }

}
