/*
 * Copyright (c) 2021 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odatav4.namespaces.catalogtypecoding;

import java.util.Map;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;

import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.google.common.collect.Maps;
import com.google.gson.annotations.JsonAdapter;
import com.sap.cloud.sdk.datamodel.odata.client.request.ODataEntityKey;
import com.sap.cloud.sdk.datamodel.odatav4.core.SimpleProperty;
import com.sap.cloud.sdk.datamodel.odatav4.core.VdmEntity;
import com.sap.cloud.sdk.datamodel.odatav4.core.VdmEntitySet;
import com.sap.cloud.sdk.result.ElementName;
import com.sap.cloud.sdk.s4hana.datamodel.odatav4.services.CatalogTypeCodingService;

import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.Getter;
import lombok.NoArgsConstructor;
import lombok.ToString;

/**
 * Catalog Code
 * <p>
 * </p>
 * <p>
 * Original entity name from the Odata EDM: <b>MaintNotifCodingCodeType</b>
 * </p>
 * 
 */
@Builder
@Data
@NoArgsConstructor
@AllArgsConstructor
@ToString( doNotUseGetters = true, callSuper = true )
@EqualsAndHashCode( doNotUseGetters = true, callSuper = true )
@JsonAdapter( com.sap.cloud.sdk.datamodel.odatav4.adapter.GsonVdmAdapterFactory.class )
@JsonSerialize( using = com.sap.cloud.sdk.datamodel.odatav4.adapter.JacksonVdmObjectSerializer.class )
@JsonDeserialize( using = com.sap.cloud.sdk.datamodel.odatav4.adapter.JacksonVdmObjectDeserializer.class )
public class MaintNotifCodingCode extends VdmEntity<MaintNotifCodingCode> implements VdmEntitySet
{

    @Getter
    private final java.lang.String odataType = "com.sap.gateway.srvd_a2x.api_coding.v0001.MaintNotifCodingCodeType";
    /**
     * Selector for all available fields of MaintNotifCodingCode.
     * 
     */
    public final static SimpleProperty<MaintNotifCodingCode> ALL_FIELDS = all();
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>MaintNotifCodingCatalog</b>
     * </p>
     * 
     * @return Catalog
     */
    @Nullable
    @ElementName( "MaintNotifCodingCatalog" )
    private java.lang.String maintNotifCodingCatalog;
    public final static SimpleProperty.String<MaintNotifCodingCode> MAINT_NOTIF_CODING_CATALOG =
        new SimpleProperty.String<MaintNotifCodingCode>(MaintNotifCodingCode.class, "MaintNotifCodingCatalog");
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 8
     * <p>
     * Original property name from the Odata EDM: <b>MaintNotifCodingCodeGroup</b>
     * </p>
     * 
     * @return Code Group
     */
    @Nullable
    @ElementName( "MaintNotifCodingCodeGroup" )
    private java.lang.String maintNotifCodingCodeGroup;
    public final static SimpleProperty.String<MaintNotifCodingCode> MAINT_NOTIF_CODING_CODE_GROUP =
        new SimpleProperty.String<MaintNotifCodingCode>(MaintNotifCodingCode.class, "MaintNotifCodingCodeGroup");
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>MaintNotifCodingCode</b>
     * </p>
     * 
     * @return Code
     */
    @Nullable
    @ElementName( "MaintNotifCodingCode" )
    private java.lang.String maintNotifCodingCode;
    public final static SimpleProperty.String<MaintNotifCodingCode> MAINT_NOTIF_CODING_CODE =
        new SimpleProperty.String<MaintNotifCodingCode>(MaintNotifCodingCode.class, "MaintNotifCodingCode");
    /**
     * Constraints: Not nullable, Maximum length: 60
     * <p>
     * Original property name from the Odata EDM: <b>MaintNotifCodeGrpStatusText</b>
     * </p>
     * 
     * @return Short Text for Fixed Values
     */
    @Nullable
    @ElementName( "MaintNotifCodeGrpStatusText" )
    private java.lang.String maintNotifCodeGrpStatusText;
    public final static SimpleProperty.String<MaintNotifCodingCode> MAINT_NOTIF_CODE_GRP_STATUS_TEXT =
        new SimpleProperty.String<MaintNotifCodingCode>(MaintNotifCodingCode.class, "MaintNotifCodeGrpStatusText");
    /**
     * Constraints: Not nullable, Maximum length: 40
     * <p>
     * Original property name from the Odata EDM: <b>MaintNotifCodingCatalogText</b>
     * </p>
     * 
     * @return Short Text for the Catalog
     */
    @Nullable
    @ElementName( "MaintNotifCodingCatalogText" )
    private java.lang.String maintNotifCodingCatalogText;
    public final static SimpleProperty.String<MaintNotifCodingCode> MAINT_NOTIF_CODING_CATALOG_TEXT =
        new SimpleProperty.String<MaintNotifCodingCode>(MaintNotifCodingCode.class, "MaintNotifCodingCatalogText");
    /**
     * Constraints: Not nullable, Maximum length: 40
     * <p>
     * Original property name from the Odata EDM: <b>MaintNotifCodingCodeGrpText</b>
     * </p>
     * 
     * @return Text for Code Group
     */
    @Nullable
    @ElementName( "MaintNotifCodingCodeGrpText" )
    private java.lang.String maintNotifCodingCodeGrpText;
    public final static SimpleProperty.String<MaintNotifCodingCode> MAINT_NOTIF_CODING_CODE_GRP_TEXT =
        new SimpleProperty.String<MaintNotifCodingCode>(MaintNotifCodingCode.class, "MaintNotifCodingCodeGrpText");
    /**
     * Constraints: Not nullable, Maximum length: 40
     * <p>
     * Original property name from the Odata EDM: <b>MaintNotifCodingCtlgCodeText</b>
     * </p>
     * 
     * @return Text for Code
     */
    @Nullable
    @ElementName( "MaintNotifCodingCtlgCodeText" )
    private java.lang.String maintNotifCodingCtlgCodeText;
    public final static SimpleProperty.String<MaintNotifCodingCode> MAINT_NOTIF_CODING_CTLG_CODE_TEXT =
        new SimpleProperty.String<MaintNotifCodingCode>(MaintNotifCodingCode.class, "MaintNotifCodingCtlgCodeText");

    /**
     * {@inheritDoc}
     * 
     */
    @Nonnull
    @Override
    public Class<MaintNotifCodingCode> getType()
    {
        return MaintNotifCodingCode.class;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>MaintNotifCodingCatalog</b>
     * </p>
     * 
     * @param maintNotifCodingCatalog
     *            Catalog
     */
    public void setMaintNotifCodingCatalog( @Nullable final java.lang.String maintNotifCodingCatalog )
    {
        rememberChangedField("MaintNotifCodingCatalog", this.maintNotifCodingCatalog);
        this.maintNotifCodingCatalog = maintNotifCodingCatalog;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 8
     * <p>
     * Original property name from the Odata EDM: <b>MaintNotifCodingCodeGroup</b>
     * </p>
     * 
     * @param maintNotifCodingCodeGroup
     *            Code Group
     */
    public void setMaintNotifCodingCodeGroup( @Nullable final java.lang.String maintNotifCodingCodeGroup )
    {
        rememberChangedField("MaintNotifCodingCodeGroup", this.maintNotifCodingCodeGroup);
        this.maintNotifCodingCodeGroup = maintNotifCodingCodeGroup;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>MaintNotifCodingCode</b>
     * </p>
     * 
     * @param maintNotifCodingCode
     *            Code
     */
    public void setMaintNotifCodingCode( @Nullable final java.lang.String maintNotifCodingCode )
    {
        rememberChangedField("MaintNotifCodingCode", this.maintNotifCodingCode);
        this.maintNotifCodingCode = maintNotifCodingCode;
    }

    /**
     * Constraints: Not nullable, Maximum length: 60
     * <p>
     * Original property name from the Odata EDM: <b>MaintNotifCodeGrpStatusText</b>
     * </p>
     * 
     * @param maintNotifCodeGrpStatusText
     *            Short Text for Fixed Values
     */
    public void setMaintNotifCodeGrpStatusText( @Nullable final java.lang.String maintNotifCodeGrpStatusText )
    {
        rememberChangedField("MaintNotifCodeGrpStatusText", this.maintNotifCodeGrpStatusText);
        this.maintNotifCodeGrpStatusText = maintNotifCodeGrpStatusText;
    }

    /**
     * Constraints: Not nullable, Maximum length: 40
     * <p>
     * Original property name from the Odata EDM: <b>MaintNotifCodingCatalogText</b>
     * </p>
     * 
     * @param maintNotifCodingCatalogText
     *            Short Text for the Catalog
     */
    public void setMaintNotifCodingCatalogText( @Nullable final java.lang.String maintNotifCodingCatalogText )
    {
        rememberChangedField("MaintNotifCodingCatalogText", this.maintNotifCodingCatalogText);
        this.maintNotifCodingCatalogText = maintNotifCodingCatalogText;
    }

    /**
     * Constraints: Not nullable, Maximum length: 40
     * <p>
     * Original property name from the Odata EDM: <b>MaintNotifCodingCodeGrpText</b>
     * </p>
     * 
     * @param maintNotifCodingCodeGrpText
     *            Text for Code Group
     */
    public void setMaintNotifCodingCodeGrpText( @Nullable final java.lang.String maintNotifCodingCodeGrpText )
    {
        rememberChangedField("MaintNotifCodingCodeGrpText", this.maintNotifCodingCodeGrpText);
        this.maintNotifCodingCodeGrpText = maintNotifCodingCodeGrpText;
    }

    /**
     * Constraints: Not nullable, Maximum length: 40
     * <p>
     * Original property name from the Odata EDM: <b>MaintNotifCodingCtlgCodeText</b>
     * </p>
     * 
     * @param maintNotifCodingCtlgCodeText
     *            Text for Code
     */
    public void setMaintNotifCodingCtlgCodeText( @Nullable final java.lang.String maintNotifCodingCtlgCodeText )
    {
        rememberChangedField("MaintNotifCodingCtlgCodeText", this.maintNotifCodingCtlgCodeText);
        this.maintNotifCodingCtlgCodeText = maintNotifCodingCtlgCodeText;
    }

    @Override
    protected java.lang.String getEntityCollection()
    {
        return "MaintNotifCodingCode";
    }

    @Nonnull
    @Override
    protected ODataEntityKey getKey()
    {
        final ODataEntityKey entityKey = super.getKey();
        entityKey.addKeyProperty("MaintNotifCodingCatalog", getMaintNotifCodingCatalog());
        entityKey.addKeyProperty("MaintNotifCodingCodeGroup", getMaintNotifCodingCodeGroup());
        entityKey.addKeyProperty("MaintNotifCodingCode", getMaintNotifCodingCode());
        return entityKey;
    }

    @Nonnull
    @Override
    protected Map<java.lang.String, Object> toMapOfFields()
    {
        final Map<java.lang.String, Object> values = super.toMapOfFields();
        values.put("MaintNotifCodingCatalog", getMaintNotifCodingCatalog());
        values.put("MaintNotifCodingCodeGroup", getMaintNotifCodingCodeGroup());
        values.put("MaintNotifCodingCode", getMaintNotifCodingCode());
        values.put("MaintNotifCodeGrpStatusText", getMaintNotifCodeGrpStatusText());
        values.put("MaintNotifCodingCatalogText", getMaintNotifCodingCatalogText());
        values.put("MaintNotifCodingCodeGrpText", getMaintNotifCodingCodeGrpText());
        values.put("MaintNotifCodingCtlgCodeText", getMaintNotifCodingCtlgCodeText());
        return values;
    }

    @Override
    protected void fromMap( final Map<java.lang.String, Object> inputValues )
    {
        final Map<java.lang.String, Object> values = Maps.newHashMap(inputValues);
        // simple properties
        {
            if( values.containsKey("MaintNotifCodingCatalog") ) {
                final Object value = values.remove("MaintNotifCodingCatalog");
                if( (value == null) || (!value.equals(getMaintNotifCodingCatalog())) ) {
                    setMaintNotifCodingCatalog(((java.lang.String) value));
                }
            }
            if( values.containsKey("MaintNotifCodingCodeGroup") ) {
                final Object value = values.remove("MaintNotifCodingCodeGroup");
                if( (value == null) || (!value.equals(getMaintNotifCodingCodeGroup())) ) {
                    setMaintNotifCodingCodeGroup(((java.lang.String) value));
                }
            }
            if( values.containsKey("MaintNotifCodingCode") ) {
                final Object value = values.remove("MaintNotifCodingCode");
                if( (value == null) || (!value.equals(getMaintNotifCodingCode())) ) {
                    setMaintNotifCodingCode(((java.lang.String) value));
                }
            }
            if( values.containsKey("MaintNotifCodeGrpStatusText") ) {
                final Object value = values.remove("MaintNotifCodeGrpStatusText");
                if( (value == null) || (!value.equals(getMaintNotifCodeGrpStatusText())) ) {
                    setMaintNotifCodeGrpStatusText(((java.lang.String) value));
                }
            }
            if( values.containsKey("MaintNotifCodingCatalogText") ) {
                final Object value = values.remove("MaintNotifCodingCatalogText");
                if( (value == null) || (!value.equals(getMaintNotifCodingCatalogText())) ) {
                    setMaintNotifCodingCatalogText(((java.lang.String) value));
                }
            }
            if( values.containsKey("MaintNotifCodingCodeGrpText") ) {
                final Object value = values.remove("MaintNotifCodingCodeGrpText");
                if( (value == null) || (!value.equals(getMaintNotifCodingCodeGrpText())) ) {
                    setMaintNotifCodingCodeGrpText(((java.lang.String) value));
                }
            }
            if( values.containsKey("MaintNotifCodingCtlgCodeText") ) {
                final Object value = values.remove("MaintNotifCodingCtlgCodeText");
                if( (value == null) || (!value.equals(getMaintNotifCodingCtlgCodeText())) ) {
                    setMaintNotifCodingCtlgCodeText(((java.lang.String) value));
                }
            }
        }
        // structured properties
        {
        }
        // navigation properties
        {
        }
        super.fromMap(values);
    }

    @Override
    protected java.lang.String getDefaultServicePath()
    {
        return CatalogTypeCodingService.DEFAULT_SERVICE_PATH;
    }

}
