/*
 * Copyright (c) 2021 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odatav4.namespaces.catalogtypeobjectpart;

import java.util.Map;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;

import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.google.common.collect.Maps;
import com.google.gson.annotations.JsonAdapter;
import com.sap.cloud.sdk.datamodel.odata.client.request.ODataEntityKey;
import com.sap.cloud.sdk.datamodel.odatav4.core.SimpleProperty;
import com.sap.cloud.sdk.datamodel.odatav4.core.VdmEntity;
import com.sap.cloud.sdk.datamodel.odatav4.core.VdmEntitySet;
import com.sap.cloud.sdk.result.ElementName;
import com.sap.cloud.sdk.s4hana.datamodel.odatav4.services.CatalogTypeObjectPartService;

import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.Getter;
import lombok.NoArgsConstructor;
import lombok.ToString;

/**
 * Catalog Code
 * <p>
 * </p>
 * <p>
 * Original entity name from the Odata EDM: <b>MaintNotifObjPrtCodeType</b>
 * </p>
 * 
 */
@Builder
@Data
@NoArgsConstructor
@AllArgsConstructor
@ToString( doNotUseGetters = true, callSuper = true )
@EqualsAndHashCode( doNotUseGetters = true, callSuper = true )
@JsonAdapter( com.sap.cloud.sdk.datamodel.odatav4.adapter.GsonVdmAdapterFactory.class )
@JsonSerialize( using = com.sap.cloud.sdk.datamodel.odatav4.adapter.JacksonVdmObjectSerializer.class )
@JsonDeserialize( using = com.sap.cloud.sdk.datamodel.odatav4.adapter.JacksonVdmObjectDeserializer.class )
public class MaintNotifObjPrtCode extends VdmEntity<MaintNotifObjPrtCode> implements VdmEntitySet
{

    @Getter
    private final java.lang.String odataType = "com.sap.gateway.srvd_a2x.api_objectpart.v0001.MaintNotifObjPrtCodeType";
    /**
     * Selector for all available fields of MaintNotifObjPrtCode.
     * 
     */
    public final static SimpleProperty<MaintNotifObjPrtCode> ALL_FIELDS = all();
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>MaintNotifObjPartCatalog</b>
     * </p>
     * 
     * @return Catalog
     */
    @Nullable
    @ElementName( "MaintNotifObjPartCatalog" )
    private java.lang.String maintNotifObjPartCatalog;
    public final static SimpleProperty.String<MaintNotifObjPrtCode> MAINT_NOTIF_OBJ_PART_CATALOG =
        new SimpleProperty.String<MaintNotifObjPrtCode>(MaintNotifObjPrtCode.class, "MaintNotifObjPartCatalog");
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 8
     * <p>
     * Original property name from the Odata EDM: <b>MaintNotifObjPartCodeGroup</b>
     * </p>
     * 
     * @return Code Group
     */
    @Nullable
    @ElementName( "MaintNotifObjPartCodeGroup" )
    private java.lang.String maintNotifObjPartCodeGroup;
    public final static SimpleProperty.String<MaintNotifObjPrtCode> MAINT_NOTIF_OBJ_PART_CODE_GROUP =
        new SimpleProperty.String<MaintNotifObjPrtCode>(MaintNotifObjPrtCode.class, "MaintNotifObjPartCodeGroup");
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>MaintNotifObjPartCode</b>
     * </p>
     * 
     * @return Code
     */
    @Nullable
    @ElementName( "MaintNotifObjPartCode" )
    private java.lang.String maintNotifObjPartCode;
    public final static SimpleProperty.String<MaintNotifObjPrtCode> MAINT_NOTIF_OBJ_PART_CODE =
        new SimpleProperty.String<MaintNotifObjPrtCode>(MaintNotifObjPrtCode.class, "MaintNotifObjPartCode");
    /**
     * Constraints: Not nullable, Maximum length: 60
     * <p>
     * Original property name from the Odata EDM: <b>MaintNotifCodeGrpStatusText</b>
     * </p>
     * 
     * @return Short Text for Fixed Values
     */
    @Nullable
    @ElementName( "MaintNotifCodeGrpStatusText" )
    private java.lang.String maintNotifCodeGrpStatusText;
    public final static SimpleProperty.String<MaintNotifObjPrtCode> MAINT_NOTIF_CODE_GRP_STATUS_TEXT =
        new SimpleProperty.String<MaintNotifObjPrtCode>(MaintNotifObjPrtCode.class, "MaintNotifCodeGrpStatusText");
    /**
     * Constraints: Not nullable, Maximum length: 40
     * <p>
     * Original property name from the Odata EDM: <b>MaintNotifObjPartCatalogText</b>
     * </p>
     * 
     * @return Short Text for the Catalog
     */
    @Nullable
    @ElementName( "MaintNotifObjPartCatalogText" )
    private java.lang.String maintNotifObjPartCatalogText;
    public final static SimpleProperty.String<MaintNotifObjPrtCode> MAINT_NOTIF_OBJ_PART_CATALOG_TEXT =
        new SimpleProperty.String<MaintNotifObjPrtCode>(MaintNotifObjPrtCode.class, "MaintNotifObjPartCatalogText");
    /**
     * Constraints: Not nullable, Maximum length: 40
     * <p>
     * Original property name from the Odata EDM: <b>MaintNotifObjPartCodeGroupText</b>
     * </p>
     * 
     * @return Text for Code Group
     */
    @Nullable
    @ElementName( "MaintNotifObjPartCodeGroupText" )
    private java.lang.String maintNotifObjPartCodeGroupText;
    public final static SimpleProperty.String<MaintNotifObjPrtCode> MAINT_NOTIF_OBJ_PART_CODE_GROUP_TEXT =
        new SimpleProperty.String<MaintNotifObjPrtCode>(MaintNotifObjPrtCode.class, "MaintNotifObjPartCodeGroupText");
    /**
     * Constraints: Not nullable, Maximum length: 40
     * <p>
     * Original property name from the Odata EDM: <b>MaintNotifObjPartCtlgCodeText</b>
     * </p>
     * 
     * @return Text for Code
     */
    @Nullable
    @ElementName( "MaintNotifObjPartCtlgCodeText" )
    private java.lang.String maintNotifObjPartCtlgCodeText;
    public final static SimpleProperty.String<MaintNotifObjPrtCode> MAINT_NOTIF_OBJ_PART_CTLG_CODE_TEXT =
        new SimpleProperty.String<MaintNotifObjPrtCode>(MaintNotifObjPrtCode.class, "MaintNotifObjPartCtlgCodeText");

    /**
     * {@inheritDoc}
     * 
     */
    @Nonnull
    @Override
    public Class<MaintNotifObjPrtCode> getType()
    {
        return MaintNotifObjPrtCode.class;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>MaintNotifObjPartCatalog</b>
     * </p>
     * 
     * @param maintNotifObjPartCatalog
     *            Catalog
     */
    public void setMaintNotifObjPartCatalog( @Nullable final java.lang.String maintNotifObjPartCatalog )
    {
        rememberChangedField("MaintNotifObjPartCatalog", this.maintNotifObjPartCatalog);
        this.maintNotifObjPartCatalog = maintNotifObjPartCatalog;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 8
     * <p>
     * Original property name from the Odata EDM: <b>MaintNotifObjPartCodeGroup</b>
     * </p>
     * 
     * @param maintNotifObjPartCodeGroup
     *            Code Group
     */
    public void setMaintNotifObjPartCodeGroup( @Nullable final java.lang.String maintNotifObjPartCodeGroup )
    {
        rememberChangedField("MaintNotifObjPartCodeGroup", this.maintNotifObjPartCodeGroup);
        this.maintNotifObjPartCodeGroup = maintNotifObjPartCodeGroup;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>MaintNotifObjPartCode</b>
     * </p>
     * 
     * @param maintNotifObjPartCode
     *            Code
     */
    public void setMaintNotifObjPartCode( @Nullable final java.lang.String maintNotifObjPartCode )
    {
        rememberChangedField("MaintNotifObjPartCode", this.maintNotifObjPartCode);
        this.maintNotifObjPartCode = maintNotifObjPartCode;
    }

    /**
     * Constraints: Not nullable, Maximum length: 60
     * <p>
     * Original property name from the Odata EDM: <b>MaintNotifCodeGrpStatusText</b>
     * </p>
     * 
     * @param maintNotifCodeGrpStatusText
     *            Short Text for Fixed Values
     */
    public void setMaintNotifCodeGrpStatusText( @Nullable final java.lang.String maintNotifCodeGrpStatusText )
    {
        rememberChangedField("MaintNotifCodeGrpStatusText", this.maintNotifCodeGrpStatusText);
        this.maintNotifCodeGrpStatusText = maintNotifCodeGrpStatusText;
    }

    /**
     * Constraints: Not nullable, Maximum length: 40
     * <p>
     * Original property name from the Odata EDM: <b>MaintNotifObjPartCatalogText</b>
     * </p>
     * 
     * @param maintNotifObjPartCatalogText
     *            Short Text for the Catalog
     */
    public void setMaintNotifObjPartCatalogText( @Nullable final java.lang.String maintNotifObjPartCatalogText )
    {
        rememberChangedField("MaintNotifObjPartCatalogText", this.maintNotifObjPartCatalogText);
        this.maintNotifObjPartCatalogText = maintNotifObjPartCatalogText;
    }

    /**
     * Constraints: Not nullable, Maximum length: 40
     * <p>
     * Original property name from the Odata EDM: <b>MaintNotifObjPartCodeGroupText</b>
     * </p>
     * 
     * @param maintNotifObjPartCodeGroupText
     *            Text for Code Group
     */
    public void setMaintNotifObjPartCodeGroupText( @Nullable final java.lang.String maintNotifObjPartCodeGroupText )
    {
        rememberChangedField("MaintNotifObjPartCodeGroupText", this.maintNotifObjPartCodeGroupText);
        this.maintNotifObjPartCodeGroupText = maintNotifObjPartCodeGroupText;
    }

    /**
     * Constraints: Not nullable, Maximum length: 40
     * <p>
     * Original property name from the Odata EDM: <b>MaintNotifObjPartCtlgCodeText</b>
     * </p>
     * 
     * @param maintNotifObjPartCtlgCodeText
     *            Text for Code
     */
    public void setMaintNotifObjPartCtlgCodeText( @Nullable final java.lang.String maintNotifObjPartCtlgCodeText )
    {
        rememberChangedField("MaintNotifObjPartCtlgCodeText", this.maintNotifObjPartCtlgCodeText);
        this.maintNotifObjPartCtlgCodeText = maintNotifObjPartCtlgCodeText;
    }

    @Override
    protected java.lang.String getEntityCollection()
    {
        return "MaintNotifObjPrtCode";
    }

    @Nonnull
    @Override
    protected ODataEntityKey getKey()
    {
        final ODataEntityKey entityKey = super.getKey();
        entityKey.addKeyProperty("MaintNotifObjPartCatalog", getMaintNotifObjPartCatalog());
        entityKey.addKeyProperty("MaintNotifObjPartCodeGroup", getMaintNotifObjPartCodeGroup());
        entityKey.addKeyProperty("MaintNotifObjPartCode", getMaintNotifObjPartCode());
        return entityKey;
    }

    @Nonnull
    @Override
    protected Map<java.lang.String, Object> toMapOfFields()
    {
        final Map<java.lang.String, Object> values = super.toMapOfFields();
        values.put("MaintNotifObjPartCatalog", getMaintNotifObjPartCatalog());
        values.put("MaintNotifObjPartCodeGroup", getMaintNotifObjPartCodeGroup());
        values.put("MaintNotifObjPartCode", getMaintNotifObjPartCode());
        values.put("MaintNotifCodeGrpStatusText", getMaintNotifCodeGrpStatusText());
        values.put("MaintNotifObjPartCatalogText", getMaintNotifObjPartCatalogText());
        values.put("MaintNotifObjPartCodeGroupText", getMaintNotifObjPartCodeGroupText());
        values.put("MaintNotifObjPartCtlgCodeText", getMaintNotifObjPartCtlgCodeText());
        return values;
    }

    @Override
    protected void fromMap( final Map<java.lang.String, Object> inputValues )
    {
        final Map<java.lang.String, Object> values = Maps.newHashMap(inputValues);
        // simple properties
        {
            if( values.containsKey("MaintNotifObjPartCatalog") ) {
                final Object value = values.remove("MaintNotifObjPartCatalog");
                if( (value == null) || (!value.equals(getMaintNotifObjPartCatalog())) ) {
                    setMaintNotifObjPartCatalog(((java.lang.String) value));
                }
            }
            if( values.containsKey("MaintNotifObjPartCodeGroup") ) {
                final Object value = values.remove("MaintNotifObjPartCodeGroup");
                if( (value == null) || (!value.equals(getMaintNotifObjPartCodeGroup())) ) {
                    setMaintNotifObjPartCodeGroup(((java.lang.String) value));
                }
            }
            if( values.containsKey("MaintNotifObjPartCode") ) {
                final Object value = values.remove("MaintNotifObjPartCode");
                if( (value == null) || (!value.equals(getMaintNotifObjPartCode())) ) {
                    setMaintNotifObjPartCode(((java.lang.String) value));
                }
            }
            if( values.containsKey("MaintNotifCodeGrpStatusText") ) {
                final Object value = values.remove("MaintNotifCodeGrpStatusText");
                if( (value == null) || (!value.equals(getMaintNotifCodeGrpStatusText())) ) {
                    setMaintNotifCodeGrpStatusText(((java.lang.String) value));
                }
            }
            if( values.containsKey("MaintNotifObjPartCatalogText") ) {
                final Object value = values.remove("MaintNotifObjPartCatalogText");
                if( (value == null) || (!value.equals(getMaintNotifObjPartCatalogText())) ) {
                    setMaintNotifObjPartCatalogText(((java.lang.String) value));
                }
            }
            if( values.containsKey("MaintNotifObjPartCodeGroupText") ) {
                final Object value = values.remove("MaintNotifObjPartCodeGroupText");
                if( (value == null) || (!value.equals(getMaintNotifObjPartCodeGroupText())) ) {
                    setMaintNotifObjPartCodeGroupText(((java.lang.String) value));
                }
            }
            if( values.containsKey("MaintNotifObjPartCtlgCodeText") ) {
                final Object value = values.remove("MaintNotifObjPartCtlgCodeText");
                if( (value == null) || (!value.equals(getMaintNotifObjPartCtlgCodeText())) ) {
                    setMaintNotifObjPartCtlgCodeText(((java.lang.String) value));
                }
            }
        }
        // structured properties
        {
        }
        // navigation properties
        {
        }
        super.fromMap(values);
    }

    @Override
    protected java.lang.String getDefaultServicePath()
    {
        return CatalogTypeObjectPartService.DEFAULT_SERVICE_PATH;
    }

}
