/*
 * Copyright (c) 2021 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odatav4.namespaces.catalogtypeoverviewofdamage;

import java.util.Map;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;

import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.google.common.collect.Maps;
import com.google.gson.annotations.JsonAdapter;
import com.sap.cloud.sdk.datamodel.odata.client.request.ODataEntityKey;
import com.sap.cloud.sdk.datamodel.odatav4.core.SimpleProperty;
import com.sap.cloud.sdk.datamodel.odatav4.core.VdmEntity;
import com.sap.cloud.sdk.datamodel.odatav4.core.VdmEntitySet;
import com.sap.cloud.sdk.result.ElementName;
import com.sap.cloud.sdk.s4hana.datamodel.odatav4.services.CatalogTypeOverviewOfDamageService;

import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.Getter;
import lombok.NoArgsConstructor;
import lombok.ToString;

/**
 * Catalog Code
 * <p>
 * </p>
 * <p>
 * Original entity name from the Odata EDM: <b>MaintNotifOvwDamageCodeType</b>
 * </p>
 * 
 */
@Builder
@Data
@NoArgsConstructor
@AllArgsConstructor
@ToString( doNotUseGetters = true, callSuper = true )
@EqualsAndHashCode( doNotUseGetters = true, callSuper = true )
@JsonAdapter( com.sap.cloud.sdk.datamodel.odatav4.adapter.GsonVdmAdapterFactory.class )
@JsonSerialize( using = com.sap.cloud.sdk.datamodel.odatav4.adapter.JacksonVdmObjectSerializer.class )
@JsonDeserialize( using = com.sap.cloud.sdk.datamodel.odatav4.adapter.JacksonVdmObjectDeserializer.class )
public class MaintNotifOvwDamageCode extends VdmEntity<MaintNotifOvwDamageCode> implements VdmEntitySet
{

    @Getter
    private final java.lang.String odataType =
        "com.sap.gateway.srvd_a2x.api_ovwdamage.v0001.MaintNotifOvwDamageCodeType";
    /**
     * Selector for all available fields of MaintNotifOvwDamageCode.
     * 
     */
    public final static SimpleProperty<MaintNotifOvwDamageCode> ALL_FIELDS = all();
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>MaintNotifOvwDamageCatalog</b>
     * </p>
     * 
     * @return Catalog
     */
    @Nullable
    @ElementName( "MaintNotifOvwDamageCatalog" )
    private java.lang.String maintNotifOvwDamageCatalog;
    public final static SimpleProperty.String<MaintNotifOvwDamageCode> MAINT_NOTIF_OVW_DAMAGE_CATALOG =
        new SimpleProperty.String<MaintNotifOvwDamageCode>(MaintNotifOvwDamageCode.class, "MaintNotifOvwDamageCatalog");
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 8
     * <p>
     * Original property name from the Odata EDM: <b>MaintNotifOvwDamageCodeGroup</b>
     * </p>
     * 
     * @return Code Group
     */
    @Nullable
    @ElementName( "MaintNotifOvwDamageCodeGroup" )
    private java.lang.String maintNotifOvwDamageCodeGroup;
    public final static SimpleProperty.String<MaintNotifOvwDamageCode> MAINT_NOTIF_OVW_DAMAGE_CODE_GROUP =
        new SimpleProperty.String<MaintNotifOvwDamageCode>(
            MaintNotifOvwDamageCode.class,
            "MaintNotifOvwDamageCodeGroup");
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>MaintNotifOvwDamageCode</b>
     * </p>
     * 
     * @return Code
     */
    @Nullable
    @ElementName( "MaintNotifOvwDamageCode" )
    private java.lang.String maintNotifOvwDamageCode;
    public final static SimpleProperty.String<MaintNotifOvwDamageCode> MAINT_NOTIF_OVW_DAMAGE_CODE =
        new SimpleProperty.String<MaintNotifOvwDamageCode>(MaintNotifOvwDamageCode.class, "MaintNotifOvwDamageCode");
    /**
     * Constraints: Not nullable, Maximum length: 60
     * <p>
     * Original property name from the Odata EDM: <b>MaintNotifCodeGrpStatusText</b>
     * </p>
     * 
     * @return Short Text for Fixed Values
     */
    @Nullable
    @ElementName( "MaintNotifCodeGrpStatusText" )
    private java.lang.String maintNotifCodeGrpStatusText;
    public final static SimpleProperty.String<MaintNotifOvwDamageCode> MAINT_NOTIF_CODE_GRP_STATUS_TEXT =
        new SimpleProperty.String<MaintNotifOvwDamageCode>(
            MaintNotifOvwDamageCode.class,
            "MaintNotifCodeGrpStatusText");
    /**
     * Constraints: Not nullable, Maximum length: 40
     * <p>
     * Original property name from the Odata EDM: <b>MaintNotifOvwDamageCatalogText</b>
     * </p>
     * 
     * @return Short Text for the Catalog
     */
    @Nullable
    @ElementName( "MaintNotifOvwDamageCatalogText" )
    private java.lang.String maintNotifOvwDamageCatalogText;
    public final static SimpleProperty.String<MaintNotifOvwDamageCode> MAINT_NOTIF_OVW_DAMAGE_CATALOG_TEXT =
        new SimpleProperty.String<MaintNotifOvwDamageCode>(
            MaintNotifOvwDamageCode.class,
            "MaintNotifOvwDamageCatalogText");
    /**
     * Constraints: Not nullable, Maximum length: 40
     * <p>
     * Original property name from the Odata EDM: <b>MaintNotifOvwDamageCodeGrpText</b>
     * </p>
     * 
     * @return Text for Code Group
     */
    @Nullable
    @ElementName( "MaintNotifOvwDamageCodeGrpText" )
    private java.lang.String maintNotifOvwDamageCodeGrpText;
    public final static SimpleProperty.String<MaintNotifOvwDamageCode> MAINT_NOTIF_OVW_DAMAGE_CODE_GRP_TEXT =
        new SimpleProperty.String<MaintNotifOvwDamageCode>(
            MaintNotifOvwDamageCode.class,
            "MaintNotifOvwDamageCodeGrpText");
    /**
     * Constraints: Not nullable, Maximum length: 40
     * <p>
     * Original property name from the Odata EDM: <b>MaintNotifOvwDamageCtlgCodeTxt</b>
     * </p>
     * 
     * @return Text for Code
     */
    @Nullable
    @ElementName( "MaintNotifOvwDamageCtlgCodeTxt" )
    private java.lang.String maintNotifOvwDamageCtlgCodeTxt;
    public final static SimpleProperty.String<MaintNotifOvwDamageCode> MAINT_NOTIF_OVW_DAMAGE_CTLG_CODE_TXT =
        new SimpleProperty.String<MaintNotifOvwDamageCode>(
            MaintNotifOvwDamageCode.class,
            "MaintNotifOvwDamageCtlgCodeTxt");

    /**
     * {@inheritDoc}
     * 
     */
    @Nonnull
    @Override
    public Class<MaintNotifOvwDamageCode> getType()
    {
        return MaintNotifOvwDamageCode.class;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>MaintNotifOvwDamageCatalog</b>
     * </p>
     * 
     * @param maintNotifOvwDamageCatalog
     *            Catalog
     */
    public void setMaintNotifOvwDamageCatalog( @Nullable final java.lang.String maintNotifOvwDamageCatalog )
    {
        rememberChangedField("MaintNotifOvwDamageCatalog", this.maintNotifOvwDamageCatalog);
        this.maintNotifOvwDamageCatalog = maintNotifOvwDamageCatalog;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 8
     * <p>
     * Original property name from the Odata EDM: <b>MaintNotifOvwDamageCodeGroup</b>
     * </p>
     * 
     * @param maintNotifOvwDamageCodeGroup
     *            Code Group
     */
    public void setMaintNotifOvwDamageCodeGroup( @Nullable final java.lang.String maintNotifOvwDamageCodeGroup )
    {
        rememberChangedField("MaintNotifOvwDamageCodeGroup", this.maintNotifOvwDamageCodeGroup);
        this.maintNotifOvwDamageCodeGroup = maintNotifOvwDamageCodeGroup;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>MaintNotifOvwDamageCode</b>
     * </p>
     * 
     * @param maintNotifOvwDamageCode
     *            Code
     */
    public void setMaintNotifOvwDamageCode( @Nullable final java.lang.String maintNotifOvwDamageCode )
    {
        rememberChangedField("MaintNotifOvwDamageCode", this.maintNotifOvwDamageCode);
        this.maintNotifOvwDamageCode = maintNotifOvwDamageCode;
    }

    /**
     * Constraints: Not nullable, Maximum length: 60
     * <p>
     * Original property name from the Odata EDM: <b>MaintNotifCodeGrpStatusText</b>
     * </p>
     * 
     * @param maintNotifCodeGrpStatusText
     *            Short Text for Fixed Values
     */
    public void setMaintNotifCodeGrpStatusText( @Nullable final java.lang.String maintNotifCodeGrpStatusText )
    {
        rememberChangedField("MaintNotifCodeGrpStatusText", this.maintNotifCodeGrpStatusText);
        this.maintNotifCodeGrpStatusText = maintNotifCodeGrpStatusText;
    }

    /**
     * Constraints: Not nullable, Maximum length: 40
     * <p>
     * Original property name from the Odata EDM: <b>MaintNotifOvwDamageCatalogText</b>
     * </p>
     * 
     * @param maintNotifOvwDamageCatalogText
     *            Short Text for the Catalog
     */
    public void setMaintNotifOvwDamageCatalogText( @Nullable final java.lang.String maintNotifOvwDamageCatalogText )
    {
        rememberChangedField("MaintNotifOvwDamageCatalogText", this.maintNotifOvwDamageCatalogText);
        this.maintNotifOvwDamageCatalogText = maintNotifOvwDamageCatalogText;
    }

    /**
     * Constraints: Not nullable, Maximum length: 40
     * <p>
     * Original property name from the Odata EDM: <b>MaintNotifOvwDamageCodeGrpText</b>
     * </p>
     * 
     * @param maintNotifOvwDamageCodeGrpText
     *            Text for Code Group
     */
    public void setMaintNotifOvwDamageCodeGrpText( @Nullable final java.lang.String maintNotifOvwDamageCodeGrpText )
    {
        rememberChangedField("MaintNotifOvwDamageCodeGrpText", this.maintNotifOvwDamageCodeGrpText);
        this.maintNotifOvwDamageCodeGrpText = maintNotifOvwDamageCodeGrpText;
    }

    /**
     * Constraints: Not nullable, Maximum length: 40
     * <p>
     * Original property name from the Odata EDM: <b>MaintNotifOvwDamageCtlgCodeTxt</b>
     * </p>
     * 
     * @param maintNotifOvwDamageCtlgCodeTxt
     *            Text for Code
     */
    public void setMaintNotifOvwDamageCtlgCodeTxt( @Nullable final java.lang.String maintNotifOvwDamageCtlgCodeTxt )
    {
        rememberChangedField("MaintNotifOvwDamageCtlgCodeTxt", this.maintNotifOvwDamageCtlgCodeTxt);
        this.maintNotifOvwDamageCtlgCodeTxt = maintNotifOvwDamageCtlgCodeTxt;
    }

    @Override
    protected java.lang.String getEntityCollection()
    {
        return "MaintNotifOvwDamageCode";
    }

    @Nonnull
    @Override
    protected ODataEntityKey getKey()
    {
        final ODataEntityKey entityKey = super.getKey();
        entityKey.addKeyProperty("MaintNotifOvwDamageCatalog", getMaintNotifOvwDamageCatalog());
        entityKey.addKeyProperty("MaintNotifOvwDamageCodeGroup", getMaintNotifOvwDamageCodeGroup());
        entityKey.addKeyProperty("MaintNotifOvwDamageCode", getMaintNotifOvwDamageCode());
        return entityKey;
    }

    @Nonnull
    @Override
    protected Map<java.lang.String, Object> toMapOfFields()
    {
        final Map<java.lang.String, Object> values = super.toMapOfFields();
        values.put("MaintNotifOvwDamageCatalog", getMaintNotifOvwDamageCatalog());
        values.put("MaintNotifOvwDamageCodeGroup", getMaintNotifOvwDamageCodeGroup());
        values.put("MaintNotifOvwDamageCode", getMaintNotifOvwDamageCode());
        values.put("MaintNotifCodeGrpStatusText", getMaintNotifCodeGrpStatusText());
        values.put("MaintNotifOvwDamageCatalogText", getMaintNotifOvwDamageCatalogText());
        values.put("MaintNotifOvwDamageCodeGrpText", getMaintNotifOvwDamageCodeGrpText());
        values.put("MaintNotifOvwDamageCtlgCodeTxt", getMaintNotifOvwDamageCtlgCodeTxt());
        return values;
    }

    @Override
    protected void fromMap( final Map<java.lang.String, Object> inputValues )
    {
        final Map<java.lang.String, Object> values = Maps.newHashMap(inputValues);
        // simple properties
        {
            if( values.containsKey("MaintNotifOvwDamageCatalog") ) {
                final Object value = values.remove("MaintNotifOvwDamageCatalog");
                if( (value == null) || (!value.equals(getMaintNotifOvwDamageCatalog())) ) {
                    setMaintNotifOvwDamageCatalog(((java.lang.String) value));
                }
            }
            if( values.containsKey("MaintNotifOvwDamageCodeGroup") ) {
                final Object value = values.remove("MaintNotifOvwDamageCodeGroup");
                if( (value == null) || (!value.equals(getMaintNotifOvwDamageCodeGroup())) ) {
                    setMaintNotifOvwDamageCodeGroup(((java.lang.String) value));
                }
            }
            if( values.containsKey("MaintNotifOvwDamageCode") ) {
                final Object value = values.remove("MaintNotifOvwDamageCode");
                if( (value == null) || (!value.equals(getMaintNotifOvwDamageCode())) ) {
                    setMaintNotifOvwDamageCode(((java.lang.String) value));
                }
            }
            if( values.containsKey("MaintNotifCodeGrpStatusText") ) {
                final Object value = values.remove("MaintNotifCodeGrpStatusText");
                if( (value == null) || (!value.equals(getMaintNotifCodeGrpStatusText())) ) {
                    setMaintNotifCodeGrpStatusText(((java.lang.String) value));
                }
            }
            if( values.containsKey("MaintNotifOvwDamageCatalogText") ) {
                final Object value = values.remove("MaintNotifOvwDamageCatalogText");
                if( (value == null) || (!value.equals(getMaintNotifOvwDamageCatalogText())) ) {
                    setMaintNotifOvwDamageCatalogText(((java.lang.String) value));
                }
            }
            if( values.containsKey("MaintNotifOvwDamageCodeGrpText") ) {
                final Object value = values.remove("MaintNotifOvwDamageCodeGrpText");
                if( (value == null) || (!value.equals(getMaintNotifOvwDamageCodeGrpText())) ) {
                    setMaintNotifOvwDamageCodeGrpText(((java.lang.String) value));
                }
            }
            if( values.containsKey("MaintNotifOvwDamageCtlgCodeTxt") ) {
                final Object value = values.remove("MaintNotifOvwDamageCtlgCodeTxt");
                if( (value == null) || (!value.equals(getMaintNotifOvwDamageCtlgCodeTxt())) ) {
                    setMaintNotifOvwDamageCtlgCodeTxt(((java.lang.String) value));
                }
            }
        }
        // structured properties
        {
        }
        // navigation properties
        {
        }
        super.fromMap(values);
    }

    @Override
    protected java.lang.String getDefaultServicePath()
    {
        return CatalogTypeOverviewOfDamageService.DEFAULT_SERVICE_PATH;
    }

}
