/*
 * Copyright (c) 2021 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odatav4.namespaces.conditioncontract;

import java.math.BigDecimal;
import java.time.LocalDate;
import java.util.Map;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;

import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.google.common.collect.Maps;
import com.google.gson.annotations.JsonAdapter;
import com.sap.cloud.sdk.datamodel.odata.client.request.ODataEntityKey;
import com.sap.cloud.sdk.datamodel.odatav4.core.DecimalDescriptor;
import com.sap.cloud.sdk.datamodel.odatav4.core.VdmComplex;
import com.sap.cloud.sdk.result.ElementName;

import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.Getter;
import lombok.NoArgsConstructor;
import lombok.ToString;

/**
 * <p>
 * Original complex type name from the Odata EDM: <b>AccrualAmountsResult_Type</b>
 * </p>
 * 
 */
@Builder
@Data
@NoArgsConstructor
@AllArgsConstructor
@ToString( doNotUseGetters = true, callSuper = true )
@EqualsAndHashCode( doNotUseGetters = true, callSuper = true )
@JsonAdapter( com.sap.cloud.sdk.datamodel.odatav4.adapter.GsonVdmAdapterFactory.class )
@JsonSerialize( using = com.sap.cloud.sdk.datamodel.odatav4.adapter.JacksonVdmObjectSerializer.class )
@JsonDeserialize( using = com.sap.cloud.sdk.datamodel.odatav4.adapter.JacksonVdmObjectDeserializer.class )
public class AccrualAmountsResult_Type extends VdmComplex<AccrualAmountsResult_Type>
{

    @Getter
    private final java.lang.String odataType =
        "com.sap.gateway.srvd_a2x.api_condition_contract.v0001.AccrualAmountsResult_Type";
    /**
     * Constraints: Not nullable, Maximum length: 5
     * <p>
     * Original property name from the Odata EDM: <b>AccrSrceDocCurrency</b>
     * </p>
     * 
     * @return The accrSrceDocCurrency contained in this {@link VdmComplex}.
     */
    @Nullable
    @ElementName( "AccrSrceDocCurrency" )
    private java.lang.String accrSrceDocCurrency;
    public final static com.sap.cloud.sdk.datamodel.odatav4.core.SimpleProperty.String<AccrualAmountsResult_Type> ACCR_SRCE_DOC_CURRENCY =
        new com.sap.cloud.sdk.datamodel.odatav4.core.SimpleProperty.String<AccrualAmountsResult_Type>(
            AccrualAmountsResult_Type.class,
            "AccrSrceDocCurrency");
    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>AccrSrceDocDistributionChannel</b>
     * </p>
     * 
     * @return The accrSrceDocDistributionChannel contained in this {@link VdmComplex}.
     */
    @Nullable
    @ElementName( "AccrSrceDocDistributionChannel" )
    private java.lang.String accrSrceDocDistributionChannel;
    public final static com.sap.cloud.sdk.datamodel.odatav4.core.SimpleProperty.String<AccrualAmountsResult_Type> ACCR_SRCE_DOC_DISTRIBUTION_CHANNEL =
        new com.sap.cloud.sdk.datamodel.odatav4.core.SimpleProperty.String<AccrualAmountsResult_Type>(
            AccrualAmountsResult_Type.class,
            "AccrSrceDocDistributionChannel");
    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>AccrSrceDocDivision</b>
     * </p>
     * 
     * @return The accrSrceDocDivision contained in this {@link VdmComplex}.
     */
    @Nullable
    @ElementName( "AccrSrceDocDivision" )
    private java.lang.String accrSrceDocDivision;
    public final static com.sap.cloud.sdk.datamodel.odatav4.core.SimpleProperty.String<AccrualAmountsResult_Type> ACCR_SRCE_DOC_DIVISION =
        new com.sap.cloud.sdk.datamodel.odatav4.core.SimpleProperty.String<AccrualAmountsResult_Type>(
            AccrualAmountsResult_Type.class,
            "AccrSrceDocDivision");
    /**
     * Constraints: Not nullable, Maximum length: 40
     * <p>
     * Original property name from the Odata EDM: <b>AccrSrceDocItemProduct</b>
     * </p>
     * 
     * @return The accrSrceDocItemProduct contained in this {@link VdmComplex}.
     */
    @Nullable
    @ElementName( "AccrSrceDocItemProduct" )
    private java.lang.String accrSrceDocItemProduct;
    public final static com.sap.cloud.sdk.datamodel.odatav4.core.SimpleProperty.String<AccrualAmountsResult_Type> ACCR_SRCE_DOC_ITEM_PRODUCT =
        new com.sap.cloud.sdk.datamodel.odatav4.core.SimpleProperty.String<AccrualAmountsResult_Type>(
            AccrualAmountsResult_Type.class,
            "AccrSrceDocItemProduct");
    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>AccrSrceDocPayerParty</b>
     * </p>
     * 
     * @return The accrSrceDocPayerParty contained in this {@link VdmComplex}.
     */
    @Nullable
    @ElementName( "AccrSrceDocPayerParty" )
    private java.lang.String accrSrceDocPayerParty;
    public final static com.sap.cloud.sdk.datamodel.odatav4.core.SimpleProperty.String<AccrualAmountsResult_Type> ACCR_SRCE_DOC_PAYER_PARTY =
        new com.sap.cloud.sdk.datamodel.odatav4.core.SimpleProperty.String<AccrualAmountsResult_Type>(
            AccrualAmountsResult_Type.class,
            "AccrSrceDocPayerParty");
    /**
     * Constraints: Nullable
     * <p>
     * Original property name from the Odata EDM: <b>AccrSrceDocPostingDate</b>
     * </p>
     * 
     * @return The accrSrceDocPostingDate contained in this {@link VdmComplex}.
     */
    @Nullable
    @ElementName( "AccrSrceDocPostingDate" )
    private LocalDate accrSrceDocPostingDate;
    public final static com.sap.cloud.sdk.datamodel.odatav4.core.SimpleProperty.Date<AccrualAmountsResult_Type> ACCR_SRCE_DOC_POSTING_DATE =
        new com.sap.cloud.sdk.datamodel.odatav4.core.SimpleProperty.Date<AccrualAmountsResult_Type>(
            AccrualAmountsResult_Type.class,
            "AccrSrceDocPostingDate");
    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>AccrSrceDocPostingHalfYear</b>
     * </p>
     * 
     * @return The accrSrceDocPostingHalfYear contained in this {@link VdmComplex}.
     */
    @Nullable
    @ElementName( "AccrSrceDocPostingHalfYear" )
    private java.lang.String accrSrceDocPostingHalfYear;
    public final static com.sap.cloud.sdk.datamodel.odatav4.core.SimpleProperty.String<AccrualAmountsResult_Type> ACCR_SRCE_DOC_POSTING_HALF_YEAR =
        new com.sap.cloud.sdk.datamodel.odatav4.core.SimpleProperty.String<AccrualAmountsResult_Type>(
            AccrualAmountsResult_Type.class,
            "AccrSrceDocPostingHalfYear");
    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>AccrSrceDocPostingMonth</b>
     * </p>
     * 
     * @return The accrSrceDocPostingMonth contained in this {@link VdmComplex}.
     */
    @Nullable
    @ElementName( "AccrSrceDocPostingMonth" )
    private java.lang.String accrSrceDocPostingMonth;
    public final static com.sap.cloud.sdk.datamodel.odatav4.core.SimpleProperty.String<AccrualAmountsResult_Type> ACCR_SRCE_DOC_POSTING_MONTH =
        new com.sap.cloud.sdk.datamodel.odatav4.core.SimpleProperty.String<AccrualAmountsResult_Type>(
            AccrualAmountsResult_Type.class,
            "AccrSrceDocPostingMonth");
    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>AccrSrceDocPostingQuarter</b>
     * </p>
     * 
     * @return The accrSrceDocPostingQuarter contained in this {@link VdmComplex}.
     */
    @Nullable
    @ElementName( "AccrSrceDocPostingQuarter" )
    private java.lang.String accrSrceDocPostingQuarter;
    public final static com.sap.cloud.sdk.datamodel.odatav4.core.SimpleProperty.String<AccrualAmountsResult_Type> ACCR_SRCE_DOC_POSTING_QUARTER =
        new com.sap.cloud.sdk.datamodel.odatav4.core.SimpleProperty.String<AccrualAmountsResult_Type>(
            AccrualAmountsResult_Type.class,
            "AccrSrceDocPostingQuarter");
    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>AccrSrceDocPostingWeek</b>
     * </p>
     * 
     * @return The accrSrceDocPostingWeek contained in this {@link VdmComplex}.
     */
    @Nullable
    @ElementName( "AccrSrceDocPostingWeek" )
    private java.lang.String accrSrceDocPostingWeek;
    public final static com.sap.cloud.sdk.datamodel.odatav4.core.SimpleProperty.String<AccrualAmountsResult_Type> ACCR_SRCE_DOC_POSTING_WEEK =
        new com.sap.cloud.sdk.datamodel.odatav4.core.SimpleProperty.String<AccrualAmountsResult_Type>(
            AccrualAmountsResult_Type.class,
            "AccrSrceDocPostingWeek");
    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>AccrSrceDocPostingYear</b>
     * </p>
     * 
     * @return The accrSrceDocPostingYear contained in this {@link VdmComplex}.
     */
    @Nullable
    @ElementName( "AccrSrceDocPostingYear" )
    private java.lang.String accrSrceDocPostingYear;
    public final static com.sap.cloud.sdk.datamodel.odatav4.core.SimpleProperty.String<AccrualAmountsResult_Type> ACCR_SRCE_DOC_POSTING_YEAR =
        new com.sap.cloud.sdk.datamodel.odatav4.core.SimpleProperty.String<AccrualAmountsResult_Type>(
            AccrualAmountsResult_Type.class,
            "AccrSrceDocPostingYear");
    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>AccrSrceDocPurgGroup</b>
     * </p>
     * 
     * @return The accrSrceDocPurgGroup contained in this {@link VdmComplex}.
     */
    @Nullable
    @ElementName( "AccrSrceDocPurgGroup" )
    private java.lang.String accrSrceDocPurgGroup;
    public final static com.sap.cloud.sdk.datamodel.odatav4.core.SimpleProperty.String<AccrualAmountsResult_Type> ACCR_SRCE_DOC_PURG_GROUP =
        new com.sap.cloud.sdk.datamodel.odatav4.core.SimpleProperty.String<AccrualAmountsResult_Type>(
            AccrualAmountsResult_Type.class,
            "AccrSrceDocPurgGroup");
    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>AccrSrceDocPurgOrganization</b>
     * </p>
     * 
     * @return The accrSrceDocPurgOrganization contained in this {@link VdmComplex}.
     */
    @Nullable
    @ElementName( "AccrSrceDocPurgOrganization" )
    private java.lang.String accrSrceDocPurgOrganization;
    public final static com.sap.cloud.sdk.datamodel.odatav4.core.SimpleProperty.String<AccrualAmountsResult_Type> ACCR_SRCE_DOC_PURG_ORGANIZATION =
        new com.sap.cloud.sdk.datamodel.odatav4.core.SimpleProperty.String<AccrualAmountsResult_Type>(
            AccrualAmountsResult_Type.class,
            "AccrSrceDocPurgOrganization");
    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>AccrSrceDocSalesOrganization</b>
     * </p>
     * 
     * @return The accrSrceDocSalesOrganization contained in this {@link VdmComplex}.
     */
    @Nullable
    @ElementName( "AccrSrceDocSalesOrganization" )
    private java.lang.String accrSrceDocSalesOrganization;
    public final static com.sap.cloud.sdk.datamodel.odatav4.core.SimpleProperty.String<AccrualAmountsResult_Type> ACCR_SRCE_DOC_SALES_ORGANIZATION =
        new com.sap.cloud.sdk.datamodel.odatav4.core.SimpleProperty.String<AccrualAmountsResult_Type>(
            AccrualAmountsResult_Type.class,
            "AccrSrceDocSalesOrganization");
    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>AccrSrceDocSoldToParty</b>
     * </p>
     * 
     * @return The accrSrceDocSoldToParty contained in this {@link VdmComplex}.
     */
    @Nullable
    @ElementName( "AccrSrceDocSoldToParty" )
    private java.lang.String accrSrceDocSoldToParty;
    public final static com.sap.cloud.sdk.datamodel.odatav4.core.SimpleProperty.String<AccrualAmountsResult_Type> ACCR_SRCE_DOC_SOLD_TO_PARTY =
        new com.sap.cloud.sdk.datamodel.odatav4.core.SimpleProperty.String<AccrualAmountsResult_Type>(
            AccrualAmountsResult_Type.class,
            "AccrSrceDocSoldToParty");
    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>AccrSrceDocSupplier</b>
     * </p>
     * 
     * @return The accrSrceDocSupplier contained in this {@link VdmComplex}.
     */
    @Nullable
    @ElementName( "AccrSrceDocSupplier" )
    private java.lang.String accrSrceDocSupplier;
    public final static com.sap.cloud.sdk.datamodel.odatav4.core.SimpleProperty.String<AccrualAmountsResult_Type> ACCR_SRCE_DOC_SUPPLIER =
        new com.sap.cloud.sdk.datamodel.odatav4.core.SimpleProperty.String<AccrualAmountsResult_Type>(
            AccrualAmountsResult_Type.class,
            "AccrSrceDocSupplier");
    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>AccrSrceDocSupplyingSupplier</b>
     * </p>
     * 
     * @return The accrSrceDocSupplyingSupplier contained in this {@link VdmComplex}.
     */
    @Nullable
    @ElementName( "AccrSrceDocSupplyingSupplier" )
    private java.lang.String accrSrceDocSupplyingSupplier;
    public final static com.sap.cloud.sdk.datamodel.odatav4.core.SimpleProperty.String<AccrualAmountsResult_Type> ACCR_SRCE_DOC_SUPPLYING_SUPPLIER =
        new com.sap.cloud.sdk.datamodel.odatav4.core.SimpleProperty.String<AccrualAmountsResult_Type>(
            AccrualAmountsResult_Type.class,
            "AccrSrceDocSupplyingSupplier");
    /**
     * Constraints: Not nullable, Precision: 13, Scale: 0
     * <p>
     * Original property name from the Odata EDM: <b>AccrualsOpenAmount</b>
     * </p>
     * 
     * @return The accrualsOpenAmount contained in this {@link VdmComplex}.
     */
    @Nullable
    @ElementName( "AccrualsOpenAmount" )
    @DecimalDescriptor( precision = 13, scale = 0 )
    private BigDecimal accrualsOpenAmount;
    public final static com.sap.cloud.sdk.datamodel.odatav4.core.SimpleProperty.NumericDecimal<AccrualAmountsResult_Type> ACCRUALS_OPEN_AMOUNT =
        new com.sap.cloud.sdk.datamodel.odatav4.core.SimpleProperty.NumericDecimal<AccrualAmountsResult_Type>(
            AccrualAmountsResult_Type.class,
            "AccrualsOpenAmount");
    /**
     * Constraints: Not nullable, Precision: 13, Scale: 0
     * <p>
     * Original property name from the Odata EDM: <b>AccrualsReversedAmount</b>
     * </p>
     * 
     * @return The accrualsReversedAmount contained in this {@link VdmComplex}.
     */
    @Nullable
    @ElementName( "AccrualsReversedAmount" )
    @DecimalDescriptor( precision = 13, scale = 0 )
    private BigDecimal accrualsReversedAmount;
    public final static com.sap.cloud.sdk.datamodel.odatav4.core.SimpleProperty.NumericDecimal<AccrualAmountsResult_Type> ACCRUALS_REVERSED_AMOUNT =
        new com.sap.cloud.sdk.datamodel.odatav4.core.SimpleProperty.NumericDecimal<AccrualAmountsResult_Type>(
            AccrualAmountsResult_Type.class,
            "AccrualsReversedAmount");
    /**
     * Constraints: Not nullable, Precision: 13, Scale: 0
     * <p>
     * Original property name from the Odata EDM: <b>AccrualsTotalAmount</b>
     * </p>
     * 
     * @return The accrualsTotalAmount contained in this {@link VdmComplex}.
     */
    @Nullable
    @ElementName( "AccrualsTotalAmount" )
    @DecimalDescriptor( precision = 13, scale = 0 )
    private BigDecimal accrualsTotalAmount;
    public final static com.sap.cloud.sdk.datamodel.odatav4.core.SimpleProperty.NumericDecimal<AccrualAmountsResult_Type> ACCRUALS_TOTAL_AMOUNT =
        new com.sap.cloud.sdk.datamodel.odatav4.core.SimpleProperty.NumericDecimal<AccrualAmountsResult_Type>(
            AccrualAmountsResult_Type.class,
            "AccrualsTotalAmount");
    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>ConditionApplication</b>
     * </p>
     * 
     * @return The conditionApplication contained in this {@link VdmComplex}.
     */
    @Nullable
    @ElementName( "ConditionApplication" )
    private java.lang.String conditionApplication;
    public final static com.sap.cloud.sdk.datamodel.odatav4.core.SimpleProperty.String<AccrualAmountsResult_Type> CONDITION_APPLICATION =
        new com.sap.cloud.sdk.datamodel.odatav4.core.SimpleProperty.String<AccrualAmountsResult_Type>(
            AccrualAmountsResult_Type.class,
            "ConditionApplication");
    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>ConditionContract</b>
     * </p>
     * 
     * @return The conditionContract contained in this {@link VdmComplex}.
     */
    @Nullable
    @ElementName( "ConditionContract" )
    private java.lang.String conditionContract;
    public final static com.sap.cloud.sdk.datamodel.odatav4.core.SimpleProperty.String<AccrualAmountsResult_Type> CONDITION_CONTRACT =
        new com.sap.cloud.sdk.datamodel.odatav4.core.SimpleProperty.String<AccrualAmountsResult_Type>(
            AccrualAmountsResult_Type.class,
            "ConditionContract");
    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>ConditionRecord</b>
     * </p>
     * 
     * @return The conditionRecord contained in this {@link VdmComplex}.
     */
    @Nullable
    @ElementName( "ConditionRecord" )
    private java.lang.String conditionRecord;
    public final static com.sap.cloud.sdk.datamodel.odatav4.core.SimpleProperty.String<AccrualAmountsResult_Type> CONDITION_RECORD =
        new com.sap.cloud.sdk.datamodel.odatav4.core.SimpleProperty.String<AccrualAmountsResult_Type>(
            AccrualAmountsResult_Type.class,
            "ConditionRecord");
    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>ConditionType</b>
     * </p>
     * 
     * @return The conditionType contained in this {@link VdmComplex}.
     */
    @Nullable
    @ElementName( "ConditionType" )
    private java.lang.String conditionType;
    public final static com.sap.cloud.sdk.datamodel.odatav4.core.SimpleProperty.String<AccrualAmountsResult_Type> CONDITION_TYPE =
        new com.sap.cloud.sdk.datamodel.odatav4.core.SimpleProperty.String<AccrualAmountsResult_Type>(
            AccrualAmountsResult_Type.class,
            "ConditionType");

    /**
     * {@inheritDoc}
     * 
     */
    @Nonnull
    @Override
    public Class<AccrualAmountsResult_Type> getType()
    {
        return AccrualAmountsResult_Type.class;
    }

    @Nonnull
    @Override
    protected Map<java.lang.String, Object> toMapOfFields()
    {
        final Map<java.lang.String, Object> values = super.toMapOfFields();
        values.put("AccrSrceDocCurrency", getAccrSrceDocCurrency());
        values.put("AccrSrceDocDistributionChannel", getAccrSrceDocDistributionChannel());
        values.put("AccrSrceDocDivision", getAccrSrceDocDivision());
        values.put("AccrSrceDocItemProduct", getAccrSrceDocItemProduct());
        values.put("AccrSrceDocPayerParty", getAccrSrceDocPayerParty());
        values.put("AccrSrceDocPostingDate", getAccrSrceDocPostingDate());
        values.put("AccrSrceDocPostingHalfYear", getAccrSrceDocPostingHalfYear());
        values.put("AccrSrceDocPostingMonth", getAccrSrceDocPostingMonth());
        values.put("AccrSrceDocPostingQuarter", getAccrSrceDocPostingQuarter());
        values.put("AccrSrceDocPostingWeek", getAccrSrceDocPostingWeek());
        values.put("AccrSrceDocPostingYear", getAccrSrceDocPostingYear());
        values.put("AccrSrceDocPurgGroup", getAccrSrceDocPurgGroup());
        values.put("AccrSrceDocPurgOrganization", getAccrSrceDocPurgOrganization());
        values.put("AccrSrceDocSalesOrganization", getAccrSrceDocSalesOrganization());
        values.put("AccrSrceDocSoldToParty", getAccrSrceDocSoldToParty());
        values.put("AccrSrceDocSupplier", getAccrSrceDocSupplier());
        values.put("AccrSrceDocSupplyingSupplier", getAccrSrceDocSupplyingSupplier());
        values.put("AccrualsOpenAmount", getAccrualsOpenAmount());
        values.put("AccrualsReversedAmount", getAccrualsReversedAmount());
        values.put("AccrualsTotalAmount", getAccrualsTotalAmount());
        values.put("ConditionApplication", getConditionApplication());
        values.put("ConditionContract", getConditionContract());
        values.put("ConditionRecord", getConditionRecord());
        values.put("ConditionType", getConditionType());
        return values;
    }

    @Override
    protected void fromMap( final Map<java.lang.String, Object> inputValues )
    {
        final Map<java.lang.String, Object> values = Maps.newHashMap(inputValues);
        // simple properties
        {
            if( values.containsKey("AccrSrceDocCurrency") ) {
                final Object value = values.remove("AccrSrceDocCurrency");
                if( (value == null) || (!value.equals(getAccrSrceDocCurrency())) ) {
                    setAccrSrceDocCurrency(((java.lang.String) value));
                }
            }
            if( values.containsKey("AccrSrceDocDistributionChannel") ) {
                final Object value = values.remove("AccrSrceDocDistributionChannel");
                if( (value == null) || (!value.equals(getAccrSrceDocDistributionChannel())) ) {
                    setAccrSrceDocDistributionChannel(((java.lang.String) value));
                }
            }
            if( values.containsKey("AccrSrceDocDivision") ) {
                final Object value = values.remove("AccrSrceDocDivision");
                if( (value == null) || (!value.equals(getAccrSrceDocDivision())) ) {
                    setAccrSrceDocDivision(((java.lang.String) value));
                }
            }
            if( values.containsKey("AccrSrceDocItemProduct") ) {
                final Object value = values.remove("AccrSrceDocItemProduct");
                if( (value == null) || (!value.equals(getAccrSrceDocItemProduct())) ) {
                    setAccrSrceDocItemProduct(((java.lang.String) value));
                }
            }
            if( values.containsKey("AccrSrceDocPayerParty") ) {
                final Object value = values.remove("AccrSrceDocPayerParty");
                if( (value == null) || (!value.equals(getAccrSrceDocPayerParty())) ) {
                    setAccrSrceDocPayerParty(((java.lang.String) value));
                }
            }
            if( values.containsKey("AccrSrceDocPostingDate") ) {
                final Object value = values.remove("AccrSrceDocPostingDate");
                if( (value == null) || (!value.equals(getAccrSrceDocPostingDate())) ) {
                    setAccrSrceDocPostingDate(((LocalDate) value));
                }
            }
            if( values.containsKey("AccrSrceDocPostingHalfYear") ) {
                final Object value = values.remove("AccrSrceDocPostingHalfYear");
                if( (value == null) || (!value.equals(getAccrSrceDocPostingHalfYear())) ) {
                    setAccrSrceDocPostingHalfYear(((java.lang.String) value));
                }
            }
            if( values.containsKey("AccrSrceDocPostingMonth") ) {
                final Object value = values.remove("AccrSrceDocPostingMonth");
                if( (value == null) || (!value.equals(getAccrSrceDocPostingMonth())) ) {
                    setAccrSrceDocPostingMonth(((java.lang.String) value));
                }
            }
            if( values.containsKey("AccrSrceDocPostingQuarter") ) {
                final Object value = values.remove("AccrSrceDocPostingQuarter");
                if( (value == null) || (!value.equals(getAccrSrceDocPostingQuarter())) ) {
                    setAccrSrceDocPostingQuarter(((java.lang.String) value));
                }
            }
            if( values.containsKey("AccrSrceDocPostingWeek") ) {
                final Object value = values.remove("AccrSrceDocPostingWeek");
                if( (value == null) || (!value.equals(getAccrSrceDocPostingWeek())) ) {
                    setAccrSrceDocPostingWeek(((java.lang.String) value));
                }
            }
            if( values.containsKey("AccrSrceDocPostingYear") ) {
                final Object value = values.remove("AccrSrceDocPostingYear");
                if( (value == null) || (!value.equals(getAccrSrceDocPostingYear())) ) {
                    setAccrSrceDocPostingYear(((java.lang.String) value));
                }
            }
            if( values.containsKey("AccrSrceDocPurgGroup") ) {
                final Object value = values.remove("AccrSrceDocPurgGroup");
                if( (value == null) || (!value.equals(getAccrSrceDocPurgGroup())) ) {
                    setAccrSrceDocPurgGroup(((java.lang.String) value));
                }
            }
            if( values.containsKey("AccrSrceDocPurgOrganization") ) {
                final Object value = values.remove("AccrSrceDocPurgOrganization");
                if( (value == null) || (!value.equals(getAccrSrceDocPurgOrganization())) ) {
                    setAccrSrceDocPurgOrganization(((java.lang.String) value));
                }
            }
            if( values.containsKey("AccrSrceDocSalesOrganization") ) {
                final Object value = values.remove("AccrSrceDocSalesOrganization");
                if( (value == null) || (!value.equals(getAccrSrceDocSalesOrganization())) ) {
                    setAccrSrceDocSalesOrganization(((java.lang.String) value));
                }
            }
            if( values.containsKey("AccrSrceDocSoldToParty") ) {
                final Object value = values.remove("AccrSrceDocSoldToParty");
                if( (value == null) || (!value.equals(getAccrSrceDocSoldToParty())) ) {
                    setAccrSrceDocSoldToParty(((java.lang.String) value));
                }
            }
            if( values.containsKey("AccrSrceDocSupplier") ) {
                final Object value = values.remove("AccrSrceDocSupplier");
                if( (value == null) || (!value.equals(getAccrSrceDocSupplier())) ) {
                    setAccrSrceDocSupplier(((java.lang.String) value));
                }
            }
            if( values.containsKey("AccrSrceDocSupplyingSupplier") ) {
                final Object value = values.remove("AccrSrceDocSupplyingSupplier");
                if( (value == null) || (!value.equals(getAccrSrceDocSupplyingSupplier())) ) {
                    setAccrSrceDocSupplyingSupplier(((java.lang.String) value));
                }
            }
            if( values.containsKey("AccrualsOpenAmount") ) {
                final Object value = values.remove("AccrualsOpenAmount");
                if( (value == null) || (!value.equals(getAccrualsOpenAmount())) ) {
                    setAccrualsOpenAmount(((BigDecimal) value));
                }
            }
            if( values.containsKey("AccrualsReversedAmount") ) {
                final Object value = values.remove("AccrualsReversedAmount");
                if( (value == null) || (!value.equals(getAccrualsReversedAmount())) ) {
                    setAccrualsReversedAmount(((BigDecimal) value));
                }
            }
            if( values.containsKey("AccrualsTotalAmount") ) {
                final Object value = values.remove("AccrualsTotalAmount");
                if( (value == null) || (!value.equals(getAccrualsTotalAmount())) ) {
                    setAccrualsTotalAmount(((BigDecimal) value));
                }
            }
            if( values.containsKey("ConditionApplication") ) {
                final Object value = values.remove("ConditionApplication");
                if( (value == null) || (!value.equals(getConditionApplication())) ) {
                    setConditionApplication(((java.lang.String) value));
                }
            }
            if( values.containsKey("ConditionContract") ) {
                final Object value = values.remove("ConditionContract");
                if( (value == null) || (!value.equals(getConditionContract())) ) {
                    setConditionContract(((java.lang.String) value));
                }
            }
            if( values.containsKey("ConditionRecord") ) {
                final Object value = values.remove("ConditionRecord");
                if( (value == null) || (!value.equals(getConditionRecord())) ) {
                    setConditionRecord(((java.lang.String) value));
                }
            }
            if( values.containsKey("ConditionType") ) {
                final Object value = values.remove("ConditionType");
                if( (value == null) || (!value.equals(getConditionType())) ) {
                    setConditionType(((java.lang.String) value));
                }
            }
        }
        // structured properties
        {
        }
        // navigation properties
        {
        }
        super.fromMap(values);
    }

    @Nonnull
    @Override
    protected ODataEntityKey getKey()
    {
        final ODataEntityKey entityKey = super.getKey();
        return entityKey;
    }

    /**
     * Constraints: Not nullable, Maximum length: 5
     * <p>
     * Original property name from the Odata EDM: <b>AccrSrceDocCurrency</b>
     * </p>
     * 
     * @param accrSrceDocCurrency
     *            The accrSrceDocCurrency to set.
     */
    public void setAccrSrceDocCurrency( @Nullable final java.lang.String accrSrceDocCurrency )
    {
        rememberChangedField("AccrSrceDocCurrency", this.accrSrceDocCurrency);
        this.accrSrceDocCurrency = accrSrceDocCurrency;
    }

    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>AccrSrceDocDistributionChannel</b>
     * </p>
     * 
     * @param accrSrceDocDistributionChannel
     *            The accrSrceDocDistributionChannel to set.
     */
    public void setAccrSrceDocDistributionChannel( @Nullable final java.lang.String accrSrceDocDistributionChannel )
    {
        rememberChangedField("AccrSrceDocDistributionChannel", this.accrSrceDocDistributionChannel);
        this.accrSrceDocDistributionChannel = accrSrceDocDistributionChannel;
    }

    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>AccrSrceDocDivision</b>
     * </p>
     * 
     * @param accrSrceDocDivision
     *            The accrSrceDocDivision to set.
     */
    public void setAccrSrceDocDivision( @Nullable final java.lang.String accrSrceDocDivision )
    {
        rememberChangedField("AccrSrceDocDivision", this.accrSrceDocDivision);
        this.accrSrceDocDivision = accrSrceDocDivision;
    }

    /**
     * Constraints: Not nullable, Maximum length: 40
     * <p>
     * Original property name from the Odata EDM: <b>AccrSrceDocItemProduct</b>
     * </p>
     * 
     * @param accrSrceDocItemProduct
     *            The accrSrceDocItemProduct to set.
     */
    public void setAccrSrceDocItemProduct( @Nullable final java.lang.String accrSrceDocItemProduct )
    {
        rememberChangedField("AccrSrceDocItemProduct", this.accrSrceDocItemProduct);
        this.accrSrceDocItemProduct = accrSrceDocItemProduct;
    }

    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>AccrSrceDocPayerParty</b>
     * </p>
     * 
     * @param accrSrceDocPayerParty
     *            The accrSrceDocPayerParty to set.
     */
    public void setAccrSrceDocPayerParty( @Nullable final java.lang.String accrSrceDocPayerParty )
    {
        rememberChangedField("AccrSrceDocPayerParty", this.accrSrceDocPayerParty);
        this.accrSrceDocPayerParty = accrSrceDocPayerParty;
    }

    /**
     * Constraints: Nullable
     * <p>
     * Original property name from the Odata EDM: <b>AccrSrceDocPostingDate</b>
     * </p>
     * 
     * @param accrSrceDocPostingDate
     *            The accrSrceDocPostingDate to set.
     */
    public void setAccrSrceDocPostingDate( @Nullable final LocalDate accrSrceDocPostingDate )
    {
        rememberChangedField("AccrSrceDocPostingDate", this.accrSrceDocPostingDate);
        this.accrSrceDocPostingDate = accrSrceDocPostingDate;
    }

    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>AccrSrceDocPostingHalfYear</b>
     * </p>
     * 
     * @param accrSrceDocPostingHalfYear
     *            The accrSrceDocPostingHalfYear to set.
     */
    public void setAccrSrceDocPostingHalfYear( @Nullable final java.lang.String accrSrceDocPostingHalfYear )
    {
        rememberChangedField("AccrSrceDocPostingHalfYear", this.accrSrceDocPostingHalfYear);
        this.accrSrceDocPostingHalfYear = accrSrceDocPostingHalfYear;
    }

    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>AccrSrceDocPostingMonth</b>
     * </p>
     * 
     * @param accrSrceDocPostingMonth
     *            The accrSrceDocPostingMonth to set.
     */
    public void setAccrSrceDocPostingMonth( @Nullable final java.lang.String accrSrceDocPostingMonth )
    {
        rememberChangedField("AccrSrceDocPostingMonth", this.accrSrceDocPostingMonth);
        this.accrSrceDocPostingMonth = accrSrceDocPostingMonth;
    }

    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>AccrSrceDocPostingQuarter</b>
     * </p>
     * 
     * @param accrSrceDocPostingQuarter
     *            The accrSrceDocPostingQuarter to set.
     */
    public void setAccrSrceDocPostingQuarter( @Nullable final java.lang.String accrSrceDocPostingQuarter )
    {
        rememberChangedField("AccrSrceDocPostingQuarter", this.accrSrceDocPostingQuarter);
        this.accrSrceDocPostingQuarter = accrSrceDocPostingQuarter;
    }

    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>AccrSrceDocPostingWeek</b>
     * </p>
     * 
     * @param accrSrceDocPostingWeek
     *            The accrSrceDocPostingWeek to set.
     */
    public void setAccrSrceDocPostingWeek( @Nullable final java.lang.String accrSrceDocPostingWeek )
    {
        rememberChangedField("AccrSrceDocPostingWeek", this.accrSrceDocPostingWeek);
        this.accrSrceDocPostingWeek = accrSrceDocPostingWeek;
    }

    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>AccrSrceDocPostingYear</b>
     * </p>
     * 
     * @param accrSrceDocPostingYear
     *            The accrSrceDocPostingYear to set.
     */
    public void setAccrSrceDocPostingYear( @Nullable final java.lang.String accrSrceDocPostingYear )
    {
        rememberChangedField("AccrSrceDocPostingYear", this.accrSrceDocPostingYear);
        this.accrSrceDocPostingYear = accrSrceDocPostingYear;
    }

    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>AccrSrceDocPurgGroup</b>
     * </p>
     * 
     * @param accrSrceDocPurgGroup
     *            The accrSrceDocPurgGroup to set.
     */
    public void setAccrSrceDocPurgGroup( @Nullable final java.lang.String accrSrceDocPurgGroup )
    {
        rememberChangedField("AccrSrceDocPurgGroup", this.accrSrceDocPurgGroup);
        this.accrSrceDocPurgGroup = accrSrceDocPurgGroup;
    }

    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>AccrSrceDocPurgOrganization</b>
     * </p>
     * 
     * @param accrSrceDocPurgOrganization
     *            The accrSrceDocPurgOrganization to set.
     */
    public void setAccrSrceDocPurgOrganization( @Nullable final java.lang.String accrSrceDocPurgOrganization )
    {
        rememberChangedField("AccrSrceDocPurgOrganization", this.accrSrceDocPurgOrganization);
        this.accrSrceDocPurgOrganization = accrSrceDocPurgOrganization;
    }

    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>AccrSrceDocSalesOrganization</b>
     * </p>
     * 
     * @param accrSrceDocSalesOrganization
     *            The accrSrceDocSalesOrganization to set.
     */
    public void setAccrSrceDocSalesOrganization( @Nullable final java.lang.String accrSrceDocSalesOrganization )
    {
        rememberChangedField("AccrSrceDocSalesOrganization", this.accrSrceDocSalesOrganization);
        this.accrSrceDocSalesOrganization = accrSrceDocSalesOrganization;
    }

    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>AccrSrceDocSoldToParty</b>
     * </p>
     * 
     * @param accrSrceDocSoldToParty
     *            The accrSrceDocSoldToParty to set.
     */
    public void setAccrSrceDocSoldToParty( @Nullable final java.lang.String accrSrceDocSoldToParty )
    {
        rememberChangedField("AccrSrceDocSoldToParty", this.accrSrceDocSoldToParty);
        this.accrSrceDocSoldToParty = accrSrceDocSoldToParty;
    }

    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>AccrSrceDocSupplier</b>
     * </p>
     * 
     * @param accrSrceDocSupplier
     *            The accrSrceDocSupplier to set.
     */
    public void setAccrSrceDocSupplier( @Nullable final java.lang.String accrSrceDocSupplier )
    {
        rememberChangedField("AccrSrceDocSupplier", this.accrSrceDocSupplier);
        this.accrSrceDocSupplier = accrSrceDocSupplier;
    }

    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>AccrSrceDocSupplyingSupplier</b>
     * </p>
     * 
     * @param accrSrceDocSupplyingSupplier
     *            The accrSrceDocSupplyingSupplier to set.
     */
    public void setAccrSrceDocSupplyingSupplier( @Nullable final java.lang.String accrSrceDocSupplyingSupplier )
    {
        rememberChangedField("AccrSrceDocSupplyingSupplier", this.accrSrceDocSupplyingSupplier);
        this.accrSrceDocSupplyingSupplier = accrSrceDocSupplyingSupplier;
    }

    /**
     * Constraints: Not nullable, Precision: 13, Scale: 0
     * <p>
     * Original property name from the Odata EDM: <b>AccrualsOpenAmount</b>
     * </p>
     * 
     * @param accrualsOpenAmount
     *            The accrualsOpenAmount to set.
     */
    public void setAccrualsOpenAmount( @Nullable final BigDecimal accrualsOpenAmount )
    {
        rememberChangedField("AccrualsOpenAmount", this.accrualsOpenAmount);
        this.accrualsOpenAmount = accrualsOpenAmount;
    }

    /**
     * Constraints: Not nullable, Precision: 13, Scale: 0
     * <p>
     * Original property name from the Odata EDM: <b>AccrualsReversedAmount</b>
     * </p>
     * 
     * @param accrualsReversedAmount
     *            The accrualsReversedAmount to set.
     */
    public void setAccrualsReversedAmount( @Nullable final BigDecimal accrualsReversedAmount )
    {
        rememberChangedField("AccrualsReversedAmount", this.accrualsReversedAmount);
        this.accrualsReversedAmount = accrualsReversedAmount;
    }

    /**
     * Constraints: Not nullable, Precision: 13, Scale: 0
     * <p>
     * Original property name from the Odata EDM: <b>AccrualsTotalAmount</b>
     * </p>
     * 
     * @param accrualsTotalAmount
     *            The accrualsTotalAmount to set.
     */
    public void setAccrualsTotalAmount( @Nullable final BigDecimal accrualsTotalAmount )
    {
        rememberChangedField("AccrualsTotalAmount", this.accrualsTotalAmount);
        this.accrualsTotalAmount = accrualsTotalAmount;
    }

    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>ConditionApplication</b>
     * </p>
     * 
     * @param conditionApplication
     *            The conditionApplication to set.
     */
    public void setConditionApplication( @Nullable final java.lang.String conditionApplication )
    {
        rememberChangedField("ConditionApplication", this.conditionApplication);
        this.conditionApplication = conditionApplication;
    }

    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>ConditionContract</b>
     * </p>
     * 
     * @param conditionContract
     *            The conditionContract to set.
     */
    public void setConditionContract( @Nullable final java.lang.String conditionContract )
    {
        rememberChangedField("ConditionContract", this.conditionContract);
        this.conditionContract = conditionContract;
    }

    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>ConditionRecord</b>
     * </p>
     * 
     * @param conditionRecord
     *            The conditionRecord to set.
     */
    public void setConditionRecord( @Nullable final java.lang.String conditionRecord )
    {
        rememberChangedField("ConditionRecord", this.conditionRecord);
        this.conditionRecord = conditionRecord;
    }

    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>ConditionType</b>
     * </p>
     * 
     * @param conditionType
     *            The conditionType to set.
     */
    public void setConditionType( @Nullable final java.lang.String conditionType )
    {
        rememberChangedField("ConditionType", this.conditionType);
        this.conditionType = conditionType;
    }

}
