/*
 * Copyright (c) 2021 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odatav4.namespaces.conditioncontract;

import java.time.LocalDate;
import java.util.Map;
import java.util.UUID;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;

import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.google.common.collect.Maps;
import com.google.gson.annotations.JsonAdapter;
import com.sap.cloud.sdk.datamodel.odata.client.request.ODataEntityKey;
import com.sap.cloud.sdk.datamodel.odatav4.core.SimpleProperty;
import com.sap.cloud.sdk.datamodel.odatav4.core.VdmEntity;
import com.sap.cloud.sdk.datamodel.odatav4.core.VdmEntitySet;
import com.sap.cloud.sdk.result.ElementName;
import com.sap.cloud.sdk.s4hana.datamodel.odatav4.services.ConditionContractService;

import io.vavr.control.Option;
import lombok.AccessLevel;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.Getter;
import lombok.NoArgsConstructor;
import lombok.Setter;
import lombok.ToString;

/**
 * Business Volume Selection Criteria
 * <p>
 * </p>
 * <p>
 * Original entity name from the Odata EDM: <b>BusVolSelectionCriteriaType</b>
 * </p>
 * 
 */
@Builder
@Data
@NoArgsConstructor
@AllArgsConstructor
@ToString( doNotUseGetters = true, callSuper = true )
@EqualsAndHashCode( doNotUseGetters = true, callSuper = true )
@JsonAdapter( com.sap.cloud.sdk.datamodel.odatav4.adapter.GsonVdmAdapterFactory.class )
@JsonSerialize( using = com.sap.cloud.sdk.datamodel.odatav4.adapter.JacksonVdmObjectSerializer.class )
@JsonDeserialize( using = com.sap.cloud.sdk.datamodel.odatav4.adapter.JacksonVdmObjectDeserializer.class )
public class BusVolSelectionCriteria extends VdmEntity<BusVolSelectionCriteria> implements VdmEntitySet
{

    @Getter
    private final java.lang.String odataType =
        "com.sap.gateway.srvd_a2x.api_condition_contract.v0001.BusVolSelectionCriteriaType";
    /**
     * Selector for all available fields of BusVolSelectionCriteria.
     * 
     */
    public final static SimpleProperty<BusVolSelectionCriteria> ALL_FIELDS = all();
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>ConditionContract</b>
     * </p>
     * 
     * @return Condition Contract
     */
    @Nullable
    @ElementName( "ConditionContract" )
    private java.lang.String conditionContract;
    public final static SimpleProperty.String<BusVolSelectionCriteria> CONDITION_CONTRACT =
        new SimpleProperty.String<BusVolSelectionCriteria>(BusVolSelectionCriteria.class, "ConditionContract");
    /**
     * (Key Field) Constraints: Not nullable
     * <p>
     * Original property name from the Odata EDM: <b>CndnContrBusVolUUID</b>
     * </p>
     * 
     * @return Condition Contract: Business volume base item GUID
     */
    @Nullable
    @ElementName( "CndnContrBusVolUUID" )
    private UUID cndnContrBusVolUUID;
    public final static SimpleProperty.Guid<BusVolSelectionCriteria> CNDN_CONTR_BUS_VOL_UUID =
        new SimpleProperty.Guid<BusVolSelectionCriteria>(BusVolSelectionCriteria.class, "CndnContrBusVolUUID");
    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>BusVolFieldCombnType</b>
     * </p>
     * 
     * @return Field Combination for Business Volume Selection
     */
    @Nullable
    @ElementName( "BusVolFieldCombnType" )
    private java.lang.String busVolFieldCombnType;
    public final static SimpleProperty.String<BusVolSelectionCriteria> BUS_VOL_FIELD_COMBN_TYPE =
        new SimpleProperty.String<BusVolSelectionCriteria>(BusVolSelectionCriteria.class, "BusVolFieldCombnType");
    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>BusVolFldCombnGroup</b>
     * </p>
     * 
     * @return Field Combination Group for Business Volume Selection in BVB
     */
    @Nullable
    @ElementName( "BusVolFldCombnGroup" )
    private java.lang.String busVolFldCombnGroup;
    public final static SimpleProperty.String<BusVolSelectionCriteria> BUS_VOL_FLD_COMBN_GROUP =
        new SimpleProperty.String<BusVolSelectionCriteria>(BusVolSelectionCriteria.class, "BusVolFldCombnGroup");
    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>CndnContrBusVolSign</b>
     * </p>
     * 
     * @return Status Including / Excluding
     */
    @Nullable
    @ElementName( "CndnContrBusVolSign" )
    private java.lang.String cndnContrBusVolSign;
    public final static SimpleProperty.String<BusVolSelectionCriteria> CNDN_CONTR_BUS_VOL_SIGN =
        new SimpleProperty.String<BusVolSelectionCriteria>(BusVolSelectionCriteria.class, "CndnContrBusVolSign");
    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>BusVolSelectionGroup</b>
     * </p>
     * 
     * @return Selection Group
     */
    @Nullable
    @ElementName( "BusVolSelectionGroup" )
    private java.lang.String busVolSelectionGroup;
    public final static SimpleProperty.String<BusVolSelectionCriteria> BUS_VOL_SELECTION_GROUP =
        new SimpleProperty.String<BusVolSelectionCriteria>(BusVolSelectionCriteria.class, "BusVolSelectionGroup");
    /**
     * Constraints: Nullable
     * <p>
     * Original property name from the Odata EDM: <b>CndnContrBusVolValidFrom</b>
     * </p>
     * 
     * @return Valid from
     */
    @Nullable
    @ElementName( "CndnContrBusVolValidFrom" )
    private LocalDate cndnContrBusVolValidFrom;
    public final static SimpleProperty.Date<BusVolSelectionCriteria> CNDN_CONTR_BUS_VOL_VALID_FROM =
        new SimpleProperty.Date<BusVolSelectionCriteria>(BusVolSelectionCriteria.class, "CndnContrBusVolValidFrom");
    /**
     * Constraints: Nullable
     * <p>
     * Original property name from the Odata EDM: <b>CndnContrBusVolValidTo</b>
     * </p>
     * 
     * @return Valid to
     */
    @Nullable
    @ElementName( "CndnContrBusVolValidTo" )
    private LocalDate cndnContrBusVolValidTo;
    public final static SimpleProperty.Date<BusVolSelectionCriteria> CNDN_CONTR_BUS_VOL_VALID_TO =
        new SimpleProperty.Date<BusVolSelectionCriteria>(BusVolSelectionCriteria.class, "CndnContrBusVolValidTo");
    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>Supplier</b>
     * </p>
     * 
     * @return Account Number of Supplier
     */
    @Nullable
    @ElementName( "Supplier" )
    private java.lang.String supplier;
    public final static SimpleProperty.String<BusVolSelectionCriteria> SUPPLIER =
        new SimpleProperty.String<BusVolSelectionCriteria>(BusVolSelectionCriteria.class, "Supplier");
    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>Customer</b>
     * </p>
     * 
     * @return Customer Number
     */
    @Nullable
    @ElementName( "Customer" )
    private java.lang.String customer;
    public final static SimpleProperty.String<BusVolSelectionCriteria> CUSTOMER =
        new SimpleProperty.String<BusVolSelectionCriteria>(BusVolSelectionCriteria.class, "Customer");
    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>PurchasingOrganization</b>
     * </p>
     * 
     * @return Purchasing Organization
     */
    @Nullable
    @ElementName( "PurchasingOrganization" )
    private java.lang.String purchasingOrganization;
    public final static SimpleProperty.String<BusVolSelectionCriteria> PURCHASING_ORGANIZATION =
        new SimpleProperty.String<BusVolSelectionCriteria>(BusVolSelectionCriteria.class, "PurchasingOrganization");
    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>PurchasingGroup</b>
     * </p>
     * 
     * @return Purchasing Group
     */
    @Nullable
    @ElementName( "PurchasingGroup" )
    private java.lang.String purchasingGroup;
    public final static SimpleProperty.String<BusVolSelectionCriteria> PURCHASING_GROUP =
        new SimpleProperty.String<BusVolSelectionCriteria>(BusVolSelectionCriteria.class, "PurchasingGroup");
    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>SalesOrganization</b>
     * </p>
     * 
     * @return Sales Organization
     */
    @Nullable
    @ElementName( "SalesOrganization" )
    private java.lang.String salesOrganization;
    public final static SimpleProperty.String<BusVolSelectionCriteria> SALES_ORGANIZATION =
        new SimpleProperty.String<BusVolSelectionCriteria>(BusVolSelectionCriteria.class, "SalesOrganization");
    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>DistributionChannel</b>
     * </p>
     * 
     * @return Distribution Channel
     */
    @Nullable
    @ElementName( "DistributionChannel" )
    private java.lang.String distributionChannel;
    public final static SimpleProperty.String<BusVolSelectionCriteria> DISTRIBUTION_CHANNEL =
        new SimpleProperty.String<BusVolSelectionCriteria>(BusVolSelectionCriteria.class, "DistributionChannel");
    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>Division</b>
     * </p>
     * 
     * @return Division
     */
    @Nullable
    @ElementName( "Division" )
    private java.lang.String division;
    public final static SimpleProperty.String<BusVolSelectionCriteria> DIVISION =
        new SimpleProperty.String<BusVolSelectionCriteria>(BusVolSelectionCriteria.class, "Division");
    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>CompanyCode</b>
     * </p>
     * 
     * @return Company Code
     */
    @Nullable
    @ElementName( "CompanyCode" )
    private java.lang.String companyCode;
    public final static SimpleProperty.String<BusVolSelectionCriteria> COMPANY_CODE =
        new SimpleProperty.String<BusVolSelectionCriteria>(BusVolSelectionCriteria.class, "CompanyCode");
    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>Plant</b>
     * </p>
     * 
     * @return Plant
     */
    @Nullable
    @ElementName( "Plant" )
    private java.lang.String plant;
    public final static SimpleProperty.String<BusVolSelectionCriteria> PLANT =
        new SimpleProperty.String<BusVolSelectionCriteria>(BusVolSelectionCriteria.class, "Plant");
    /**
     * Constraints: Not nullable, Maximum length: 6
     * <p>
     * Original property name from the Odata EDM: <b>SupplierSubrange</b>
     * </p>
     * 
     * @return Supplier Subrange
     */
    @Nullable
    @ElementName( "SupplierSubrange" )
    private java.lang.String supplierSubrange;
    public final static SimpleProperty.String<BusVolSelectionCriteria> SUPPLIER_SUBRANGE =
        new SimpleProperty.String<BusVolSelectionCriteria>(BusVolSelectionCriteria.class, "SupplierSubrange");
    /**
     * Constraints: Not nullable, Maximum length: 9
     * <p>
     * Original property name from the Odata EDM: <b>ProductGroup</b>
     * </p>
     * 
     * @return Product Group
     */
    @Nullable
    @ElementName( "ProductGroup" )
    private java.lang.String productGroup;
    public final static SimpleProperty.String<BusVolSelectionCriteria> PRODUCT_GROUP =
        new SimpleProperty.String<BusVolSelectionCriteria>(BusVolSelectionCriteria.class, "ProductGroup");
    /**
     * Constraints: Not nullable, Maximum length: 18
     * <p>
     * Original property name from the Odata EDM: <b>Product</b>
     * </p>
     * 
     * @return Product Number
     */
    @Nullable
    @ElementName( "Product" )
    private java.lang.String product;
    public final static SimpleProperty.String<BusVolSelectionCriteria> PRODUCT =
        new SimpleProperty.String<BusVolSelectionCriteria>(BusVolSelectionCriteria.class, "Product");
    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>ProductType</b>
     * </p>
     * 
     * @return Product Type
     */
    @Nullable
    @ElementName( "ProductType" )
    private java.lang.String productType;
    public final static SimpleProperty.String<BusVolSelectionCriteria> PRODUCT_TYPE =
        new SimpleProperty.String<BusVolSelectionCriteria>(BusVolSelectionCriteria.class, "ProductType");
    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>CustomerHierarchy</b>
     * </p>
     * 
     * @return Customer Hierarchy
     */
    @Nullable
    @ElementName( "CustomerHierarchy" )
    private java.lang.String customerHierarchy;
    public final static SimpleProperty.String<BusVolSelectionCriteria> CUSTOMER_HIERARCHY =
        new SimpleProperty.String<BusVolSelectionCriteria>(BusVolSelectionCriteria.class, "CustomerHierarchy");
    /**
     * Constraints: Not nullable, Maximum length: 18
     * <p>
     * Original property name from the Odata EDM: <b>ProductHierarchy</b>
     * </p>
     * 
     * @return Product Hierarchy
     */
    @Nullable
    @ElementName( "ProductHierarchy" )
    private java.lang.String productHierarchy;
    public final static SimpleProperty.String<BusVolSelectionCriteria> PRODUCT_HIERARCHY =
        new SimpleProperty.String<BusVolSelectionCriteria>(BusVolSelectionCriteria.class, "ProductHierarchy");
    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>SalesSpcfcProductGroup1</b>
     * </p>
     * 
     * @return Sales-Specific Product Group 1
     */
    @Nullable
    @ElementName( "SalesSpcfcProductGroup1" )
    private java.lang.String salesSpcfcProductGroup1;
    public final static SimpleProperty.String<BusVolSelectionCriteria> SALES_SPCFC_PRODUCT_GROUP1 =
        new SimpleProperty.String<BusVolSelectionCriteria>(BusVolSelectionCriteria.class, "SalesSpcfcProductGroup1");
    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>SalesSpcfcProductGroup2</b>
     * </p>
     * 
     * @return Sales-Specific Product Group 2
     */
    @Nullable
    @ElementName( "SalesSpcfcProductGroup2" )
    private java.lang.String salesSpcfcProductGroup2;
    public final static SimpleProperty.String<BusVolSelectionCriteria> SALES_SPCFC_PRODUCT_GROUP2 =
        new SimpleProperty.String<BusVolSelectionCriteria>(BusVolSelectionCriteria.class, "SalesSpcfcProductGroup2");
    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>SalesSpcfcProductGroup3</b>
     * </p>
     * 
     * @return Sales-Specific Product Group 3
     */
    @Nullable
    @ElementName( "SalesSpcfcProductGroup3" )
    private java.lang.String salesSpcfcProductGroup3;
    public final static SimpleProperty.String<BusVolSelectionCriteria> SALES_SPCFC_PRODUCT_GROUP3 =
        new SimpleProperty.String<BusVolSelectionCriteria>(BusVolSelectionCriteria.class, "SalesSpcfcProductGroup3");
    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>SalesSpcfcProductGroup4</b>
     * </p>
     * 
     * @return Sales-Specific Product Group 4
     */
    @Nullable
    @ElementName( "SalesSpcfcProductGroup4" )
    private java.lang.String salesSpcfcProductGroup4;
    public final static SimpleProperty.String<BusVolSelectionCriteria> SALES_SPCFC_PRODUCT_GROUP4 =
        new SimpleProperty.String<BusVolSelectionCriteria>(BusVolSelectionCriteria.class, "SalesSpcfcProductGroup4");
    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>SalesSpcfcProductGroup5</b>
     * </p>
     * 
     * @return Sales-Specific Product Group 5
     */
    @Nullable
    @ElementName( "SalesSpcfcProductGroup5" )
    private java.lang.String salesSpcfcProductGroup5;
    public final static SimpleProperty.String<BusVolSelectionCriteria> SALES_SPCFC_PRODUCT_GROUP5 =
        new SimpleProperty.String<BusVolSelectionCriteria>(BusVolSelectionCriteria.class, "SalesSpcfcProductGroup5");
    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>SalesOrderReason</b>
     * </p>
     * 
     * @return Sales Document Reason
     */
    @Nullable
    @ElementName( "SalesOrderReason" )
    private java.lang.String salesOrderReason;
    public final static SimpleProperty.String<BusVolSelectionCriteria> SALES_ORDER_REASON =
        new SimpleProperty.String<BusVolSelectionCriteria>(BusVolSelectionCriteria.class, "SalesOrderReason");
    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>Manufacturer</b>
     * </p>
     * 
     * @return Manufacturer number
     */
    @Nullable
    @ElementName( "Manufacturer" )
    private java.lang.String manufacturer;
    public final static SimpleProperty.String<BusVolSelectionCriteria> MANUFACTURER =
        new SimpleProperty.String<BusVolSelectionCriteria>(BusVolSelectionCriteria.class, "Manufacturer");
    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>RoyaltyRecipient</b>
     * </p>
     * 
     * @return Royalties Recipient
     */
    @Nullable
    @ElementName( "RoyaltyRecipient" )
    private java.lang.String royaltyRecipient;
    public final static SimpleProperty.String<BusVolSelectionCriteria> ROYALTY_RECIPIENT =
        new SimpleProperty.String<BusVolSelectionCriteria>(BusVolSelectionCriteria.class, "RoyaltyRecipient");
    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>CommissionRecipient</b>
     * </p>
     * 
     * @return Commission Recipient
     */
    @Nullable
    @ElementName( "CommissionRecipient" )
    private java.lang.String commissionRecipient;
    public final static SimpleProperty.String<BusVolSelectionCriteria> COMMISSION_RECIPIENT =
        new SimpleProperty.String<BusVolSelectionCriteria>(BusVolSelectionCriteria.class, "CommissionRecipient");
    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>ServiceDocumentType</b>
     * </p>
     * 
     * @return Service Document Type
     */
    @Nullable
    @ElementName( "ServiceDocumentType" )
    private java.lang.String serviceDocumentType;
    public final static SimpleProperty.String<BusVolSelectionCriteria> SERVICE_DOCUMENT_TYPE =
        new SimpleProperty.String<BusVolSelectionCriteria>(BusVolSelectionCriteria.class, "ServiceDocumentType");
    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>ServiceDocument</b>
     * </p>
     * 
     * @return Service Document ID
     */
    @Nullable
    @ElementName( "ServiceDocument" )
    private java.lang.String serviceDocument;
    public final static SimpleProperty.String<BusVolSelectionCriteria> SERVICE_DOCUMENT =
        new SimpleProperty.String<BusVolSelectionCriteria>(BusVolSelectionCriteria.class, "ServiceDocument");
    /**
     * Constraints: Not nullable, Maximum length: 6
     * <p>
     * Original property name from the Odata EDM: <b>ServiceDocumentItem</b>
     * </p>
     * 
     * @return Service Document Item ID
     */
    @Nullable
    @ElementName( "ServiceDocumentItem" )
    private java.lang.String serviceDocumentItem;
    public final static SimpleProperty.String<BusVolSelectionCriteria> SERVICE_DOCUMENT_ITEM =
        new SimpleProperty.String<BusVolSelectionCriteria>(BusVolSelectionCriteria.class, "ServiceDocumentItem");
    /**
     * Constraints: Nullable
     * <p>
     * Original property name from the Odata EDM: <b>CndnContrSourceBusVolUUID</b>
     * </p>
     * 
     * @return External BVB GUID
     */
    @Nullable
    @ElementName( "CndnContrSourceBusVolUUID" )
    private UUID cndnContrSourceBusVolUUID;
    public final static SimpleProperty.Guid<BusVolSelectionCriteria> CNDN_CONTR_SOURCE_BUS_VOL_UUID =
        new SimpleProperty.Guid<BusVolSelectionCriteria>(BusVolSelectionCriteria.class, "CndnContrSourceBusVolUUID");
    /**
     * Navigation property <b>_ConditionContract</b> for <b>BusVolSelectionCriteria</b> to single
     * <b>ConditionContract</b>.
     * 
     */
    @ElementName( "_ConditionContract" )
    @Nullable
    @Getter( AccessLevel.NONE )
    @Setter( AccessLevel.NONE )
    private ConditionContract to_ConditionContract;
    /**
     * Use with available request builders to apply the <b>_ConditionContract</b> navigation property to query
     * operations.
     * 
     */
    public final static com.sap.cloud.sdk.datamodel.odatav4.core.NavigationProperty.Single<BusVolSelectionCriteria, ConditionContract> TO__CONDITION_CONTRACT =
        new com.sap.cloud.sdk.datamodel.odatav4.core.NavigationProperty.Single<BusVolSelectionCriteria, ConditionContract>(
            BusVolSelectionCriteria.class,
            "_ConditionContract",
            ConditionContract.class);

    /**
     * {@inheritDoc}
     * 
     */
    @Nonnull
    @Override
    public Class<BusVolSelectionCriteria> getType()
    {
        return BusVolSelectionCriteria.class;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>ConditionContract</b>
     * </p>
     * 
     * @param conditionContract
     *            Condition Contract
     */
    public void setConditionContract( @Nullable final java.lang.String conditionContract )
    {
        rememberChangedField("ConditionContract", this.conditionContract);
        this.conditionContract = conditionContract;
    }

    /**
     * (Key Field) Constraints: Not nullable
     * <p>
     * Original property name from the Odata EDM: <b>CndnContrBusVolUUID</b>
     * </p>
     * 
     * @param cndnContrBusVolUUID
     *            Condition Contract: Business volume base item GUID
     */
    public void setCndnContrBusVolUUID( @Nullable final UUID cndnContrBusVolUUID )
    {
        rememberChangedField("CndnContrBusVolUUID", this.cndnContrBusVolUUID);
        this.cndnContrBusVolUUID = cndnContrBusVolUUID;
    }

    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>BusVolFieldCombnType</b>
     * </p>
     * 
     * @param busVolFieldCombnType
     *            Field Combination for Business Volume Selection
     */
    public void setBusVolFieldCombnType( @Nullable final java.lang.String busVolFieldCombnType )
    {
        rememberChangedField("BusVolFieldCombnType", this.busVolFieldCombnType);
        this.busVolFieldCombnType = busVolFieldCombnType;
    }

    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>BusVolFldCombnGroup</b>
     * </p>
     * 
     * @param busVolFldCombnGroup
     *            Field Combination Group for Business Volume Selection in BVB
     */
    public void setBusVolFldCombnGroup( @Nullable final java.lang.String busVolFldCombnGroup )
    {
        rememberChangedField("BusVolFldCombnGroup", this.busVolFldCombnGroup);
        this.busVolFldCombnGroup = busVolFldCombnGroup;
    }

    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>CndnContrBusVolSign</b>
     * </p>
     * 
     * @param cndnContrBusVolSign
     *            Status Including / Excluding
     */
    public void setCndnContrBusVolSign( @Nullable final java.lang.String cndnContrBusVolSign )
    {
        rememberChangedField("CndnContrBusVolSign", this.cndnContrBusVolSign);
        this.cndnContrBusVolSign = cndnContrBusVolSign;
    }

    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>BusVolSelectionGroup</b>
     * </p>
     * 
     * @param busVolSelectionGroup
     *            Selection Group
     */
    public void setBusVolSelectionGroup( @Nullable final java.lang.String busVolSelectionGroup )
    {
        rememberChangedField("BusVolSelectionGroup", this.busVolSelectionGroup);
        this.busVolSelectionGroup = busVolSelectionGroup;
    }

    /**
     * Constraints: Nullable
     * <p>
     * Original property name from the Odata EDM: <b>CndnContrBusVolValidFrom</b>
     * </p>
     * 
     * @param cndnContrBusVolValidFrom
     *            Valid from
     */
    public void setCndnContrBusVolValidFrom( @Nullable final LocalDate cndnContrBusVolValidFrom )
    {
        rememberChangedField("CndnContrBusVolValidFrom", this.cndnContrBusVolValidFrom);
        this.cndnContrBusVolValidFrom = cndnContrBusVolValidFrom;
    }

    /**
     * Constraints: Nullable
     * <p>
     * Original property name from the Odata EDM: <b>CndnContrBusVolValidTo</b>
     * </p>
     * 
     * @param cndnContrBusVolValidTo
     *            Valid to
     */
    public void setCndnContrBusVolValidTo( @Nullable final LocalDate cndnContrBusVolValidTo )
    {
        rememberChangedField("CndnContrBusVolValidTo", this.cndnContrBusVolValidTo);
        this.cndnContrBusVolValidTo = cndnContrBusVolValidTo;
    }

    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>Supplier</b>
     * </p>
     * 
     * @param supplier
     *            Account Number of Supplier
     */
    public void setSupplier( @Nullable final java.lang.String supplier )
    {
        rememberChangedField("Supplier", this.supplier);
        this.supplier = supplier;
    }

    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>Customer</b>
     * </p>
     * 
     * @param customer
     *            Customer Number
     */
    public void setCustomer( @Nullable final java.lang.String customer )
    {
        rememberChangedField("Customer", this.customer);
        this.customer = customer;
    }

    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>PurchasingOrganization</b>
     * </p>
     * 
     * @param purchasingOrganization
     *            Purchasing Organization
     */
    public void setPurchasingOrganization( @Nullable final java.lang.String purchasingOrganization )
    {
        rememberChangedField("PurchasingOrganization", this.purchasingOrganization);
        this.purchasingOrganization = purchasingOrganization;
    }

    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>PurchasingGroup</b>
     * </p>
     * 
     * @param purchasingGroup
     *            Purchasing Group
     */
    public void setPurchasingGroup( @Nullable final java.lang.String purchasingGroup )
    {
        rememberChangedField("PurchasingGroup", this.purchasingGroup);
        this.purchasingGroup = purchasingGroup;
    }

    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>SalesOrganization</b>
     * </p>
     * 
     * @param salesOrganization
     *            Sales Organization
     */
    public void setSalesOrganization( @Nullable final java.lang.String salesOrganization )
    {
        rememberChangedField("SalesOrganization", this.salesOrganization);
        this.salesOrganization = salesOrganization;
    }

    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>DistributionChannel</b>
     * </p>
     * 
     * @param distributionChannel
     *            Distribution Channel
     */
    public void setDistributionChannel( @Nullable final java.lang.String distributionChannel )
    {
        rememberChangedField("DistributionChannel", this.distributionChannel);
        this.distributionChannel = distributionChannel;
    }

    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>Division</b>
     * </p>
     * 
     * @param division
     *            Division
     */
    public void setDivision( @Nullable final java.lang.String division )
    {
        rememberChangedField("Division", this.division);
        this.division = division;
    }

    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>CompanyCode</b>
     * </p>
     * 
     * @param companyCode
     *            Company Code
     */
    public void setCompanyCode( @Nullable final java.lang.String companyCode )
    {
        rememberChangedField("CompanyCode", this.companyCode);
        this.companyCode = companyCode;
    }

    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>Plant</b>
     * </p>
     * 
     * @param plant
     *            Plant
     */
    public void setPlant( @Nullable final java.lang.String plant )
    {
        rememberChangedField("Plant", this.plant);
        this.plant = plant;
    }

    /**
     * Constraints: Not nullable, Maximum length: 6
     * <p>
     * Original property name from the Odata EDM: <b>SupplierSubrange</b>
     * </p>
     * 
     * @param supplierSubrange
     *            Supplier Subrange
     */
    public void setSupplierSubrange( @Nullable final java.lang.String supplierSubrange )
    {
        rememberChangedField("SupplierSubrange", this.supplierSubrange);
        this.supplierSubrange = supplierSubrange;
    }

    /**
     * Constraints: Not nullable, Maximum length: 9
     * <p>
     * Original property name from the Odata EDM: <b>ProductGroup</b>
     * </p>
     * 
     * @param productGroup
     *            Product Group
     */
    public void setProductGroup( @Nullable final java.lang.String productGroup )
    {
        rememberChangedField("ProductGroup", this.productGroup);
        this.productGroup = productGroup;
    }

    /**
     * Constraints: Not nullable, Maximum length: 18
     * <p>
     * Original property name from the Odata EDM: <b>Product</b>
     * </p>
     * 
     * @param product
     *            Product Number
     */
    public void setProduct( @Nullable final java.lang.String product )
    {
        rememberChangedField("Product", this.product);
        this.product = product;
    }

    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>ProductType</b>
     * </p>
     * 
     * @param productType
     *            Product Type
     */
    public void setProductType( @Nullable final java.lang.String productType )
    {
        rememberChangedField("ProductType", this.productType);
        this.productType = productType;
    }

    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>CustomerHierarchy</b>
     * </p>
     * 
     * @param customerHierarchy
     *            Customer Hierarchy
     */
    public void setCustomerHierarchy( @Nullable final java.lang.String customerHierarchy )
    {
        rememberChangedField("CustomerHierarchy", this.customerHierarchy);
        this.customerHierarchy = customerHierarchy;
    }

    /**
     * Constraints: Not nullable, Maximum length: 18
     * <p>
     * Original property name from the Odata EDM: <b>ProductHierarchy</b>
     * </p>
     * 
     * @param productHierarchy
     *            Product Hierarchy
     */
    public void setProductHierarchy( @Nullable final java.lang.String productHierarchy )
    {
        rememberChangedField("ProductHierarchy", this.productHierarchy);
        this.productHierarchy = productHierarchy;
    }

    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>SalesSpcfcProductGroup1</b>
     * </p>
     * 
     * @param salesSpcfcProductGroup1
     *            Sales-Specific Product Group 1
     */
    public void setSalesSpcfcProductGroup1( @Nullable final java.lang.String salesSpcfcProductGroup1 )
    {
        rememberChangedField("SalesSpcfcProductGroup1", this.salesSpcfcProductGroup1);
        this.salesSpcfcProductGroup1 = salesSpcfcProductGroup1;
    }

    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>SalesSpcfcProductGroup2</b>
     * </p>
     * 
     * @param salesSpcfcProductGroup2
     *            Sales-Specific Product Group 2
     */
    public void setSalesSpcfcProductGroup2( @Nullable final java.lang.String salesSpcfcProductGroup2 )
    {
        rememberChangedField("SalesSpcfcProductGroup2", this.salesSpcfcProductGroup2);
        this.salesSpcfcProductGroup2 = salesSpcfcProductGroup2;
    }

    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>SalesSpcfcProductGroup3</b>
     * </p>
     * 
     * @param salesSpcfcProductGroup3
     *            Sales-Specific Product Group 3
     */
    public void setSalesSpcfcProductGroup3( @Nullable final java.lang.String salesSpcfcProductGroup3 )
    {
        rememberChangedField("SalesSpcfcProductGroup3", this.salesSpcfcProductGroup3);
        this.salesSpcfcProductGroup3 = salesSpcfcProductGroup3;
    }

    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>SalesSpcfcProductGroup4</b>
     * </p>
     * 
     * @param salesSpcfcProductGroup4
     *            Sales-Specific Product Group 4
     */
    public void setSalesSpcfcProductGroup4( @Nullable final java.lang.String salesSpcfcProductGroup4 )
    {
        rememberChangedField("SalesSpcfcProductGroup4", this.salesSpcfcProductGroup4);
        this.salesSpcfcProductGroup4 = salesSpcfcProductGroup4;
    }

    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>SalesSpcfcProductGroup5</b>
     * </p>
     * 
     * @param salesSpcfcProductGroup5
     *            Sales-Specific Product Group 5
     */
    public void setSalesSpcfcProductGroup5( @Nullable final java.lang.String salesSpcfcProductGroup5 )
    {
        rememberChangedField("SalesSpcfcProductGroup5", this.salesSpcfcProductGroup5);
        this.salesSpcfcProductGroup5 = salesSpcfcProductGroup5;
    }

    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>SalesOrderReason</b>
     * </p>
     * 
     * @param salesOrderReason
     *            Sales Document Reason
     */
    public void setSalesOrderReason( @Nullable final java.lang.String salesOrderReason )
    {
        rememberChangedField("SalesOrderReason", this.salesOrderReason);
        this.salesOrderReason = salesOrderReason;
    }

    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>Manufacturer</b>
     * </p>
     * 
     * @param manufacturer
     *            Manufacturer number
     */
    public void setManufacturer( @Nullable final java.lang.String manufacturer )
    {
        rememberChangedField("Manufacturer", this.manufacturer);
        this.manufacturer = manufacturer;
    }

    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>RoyaltyRecipient</b>
     * </p>
     * 
     * @param royaltyRecipient
     *            Royalties Recipient
     */
    public void setRoyaltyRecipient( @Nullable final java.lang.String royaltyRecipient )
    {
        rememberChangedField("RoyaltyRecipient", this.royaltyRecipient);
        this.royaltyRecipient = royaltyRecipient;
    }

    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>CommissionRecipient</b>
     * </p>
     * 
     * @param commissionRecipient
     *            Commission Recipient
     */
    public void setCommissionRecipient( @Nullable final java.lang.String commissionRecipient )
    {
        rememberChangedField("CommissionRecipient", this.commissionRecipient);
        this.commissionRecipient = commissionRecipient;
    }

    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>ServiceDocumentType</b>
     * </p>
     * 
     * @param serviceDocumentType
     *            Service Document Type
     */
    public void setServiceDocumentType( @Nullable final java.lang.String serviceDocumentType )
    {
        rememberChangedField("ServiceDocumentType", this.serviceDocumentType);
        this.serviceDocumentType = serviceDocumentType;
    }

    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>ServiceDocument</b>
     * </p>
     * 
     * @param serviceDocument
     *            Service Document ID
     */
    public void setServiceDocument( @Nullable final java.lang.String serviceDocument )
    {
        rememberChangedField("ServiceDocument", this.serviceDocument);
        this.serviceDocument = serviceDocument;
    }

    /**
     * Constraints: Not nullable, Maximum length: 6
     * <p>
     * Original property name from the Odata EDM: <b>ServiceDocumentItem</b>
     * </p>
     * 
     * @param serviceDocumentItem
     *            Service Document Item ID
     */
    public void setServiceDocumentItem( @Nullable final java.lang.String serviceDocumentItem )
    {
        rememberChangedField("ServiceDocumentItem", this.serviceDocumentItem);
        this.serviceDocumentItem = serviceDocumentItem;
    }

    /**
     * Constraints: Nullable
     * <p>
     * Original property name from the Odata EDM: <b>CndnContrSourceBusVolUUID</b>
     * </p>
     * 
     * @param cndnContrSourceBusVolUUID
     *            External BVB GUID
     */
    public void setCndnContrSourceBusVolUUID( @Nullable final UUID cndnContrSourceBusVolUUID )
    {
        rememberChangedField("CndnContrSourceBusVolUUID", this.cndnContrSourceBusVolUUID);
        this.cndnContrSourceBusVolUUID = cndnContrSourceBusVolUUID;
    }

    @Override
    protected java.lang.String getEntityCollection()
    {
        return "BusVolSelectionCriteria";
    }

    @Nonnull
    @Override
    protected ODataEntityKey getKey()
    {
        final ODataEntityKey entityKey = super.getKey();
        entityKey.addKeyProperty("ConditionContract", getConditionContract());
        entityKey.addKeyProperty("CndnContrBusVolUUID", getCndnContrBusVolUUID());
        return entityKey;
    }

    @Nonnull
    @Override
    protected Map<java.lang.String, Object> toMapOfFields()
    {
        final Map<java.lang.String, Object> values = super.toMapOfFields();
        values.put("ConditionContract", getConditionContract());
        values.put("CndnContrBusVolUUID", getCndnContrBusVolUUID());
        values.put("BusVolFieldCombnType", getBusVolFieldCombnType());
        values.put("BusVolFldCombnGroup", getBusVolFldCombnGroup());
        values.put("CndnContrBusVolSign", getCndnContrBusVolSign());
        values.put("BusVolSelectionGroup", getBusVolSelectionGroup());
        values.put("CndnContrBusVolValidFrom", getCndnContrBusVolValidFrom());
        values.put("CndnContrBusVolValidTo", getCndnContrBusVolValidTo());
        values.put("Supplier", getSupplier());
        values.put("Customer", getCustomer());
        values.put("PurchasingOrganization", getPurchasingOrganization());
        values.put("PurchasingGroup", getPurchasingGroup());
        values.put("SalesOrganization", getSalesOrganization());
        values.put("DistributionChannel", getDistributionChannel());
        values.put("Division", getDivision());
        values.put("CompanyCode", getCompanyCode());
        values.put("Plant", getPlant());
        values.put("SupplierSubrange", getSupplierSubrange());
        values.put("ProductGroup", getProductGroup());
        values.put("Product", getProduct());
        values.put("ProductType", getProductType());
        values.put("CustomerHierarchy", getCustomerHierarchy());
        values.put("ProductHierarchy", getProductHierarchy());
        values.put("SalesSpcfcProductGroup1", getSalesSpcfcProductGroup1());
        values.put("SalesSpcfcProductGroup2", getSalesSpcfcProductGroup2());
        values.put("SalesSpcfcProductGroup3", getSalesSpcfcProductGroup3());
        values.put("SalesSpcfcProductGroup4", getSalesSpcfcProductGroup4());
        values.put("SalesSpcfcProductGroup5", getSalesSpcfcProductGroup5());
        values.put("SalesOrderReason", getSalesOrderReason());
        values.put("Manufacturer", getManufacturer());
        values.put("RoyaltyRecipient", getRoyaltyRecipient());
        values.put("CommissionRecipient", getCommissionRecipient());
        values.put("ServiceDocumentType", getServiceDocumentType());
        values.put("ServiceDocument", getServiceDocument());
        values.put("ServiceDocumentItem", getServiceDocumentItem());
        values.put("CndnContrSourceBusVolUUID", getCndnContrSourceBusVolUUID());
        return values;
    }

    @Override
    protected void fromMap( final Map<java.lang.String, Object> inputValues )
    {
        final Map<java.lang.String, Object> values = Maps.newHashMap(inputValues);
        // simple properties
        {
            if( values.containsKey("ConditionContract") ) {
                final Object value = values.remove("ConditionContract");
                if( (value == null) || (!value.equals(getConditionContract())) ) {
                    setConditionContract(((java.lang.String) value));
                }
            }
            if( values.containsKey("CndnContrBusVolUUID") ) {
                final Object value = values.remove("CndnContrBusVolUUID");
                if( (value == null) || (!value.equals(getCndnContrBusVolUUID())) ) {
                    setCndnContrBusVolUUID(((UUID) value));
                }
            }
            if( values.containsKey("BusVolFieldCombnType") ) {
                final Object value = values.remove("BusVolFieldCombnType");
                if( (value == null) || (!value.equals(getBusVolFieldCombnType())) ) {
                    setBusVolFieldCombnType(((java.lang.String) value));
                }
            }
            if( values.containsKey("BusVolFldCombnGroup") ) {
                final Object value = values.remove("BusVolFldCombnGroup");
                if( (value == null) || (!value.equals(getBusVolFldCombnGroup())) ) {
                    setBusVolFldCombnGroup(((java.lang.String) value));
                }
            }
            if( values.containsKey("CndnContrBusVolSign") ) {
                final Object value = values.remove("CndnContrBusVolSign");
                if( (value == null) || (!value.equals(getCndnContrBusVolSign())) ) {
                    setCndnContrBusVolSign(((java.lang.String) value));
                }
            }
            if( values.containsKey("BusVolSelectionGroup") ) {
                final Object value = values.remove("BusVolSelectionGroup");
                if( (value == null) || (!value.equals(getBusVolSelectionGroup())) ) {
                    setBusVolSelectionGroup(((java.lang.String) value));
                }
            }
            if( values.containsKey("CndnContrBusVolValidFrom") ) {
                final Object value = values.remove("CndnContrBusVolValidFrom");
                if( (value == null) || (!value.equals(getCndnContrBusVolValidFrom())) ) {
                    setCndnContrBusVolValidFrom(((LocalDate) value));
                }
            }
            if( values.containsKey("CndnContrBusVolValidTo") ) {
                final Object value = values.remove("CndnContrBusVolValidTo");
                if( (value == null) || (!value.equals(getCndnContrBusVolValidTo())) ) {
                    setCndnContrBusVolValidTo(((LocalDate) value));
                }
            }
            if( values.containsKey("Supplier") ) {
                final Object value = values.remove("Supplier");
                if( (value == null) || (!value.equals(getSupplier())) ) {
                    setSupplier(((java.lang.String) value));
                }
            }
            if( values.containsKey("Customer") ) {
                final Object value = values.remove("Customer");
                if( (value == null) || (!value.equals(getCustomer())) ) {
                    setCustomer(((java.lang.String) value));
                }
            }
            if( values.containsKey("PurchasingOrganization") ) {
                final Object value = values.remove("PurchasingOrganization");
                if( (value == null) || (!value.equals(getPurchasingOrganization())) ) {
                    setPurchasingOrganization(((java.lang.String) value));
                }
            }
            if( values.containsKey("PurchasingGroup") ) {
                final Object value = values.remove("PurchasingGroup");
                if( (value == null) || (!value.equals(getPurchasingGroup())) ) {
                    setPurchasingGroup(((java.lang.String) value));
                }
            }
            if( values.containsKey("SalesOrganization") ) {
                final Object value = values.remove("SalesOrganization");
                if( (value == null) || (!value.equals(getSalesOrganization())) ) {
                    setSalesOrganization(((java.lang.String) value));
                }
            }
            if( values.containsKey("DistributionChannel") ) {
                final Object value = values.remove("DistributionChannel");
                if( (value == null) || (!value.equals(getDistributionChannel())) ) {
                    setDistributionChannel(((java.lang.String) value));
                }
            }
            if( values.containsKey("Division") ) {
                final Object value = values.remove("Division");
                if( (value == null) || (!value.equals(getDivision())) ) {
                    setDivision(((java.lang.String) value));
                }
            }
            if( values.containsKey("CompanyCode") ) {
                final Object value = values.remove("CompanyCode");
                if( (value == null) || (!value.equals(getCompanyCode())) ) {
                    setCompanyCode(((java.lang.String) value));
                }
            }
            if( values.containsKey("Plant") ) {
                final Object value = values.remove("Plant");
                if( (value == null) || (!value.equals(getPlant())) ) {
                    setPlant(((java.lang.String) value));
                }
            }
            if( values.containsKey("SupplierSubrange") ) {
                final Object value = values.remove("SupplierSubrange");
                if( (value == null) || (!value.equals(getSupplierSubrange())) ) {
                    setSupplierSubrange(((java.lang.String) value));
                }
            }
            if( values.containsKey("ProductGroup") ) {
                final Object value = values.remove("ProductGroup");
                if( (value == null) || (!value.equals(getProductGroup())) ) {
                    setProductGroup(((java.lang.String) value));
                }
            }
            if( values.containsKey("Product") ) {
                final Object value = values.remove("Product");
                if( (value == null) || (!value.equals(getProduct())) ) {
                    setProduct(((java.lang.String) value));
                }
            }
            if( values.containsKey("ProductType") ) {
                final Object value = values.remove("ProductType");
                if( (value == null) || (!value.equals(getProductType())) ) {
                    setProductType(((java.lang.String) value));
                }
            }
            if( values.containsKey("CustomerHierarchy") ) {
                final Object value = values.remove("CustomerHierarchy");
                if( (value == null) || (!value.equals(getCustomerHierarchy())) ) {
                    setCustomerHierarchy(((java.lang.String) value));
                }
            }
            if( values.containsKey("ProductHierarchy") ) {
                final Object value = values.remove("ProductHierarchy");
                if( (value == null) || (!value.equals(getProductHierarchy())) ) {
                    setProductHierarchy(((java.lang.String) value));
                }
            }
            if( values.containsKey("SalesSpcfcProductGroup1") ) {
                final Object value = values.remove("SalesSpcfcProductGroup1");
                if( (value == null) || (!value.equals(getSalesSpcfcProductGroup1())) ) {
                    setSalesSpcfcProductGroup1(((java.lang.String) value));
                }
            }
            if( values.containsKey("SalesSpcfcProductGroup2") ) {
                final Object value = values.remove("SalesSpcfcProductGroup2");
                if( (value == null) || (!value.equals(getSalesSpcfcProductGroup2())) ) {
                    setSalesSpcfcProductGroup2(((java.lang.String) value));
                }
            }
            if( values.containsKey("SalesSpcfcProductGroup3") ) {
                final Object value = values.remove("SalesSpcfcProductGroup3");
                if( (value == null) || (!value.equals(getSalesSpcfcProductGroup3())) ) {
                    setSalesSpcfcProductGroup3(((java.lang.String) value));
                }
            }
            if( values.containsKey("SalesSpcfcProductGroup4") ) {
                final Object value = values.remove("SalesSpcfcProductGroup4");
                if( (value == null) || (!value.equals(getSalesSpcfcProductGroup4())) ) {
                    setSalesSpcfcProductGroup4(((java.lang.String) value));
                }
            }
            if( values.containsKey("SalesSpcfcProductGroup5") ) {
                final Object value = values.remove("SalesSpcfcProductGroup5");
                if( (value == null) || (!value.equals(getSalesSpcfcProductGroup5())) ) {
                    setSalesSpcfcProductGroup5(((java.lang.String) value));
                }
            }
            if( values.containsKey("SalesOrderReason") ) {
                final Object value = values.remove("SalesOrderReason");
                if( (value == null) || (!value.equals(getSalesOrderReason())) ) {
                    setSalesOrderReason(((java.lang.String) value));
                }
            }
            if( values.containsKey("Manufacturer") ) {
                final Object value = values.remove("Manufacturer");
                if( (value == null) || (!value.equals(getManufacturer())) ) {
                    setManufacturer(((java.lang.String) value));
                }
            }
            if( values.containsKey("RoyaltyRecipient") ) {
                final Object value = values.remove("RoyaltyRecipient");
                if( (value == null) || (!value.equals(getRoyaltyRecipient())) ) {
                    setRoyaltyRecipient(((java.lang.String) value));
                }
            }
            if( values.containsKey("CommissionRecipient") ) {
                final Object value = values.remove("CommissionRecipient");
                if( (value == null) || (!value.equals(getCommissionRecipient())) ) {
                    setCommissionRecipient(((java.lang.String) value));
                }
            }
            if( values.containsKey("ServiceDocumentType") ) {
                final Object value = values.remove("ServiceDocumentType");
                if( (value == null) || (!value.equals(getServiceDocumentType())) ) {
                    setServiceDocumentType(((java.lang.String) value));
                }
            }
            if( values.containsKey("ServiceDocument") ) {
                final Object value = values.remove("ServiceDocument");
                if( (value == null) || (!value.equals(getServiceDocument())) ) {
                    setServiceDocument(((java.lang.String) value));
                }
            }
            if( values.containsKey("ServiceDocumentItem") ) {
                final Object value = values.remove("ServiceDocumentItem");
                if( (value == null) || (!value.equals(getServiceDocumentItem())) ) {
                    setServiceDocumentItem(((java.lang.String) value));
                }
            }
            if( values.containsKey("CndnContrSourceBusVolUUID") ) {
                final Object value = values.remove("CndnContrSourceBusVolUUID");
                if( (value == null) || (!value.equals(getCndnContrSourceBusVolUUID())) ) {
                    setCndnContrSourceBusVolUUID(((UUID) value));
                }
            }
        }
        // structured properties
        {
        }
        // navigation properties
        {
            if( (values).containsKey("_ConditionContract") ) {
                final Object value = (values).remove("_ConditionContract");
                if( value instanceof Map ) {
                    if( to_ConditionContract == null ) {
                        to_ConditionContract = new ConditionContract();
                    }
                    @SuppressWarnings( "unchecked" )
                    final Map<java.lang.String, Object> inputMap = ((Map<java.lang.String, Object>) value);
                    to_ConditionContract.fromMap(inputMap);
                }
            }
        }
        super.fromMap(values);
    }

    @Override
    protected java.lang.String getDefaultServicePath()
    {
        return ConditionContractService.DEFAULT_SERVICE_PATH;
    }

    @Nonnull
    @Override
    protected Map<java.lang.String, Object> toMapOfNavigationProperties()
    {
        final Map<java.lang.String, Object> values = super.toMapOfNavigationProperties();
        if( to_ConditionContract != null ) {
            (values).put("_ConditionContract", to_ConditionContract);
        }
        return values;
    }

    /**
     * Retrieval of associated <b>ConditionContract</b> entity (one to one). This corresponds to the OData navigation
     * property <b>_ConditionContract</b>.
     * <p>
     * If the navigation property for an entity <b>BusVolSelectionCriteria</b> has not been resolved yet, this method
     * will <b>not query</b> further information. Instead its <code>Option</code> result state will be
     * <code>empty</code>.
     * 
     * @return If the information for navigation property <b>_ConditionContract</b> is already loaded, the result will
     *         contain the <b>ConditionContract</b> entity. If not, an <code>Option</code> with result state
     *         <code>empty</code> is returned.
     */
    @Nonnull
    public Option<ConditionContract> getConditionContractIfPresent()
    {
        return Option.of(to_ConditionContract);
    }

    /**
     * Overwrites the associated <b>ConditionContract</b> entity for the loaded navigation property
     * <b>_ConditionContract</b>.
     * 
     * @param value
     *            New <b>ConditionContract</b> entity.
     */
    public void setConditionContract( final ConditionContract value )
    {
        to_ConditionContract = value;
    }

    /**
     * Helper class to allow for fluent creation of BusVolSelectionCriteria instances.
     * 
     */
    public final static class BusVolSelectionCriteriaBuilder
    {

        private ConditionContract to_ConditionContract;
        private java.lang.String conditionContract = null;

        private BusVolSelectionCriteria.BusVolSelectionCriteriaBuilder to_ConditionContract(
            final ConditionContract value )
        {
            to_ConditionContract = value;
            return this;
        }

        /**
         * Navigation property <b>_ConditionContract</b> for <b>BusVolSelectionCriteria</b> to single
         * <b>ConditionContract</b>.
         * 
         * @param value
         *            The ConditionContract to build this BusVolSelectionCriteria with.
         * @return This Builder to allow for a fluent interface.
         */
        @Nonnull
        public BusVolSelectionCriteria.BusVolSelectionCriteriaBuilder conditionContract( final ConditionContract value )
        {
            return to_ConditionContract(value);
        }

        /**
         * (Key Field) Constraints: Not nullable, Maximum length: 10
         * <p>
         * Original property name from the Odata EDM: <b>ConditionContract</b>
         * </p>
         * 
         * @param value
         *            The conditionContract to build this BusVolSelectionCriteria with.
         * @return This Builder to allow for a fluent interface.
         */
        @Nonnull
        public BusVolSelectionCriteria.BusVolSelectionCriteriaBuilder conditionContract( final java.lang.String value )
        {
            conditionContract = value;
            return this;
        }

    }

}
