/*
 * Copyright (c) 2021 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odatav4.namespaces.conditioncontract;

import java.time.LocalDate;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;

import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.google.common.collect.Maps;
import com.google.gson.annotations.JsonAdapter;
import com.sap.cloud.sdk.datamodel.odata.client.request.ODataEntityKey;
import com.sap.cloud.sdk.datamodel.odatav4.core.SimpleProperty;
import com.sap.cloud.sdk.datamodel.odatav4.core.VdmEntity;
import com.sap.cloud.sdk.datamodel.odatav4.core.VdmEntitySet;
import com.sap.cloud.sdk.result.ElementName;
import com.sap.cloud.sdk.s4hana.datamodel.odatav4.services.ConditionContractService;

import io.vavr.control.Option;
import lombok.AccessLevel;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.Getter;
import lombok.NoArgsConstructor;
import lombok.Setter;
import lombok.ToString;

/**
 * <p>
 * Original entity name from the Odata EDM: <b>CndnContrCndnRecordValidityType</b>
 * </p>
 * 
 */
@Builder
@Data
@NoArgsConstructor
@AllArgsConstructor
@ToString( doNotUseGetters = true, callSuper = true )
@EqualsAndHashCode( doNotUseGetters = true, callSuper = true )
@JsonAdapter( com.sap.cloud.sdk.datamodel.odatav4.adapter.GsonVdmAdapterFactory.class )
@JsonSerialize( using = com.sap.cloud.sdk.datamodel.odatav4.adapter.JacksonVdmObjectSerializer.class )
@JsonDeserialize( using = com.sap.cloud.sdk.datamodel.odatav4.adapter.JacksonVdmObjectDeserializer.class )
public class CndnContrCndnRecordValidity extends VdmEntity<CndnContrCndnRecordValidity> implements VdmEntitySet
{

    @Getter
    private final java.lang.String odataType =
        "com.sap.gateway.srvd_a2x.api_condition_contract.v0001.CndnContrCndnRecordValidityType";
    /**
     * Selector for all available fields of CndnContrCndnRecordValidity.
     * 
     */
    public final static SimpleProperty<CndnContrCndnRecordValidity> ALL_FIELDS = all();
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>ConditionContract</b>
     * </p>
     * 
     * @return Condition Contract
     */
    @Nullable
    @ElementName( "ConditionContract" )
    private java.lang.String conditionContract;
    public final static SimpleProperty.String<CndnContrCndnRecordValidity> CONDITION_CONTRACT =
        new SimpleProperty.String<CndnContrCndnRecordValidity>(CndnContrCndnRecordValidity.class, "ConditionContract");
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>ConditionRecord</b>
     * </p>
     * 
     * @return Number of the Condition Record
     */
    @Nullable
    @ElementName( "ConditionRecord" )
    private java.lang.String conditionRecord;
    public final static SimpleProperty.String<CndnContrCndnRecordValidity> CONDITION_RECORD =
        new SimpleProperty.String<CndnContrCndnRecordValidity>(CndnContrCndnRecordValidity.class, "ConditionRecord");
    /**
     * (Key Field) Constraints: Not nullable
     * <p>
     * Original property name from the Odata EDM: <b>ConditionValidityEndDate</b>
     * </p>
     * 
     * @return Validity end date of the condition record
     */
    @Nullable
    @ElementName( "ConditionValidityEndDate" )
    private LocalDate conditionValidityEndDate;
    public final static SimpleProperty.Date<CndnContrCndnRecordValidity> CONDITION_VALIDITY_END_DATE =
        new SimpleProperty.Date<CndnContrCndnRecordValidity>(
            CndnContrCndnRecordValidity.class,
            "ConditionValidityEndDate");
    /**
     * Constraints: Nullable
     * <p>
     * Original property name from the Odata EDM: <b>ConditionValidityStartDate</b>
     * </p>
     * 
     * @return Validity start date of the condition record
     */
    @Nullable
    @ElementName( "ConditionValidityStartDate" )
    private LocalDate conditionValidityStartDate;
    public final static SimpleProperty.Date<CndnContrCndnRecordValidity> CONDITION_VALIDITY_START_DATE =
        new SimpleProperty.Date<CndnContrCndnRecordValidity>(
            CndnContrCndnRecordValidity.class,
            "ConditionValidityStartDate");
    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>ConditionTable</b>
     * </p>
     * 
     * @return Condition Table
     */
    @Nullable
    @ElementName( "ConditionTable" )
    private java.lang.String conditionTable;
    public final static SimpleProperty.String<CndnContrCndnRecordValidity> CONDITION_TABLE =
        new SimpleProperty.String<CndnContrCndnRecordValidity>(CndnContrCndnRecordValidity.class, "ConditionTable");
    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>ConditionApplication</b>
     * </p>
     * 
     * @return Application
     */
    @Nullable
    @ElementName( "ConditionApplication" )
    private java.lang.String conditionApplication;
    public final static SimpleProperty.String<CndnContrCndnRecordValidity> CONDITION_APPLICATION =
        new SimpleProperty.String<CndnContrCndnRecordValidity>(
            CndnContrCndnRecordValidity.class,
            "ConditionApplication");
    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>ConditionType</b>
     * </p>
     * 
     * @return Condition Type
     */
    @Nullable
    @ElementName( "ConditionType" )
    private java.lang.String conditionType;
    public final static SimpleProperty.String<CndnContrCndnRecordValidity> CONDITION_TYPE =
        new SimpleProperty.String<CndnContrCndnRecordValidity>(CndnContrCndnRecordValidity.class, "ConditionType");
    /**
     * Constraints: Not nullable
     * <p>
     * Original property name from the Odata EDM: <b>SAP__Messages</b>
     * </p>
     * 
     * @return The _Messages contained in this {@link VdmEntity}.
     */
    @Nullable
    @ElementName( "SAP__Messages" )
    private java.util.Collection<SAP__Message> _Messages;
    /**
     * Use with available request builders to apply the <b>SAP__Messages</b> complex property to query operations.
     * 
     */
    public final static com.sap.cloud.sdk.datamodel.odatav4.core.ComplexProperty.Collection<CndnContrCndnRecordValidity, SAP__Message> _MESSAGES =
        new com.sap.cloud.sdk.datamodel.odatav4.core.ComplexProperty.Collection<CndnContrCndnRecordValidity, SAP__Message>(
            CndnContrCndnRecordValidity.class,
            "SAP__Messages",
            SAP__Message.class);
    /**
     * Navigation property <b>_CndnContrCndnRecord</b> for <b>CndnContrCndnRecordValidity</b> to single
     * <b>CndnContrConditionRecord</b>.
     * 
     */
    @ElementName( "_CndnContrCndnRecord" )
    @Nullable
    @Getter( AccessLevel.NONE )
    @Setter( AccessLevel.NONE )
    private CndnContrConditionRecord to_CndnContrCndnRecord;
    /**
     * Navigation property <b>_ConditionContract</b> for <b>CndnContrCndnRecordValidity</b> to single
     * <b>ConditionContract</b>.
     * 
     */
    @ElementName( "_ConditionContract" )
    @Nullable
    @Getter( AccessLevel.NONE )
    @Setter( AccessLevel.NONE )
    private ConditionContract to_ConditionContract;
    /**
     * Use with available request builders to apply the <b>_CndnContrCndnRecord</b> navigation property to query
     * operations.
     * 
     */
    public final static com.sap.cloud.sdk.datamodel.odatav4.core.NavigationProperty.Single<CndnContrCndnRecordValidity, CndnContrConditionRecord> TO__CNDN_CONTR_CNDN_RECORD =
        new com.sap.cloud.sdk.datamodel.odatav4.core.NavigationProperty.Single<CndnContrCndnRecordValidity, CndnContrConditionRecord>(
            CndnContrCndnRecordValidity.class,
            "_CndnContrCndnRecord",
            CndnContrConditionRecord.class);
    /**
     * Use with available request builders to apply the <b>_ConditionContract</b> navigation property to query
     * operations.
     * 
     */
    public final static com.sap.cloud.sdk.datamodel.odatav4.core.NavigationProperty.Single<CndnContrCndnRecordValidity, ConditionContract> TO__CONDITION_CONTRACT =
        new com.sap.cloud.sdk.datamodel.odatav4.core.NavigationProperty.Single<CndnContrCndnRecordValidity, ConditionContract>(
            CndnContrCndnRecordValidity.class,
            "_ConditionContract",
            ConditionContract.class);

    /**
     * {@inheritDoc}
     * 
     */
    @Nonnull
    @Override
    public Class<CndnContrCndnRecordValidity> getType()
    {
        return CndnContrCndnRecordValidity.class;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>ConditionContract</b>
     * </p>
     * 
     * @param conditionContract
     *            Condition Contract
     */
    public void setConditionContract( @Nullable final java.lang.String conditionContract )
    {
        rememberChangedField("ConditionContract", this.conditionContract);
        this.conditionContract = conditionContract;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>ConditionRecord</b>
     * </p>
     * 
     * @param conditionRecord
     *            Number of the Condition Record
     */
    public void setConditionRecord( @Nullable final java.lang.String conditionRecord )
    {
        rememberChangedField("ConditionRecord", this.conditionRecord);
        this.conditionRecord = conditionRecord;
    }

    /**
     * (Key Field) Constraints: Not nullable
     * <p>
     * Original property name from the Odata EDM: <b>ConditionValidityEndDate</b>
     * </p>
     * 
     * @param conditionValidityEndDate
     *            Validity end date of the condition record
     */
    public void setConditionValidityEndDate( @Nullable final LocalDate conditionValidityEndDate )
    {
        rememberChangedField("ConditionValidityEndDate", this.conditionValidityEndDate);
        this.conditionValidityEndDate = conditionValidityEndDate;
    }

    /**
     * Constraints: Nullable
     * <p>
     * Original property name from the Odata EDM: <b>ConditionValidityStartDate</b>
     * </p>
     * 
     * @param conditionValidityStartDate
     *            Validity start date of the condition record
     */
    public void setConditionValidityStartDate( @Nullable final LocalDate conditionValidityStartDate )
    {
        rememberChangedField("ConditionValidityStartDate", this.conditionValidityStartDate);
        this.conditionValidityStartDate = conditionValidityStartDate;
    }

    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>ConditionTable</b>
     * </p>
     * 
     * @param conditionTable
     *            Condition Table
     */
    public void setConditionTable( @Nullable final java.lang.String conditionTable )
    {
        rememberChangedField("ConditionTable", this.conditionTable);
        this.conditionTable = conditionTable;
    }

    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>ConditionApplication</b>
     * </p>
     * 
     * @param conditionApplication
     *            Application
     */
    public void setConditionApplication( @Nullable final java.lang.String conditionApplication )
    {
        rememberChangedField("ConditionApplication", this.conditionApplication);
        this.conditionApplication = conditionApplication;
    }

    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>ConditionType</b>
     * </p>
     * 
     * @param conditionType
     *            Condition Type
     */
    public void setConditionType( @Nullable final java.lang.String conditionType )
    {
        rememberChangedField("ConditionType", this.conditionType);
        this.conditionType = conditionType;
    }

    /**
     * Constraints: Not nullable
     * <p>
     * Original property name from the Odata EDM: <b>SAP__Messages</b>
     * </p>
     * 
     * @param _Messages
     *            The _Messages to set.
     */
    public void set_Messages( @Nullable final java.util.Collection<SAP__Message> _Messages )
    {
        rememberChangedField("SAP__Messages", this._Messages);
        this._Messages = _Messages;
    }

    @Override
    protected java.lang.String getEntityCollection()
    {
        return "CndnContrCndnRecordValidity";
    }

    @Nonnull
    @Override
    protected ODataEntityKey getKey()
    {
        final ODataEntityKey entityKey = super.getKey();
        entityKey.addKeyProperty("ConditionContract", getConditionContract());
        entityKey.addKeyProperty("ConditionRecord", getConditionRecord());
        entityKey.addKeyProperty("ConditionValidityEndDate", getConditionValidityEndDate());
        return entityKey;
    }

    @Nonnull
    @Override
    protected Map<java.lang.String, Object> toMapOfFields()
    {
        final Map<java.lang.String, Object> values = super.toMapOfFields();
        values.put("ConditionContract", getConditionContract());
        values.put("ConditionRecord", getConditionRecord());
        values.put("ConditionValidityEndDate", getConditionValidityEndDate());
        values.put("ConditionValidityStartDate", getConditionValidityStartDate());
        values.put("ConditionTable", getConditionTable());
        values.put("ConditionApplication", getConditionApplication());
        values.put("ConditionType", getConditionType());
        values.put("SAP__Messages", get_Messages());
        return values;
    }

    @Override
    protected void fromMap( final Map<java.lang.String, Object> inputValues )
    {
        final Map<java.lang.String, Object> values = Maps.newHashMap(inputValues);
        // simple properties
        {
            if( values.containsKey("ConditionContract") ) {
                final Object value = values.remove("ConditionContract");
                if( (value == null) || (!value.equals(getConditionContract())) ) {
                    setConditionContract(((java.lang.String) value));
                }
            }
            if( values.containsKey("ConditionRecord") ) {
                final Object value = values.remove("ConditionRecord");
                if( (value == null) || (!value.equals(getConditionRecord())) ) {
                    setConditionRecord(((java.lang.String) value));
                }
            }
            if( values.containsKey("ConditionValidityEndDate") ) {
                final Object value = values.remove("ConditionValidityEndDate");
                if( (value == null) || (!value.equals(getConditionValidityEndDate())) ) {
                    setConditionValidityEndDate(((LocalDate) value));
                }
            }
            if( values.containsKey("ConditionValidityStartDate") ) {
                final Object value = values.remove("ConditionValidityStartDate");
                if( (value == null) || (!value.equals(getConditionValidityStartDate())) ) {
                    setConditionValidityStartDate(((LocalDate) value));
                }
            }
            if( values.containsKey("ConditionTable") ) {
                final Object value = values.remove("ConditionTable");
                if( (value == null) || (!value.equals(getConditionTable())) ) {
                    setConditionTable(((java.lang.String) value));
                }
            }
            if( values.containsKey("ConditionApplication") ) {
                final Object value = values.remove("ConditionApplication");
                if( (value == null) || (!value.equals(getConditionApplication())) ) {
                    setConditionApplication(((java.lang.String) value));
                }
            }
            if( values.containsKey("ConditionType") ) {
                final Object value = values.remove("ConditionType");
                if( (value == null) || (!value.equals(getConditionType())) ) {
                    setConditionType(((java.lang.String) value));
                }
            }
        }
        // structured properties
        {
            if( values.containsKey("SAP__Messages") ) {
                final Object value = values.remove("SAP__Messages");
                if( value instanceof Iterable ) {
                    final LinkedList<SAP__Message> _Messages = new LinkedList<SAP__Message>();
                    for( Object properties : ((Iterable<?>) value) ) {
                        if( properties instanceof Map ) {
                            final SAP__Message item = new SAP__Message();
                            @SuppressWarnings( "unchecked" )
                            final Map<java.lang.String, Object> inputMap = ((Map<java.lang.String, Object>) value);
                            item.fromMap(inputMap);
                            _Messages.add(item);
                        }
                    }
                    set_Messages(_Messages);
                }
                if( (value == null) && (get_Messages() != null) ) {
                    set_Messages(null);
                }
            }
        }
        // navigation properties
        {
            if( (values).containsKey("_CndnContrCndnRecord") ) {
                final Object value = (values).remove("_CndnContrCndnRecord");
                if( value instanceof Map ) {
                    if( to_CndnContrCndnRecord == null ) {
                        to_CndnContrCndnRecord = new CndnContrConditionRecord();
                    }
                    @SuppressWarnings( "unchecked" )
                    final Map<java.lang.String, Object> inputMap = ((Map<java.lang.String, Object>) value);
                    to_CndnContrCndnRecord.fromMap(inputMap);
                }
            }
            if( (values).containsKey("_ConditionContract") ) {
                final Object value = (values).remove("_ConditionContract");
                if( value instanceof Map ) {
                    if( to_ConditionContract == null ) {
                        to_ConditionContract = new ConditionContract();
                    }
                    @SuppressWarnings( "unchecked" )
                    final Map<java.lang.String, Object> inputMap = ((Map<java.lang.String, Object>) value);
                    to_ConditionContract.fromMap(inputMap);
                }
            }
        }
        super.fromMap(values);
    }

    @Override
    protected java.lang.String getDefaultServicePath()
    {
        return ConditionContractService.DEFAULT_SERVICE_PATH;
    }

    @Nonnull
    @Override
    protected Map<java.lang.String, Object> toMapOfNavigationProperties()
    {
        final Map<java.lang.String, Object> values = super.toMapOfNavigationProperties();
        if( to_CndnContrCndnRecord != null ) {
            (values).put("_CndnContrCndnRecord", to_CndnContrCndnRecord);
        }
        if( to_ConditionContract != null ) {
            (values).put("_ConditionContract", to_ConditionContract);
        }
        return values;
    }

    /**
     * Retrieval of associated <b>CndnContrConditionRecord</b> entity (one to one). This corresponds to the OData
     * navigation property <b>_CndnContrCndnRecord</b>.
     * <p>
     * If the navigation property for an entity <b>CndnContrCndnRecordValidity</b> has not been resolved yet, this
     * method will <b>not query</b> further information. Instead its <code>Option</code> result state will be
     * <code>empty</code>.
     * 
     * @return If the information for navigation property <b>_CndnContrCndnRecord</b> is already loaded, the result will
     *         contain the <b>CndnContrConditionRecord</b> entity. If not, an <code>Option</code> with result state
     *         <code>empty</code> is returned.
     */
    @Nonnull
    public Option<CndnContrConditionRecord> getCndnContrCndnRecordIfPresent()
    {
        return Option.of(to_CndnContrCndnRecord);
    }

    /**
     * Overwrites the associated <b>CndnContrConditionRecord</b> entity for the loaded navigation property
     * <b>_CndnContrCndnRecord</b>.
     * 
     * @param value
     *            New <b>CndnContrConditionRecord</b> entity.
     */
    public void setCndnContrCndnRecord( final CndnContrConditionRecord value )
    {
        to_CndnContrCndnRecord = value;
    }

    /**
     * Retrieval of associated <b>ConditionContract</b> entity (one to one). This corresponds to the OData navigation
     * property <b>_ConditionContract</b>.
     * <p>
     * If the navigation property for an entity <b>CndnContrCndnRecordValidity</b> has not been resolved yet, this
     * method will <b>not query</b> further information. Instead its <code>Option</code> result state will be
     * <code>empty</code>.
     * 
     * @return If the information for navigation property <b>_ConditionContract</b> is already loaded, the result will
     *         contain the <b>ConditionContract</b> entity. If not, an <code>Option</code> with result state
     *         <code>empty</code> is returned.
     */
    @Nonnull
    public Option<ConditionContract> getConditionContractIfPresent()
    {
        return Option.of(to_ConditionContract);
    }

    /**
     * Overwrites the associated <b>ConditionContract</b> entity for the loaded navigation property
     * <b>_ConditionContract</b>.
     * 
     * @param value
     *            New <b>ConditionContract</b> entity.
     */
    public void setConditionContract( final ConditionContract value )
    {
        to_ConditionContract = value;
    }

    /**
     * Action that can be applied to any entity object of this class.
     * </p>
     * 
     * @param conditionValidityStartDate
     *            Constraints: Not nullable
     *            <p>
     *            Original parameter name from the Odata EDM: <b>ConditionValidityStartDate</b>
     *            </p>
     * @param conditionValidityEndDate
     *            Constraints: Not nullable
     *            <p>
     *            Original parameter name from the Odata EDM: <b>ConditionValidityEndDate</b>
     *            </p>
     * @return Action object prepared with the given parameters to be applied to any entity object of this class.
     *         </p>
     *         To execute it use the {@code service.forEntity(entity).applyAction(thisAction)} API.
     */
    @Nonnull
    public static
        com.sap.cloud.sdk.datamodel.odatav4.core.BoundAction.SingleToSingle<CndnContrCndnRecordValidity, Void>
        changeValidity(
            @Nonnull final LocalDate conditionValidityStartDate,
            @Nonnull final LocalDate conditionValidityEndDate )
    {
        final Map<java.lang.String, Object> parameters = new HashMap<java.lang.String, Object>();
        parameters.put("ConditionValidityStartDate", conditionValidityStartDate);
        parameters.put("ConditionValidityEndDate", conditionValidityEndDate);
        return new com.sap.cloud.sdk.datamodel.odatav4.core.BoundAction.SingleToSingle<CndnContrCndnRecordValidity, Void>(
            CndnContrCndnRecordValidity.class,
            Void.class,
            "com.sap.gateway.srvd_a2x.api_condition_contract.v0001.ChangeValidity",
            parameters);
    }

    /**
     * Helper class to allow for fluent creation of CndnContrCndnRecordValidity instances.
     * 
     */
    public final static class CndnContrCndnRecordValidityBuilder
    {

        private CndnContrConditionRecord to_CndnContrCndnRecord;
        private ConditionContract to_ConditionContract;
        private java.lang.String conditionContract = null;

        private CndnContrCndnRecordValidity.CndnContrCndnRecordValidityBuilder to_CndnContrCndnRecord(
            final CndnContrConditionRecord value )
        {
            to_CndnContrCndnRecord = value;
            return this;
        }

        /**
         * Navigation property <b>_CndnContrCndnRecord</b> for <b>CndnContrCndnRecordValidity</b> to single
         * <b>CndnContrConditionRecord</b>.
         * 
         * @param value
         *            The CndnContrConditionRecord to build this CndnContrCndnRecordValidity with.
         * @return This Builder to allow for a fluent interface.
         */
        @Nonnull
        public CndnContrCndnRecordValidity.CndnContrCndnRecordValidityBuilder cndnContrCndnRecord(
            final CndnContrConditionRecord value )
        {
            return to_CndnContrCndnRecord(value);
        }

        private CndnContrCndnRecordValidity.CndnContrCndnRecordValidityBuilder to_ConditionContract(
            final ConditionContract value )
        {
            to_ConditionContract = value;
            return this;
        }

        /**
         * Navigation property <b>_ConditionContract</b> for <b>CndnContrCndnRecordValidity</b> to single
         * <b>ConditionContract</b>.
         * 
         * @param value
         *            The ConditionContract to build this CndnContrCndnRecordValidity with.
         * @return This Builder to allow for a fluent interface.
         */
        @Nonnull
        public CndnContrCndnRecordValidity.CndnContrCndnRecordValidityBuilder conditionContract(
            final ConditionContract value )
        {
            return to_ConditionContract(value);
        }

        /**
         * (Key Field) Constraints: Not nullable, Maximum length: 10
         * <p>
         * Original property name from the Odata EDM: <b>ConditionContract</b>
         * </p>
         * 
         * @param value
         *            The conditionContract to build this CndnContrCndnRecordValidity with.
         * @return This Builder to allow for a fluent interface.
         */
        @Nonnull
        public CndnContrCndnRecordValidity.CndnContrCndnRecordValidityBuilder conditionContract(
            final java.lang.String value )
        {
            conditionContract = value;
            return this;
        }

    }

}
