/*
 * Copyright (c) 2021 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odatav4.namespaces.conditioncontract;

import java.math.BigDecimal;
import java.time.LocalDate;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;

import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.gson.annotations.JsonAdapter;
import com.sap.cloud.sdk.datamodel.odata.client.request.ODataEntityKey;
import com.sap.cloud.sdk.datamodel.odatav4.core.DecimalDescriptor;
import com.sap.cloud.sdk.datamodel.odatav4.core.SimpleProperty;
import com.sap.cloud.sdk.datamodel.odatav4.core.VdmEntity;
import com.sap.cloud.sdk.datamodel.odatav4.core.VdmEntitySet;
import com.sap.cloud.sdk.result.ElementName;
import com.sap.cloud.sdk.s4hana.datamodel.odatav4.services.ConditionContractService;

import io.vavr.control.Option;
import lombok.AccessLevel;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.Getter;
import lombok.NoArgsConstructor;
import lombok.Setter;
import lombok.ToString;

/**
 * <p>
 * Original entity name from the Odata EDM: <b>CndnContrConditionRecordType</b>
 * </p>
 * 
 */
@Builder
@Data
@NoArgsConstructor
@AllArgsConstructor
@ToString( doNotUseGetters = true, callSuper = true )
@EqualsAndHashCode( doNotUseGetters = true, callSuper = true )
@JsonAdapter( com.sap.cloud.sdk.datamodel.odatav4.adapter.GsonVdmAdapterFactory.class )
@JsonSerialize( using = com.sap.cloud.sdk.datamodel.odatav4.adapter.JacksonVdmObjectSerializer.class )
@JsonDeserialize( using = com.sap.cloud.sdk.datamodel.odatav4.adapter.JacksonVdmObjectDeserializer.class )
public class CndnContrConditionRecord extends VdmEntity<CndnContrConditionRecord> implements VdmEntitySet
{

    @Getter
    private final java.lang.String odataType =
        "com.sap.gateway.srvd_a2x.api_condition_contract.v0001.CndnContrConditionRecordType";
    /**
     * Selector for all available fields of CndnContrConditionRecord.
     * 
     */
    public final static SimpleProperty<CndnContrConditionRecord> ALL_FIELDS = all();
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>ConditionContract</b>
     * </p>
     * 
     * @return Condition Contract
     */
    @Nullable
    @ElementName( "ConditionContract" )
    private java.lang.String conditionContract;
    public final static SimpleProperty.String<CndnContrConditionRecord> CONDITION_CONTRACT =
        new SimpleProperty.String<CndnContrConditionRecord>(CndnContrConditionRecord.class, "ConditionContract");
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>ConditionRecord</b>
     * </p>
     * 
     * @return Number of the Condition Record
     */
    @Nullable
    @ElementName( "ConditionRecord" )
    private java.lang.String conditionRecord;
    public final static SimpleProperty.String<CndnContrConditionRecord> CONDITION_RECORD =
        new SimpleProperty.String<CndnContrConditionRecord>(CndnContrConditionRecord.class, "ConditionRecord");
    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>ConditionTable</b>
     * </p>
     * 
     * @return Condition Table
     */
    @Nullable
    @ElementName( "ConditionTable" )
    private java.lang.String conditionTable;
    public final static SimpleProperty.String<CndnContrConditionRecord> CONDITION_TABLE =
        new SimpleProperty.String<CndnContrConditionRecord>(CndnContrConditionRecord.class, "ConditionTable");
    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>ConditionApplication</b>
     * </p>
     * 
     * @return Application
     */
    @Nullable
    @ElementName( "ConditionApplication" )
    private java.lang.String conditionApplication;
    public final static SimpleProperty.String<CndnContrConditionRecord> CONDITION_APPLICATION =
        new SimpleProperty.String<CndnContrConditionRecord>(CndnContrConditionRecord.class, "ConditionApplication");
    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>ConditionType</b>
     * </p>
     * 
     * @return Condition Type
     */
    @Nullable
    @ElementName( "ConditionType" )
    private java.lang.String conditionType;
    public final static SimpleProperty.String<CndnContrConditionRecord> CONDITION_TYPE =
        new SimpleProperty.String<CndnContrConditionRecord>(CndnContrConditionRecord.class, "ConditionType");
    /**
     * Constraints: Nullable
     * <p>
     * Original property name from the Odata EDM: <b>ConditionValidityStartDate</b>
     * </p>
     * 
     * @return Validity start date of the condition record
     */
    @Nullable
    @ElementName( "ConditionValidityStartDate" )
    private LocalDate conditionValidityStartDate;
    public final static SimpleProperty.Date<CndnContrConditionRecord> CONDITION_VALIDITY_START_DATE =
        new SimpleProperty.Date<CndnContrConditionRecord>(CndnContrConditionRecord.class, "ConditionValidityStartDate");
    /**
     * Constraints: Nullable
     * <p>
     * Original property name from the Odata EDM: <b>ConditionValidityEndDate</b>
     * </p>
     * 
     * @return Validity end date of the condition record
     */
    @Nullable
    @ElementName( "ConditionValidityEndDate" )
    private LocalDate conditionValidityEndDate;
    public final static SimpleProperty.Date<CndnContrConditionRecord> CONDITION_VALIDITY_END_DATE =
        new SimpleProperty.Date<CndnContrConditionRecord>(CndnContrConditionRecord.class, "ConditionValidityEndDate");
    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>ConditionCalculationType</b>
     * </p>
     * 
     * @return Calculation Type for Condition
     */
    @Nullable
    @ElementName( "ConditionCalculationType" )
    private java.lang.String conditionCalculationType;
    public final static SimpleProperty.String<CndnContrConditionRecord> CONDITION_CALCULATION_TYPE =
        new SimpleProperty.String<CndnContrConditionRecord>(CndnContrConditionRecord.class, "ConditionCalculationType");
    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>PricingScaleBasis</b>
     * </p>
     * 
     * @return Scale Basis Indicator
     */
    @Nullable
    @ElementName( "PricingScaleBasis" )
    private java.lang.String pricingScaleBasis;
    public final static SimpleProperty.String<CndnContrConditionRecord> PRICING_SCALE_BASIS =
        new SimpleProperty.String<CndnContrConditionRecord>(CndnContrConditionRecord.class, "PricingScaleBasis");
    /**
     * Constraints: Not nullable, Precision: 24, Scale: 9
     * <p>
     * Original property name from the Odata EDM: <b>ConditionRateAmount</b>
     * </p>
     * 
     * @return The conditionRateAmount contained in this {@link VdmEntity}.
     */
    @Nullable
    @ElementName( "ConditionRateAmount" )
    @DecimalDescriptor( precision = 24, scale = 9 )
    private BigDecimal conditionRateAmount;
    public final static SimpleProperty.NumericDecimal<CndnContrConditionRecord> CONDITION_RATE_AMOUNT =
        new SimpleProperty.NumericDecimal<CndnContrConditionRecord>(
            CndnContrConditionRecord.class,
            "ConditionRateAmount");
    /**
     * Constraints: Not nullable, Precision: 24, Scale: 9
     * <p>
     * Original property name from the Odata EDM: <b>ConditionAccrualsAmount</b>
     * </p>
     * 
     * @return The conditionAccrualsAmount contained in this {@link VdmEntity}.
     */
    @Nullable
    @ElementName( "ConditionAccrualsAmount" )
    @DecimalDescriptor( precision = 24, scale = 9 )
    private BigDecimal conditionAccrualsAmount;
    public final static SimpleProperty.NumericDecimal<CndnContrConditionRecord> CONDITION_ACCRUALS_AMOUNT =
        new SimpleProperty.NumericDecimal<CndnContrConditionRecord>(
            CndnContrConditionRecord.class,
            "ConditionAccrualsAmount");
    /**
     * Constraints: Not nullable, Maximum length: 5
     * <p>
     * Original property name from the Odata EDM: <b>ConditionCurrency</b>
     * </p>
     * 
     * @return Condition Unit (Currency or Percentage)
     */
    @Nullable
    @ElementName( "ConditionCurrency" )
    private java.lang.String conditionCurrency;
    public final static SimpleProperty.String<CndnContrConditionRecord> CONDITION_CURRENCY =
        new SimpleProperty.String<CndnContrConditionRecord>(CndnContrConditionRecord.class, "ConditionCurrency");
    /**
     * Constraints: Not nullable, Precision: 5
     * <p>
     * Original property name from the Odata EDM: <b>ConditionQuantity</b>
     * </p>
     * 
     * @return The conditionQuantity contained in this {@link VdmEntity}.
     */
    @Nullable
    @ElementName( "ConditionQuantity" )
    @DecimalDescriptor( precision = 5, scale = 0 )
    private BigDecimal conditionQuantity;
    public final static SimpleProperty.NumericDecimal<CndnContrConditionRecord> CONDITION_QUANTITY =
        new SimpleProperty.NumericDecimal<CndnContrConditionRecord>(
            CndnContrConditionRecord.class,
            "ConditionQuantity");
    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>ConditionQuantityUnit</b>
     * </p>
     * 
     * @return Condition Unit
     */
    @Nullable
    @ElementName( "ConditionQuantityUnit" )
    private java.lang.String conditionQuantityUnit;
    public final static SimpleProperty.String<CndnContrConditionRecord> CONDITION_QUANTITY_UNIT =
        new SimpleProperty.String<CndnContrConditionRecord>(CndnContrConditionRecord.class, "ConditionQuantityUnit");
    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>ConditionQuantityUnitISOCode</b>
     * </p>
     * 
     * @return Condition Quantity Unit in ISO code
     */
    @Nullable
    @ElementName( "ConditionQuantityUnitISOCode" )
    private java.lang.String conditionQuantityUnitISOCode;
    public final static SimpleProperty.String<CndnContrConditionRecord> CONDITION_QUANTITY_UNIT_ISO_CODE =
        new SimpleProperty.String<CndnContrConditionRecord>(
            CndnContrConditionRecord.class,
            "ConditionQuantityUnitISOCode");
    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>ConditionQuantityUnitSAPCode</b>
     * </p>
     * 
     * @return Condition Quantity Unit in SAP code
     */
    @Nullable
    @ElementName( "ConditionQuantityUnitSAPCode" )
    private java.lang.String conditionQuantityUnitSAPCode;
    public final static SimpleProperty.String<CndnContrConditionRecord> CONDITION_QUANTITY_UNIT_SAP_CODE =
        new SimpleProperty.String<CndnContrConditionRecord>(
            CndnContrConditionRecord.class,
            "ConditionQuantityUnitSAPCode");
    /**
     * Constraints: Not nullable, Precision: 24, Scale: 9
     * <p>
     * Original property name from the Odata EDM: <b>ConditionRateRatio</b>
     * </p>
     * 
     * @return The conditionRateRatio contained in this {@link VdmEntity}.
     */
    @Nullable
    @ElementName( "ConditionRateRatio" )
    @DecimalDescriptor( precision = 24, scale = 9 )
    private BigDecimal conditionRateRatio;
    public final static SimpleProperty.NumericDecimal<CndnContrConditionRecord> CONDITION_RATE_RATIO =
        new SimpleProperty.NumericDecimal<CndnContrConditionRecord>(
            CndnContrConditionRecord.class,
            "ConditionRateRatio");
    /**
     * Constraints: Not nullable, Precision: 24, Scale: 9
     * <p>
     * Original property name from the Odata EDM: <b>ConditionAccrualsRatio</b>
     * </p>
     * 
     * @return The conditionAccrualsRatio contained in this {@link VdmEntity}.
     */
    @Nullable
    @ElementName( "ConditionAccrualsRatio" )
    @DecimalDescriptor( precision = 24, scale = 9 )
    private BigDecimal conditionAccrualsRatio;
    public final static SimpleProperty.NumericDecimal<CndnContrConditionRecord> CONDITION_ACCRUALS_RATIO =
        new SimpleProperty.NumericDecimal<CndnContrConditionRecord>(
            CndnContrConditionRecord.class,
            "ConditionAccrualsRatio");
    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>ConditionRateRatioUnit</b>
     * </p>
     * 
     * @return Percent Sign (Transactional Processing)
     */
    @Nullable
    @ElementName( "ConditionRateRatioUnit" )
    private java.lang.String conditionRateRatioUnit;
    public final static SimpleProperty.String<CndnContrConditionRecord> CONDITION_RATE_RATIO_UNIT =
        new SimpleProperty.String<CndnContrConditionRecord>(CndnContrConditionRecord.class, "ConditionRateRatioUnit");
    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>ConditionRateRatioUnitISOCode</b>
     * </p>
     * 
     * @return Percent Sign in ISO Code
     */
    @Nullable
    @ElementName( "ConditionRateRatioUnitISOCode" )
    private java.lang.String conditionRateRatioUnitISOCode;
    public final static SimpleProperty.String<CndnContrConditionRecord> CONDITION_RATE_RATIO_UNIT_ISO_CODE =
        new SimpleProperty.String<CndnContrConditionRecord>(
            CndnContrConditionRecord.class,
            "ConditionRateRatioUnitISOCode");
    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>ConditionRateRatioUnitSAPCode</b>
     * </p>
     * 
     * @return Percent Sign in SAP Code
     */
    @Nullable
    @ElementName( "ConditionRateRatioUnitSAPCode" )
    private java.lang.String conditionRateRatioUnitSAPCode;
    public final static SimpleProperty.String<CndnContrConditionRecord> CONDITION_RATE_RATIO_UNIT_SAP_CODE =
        new SimpleProperty.String<CndnContrConditionRecord>(
            CndnContrConditionRecord.class,
            "ConditionRateRatioUnitSAPCode");
    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>PricingScaleType</b>
     * </p>
     * 
     * @return Scale Type
     */
    @Nullable
    @ElementName( "PricingScaleType" )
    private java.lang.String pricingScaleType;
    public final static SimpleProperty.String<CndnContrConditionRecord> PRICING_SCALE_TYPE =
        new SimpleProperty.String<CndnContrConditionRecord>(CndnContrConditionRecord.class, "PricingScaleType");
    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>ConditionScaleQuantityUnit</b>
     * </p>
     * 
     * @return Condition Scale Unit of Measure
     */
    @Nullable
    @ElementName( "ConditionScaleQuantityUnit" )
    private java.lang.String conditionScaleQuantityUnit;
    public final static SimpleProperty.String<CndnContrConditionRecord> CONDITION_SCALE_QUANTITY_UNIT =
        new SimpleProperty.String<CndnContrConditionRecord>(
            CndnContrConditionRecord.class,
            "ConditionScaleQuantityUnit");
    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>CndnScaleQuantityUnitISOCode</b>
     * </p>
     * 
     * @return Condition Scale Unit of Measure in ISO Code
     */
    @Nullable
    @ElementName( "CndnScaleQuantityUnitISOCode" )
    private java.lang.String cndnScaleQuantityUnitISOCode;
    public final static SimpleProperty.String<CndnContrConditionRecord> CNDN_SCALE_QUANTITY_UNIT_ISO_CODE =
        new SimpleProperty.String<CndnContrConditionRecord>(
            CndnContrConditionRecord.class,
            "CndnScaleQuantityUnitISOCode");
    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>CndnScaleQuantityUnitSAPCode</b>
     * </p>
     * 
     * @return Condition Scale Unit of Measure in SAP Code
     */
    @Nullable
    @ElementName( "CndnScaleQuantityUnitSAPCode" )
    private java.lang.String cndnScaleQuantityUnitSAPCode;
    public final static SimpleProperty.String<CndnContrConditionRecord> CNDN_SCALE_QUANTITY_UNIT_SAP_CODE =
        new SimpleProperty.String<CndnContrConditionRecord>(
            CndnContrConditionRecord.class,
            "CndnScaleQuantityUnitSAPCode");
    /**
     * Constraints: Not nullable, Maximum length: 5
     * <p>
     * Original property name from the Odata EDM: <b>ConditionScaleAmountCurrency</b>
     * </p>
     * 
     * @return Scale Currency
     */
    @Nullable
    @ElementName( "ConditionScaleAmountCurrency" )
    private java.lang.String conditionScaleAmountCurrency;
    public final static SimpleProperty.String<CndnContrConditionRecord> CONDITION_SCALE_AMOUNT_CURRENCY =
        new SimpleProperty.String<CndnContrConditionRecord>(
            CndnContrConditionRecord.class,
            "ConditionScaleAmountCurrency");
    /**
     * Constraints: Not nullable
     * <p>
     * Original property name from the Odata EDM: <b>ConditionIsDeleted</b>
     * </p>
     * 
     * @return Deletion Indicator for Condition Record
     */
    @Nullable
    @ElementName( "ConditionIsDeleted" )
    private java.lang.Boolean conditionIsDeleted;
    public final static SimpleProperty.Boolean<CndnContrConditionRecord> CONDITION_IS_DELETED =
        new SimpleProperty.Boolean<CndnContrConditionRecord>(CndnContrConditionRecord.class, "ConditionIsDeleted");
    /**
     * Constraints: Not nullable, Maximum length: 18
     * <p>
     * Original property name from the Odata EDM: <b>Product</b>
     * </p>
     * 
     * @return Product Number
     */
    @Nullable
    @ElementName( "Product" )
    private java.lang.String product;
    public final static SimpleProperty.String<CndnContrConditionRecord> PRODUCT =
        new SimpleProperty.String<CndnContrConditionRecord>(CndnContrConditionRecord.class, "Product");
    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>Customer</b>
     * </p>
     * 
     * @return Customer Number
     */
    @Nullable
    @ElementName( "Customer" )
    private java.lang.String customer;
    public final static SimpleProperty.String<CndnContrConditionRecord> CUSTOMER =
        new SimpleProperty.String<CndnContrConditionRecord>(CndnContrConditionRecord.class, "Customer");
    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>BillToParty</b>
     * </p>
     * 
     * @return Bill-to Party
     */
    @Nullable
    @ElementName( "BillToParty" )
    private java.lang.String billToParty;
    public final static SimpleProperty.String<CndnContrConditionRecord> BILL_TO_PARTY =
        new SimpleProperty.String<CndnContrConditionRecord>(CndnContrConditionRecord.class, "BillToParty");
    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>PayerParty</b>
     * </p>
     * 
     * @return Payer
     */
    @Nullable
    @ElementName( "PayerParty" )
    private java.lang.String payerParty;
    public final static SimpleProperty.String<CndnContrConditionRecord> PAYER_PARTY =
        new SimpleProperty.String<CndnContrConditionRecord>(CndnContrConditionRecord.class, "PayerParty");
    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>ShipToParty</b>
     * </p>
     * 
     * @return Ship-to Party
     */
    @Nullable
    @ElementName( "ShipToParty" )
    private java.lang.String shipToParty;
    public final static SimpleProperty.String<CndnContrConditionRecord> SHIP_TO_PARTY =
        new SimpleProperty.String<CndnContrConditionRecord>(CndnContrConditionRecord.class, "ShipToParty");
    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>Supplier</b>
     * </p>
     * 
     * @return Supplier
     */
    @Nullable
    @ElementName( "Supplier" )
    private java.lang.String supplier;
    public final static SimpleProperty.String<CndnContrConditionRecord> SUPPLIER =
        new SimpleProperty.String<CndnContrConditionRecord>(CndnContrConditionRecord.class, "Supplier");
    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>InvoicingParty</b>
     * </p>
     * 
     * @return Different Invoicing Party
     */
    @Nullable
    @ElementName( "InvoicingParty" )
    private java.lang.String invoicingParty;
    public final static SimpleProperty.String<CndnContrConditionRecord> INVOICING_PARTY =
        new SimpleProperty.String<CndnContrConditionRecord>(CndnContrConditionRecord.class, "InvoicingParty");
    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>PriorSupplier</b>
     * </p>
     * 
     * @return Prior Supplier
     */
    @Nullable
    @ElementName( "PriorSupplier" )
    private java.lang.String priorSupplier;
    public final static SimpleProperty.String<CndnContrConditionRecord> PRIOR_SUPPLIER =
        new SimpleProperty.String<CndnContrConditionRecord>(CndnContrConditionRecord.class, "PriorSupplier");
    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>SupplyingSupplier</b>
     * </p>
     * 
     * @return Goods Supplier
     */
    @Nullable
    @ElementName( "SupplyingSupplier" )
    private java.lang.String supplyingSupplier;
    public final static SimpleProperty.String<CndnContrConditionRecord> SUPPLYING_SUPPLIER =
        new SimpleProperty.String<CndnContrConditionRecord>(CndnContrConditionRecord.class, "SupplyingSupplier");
    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>CompanyCode</b>
     * </p>
     * 
     * @return Company Code
     */
    @Nullable
    @ElementName( "CompanyCode" )
    private java.lang.String companyCode;
    public final static SimpleProperty.String<CndnContrConditionRecord> COMPANY_CODE =
        new SimpleProperty.String<CndnContrConditionRecord>(CndnContrConditionRecord.class, "CompanyCode");
    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>SalesOrganization</b>
     * </p>
     * 
     * @return Sales Organization
     */
    @Nullable
    @ElementName( "SalesOrganization" )
    private java.lang.String salesOrganization;
    public final static SimpleProperty.String<CndnContrConditionRecord> SALES_ORGANIZATION =
        new SimpleProperty.String<CndnContrConditionRecord>(CndnContrConditionRecord.class, "SalesOrganization");
    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>DistributionChannel</b>
     * </p>
     * 
     * @return Distribution Channel
     */
    @Nullable
    @ElementName( "DistributionChannel" )
    private java.lang.String distributionChannel;
    public final static SimpleProperty.String<CndnContrConditionRecord> DISTRIBUTION_CHANNEL =
        new SimpleProperty.String<CndnContrConditionRecord>(CndnContrConditionRecord.class, "DistributionChannel");
    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>Division</b>
     * </p>
     * 
     * @return Division
     */
    @Nullable
    @ElementName( "Division" )
    private java.lang.String division;
    public final static SimpleProperty.String<CndnContrConditionRecord> DIVISION =
        new SimpleProperty.String<CndnContrConditionRecord>(CndnContrConditionRecord.class, "Division");
    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>SalesOffice</b>
     * </p>
     * 
     * @return Sales Office
     */
    @Nullable
    @ElementName( "SalesOffice" )
    private java.lang.String salesOffice;
    public final static SimpleProperty.String<CndnContrConditionRecord> SALES_OFFICE =
        new SimpleProperty.String<CndnContrConditionRecord>(CndnContrConditionRecord.class, "SalesOffice");
    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>SalesGroup</b>
     * </p>
     * 
     * @return Sales Group
     */
    @Nullable
    @ElementName( "SalesGroup" )
    private java.lang.String salesGroup;
    public final static SimpleProperty.String<CndnContrConditionRecord> SALES_GROUP =
        new SimpleProperty.String<CndnContrConditionRecord>(CndnContrConditionRecord.class, "SalesGroup");
    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>PurchasingOrganization</b>
     * </p>
     * 
     * @return Purchasing Organization
     */
    @Nullable
    @ElementName( "PurchasingOrganization" )
    private java.lang.String purchasingOrganization;
    public final static SimpleProperty.String<CndnContrConditionRecord> PURCHASING_ORGANIZATION =
        new SimpleProperty.String<CndnContrConditionRecord>(CndnContrConditionRecord.class, "PurchasingOrganization");
    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>Plant</b>
     * </p>
     * 
     * @return Plant
     */
    @Nullable
    @ElementName( "Plant" )
    private java.lang.String plant;
    public final static SimpleProperty.String<CndnContrConditionRecord> PLANT =
        new SimpleProperty.String<CndnContrConditionRecord>(CndnContrConditionRecord.class, "Plant");
    /**
     * Constraints: Not nullable, Maximum length: 9
     * <p>
     * Original property name from the Odata EDM: <b>ProductGroup</b>
     * </p>
     * 
     * @return Product Group
     */
    @Nullable
    @ElementName( "ProductGroup" )
    private java.lang.String productGroup;
    public final static SimpleProperty.String<CndnContrConditionRecord> PRODUCT_GROUP =
        new SimpleProperty.String<CndnContrConditionRecord>(CndnContrConditionRecord.class, "ProductGroup");
    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>SalesSpcfcProductGroup1</b>
     * </p>
     * 
     * @return Sales-Specific Product Group 1
     */
    @Nullable
    @ElementName( "SalesSpcfcProductGroup1" )
    private java.lang.String salesSpcfcProductGroup1;
    public final static SimpleProperty.String<CndnContrConditionRecord> SALES_SPCFC_PRODUCT_GROUP1 =
        new SimpleProperty.String<CndnContrConditionRecord>(CndnContrConditionRecord.class, "SalesSpcfcProductGroup1");
    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>SalesSpcfcProductGroup2</b>
     * </p>
     * 
     * @return Sales-Specific Product Group 2
     */
    @Nullable
    @ElementName( "SalesSpcfcProductGroup2" )
    private java.lang.String salesSpcfcProductGroup2;
    public final static SimpleProperty.String<CndnContrConditionRecord> SALES_SPCFC_PRODUCT_GROUP2 =
        new SimpleProperty.String<CndnContrConditionRecord>(CndnContrConditionRecord.class, "SalesSpcfcProductGroup2");
    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>SalesSpcfcProductGroup3</b>
     * </p>
     * 
     * @return Sales-Specific Product Group 3
     */
    @Nullable
    @ElementName( "SalesSpcfcProductGroup3" )
    private java.lang.String salesSpcfcProductGroup3;
    public final static SimpleProperty.String<CndnContrConditionRecord> SALES_SPCFC_PRODUCT_GROUP3 =
        new SimpleProperty.String<CndnContrConditionRecord>(CndnContrConditionRecord.class, "SalesSpcfcProductGroup3");
    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>SalesSpcfcProductGroup4</b>
     * </p>
     * 
     * @return Sales-Specific Product Group 4
     */
    @Nullable
    @ElementName( "SalesSpcfcProductGroup4" )
    private java.lang.String salesSpcfcProductGroup4;
    public final static SimpleProperty.String<CndnContrConditionRecord> SALES_SPCFC_PRODUCT_GROUP4 =
        new SimpleProperty.String<CndnContrConditionRecord>(CndnContrConditionRecord.class, "SalesSpcfcProductGroup4");
    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>SalesSpcfcProductGroup5</b>
     * </p>
     * 
     * @return Sales-Specific Product Group 5
     */
    @Nullable
    @ElementName( "SalesSpcfcProductGroup5" )
    private java.lang.String salesSpcfcProductGroup5;
    public final static SimpleProperty.String<CndnContrConditionRecord> SALES_SPCFC_PRODUCT_GROUP5 =
        new SimpleProperty.String<CndnContrConditionRecord>(CndnContrConditionRecord.class, "SalesSpcfcProductGroup5");
    /**
     * Constraints: Not nullable
     * <p>
     * Original property name from the Odata EDM: <b>SAP__Messages</b>
     * </p>
     * 
     * @return The _Messages contained in this {@link VdmEntity}.
     */
    @Nullable
    @ElementName( "SAP__Messages" )
    private java.util.Collection<SAP__Message> _Messages;
    /**
     * Use with available request builders to apply the <b>SAP__Messages</b> complex property to query operations.
     * 
     */
    public final static com.sap.cloud.sdk.datamodel.odatav4.core.ComplexProperty.Collection<CndnContrConditionRecord, SAP__Message> _MESSAGES =
        new com.sap.cloud.sdk.datamodel.odatav4.core.ComplexProperty.Collection<CndnContrConditionRecord, SAP__Message>(
            CndnContrConditionRecord.class,
            "SAP__Messages",
            SAP__Message.class);
    /**
     * Navigation property <b>_CndnContrCndnRecdValidity</b> for <b>CndnContrConditionRecord</b> to multiple
     * <b>CndnContrCndnRecordValidity</b>.
     * 
     */
    @ElementName( "_CndnContrCndnRecdValidity" )
    @Getter( AccessLevel.NONE )
    @Setter( AccessLevel.NONE )
    private List<CndnContrCndnRecordValidity> to_CndnContrCndnRecdValidity;
    /**
     * Navigation property <b>_CndnContrScCndnRecord</b> for <b>CndnContrConditionRecord</b> to multiple
     * <b>CndnContrConditionRecordScale</b>.
     * 
     */
    @ElementName( "_CndnContrScCndnRecord" )
    @Getter( AccessLevel.NONE )
    @Setter( AccessLevel.NONE )
    private List<CndnContrConditionRecordScale> to_CndnContrScCndnRecord;
    /**
     * Navigation property <b>_ConditionContract</b> for <b>CndnContrConditionRecord</b> to single
     * <b>ConditionContract</b>.
     * 
     */
    @ElementName( "_ConditionContract" )
    @Nullable
    @Getter( AccessLevel.NONE )
    @Setter( AccessLevel.NONE )
    private ConditionContract to_ConditionContract;
    /**
     * Use with available request builders to apply the <b>_CndnContrCndnRecdValidity</b> navigation property to query
     * operations.
     * 
     */
    public final static com.sap.cloud.sdk.datamodel.odatav4.core.NavigationProperty.Collection<CndnContrConditionRecord, CndnContrCndnRecordValidity> TO__CNDN_CONTR_CNDN_RECD_VALIDITY =
        new com.sap.cloud.sdk.datamodel.odatav4.core.NavigationProperty.Collection<CndnContrConditionRecord, CndnContrCndnRecordValidity>(
            CndnContrConditionRecord.class,
            "_CndnContrCndnRecdValidity",
            CndnContrCndnRecordValidity.class);
    /**
     * Use with available request builders to apply the <b>_CndnContrScCndnRecord</b> navigation property to query
     * operations.
     * 
     */
    public final static com.sap.cloud.sdk.datamodel.odatav4.core.NavigationProperty.Collection<CndnContrConditionRecord, CndnContrConditionRecordScale> TO__CNDN_CONTR_SC_CNDN_RECORD =
        new com.sap.cloud.sdk.datamodel.odatav4.core.NavigationProperty.Collection<CndnContrConditionRecord, CndnContrConditionRecordScale>(
            CndnContrConditionRecord.class,
            "_CndnContrScCndnRecord",
            CndnContrConditionRecordScale.class);
    /**
     * Use with available request builders to apply the <b>_ConditionContract</b> navigation property to query
     * operations.
     * 
     */
    public final static com.sap.cloud.sdk.datamodel.odatav4.core.NavigationProperty.Single<CndnContrConditionRecord, ConditionContract> TO__CONDITION_CONTRACT =
        new com.sap.cloud.sdk.datamodel.odatav4.core.NavigationProperty.Single<CndnContrConditionRecord, ConditionContract>(
            CndnContrConditionRecord.class,
            "_ConditionContract",
            ConditionContract.class);

    /**
     * {@inheritDoc}
     * 
     */
    @Nonnull
    @Override
    public Class<CndnContrConditionRecord> getType()
    {
        return CndnContrConditionRecord.class;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>ConditionContract</b>
     * </p>
     * 
     * @param conditionContract
     *            Condition Contract
     */
    public void setConditionContract( @Nullable final java.lang.String conditionContract )
    {
        rememberChangedField("ConditionContract", this.conditionContract);
        this.conditionContract = conditionContract;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>ConditionRecord</b>
     * </p>
     * 
     * @param conditionRecord
     *            Number of the Condition Record
     */
    public void setConditionRecord( @Nullable final java.lang.String conditionRecord )
    {
        rememberChangedField("ConditionRecord", this.conditionRecord);
        this.conditionRecord = conditionRecord;
    }

    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>ConditionTable</b>
     * </p>
     * 
     * @param conditionTable
     *            Condition Table
     */
    public void setConditionTable( @Nullable final java.lang.String conditionTable )
    {
        rememberChangedField("ConditionTable", this.conditionTable);
        this.conditionTable = conditionTable;
    }

    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>ConditionApplication</b>
     * </p>
     * 
     * @param conditionApplication
     *            Application
     */
    public void setConditionApplication( @Nullable final java.lang.String conditionApplication )
    {
        rememberChangedField("ConditionApplication", this.conditionApplication);
        this.conditionApplication = conditionApplication;
    }

    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>ConditionType</b>
     * </p>
     * 
     * @param conditionType
     *            Condition Type
     */
    public void setConditionType( @Nullable final java.lang.String conditionType )
    {
        rememberChangedField("ConditionType", this.conditionType);
        this.conditionType = conditionType;
    }

    /**
     * Constraints: Nullable
     * <p>
     * Original property name from the Odata EDM: <b>ConditionValidityStartDate</b>
     * </p>
     * 
     * @param conditionValidityStartDate
     *            Validity start date of the condition record
     */
    public void setConditionValidityStartDate( @Nullable final LocalDate conditionValidityStartDate )
    {
        rememberChangedField("ConditionValidityStartDate", this.conditionValidityStartDate);
        this.conditionValidityStartDate = conditionValidityStartDate;
    }

    /**
     * Constraints: Nullable
     * <p>
     * Original property name from the Odata EDM: <b>ConditionValidityEndDate</b>
     * </p>
     * 
     * @param conditionValidityEndDate
     *            Validity end date of the condition record
     */
    public void setConditionValidityEndDate( @Nullable final LocalDate conditionValidityEndDate )
    {
        rememberChangedField("ConditionValidityEndDate", this.conditionValidityEndDate);
        this.conditionValidityEndDate = conditionValidityEndDate;
    }

    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>ConditionCalculationType</b>
     * </p>
     * 
     * @param conditionCalculationType
     *            Calculation Type for Condition
     */
    public void setConditionCalculationType( @Nullable final java.lang.String conditionCalculationType )
    {
        rememberChangedField("ConditionCalculationType", this.conditionCalculationType);
        this.conditionCalculationType = conditionCalculationType;
    }

    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>PricingScaleBasis</b>
     * </p>
     * 
     * @param pricingScaleBasis
     *            Scale Basis Indicator
     */
    public void setPricingScaleBasis( @Nullable final java.lang.String pricingScaleBasis )
    {
        rememberChangedField("PricingScaleBasis", this.pricingScaleBasis);
        this.pricingScaleBasis = pricingScaleBasis;
    }

    /**
     * Constraints: Not nullable, Precision: 24, Scale: 9
     * <p>
     * Original property name from the Odata EDM: <b>ConditionRateAmount</b>
     * </p>
     * 
     * @param conditionRateAmount
     *            The conditionRateAmount to set.
     */
    public void setConditionRateAmount( @Nullable final BigDecimal conditionRateAmount )
    {
        rememberChangedField("ConditionRateAmount", this.conditionRateAmount);
        this.conditionRateAmount = conditionRateAmount;
    }

    /**
     * Constraints: Not nullable, Precision: 24, Scale: 9
     * <p>
     * Original property name from the Odata EDM: <b>ConditionAccrualsAmount</b>
     * </p>
     * 
     * @param conditionAccrualsAmount
     *            The conditionAccrualsAmount to set.
     */
    public void setConditionAccrualsAmount( @Nullable final BigDecimal conditionAccrualsAmount )
    {
        rememberChangedField("ConditionAccrualsAmount", this.conditionAccrualsAmount);
        this.conditionAccrualsAmount = conditionAccrualsAmount;
    }

    /**
     * Constraints: Not nullable, Maximum length: 5
     * <p>
     * Original property name from the Odata EDM: <b>ConditionCurrency</b>
     * </p>
     * 
     * @param conditionCurrency
     *            Condition Unit (Currency or Percentage)
     */
    public void setConditionCurrency( @Nullable final java.lang.String conditionCurrency )
    {
        rememberChangedField("ConditionCurrency", this.conditionCurrency);
        this.conditionCurrency = conditionCurrency;
    }

    /**
     * Constraints: Not nullable, Precision: 5
     * <p>
     * Original property name from the Odata EDM: <b>ConditionQuantity</b>
     * </p>
     * 
     * @param conditionQuantity
     *            The conditionQuantity to set.
     */
    public void setConditionQuantity( @Nullable final BigDecimal conditionQuantity )
    {
        rememberChangedField("ConditionQuantity", this.conditionQuantity);
        this.conditionQuantity = conditionQuantity;
    }

    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>ConditionQuantityUnit</b>
     * </p>
     * 
     * @param conditionQuantityUnit
     *            Condition Unit
     */
    public void setConditionQuantityUnit( @Nullable final java.lang.String conditionQuantityUnit )
    {
        rememberChangedField("ConditionQuantityUnit", this.conditionQuantityUnit);
        this.conditionQuantityUnit = conditionQuantityUnit;
    }

    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>ConditionQuantityUnitISOCode</b>
     * </p>
     * 
     * @param conditionQuantityUnitISOCode
     *            Condition Quantity Unit in ISO code
     */
    public void setConditionQuantityUnitISOCode( @Nullable final java.lang.String conditionQuantityUnitISOCode )
    {
        rememberChangedField("ConditionQuantityUnitISOCode", this.conditionQuantityUnitISOCode);
        this.conditionQuantityUnitISOCode = conditionQuantityUnitISOCode;
    }

    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>ConditionQuantityUnitSAPCode</b>
     * </p>
     * 
     * @param conditionQuantityUnitSAPCode
     *            Condition Quantity Unit in SAP code
     */
    public void setConditionQuantityUnitSAPCode( @Nullable final java.lang.String conditionQuantityUnitSAPCode )
    {
        rememberChangedField("ConditionQuantityUnitSAPCode", this.conditionQuantityUnitSAPCode);
        this.conditionQuantityUnitSAPCode = conditionQuantityUnitSAPCode;
    }

    /**
     * Constraints: Not nullable, Precision: 24, Scale: 9
     * <p>
     * Original property name from the Odata EDM: <b>ConditionRateRatio</b>
     * </p>
     * 
     * @param conditionRateRatio
     *            The conditionRateRatio to set.
     */
    public void setConditionRateRatio( @Nullable final BigDecimal conditionRateRatio )
    {
        rememberChangedField("ConditionRateRatio", this.conditionRateRatio);
        this.conditionRateRatio = conditionRateRatio;
    }

    /**
     * Constraints: Not nullable, Precision: 24, Scale: 9
     * <p>
     * Original property name from the Odata EDM: <b>ConditionAccrualsRatio</b>
     * </p>
     * 
     * @param conditionAccrualsRatio
     *            The conditionAccrualsRatio to set.
     */
    public void setConditionAccrualsRatio( @Nullable final BigDecimal conditionAccrualsRatio )
    {
        rememberChangedField("ConditionAccrualsRatio", this.conditionAccrualsRatio);
        this.conditionAccrualsRatio = conditionAccrualsRatio;
    }

    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>ConditionRateRatioUnit</b>
     * </p>
     * 
     * @param conditionRateRatioUnit
     *            Percent Sign (Transactional Processing)
     */
    public void setConditionRateRatioUnit( @Nullable final java.lang.String conditionRateRatioUnit )
    {
        rememberChangedField("ConditionRateRatioUnit", this.conditionRateRatioUnit);
        this.conditionRateRatioUnit = conditionRateRatioUnit;
    }

    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>ConditionRateRatioUnitISOCode</b>
     * </p>
     * 
     * @param conditionRateRatioUnitISOCode
     *            Percent Sign in ISO Code
     */
    public void setConditionRateRatioUnitISOCode( @Nullable final java.lang.String conditionRateRatioUnitISOCode )
    {
        rememberChangedField("ConditionRateRatioUnitISOCode", this.conditionRateRatioUnitISOCode);
        this.conditionRateRatioUnitISOCode = conditionRateRatioUnitISOCode;
    }

    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>ConditionRateRatioUnitSAPCode</b>
     * </p>
     * 
     * @param conditionRateRatioUnitSAPCode
     *            Percent Sign in SAP Code
     */
    public void setConditionRateRatioUnitSAPCode( @Nullable final java.lang.String conditionRateRatioUnitSAPCode )
    {
        rememberChangedField("ConditionRateRatioUnitSAPCode", this.conditionRateRatioUnitSAPCode);
        this.conditionRateRatioUnitSAPCode = conditionRateRatioUnitSAPCode;
    }

    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>PricingScaleType</b>
     * </p>
     * 
     * @param pricingScaleType
     *            Scale Type
     */
    public void setPricingScaleType( @Nullable final java.lang.String pricingScaleType )
    {
        rememberChangedField("PricingScaleType", this.pricingScaleType);
        this.pricingScaleType = pricingScaleType;
    }

    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>ConditionScaleQuantityUnit</b>
     * </p>
     * 
     * @param conditionScaleQuantityUnit
     *            Condition Scale Unit of Measure
     */
    public void setConditionScaleQuantityUnit( @Nullable final java.lang.String conditionScaleQuantityUnit )
    {
        rememberChangedField("ConditionScaleQuantityUnit", this.conditionScaleQuantityUnit);
        this.conditionScaleQuantityUnit = conditionScaleQuantityUnit;
    }

    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>CndnScaleQuantityUnitISOCode</b>
     * </p>
     * 
     * @param cndnScaleQuantityUnitISOCode
     *            Condition Scale Unit of Measure in ISO Code
     */
    public void setCndnScaleQuantityUnitISOCode( @Nullable final java.lang.String cndnScaleQuantityUnitISOCode )
    {
        rememberChangedField("CndnScaleQuantityUnitISOCode", this.cndnScaleQuantityUnitISOCode);
        this.cndnScaleQuantityUnitISOCode = cndnScaleQuantityUnitISOCode;
    }

    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>CndnScaleQuantityUnitSAPCode</b>
     * </p>
     * 
     * @param cndnScaleQuantityUnitSAPCode
     *            Condition Scale Unit of Measure in SAP Code
     */
    public void setCndnScaleQuantityUnitSAPCode( @Nullable final java.lang.String cndnScaleQuantityUnitSAPCode )
    {
        rememberChangedField("CndnScaleQuantityUnitSAPCode", this.cndnScaleQuantityUnitSAPCode);
        this.cndnScaleQuantityUnitSAPCode = cndnScaleQuantityUnitSAPCode;
    }

    /**
     * Constraints: Not nullable, Maximum length: 5
     * <p>
     * Original property name from the Odata EDM: <b>ConditionScaleAmountCurrency</b>
     * </p>
     * 
     * @param conditionScaleAmountCurrency
     *            Scale Currency
     */
    public void setConditionScaleAmountCurrency( @Nullable final java.lang.String conditionScaleAmountCurrency )
    {
        rememberChangedField("ConditionScaleAmountCurrency", this.conditionScaleAmountCurrency);
        this.conditionScaleAmountCurrency = conditionScaleAmountCurrency;
    }

    /**
     * Constraints: Not nullable
     * <p>
     * Original property name from the Odata EDM: <b>ConditionIsDeleted</b>
     * </p>
     * 
     * @param conditionIsDeleted
     *            Deletion Indicator for Condition Record
     */
    public void setConditionIsDeleted( @Nullable final java.lang.Boolean conditionIsDeleted )
    {
        rememberChangedField("ConditionIsDeleted", this.conditionIsDeleted);
        this.conditionIsDeleted = conditionIsDeleted;
    }

    /**
     * Constraints: Not nullable, Maximum length: 18
     * <p>
     * Original property name from the Odata EDM: <b>Product</b>
     * </p>
     * 
     * @param product
     *            Product Number
     */
    public void setProduct( @Nullable final java.lang.String product )
    {
        rememberChangedField("Product", this.product);
        this.product = product;
    }

    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>Customer</b>
     * </p>
     * 
     * @param customer
     *            Customer Number
     */
    public void setCustomer( @Nullable final java.lang.String customer )
    {
        rememberChangedField("Customer", this.customer);
        this.customer = customer;
    }

    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>BillToParty</b>
     * </p>
     * 
     * @param billToParty
     *            Bill-to Party
     */
    public void setBillToParty( @Nullable final java.lang.String billToParty )
    {
        rememberChangedField("BillToParty", this.billToParty);
        this.billToParty = billToParty;
    }

    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>PayerParty</b>
     * </p>
     * 
     * @param payerParty
     *            Payer
     */
    public void setPayerParty( @Nullable final java.lang.String payerParty )
    {
        rememberChangedField("PayerParty", this.payerParty);
        this.payerParty = payerParty;
    }

    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>ShipToParty</b>
     * </p>
     * 
     * @param shipToParty
     *            Ship-to Party
     */
    public void setShipToParty( @Nullable final java.lang.String shipToParty )
    {
        rememberChangedField("ShipToParty", this.shipToParty);
        this.shipToParty = shipToParty;
    }

    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>Supplier</b>
     * </p>
     * 
     * @param supplier
     *            Supplier
     */
    public void setSupplier( @Nullable final java.lang.String supplier )
    {
        rememberChangedField("Supplier", this.supplier);
        this.supplier = supplier;
    }

    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>InvoicingParty</b>
     * </p>
     * 
     * @param invoicingParty
     *            Different Invoicing Party
     */
    public void setInvoicingParty( @Nullable final java.lang.String invoicingParty )
    {
        rememberChangedField("InvoicingParty", this.invoicingParty);
        this.invoicingParty = invoicingParty;
    }

    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>PriorSupplier</b>
     * </p>
     * 
     * @param priorSupplier
     *            Prior Supplier
     */
    public void setPriorSupplier( @Nullable final java.lang.String priorSupplier )
    {
        rememberChangedField("PriorSupplier", this.priorSupplier);
        this.priorSupplier = priorSupplier;
    }

    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>SupplyingSupplier</b>
     * </p>
     * 
     * @param supplyingSupplier
     *            Goods Supplier
     */
    public void setSupplyingSupplier( @Nullable final java.lang.String supplyingSupplier )
    {
        rememberChangedField("SupplyingSupplier", this.supplyingSupplier);
        this.supplyingSupplier = supplyingSupplier;
    }

    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>CompanyCode</b>
     * </p>
     * 
     * @param companyCode
     *            Company Code
     */
    public void setCompanyCode( @Nullable final java.lang.String companyCode )
    {
        rememberChangedField("CompanyCode", this.companyCode);
        this.companyCode = companyCode;
    }

    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>SalesOrganization</b>
     * </p>
     * 
     * @param salesOrganization
     *            Sales Organization
     */
    public void setSalesOrganization( @Nullable final java.lang.String salesOrganization )
    {
        rememberChangedField("SalesOrganization", this.salesOrganization);
        this.salesOrganization = salesOrganization;
    }

    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>DistributionChannel</b>
     * </p>
     * 
     * @param distributionChannel
     *            Distribution Channel
     */
    public void setDistributionChannel( @Nullable final java.lang.String distributionChannel )
    {
        rememberChangedField("DistributionChannel", this.distributionChannel);
        this.distributionChannel = distributionChannel;
    }

    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>Division</b>
     * </p>
     * 
     * @param division
     *            Division
     */
    public void setDivision( @Nullable final java.lang.String division )
    {
        rememberChangedField("Division", this.division);
        this.division = division;
    }

    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>SalesOffice</b>
     * </p>
     * 
     * @param salesOffice
     *            Sales Office
     */
    public void setSalesOffice( @Nullable final java.lang.String salesOffice )
    {
        rememberChangedField("SalesOffice", this.salesOffice);
        this.salesOffice = salesOffice;
    }

    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>SalesGroup</b>
     * </p>
     * 
     * @param salesGroup
     *            Sales Group
     */
    public void setSalesGroup( @Nullable final java.lang.String salesGroup )
    {
        rememberChangedField("SalesGroup", this.salesGroup);
        this.salesGroup = salesGroup;
    }

    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>PurchasingOrganization</b>
     * </p>
     * 
     * @param purchasingOrganization
     *            Purchasing Organization
     */
    public void setPurchasingOrganization( @Nullable final java.lang.String purchasingOrganization )
    {
        rememberChangedField("PurchasingOrganization", this.purchasingOrganization);
        this.purchasingOrganization = purchasingOrganization;
    }

    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>Plant</b>
     * </p>
     * 
     * @param plant
     *            Plant
     */
    public void setPlant( @Nullable final java.lang.String plant )
    {
        rememberChangedField("Plant", this.plant);
        this.plant = plant;
    }

    /**
     * Constraints: Not nullable, Maximum length: 9
     * <p>
     * Original property name from the Odata EDM: <b>ProductGroup</b>
     * </p>
     * 
     * @param productGroup
     *            Product Group
     */
    public void setProductGroup( @Nullable final java.lang.String productGroup )
    {
        rememberChangedField("ProductGroup", this.productGroup);
        this.productGroup = productGroup;
    }

    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>SalesSpcfcProductGroup1</b>
     * </p>
     * 
     * @param salesSpcfcProductGroup1
     *            Sales-Specific Product Group 1
     */
    public void setSalesSpcfcProductGroup1( @Nullable final java.lang.String salesSpcfcProductGroup1 )
    {
        rememberChangedField("SalesSpcfcProductGroup1", this.salesSpcfcProductGroup1);
        this.salesSpcfcProductGroup1 = salesSpcfcProductGroup1;
    }

    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>SalesSpcfcProductGroup2</b>
     * </p>
     * 
     * @param salesSpcfcProductGroup2
     *            Sales-Specific Product Group 2
     */
    public void setSalesSpcfcProductGroup2( @Nullable final java.lang.String salesSpcfcProductGroup2 )
    {
        rememberChangedField("SalesSpcfcProductGroup2", this.salesSpcfcProductGroup2);
        this.salesSpcfcProductGroup2 = salesSpcfcProductGroup2;
    }

    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>SalesSpcfcProductGroup3</b>
     * </p>
     * 
     * @param salesSpcfcProductGroup3
     *            Sales-Specific Product Group 3
     */
    public void setSalesSpcfcProductGroup3( @Nullable final java.lang.String salesSpcfcProductGroup3 )
    {
        rememberChangedField("SalesSpcfcProductGroup3", this.salesSpcfcProductGroup3);
        this.salesSpcfcProductGroup3 = salesSpcfcProductGroup3;
    }

    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>SalesSpcfcProductGroup4</b>
     * </p>
     * 
     * @param salesSpcfcProductGroup4
     *            Sales-Specific Product Group 4
     */
    public void setSalesSpcfcProductGroup4( @Nullable final java.lang.String salesSpcfcProductGroup4 )
    {
        rememberChangedField("SalesSpcfcProductGroup4", this.salesSpcfcProductGroup4);
        this.salesSpcfcProductGroup4 = salesSpcfcProductGroup4;
    }

    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>SalesSpcfcProductGroup5</b>
     * </p>
     * 
     * @param salesSpcfcProductGroup5
     *            Sales-Specific Product Group 5
     */
    public void setSalesSpcfcProductGroup5( @Nullable final java.lang.String salesSpcfcProductGroup5 )
    {
        rememberChangedField("SalesSpcfcProductGroup5", this.salesSpcfcProductGroup5);
        this.salesSpcfcProductGroup5 = salesSpcfcProductGroup5;
    }

    /**
     * Constraints: Not nullable
     * <p>
     * Original property name from the Odata EDM: <b>SAP__Messages</b>
     * </p>
     * 
     * @param _Messages
     *            The _Messages to set.
     */
    public void set_Messages( @Nullable final java.util.Collection<SAP__Message> _Messages )
    {
        rememberChangedField("SAP__Messages", this._Messages);
        this._Messages = _Messages;
    }

    @Override
    protected java.lang.String getEntityCollection()
    {
        return "CndnContrConditionRecord";
    }

    @Nonnull
    @Override
    protected ODataEntityKey getKey()
    {
        final ODataEntityKey entityKey = super.getKey();
        entityKey.addKeyProperty("ConditionContract", getConditionContract());
        entityKey.addKeyProperty("ConditionRecord", getConditionRecord());
        return entityKey;
    }

    @Nonnull
    @Override
    protected Map<java.lang.String, Object> toMapOfFields()
    {
        final Map<java.lang.String, Object> values = super.toMapOfFields();
        values.put("ConditionContract", getConditionContract());
        values.put("ConditionRecord", getConditionRecord());
        values.put("ConditionTable", getConditionTable());
        values.put("ConditionApplication", getConditionApplication());
        values.put("ConditionType", getConditionType());
        values.put("ConditionValidityStartDate", getConditionValidityStartDate());
        values.put("ConditionValidityEndDate", getConditionValidityEndDate());
        values.put("ConditionCalculationType", getConditionCalculationType());
        values.put("PricingScaleBasis", getPricingScaleBasis());
        values.put("ConditionRateAmount", getConditionRateAmount());
        values.put("ConditionAccrualsAmount", getConditionAccrualsAmount());
        values.put("ConditionCurrency", getConditionCurrency());
        values.put("ConditionQuantity", getConditionQuantity());
        values.put("ConditionQuantityUnit", getConditionQuantityUnit());
        values.put("ConditionQuantityUnitISOCode", getConditionQuantityUnitISOCode());
        values.put("ConditionQuantityUnitSAPCode", getConditionQuantityUnitSAPCode());
        values.put("ConditionRateRatio", getConditionRateRatio());
        values.put("ConditionAccrualsRatio", getConditionAccrualsRatio());
        values.put("ConditionRateRatioUnit", getConditionRateRatioUnit());
        values.put("ConditionRateRatioUnitISOCode", getConditionRateRatioUnitISOCode());
        values.put("ConditionRateRatioUnitSAPCode", getConditionRateRatioUnitSAPCode());
        values.put("PricingScaleType", getPricingScaleType());
        values.put("ConditionScaleQuantityUnit", getConditionScaleQuantityUnit());
        values.put("CndnScaleQuantityUnitISOCode", getCndnScaleQuantityUnitISOCode());
        values.put("CndnScaleQuantityUnitSAPCode", getCndnScaleQuantityUnitSAPCode());
        values.put("ConditionScaleAmountCurrency", getConditionScaleAmountCurrency());
        values.put("ConditionIsDeleted", getConditionIsDeleted());
        values.put("Product", getProduct());
        values.put("Customer", getCustomer());
        values.put("BillToParty", getBillToParty());
        values.put("PayerParty", getPayerParty());
        values.put("ShipToParty", getShipToParty());
        values.put("Supplier", getSupplier());
        values.put("InvoicingParty", getInvoicingParty());
        values.put("PriorSupplier", getPriorSupplier());
        values.put("SupplyingSupplier", getSupplyingSupplier());
        values.put("CompanyCode", getCompanyCode());
        values.put("SalesOrganization", getSalesOrganization());
        values.put("DistributionChannel", getDistributionChannel());
        values.put("Division", getDivision());
        values.put("SalesOffice", getSalesOffice());
        values.put("SalesGroup", getSalesGroup());
        values.put("PurchasingOrganization", getPurchasingOrganization());
        values.put("Plant", getPlant());
        values.put("ProductGroup", getProductGroup());
        values.put("SalesSpcfcProductGroup1", getSalesSpcfcProductGroup1());
        values.put("SalesSpcfcProductGroup2", getSalesSpcfcProductGroup2());
        values.put("SalesSpcfcProductGroup3", getSalesSpcfcProductGroup3());
        values.put("SalesSpcfcProductGroup4", getSalesSpcfcProductGroup4());
        values.put("SalesSpcfcProductGroup5", getSalesSpcfcProductGroup5());
        values.put("SAP__Messages", get_Messages());
        return values;
    }

    @Override
    protected void fromMap( final Map<java.lang.String, Object> inputValues )
    {
        final Map<java.lang.String, Object> values = Maps.newHashMap(inputValues);
        // simple properties
        {
            if( values.containsKey("ConditionContract") ) {
                final Object value = values.remove("ConditionContract");
                if( (value == null) || (!value.equals(getConditionContract())) ) {
                    setConditionContract(((java.lang.String) value));
                }
            }
            if( values.containsKey("ConditionRecord") ) {
                final Object value = values.remove("ConditionRecord");
                if( (value == null) || (!value.equals(getConditionRecord())) ) {
                    setConditionRecord(((java.lang.String) value));
                }
            }
            if( values.containsKey("ConditionTable") ) {
                final Object value = values.remove("ConditionTable");
                if( (value == null) || (!value.equals(getConditionTable())) ) {
                    setConditionTable(((java.lang.String) value));
                }
            }
            if( values.containsKey("ConditionApplication") ) {
                final Object value = values.remove("ConditionApplication");
                if( (value == null) || (!value.equals(getConditionApplication())) ) {
                    setConditionApplication(((java.lang.String) value));
                }
            }
            if( values.containsKey("ConditionType") ) {
                final Object value = values.remove("ConditionType");
                if( (value == null) || (!value.equals(getConditionType())) ) {
                    setConditionType(((java.lang.String) value));
                }
            }
            if( values.containsKey("ConditionValidityStartDate") ) {
                final Object value = values.remove("ConditionValidityStartDate");
                if( (value == null) || (!value.equals(getConditionValidityStartDate())) ) {
                    setConditionValidityStartDate(((LocalDate) value));
                }
            }
            if( values.containsKey("ConditionValidityEndDate") ) {
                final Object value = values.remove("ConditionValidityEndDate");
                if( (value == null) || (!value.equals(getConditionValidityEndDate())) ) {
                    setConditionValidityEndDate(((LocalDate) value));
                }
            }
            if( values.containsKey("ConditionCalculationType") ) {
                final Object value = values.remove("ConditionCalculationType");
                if( (value == null) || (!value.equals(getConditionCalculationType())) ) {
                    setConditionCalculationType(((java.lang.String) value));
                }
            }
            if( values.containsKey("PricingScaleBasis") ) {
                final Object value = values.remove("PricingScaleBasis");
                if( (value == null) || (!value.equals(getPricingScaleBasis())) ) {
                    setPricingScaleBasis(((java.lang.String) value));
                }
            }
            if( values.containsKey("ConditionRateAmount") ) {
                final Object value = values.remove("ConditionRateAmount");
                if( (value == null) || (!value.equals(getConditionRateAmount())) ) {
                    setConditionRateAmount(((BigDecimal) value));
                }
            }
            if( values.containsKey("ConditionAccrualsAmount") ) {
                final Object value = values.remove("ConditionAccrualsAmount");
                if( (value == null) || (!value.equals(getConditionAccrualsAmount())) ) {
                    setConditionAccrualsAmount(((BigDecimal) value));
                }
            }
            if( values.containsKey("ConditionCurrency") ) {
                final Object value = values.remove("ConditionCurrency");
                if( (value == null) || (!value.equals(getConditionCurrency())) ) {
                    setConditionCurrency(((java.lang.String) value));
                }
            }
            if( values.containsKey("ConditionQuantity") ) {
                final Object value = values.remove("ConditionQuantity");
                if( (value == null) || (!value.equals(getConditionQuantity())) ) {
                    setConditionQuantity(((BigDecimal) value));
                }
            }
            if( values.containsKey("ConditionQuantityUnit") ) {
                final Object value = values.remove("ConditionQuantityUnit");
                if( (value == null) || (!value.equals(getConditionQuantityUnit())) ) {
                    setConditionQuantityUnit(((java.lang.String) value));
                }
            }
            if( values.containsKey("ConditionQuantityUnitISOCode") ) {
                final Object value = values.remove("ConditionQuantityUnitISOCode");
                if( (value == null) || (!value.equals(getConditionQuantityUnitISOCode())) ) {
                    setConditionQuantityUnitISOCode(((java.lang.String) value));
                }
            }
            if( values.containsKey("ConditionQuantityUnitSAPCode") ) {
                final Object value = values.remove("ConditionQuantityUnitSAPCode");
                if( (value == null) || (!value.equals(getConditionQuantityUnitSAPCode())) ) {
                    setConditionQuantityUnitSAPCode(((java.lang.String) value));
                }
            }
            if( values.containsKey("ConditionRateRatio") ) {
                final Object value = values.remove("ConditionRateRatio");
                if( (value == null) || (!value.equals(getConditionRateRatio())) ) {
                    setConditionRateRatio(((BigDecimal) value));
                }
            }
            if( values.containsKey("ConditionAccrualsRatio") ) {
                final Object value = values.remove("ConditionAccrualsRatio");
                if( (value == null) || (!value.equals(getConditionAccrualsRatio())) ) {
                    setConditionAccrualsRatio(((BigDecimal) value));
                }
            }
            if( values.containsKey("ConditionRateRatioUnit") ) {
                final Object value = values.remove("ConditionRateRatioUnit");
                if( (value == null) || (!value.equals(getConditionRateRatioUnit())) ) {
                    setConditionRateRatioUnit(((java.lang.String) value));
                }
            }
            if( values.containsKey("ConditionRateRatioUnitISOCode") ) {
                final Object value = values.remove("ConditionRateRatioUnitISOCode");
                if( (value == null) || (!value.equals(getConditionRateRatioUnitISOCode())) ) {
                    setConditionRateRatioUnitISOCode(((java.lang.String) value));
                }
            }
            if( values.containsKey("ConditionRateRatioUnitSAPCode") ) {
                final Object value = values.remove("ConditionRateRatioUnitSAPCode");
                if( (value == null) || (!value.equals(getConditionRateRatioUnitSAPCode())) ) {
                    setConditionRateRatioUnitSAPCode(((java.lang.String) value));
                }
            }
            if( values.containsKey("PricingScaleType") ) {
                final Object value = values.remove("PricingScaleType");
                if( (value == null) || (!value.equals(getPricingScaleType())) ) {
                    setPricingScaleType(((java.lang.String) value));
                }
            }
            if( values.containsKey("ConditionScaleQuantityUnit") ) {
                final Object value = values.remove("ConditionScaleQuantityUnit");
                if( (value == null) || (!value.equals(getConditionScaleQuantityUnit())) ) {
                    setConditionScaleQuantityUnit(((java.lang.String) value));
                }
            }
            if( values.containsKey("CndnScaleQuantityUnitISOCode") ) {
                final Object value = values.remove("CndnScaleQuantityUnitISOCode");
                if( (value == null) || (!value.equals(getCndnScaleQuantityUnitISOCode())) ) {
                    setCndnScaleQuantityUnitISOCode(((java.lang.String) value));
                }
            }
            if( values.containsKey("CndnScaleQuantityUnitSAPCode") ) {
                final Object value = values.remove("CndnScaleQuantityUnitSAPCode");
                if( (value == null) || (!value.equals(getCndnScaleQuantityUnitSAPCode())) ) {
                    setCndnScaleQuantityUnitSAPCode(((java.lang.String) value));
                }
            }
            if( values.containsKey("ConditionScaleAmountCurrency") ) {
                final Object value = values.remove("ConditionScaleAmountCurrency");
                if( (value == null) || (!value.equals(getConditionScaleAmountCurrency())) ) {
                    setConditionScaleAmountCurrency(((java.lang.String) value));
                }
            }
            if( values.containsKey("ConditionIsDeleted") ) {
                final Object value = values.remove("ConditionIsDeleted");
                if( (value == null) || (!value.equals(getConditionIsDeleted())) ) {
                    setConditionIsDeleted(((java.lang.Boolean) value));
                }
            }
            if( values.containsKey("Product") ) {
                final Object value = values.remove("Product");
                if( (value == null) || (!value.equals(getProduct())) ) {
                    setProduct(((java.lang.String) value));
                }
            }
            if( values.containsKey("Customer") ) {
                final Object value = values.remove("Customer");
                if( (value == null) || (!value.equals(getCustomer())) ) {
                    setCustomer(((java.lang.String) value));
                }
            }
            if( values.containsKey("BillToParty") ) {
                final Object value = values.remove("BillToParty");
                if( (value == null) || (!value.equals(getBillToParty())) ) {
                    setBillToParty(((java.lang.String) value));
                }
            }
            if( values.containsKey("PayerParty") ) {
                final Object value = values.remove("PayerParty");
                if( (value == null) || (!value.equals(getPayerParty())) ) {
                    setPayerParty(((java.lang.String) value));
                }
            }
            if( values.containsKey("ShipToParty") ) {
                final Object value = values.remove("ShipToParty");
                if( (value == null) || (!value.equals(getShipToParty())) ) {
                    setShipToParty(((java.lang.String) value));
                }
            }
            if( values.containsKey("Supplier") ) {
                final Object value = values.remove("Supplier");
                if( (value == null) || (!value.equals(getSupplier())) ) {
                    setSupplier(((java.lang.String) value));
                }
            }
            if( values.containsKey("InvoicingParty") ) {
                final Object value = values.remove("InvoicingParty");
                if( (value == null) || (!value.equals(getInvoicingParty())) ) {
                    setInvoicingParty(((java.lang.String) value));
                }
            }
            if( values.containsKey("PriorSupplier") ) {
                final Object value = values.remove("PriorSupplier");
                if( (value == null) || (!value.equals(getPriorSupplier())) ) {
                    setPriorSupplier(((java.lang.String) value));
                }
            }
            if( values.containsKey("SupplyingSupplier") ) {
                final Object value = values.remove("SupplyingSupplier");
                if( (value == null) || (!value.equals(getSupplyingSupplier())) ) {
                    setSupplyingSupplier(((java.lang.String) value));
                }
            }
            if( values.containsKey("CompanyCode") ) {
                final Object value = values.remove("CompanyCode");
                if( (value == null) || (!value.equals(getCompanyCode())) ) {
                    setCompanyCode(((java.lang.String) value));
                }
            }
            if( values.containsKey("SalesOrganization") ) {
                final Object value = values.remove("SalesOrganization");
                if( (value == null) || (!value.equals(getSalesOrganization())) ) {
                    setSalesOrganization(((java.lang.String) value));
                }
            }
            if( values.containsKey("DistributionChannel") ) {
                final Object value = values.remove("DistributionChannel");
                if( (value == null) || (!value.equals(getDistributionChannel())) ) {
                    setDistributionChannel(((java.lang.String) value));
                }
            }
            if( values.containsKey("Division") ) {
                final Object value = values.remove("Division");
                if( (value == null) || (!value.equals(getDivision())) ) {
                    setDivision(((java.lang.String) value));
                }
            }
            if( values.containsKey("SalesOffice") ) {
                final Object value = values.remove("SalesOffice");
                if( (value == null) || (!value.equals(getSalesOffice())) ) {
                    setSalesOffice(((java.lang.String) value));
                }
            }
            if( values.containsKey("SalesGroup") ) {
                final Object value = values.remove("SalesGroup");
                if( (value == null) || (!value.equals(getSalesGroup())) ) {
                    setSalesGroup(((java.lang.String) value));
                }
            }
            if( values.containsKey("PurchasingOrganization") ) {
                final Object value = values.remove("PurchasingOrganization");
                if( (value == null) || (!value.equals(getPurchasingOrganization())) ) {
                    setPurchasingOrganization(((java.lang.String) value));
                }
            }
            if( values.containsKey("Plant") ) {
                final Object value = values.remove("Plant");
                if( (value == null) || (!value.equals(getPlant())) ) {
                    setPlant(((java.lang.String) value));
                }
            }
            if( values.containsKey("ProductGroup") ) {
                final Object value = values.remove("ProductGroup");
                if( (value == null) || (!value.equals(getProductGroup())) ) {
                    setProductGroup(((java.lang.String) value));
                }
            }
            if( values.containsKey("SalesSpcfcProductGroup1") ) {
                final Object value = values.remove("SalesSpcfcProductGroup1");
                if( (value == null) || (!value.equals(getSalesSpcfcProductGroup1())) ) {
                    setSalesSpcfcProductGroup1(((java.lang.String) value));
                }
            }
            if( values.containsKey("SalesSpcfcProductGroup2") ) {
                final Object value = values.remove("SalesSpcfcProductGroup2");
                if( (value == null) || (!value.equals(getSalesSpcfcProductGroup2())) ) {
                    setSalesSpcfcProductGroup2(((java.lang.String) value));
                }
            }
            if( values.containsKey("SalesSpcfcProductGroup3") ) {
                final Object value = values.remove("SalesSpcfcProductGroup3");
                if( (value == null) || (!value.equals(getSalesSpcfcProductGroup3())) ) {
                    setSalesSpcfcProductGroup3(((java.lang.String) value));
                }
            }
            if( values.containsKey("SalesSpcfcProductGroup4") ) {
                final Object value = values.remove("SalesSpcfcProductGroup4");
                if( (value == null) || (!value.equals(getSalesSpcfcProductGroup4())) ) {
                    setSalesSpcfcProductGroup4(((java.lang.String) value));
                }
            }
            if( values.containsKey("SalesSpcfcProductGroup5") ) {
                final Object value = values.remove("SalesSpcfcProductGroup5");
                if( (value == null) || (!value.equals(getSalesSpcfcProductGroup5())) ) {
                    setSalesSpcfcProductGroup5(((java.lang.String) value));
                }
            }
        }
        // structured properties
        {
            if( values.containsKey("SAP__Messages") ) {
                final Object value = values.remove("SAP__Messages");
                if( value instanceof Iterable ) {
                    final LinkedList<SAP__Message> _Messages = new LinkedList<SAP__Message>();
                    for( Object properties : ((Iterable<?>) value) ) {
                        if( properties instanceof Map ) {
                            final SAP__Message item = new SAP__Message();
                            @SuppressWarnings( "unchecked" )
                            final Map<java.lang.String, Object> inputMap = ((Map<java.lang.String, Object>) value);
                            item.fromMap(inputMap);
                            _Messages.add(item);
                        }
                    }
                    set_Messages(_Messages);
                }
                if( (value == null) && (get_Messages() != null) ) {
                    set_Messages(null);
                }
            }
        }
        // navigation properties
        {
            if( (values).containsKey("_CndnContrCndnRecdValidity") ) {
                final Object value = (values).remove("_CndnContrCndnRecdValidity");
                if( value instanceof Iterable ) {
                    if( to_CndnContrCndnRecdValidity == null ) {
                        to_CndnContrCndnRecdValidity = Lists.newArrayList();
                    } else {
                        to_CndnContrCndnRecdValidity = Lists.newArrayList(to_CndnContrCndnRecdValidity);
                    }
                    int i = 0;
                    for( Object item : ((Iterable<?>) value) ) {
                        if( !(item instanceof Map) ) {
                            continue;
                        }
                        CndnContrCndnRecordValidity entity;
                        if( to_CndnContrCndnRecdValidity.size() > i ) {
                            entity = to_CndnContrCndnRecdValidity.get(i);
                        } else {
                            entity = new CndnContrCndnRecordValidity();
                            to_CndnContrCndnRecdValidity.add(entity);
                        }
                        i = (i + 1);
                        @SuppressWarnings( "unchecked" )
                        final Map<java.lang.String, Object> inputMap = ((Map<java.lang.String, Object>) item);
                        entity.fromMap(inputMap);
                    }
                }
            }
            if( (values).containsKey("_CndnContrScCndnRecord") ) {
                final Object value = (values).remove("_CndnContrScCndnRecord");
                if( value instanceof Iterable ) {
                    if( to_CndnContrScCndnRecord == null ) {
                        to_CndnContrScCndnRecord = Lists.newArrayList();
                    } else {
                        to_CndnContrScCndnRecord = Lists.newArrayList(to_CndnContrScCndnRecord);
                    }
                    int i = 0;
                    for( Object item : ((Iterable<?>) value) ) {
                        if( !(item instanceof Map) ) {
                            continue;
                        }
                        CndnContrConditionRecordScale entity;
                        if( to_CndnContrScCndnRecord.size() > i ) {
                            entity = to_CndnContrScCndnRecord.get(i);
                        } else {
                            entity = new CndnContrConditionRecordScale();
                            to_CndnContrScCndnRecord.add(entity);
                        }
                        i = (i + 1);
                        @SuppressWarnings( "unchecked" )
                        final Map<java.lang.String, Object> inputMap = ((Map<java.lang.String, Object>) item);
                        entity.fromMap(inputMap);
                    }
                }
            }
            if( (values).containsKey("_ConditionContract") ) {
                final Object value = (values).remove("_ConditionContract");
                if( value instanceof Map ) {
                    if( to_ConditionContract == null ) {
                        to_ConditionContract = new ConditionContract();
                    }
                    @SuppressWarnings( "unchecked" )
                    final Map<java.lang.String, Object> inputMap = ((Map<java.lang.String, Object>) value);
                    to_ConditionContract.fromMap(inputMap);
                }
            }
        }
        super.fromMap(values);
    }

    @Override
    protected java.lang.String getDefaultServicePath()
    {
        return ConditionContractService.DEFAULT_SERVICE_PATH;
    }

    @Nonnull
    @Override
    protected Map<java.lang.String, Object> toMapOfNavigationProperties()
    {
        final Map<java.lang.String, Object> values = super.toMapOfNavigationProperties();
        if( to_CndnContrCndnRecdValidity != null ) {
            (values).put("_CndnContrCndnRecdValidity", to_CndnContrCndnRecdValidity);
        }
        if( to_CndnContrScCndnRecord != null ) {
            (values).put("_CndnContrScCndnRecord", to_CndnContrScCndnRecord);
        }
        if( to_ConditionContract != null ) {
            (values).put("_ConditionContract", to_ConditionContract);
        }
        return values;
    }

    /**
     * Retrieval of associated <b>CndnContrCndnRecordValidity</b> entities (one to many). This corresponds to the OData
     * navigation property <b>_CndnContrCndnRecdValidity</b>.
     * <p>
     * If the navigation property for an entity <b>CndnContrConditionRecord</b> has not been resolved yet, this method
     * will <b>not query</b> further information. Instead its <code>Option</code> result state will be
     * <code>empty</code>.
     * 
     * @return If the information for navigation property <b>_CndnContrCndnRecdValidity</b> is already loaded, the
     *         result will contain the <b>CndnContrCndnRecordValidity</b> entities. If not, an <code>Option</code> with
     *         result state <code>empty</code> is returned.
     */
    @Nonnull
    public Option<List<CndnContrCndnRecordValidity>> getCndnContrCndnRecdValidityIfPresent()
    {
        return Option.of(to_CndnContrCndnRecdValidity);
    }

    /**
     * Overwrites the list of associated <b>CndnContrCndnRecordValidity</b> entities for the loaded navigation property
     * <b>_CndnContrCndnRecdValidity</b>.
     * <p>
     * If the navigation property <b>_CndnContrCndnRecdValidity</b> of a queried <b>CndnContrConditionRecord</b> is
     * operated lazily, an <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     * 
     * @param value
     *            List of <b>CndnContrCndnRecordValidity</b> entities.
     */
    public void setCndnContrCndnRecdValidity( @Nonnull final List<CndnContrCndnRecordValidity> value )
    {
        if( to_CndnContrCndnRecdValidity == null ) {
            to_CndnContrCndnRecdValidity = Lists.newArrayList();
        }
        to_CndnContrCndnRecdValidity.clear();
        to_CndnContrCndnRecdValidity.addAll(value);
    }

    /**
     * Adds elements to the list of associated <b>CndnContrCndnRecordValidity</b> entities. This corresponds to the
     * OData navigation property <b>_CndnContrCndnRecdValidity</b>.
     * <p>
     * If the navigation property <b>_CndnContrCndnRecdValidity</b> of a queried <b>CndnContrConditionRecord</b> is
     * operated lazily, an <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     * 
     * @param entity
     *            Array of <b>CndnContrCndnRecordValidity</b> entities.
     */
    public void addCndnContrCndnRecdValidity( CndnContrCndnRecordValidity... entity )
    {
        if( to_CndnContrCndnRecdValidity == null ) {
            to_CndnContrCndnRecdValidity = Lists.newArrayList();
        }
        to_CndnContrCndnRecdValidity.addAll(Lists.newArrayList(entity));
    }

    /**
     * Retrieval of associated <b>CndnContrConditionRecordScale</b> entities (one to many). This corresponds to the
     * OData navigation property <b>_CndnContrScCndnRecord</b>.
     * <p>
     * If the navigation property for an entity <b>CndnContrConditionRecord</b> has not been resolved yet, this method
     * will <b>not query</b> further information. Instead its <code>Option</code> result state will be
     * <code>empty</code>.
     * 
     * @return If the information for navigation property <b>_CndnContrScCndnRecord</b> is already loaded, the result
     *         will contain the <b>CndnContrConditionRecordScale</b> entities. If not, an <code>Option</code> with
     *         result state <code>empty</code> is returned.
     */
    @Nonnull
    public Option<List<CndnContrConditionRecordScale>> getCndnContrScCndnRecordIfPresent()
    {
        return Option.of(to_CndnContrScCndnRecord);
    }

    /**
     * Overwrites the list of associated <b>CndnContrConditionRecordScale</b> entities for the loaded navigation
     * property <b>_CndnContrScCndnRecord</b>.
     * <p>
     * If the navigation property <b>_CndnContrScCndnRecord</b> of a queried <b>CndnContrConditionRecord</b> is operated
     * lazily, an <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     * 
     * @param value
     *            List of <b>CndnContrConditionRecordScale</b> entities.
     */
    public void setCndnContrScCndnRecord( @Nonnull final List<CndnContrConditionRecordScale> value )
    {
        if( to_CndnContrScCndnRecord == null ) {
            to_CndnContrScCndnRecord = Lists.newArrayList();
        }
        to_CndnContrScCndnRecord.clear();
        to_CndnContrScCndnRecord.addAll(value);
    }

    /**
     * Adds elements to the list of associated <b>CndnContrConditionRecordScale</b> entities. This corresponds to the
     * OData navigation property <b>_CndnContrScCndnRecord</b>.
     * <p>
     * If the navigation property <b>_CndnContrScCndnRecord</b> of a queried <b>CndnContrConditionRecord</b> is operated
     * lazily, an <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     * 
     * @param entity
     *            Array of <b>CndnContrConditionRecordScale</b> entities.
     */
    public void addCndnContrScCndnRecord( CndnContrConditionRecordScale... entity )
    {
        if( to_CndnContrScCndnRecord == null ) {
            to_CndnContrScCndnRecord = Lists.newArrayList();
        }
        to_CndnContrScCndnRecord.addAll(Lists.newArrayList(entity));
    }

    /**
     * Retrieval of associated <b>ConditionContract</b> entity (one to one). This corresponds to the OData navigation
     * property <b>_ConditionContract</b>.
     * <p>
     * If the navigation property for an entity <b>CndnContrConditionRecord</b> has not been resolved yet, this method
     * will <b>not query</b> further information. Instead its <code>Option</code> result state will be
     * <code>empty</code>.
     * 
     * @return If the information for navigation property <b>_ConditionContract</b> is already loaded, the result will
     *         contain the <b>ConditionContract</b> entity. If not, an <code>Option</code> with result state
     *         <code>empty</code> is returned.
     */
    @Nonnull
    public Option<ConditionContract> getConditionContractIfPresent()
    {
        return Option.of(to_ConditionContract);
    }

    /**
     * Overwrites the associated <b>ConditionContract</b> entity for the loaded navigation property
     * <b>_ConditionContract</b>.
     * 
     * @param value
     *            New <b>ConditionContract</b> entity.
     */
    public void setConditionContract( final ConditionContract value )
    {
        to_ConditionContract = value;
    }

    /**
     * Action that can be applied to any entity object of this class.
     * </p>
     * 
     * @return Action object prepared with the given parameters to be applied to any entity object of this class.
     *         </p>
     *         To execute it use the {@code service.forEntity(entity).applyAction(thisAction)} API.
     */
    @Nonnull
    public static
        com.sap.cloud.sdk.datamodel.odatav4.core.BoundAction.SingleToSingle<CndnContrConditionRecord, Void>
        setConditionToInvalid()
    {
        final Map<java.lang.String, Object> parameters = Collections.emptyMap();
        return new com.sap.cloud.sdk.datamodel.odatav4.core.BoundAction.SingleToSingle<CndnContrConditionRecord, Void>(
            CndnContrConditionRecord.class,
            Void.class,
            "com.sap.gateway.srvd_a2x.api_condition_contract.v0001.SetConditionToInvalid",
            parameters);
    }

    /**
     * Action that can be applied to any entity object of this class.
     * </p>
     * 
     * @return Action object prepared with the given parameters to be applied to any entity object of this class.
     *         </p>
     *         To execute it use the {@code service.forEntity(entity).applyAction(thisAction)} API.
     */
    @Nonnull
    public static
        com.sap.cloud.sdk.datamodel.odatav4.core.BoundAction.SingleToSingle<CndnContrConditionRecord, Void>
        revokeConditionInvalidity()
    {
        final Map<java.lang.String, Object> parameters = Collections.emptyMap();
        return new com.sap.cloud.sdk.datamodel.odatav4.core.BoundAction.SingleToSingle<CndnContrConditionRecord, Void>(
            CndnContrConditionRecord.class,
            Void.class,
            "com.sap.gateway.srvd_a2x.api_condition_contract.v0001.RevokeConditionInvalidity",
            parameters);
    }

    /**
     * Helper class to allow for fluent creation of CndnContrConditionRecord instances.
     * 
     */
    public final static class CndnContrConditionRecordBuilder
    {

        private List<CndnContrCndnRecordValidity> to_CndnContrCndnRecdValidity = Lists.newArrayList();
        private List<CndnContrConditionRecordScale> to_CndnContrScCndnRecord = Lists.newArrayList();
        private ConditionContract to_ConditionContract;
        private java.lang.String conditionContract = null;

        private CndnContrConditionRecord.CndnContrConditionRecordBuilder to_CndnContrCndnRecdValidity(
            final List<CndnContrCndnRecordValidity> value )
        {
            to_CndnContrCndnRecdValidity.addAll(value);
            return this;
        }

        /**
         * Navigation property <b>_CndnContrCndnRecdValidity</b> for <b>CndnContrConditionRecord</b> to multiple
         * <b>CndnContrCndnRecordValidity</b>.
         * 
         * @param value
         *            The CndnContrCndnRecordValiditys to build this CndnContrConditionRecord with.
         * @return This Builder to allow for a fluent interface.
         */
        @Nonnull
        public CndnContrConditionRecord.CndnContrConditionRecordBuilder cndnContrCndnRecdValidity(
            CndnContrCndnRecordValidity... value )
        {
            return to_CndnContrCndnRecdValidity(Lists.newArrayList(value));
        }

        private CndnContrConditionRecord.CndnContrConditionRecordBuilder to_CndnContrScCndnRecord(
            final List<CndnContrConditionRecordScale> value )
        {
            to_CndnContrScCndnRecord.addAll(value);
            return this;
        }

        /**
         * Navigation property <b>_CndnContrScCndnRecord</b> for <b>CndnContrConditionRecord</b> to multiple
         * <b>CndnContrConditionRecordScale</b>.
         * 
         * @param value
         *            The CndnContrConditionRecordScales to build this CndnContrConditionRecord with.
         * @return This Builder to allow for a fluent interface.
         */
        @Nonnull
        public CndnContrConditionRecord.CndnContrConditionRecordBuilder cndnContrScCndnRecord(
            CndnContrConditionRecordScale... value )
        {
            return to_CndnContrScCndnRecord(Lists.newArrayList(value));
        }

        private CndnContrConditionRecord.CndnContrConditionRecordBuilder to_ConditionContract(
            final ConditionContract value )
        {
            to_ConditionContract = value;
            return this;
        }

        /**
         * Navigation property <b>_ConditionContract</b> for <b>CndnContrConditionRecord</b> to single
         * <b>ConditionContract</b>.
         * 
         * @param value
         *            The ConditionContract to build this CndnContrConditionRecord with.
         * @return This Builder to allow for a fluent interface.
         */
        @Nonnull
        public CndnContrConditionRecord.CndnContrConditionRecordBuilder conditionContract(
            final ConditionContract value )
        {
            return to_ConditionContract(value);
        }

        /**
         * (Key Field) Constraints: Not nullable, Maximum length: 10
         * <p>
         * Original property name from the Odata EDM: <b>ConditionContract</b>
         * </p>
         * 
         * @param value
         *            The conditionContract to build this CndnContrConditionRecord with.
         * @return This Builder to allow for a fluent interface.
         */
        @Nonnull
        public CndnContrConditionRecord.CndnContrConditionRecordBuilder conditionContract(
            final java.lang.String value )
        {
            conditionContract = value;
            return this;
        }

    }

}
