/*
 * Copyright (c) 2021 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odatav4.namespaces.conditioncontract;

import java.math.BigDecimal;
import java.util.Map;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;

import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.google.common.collect.Maps;
import com.google.gson.annotations.JsonAdapter;
import com.sap.cloud.sdk.datamodel.odata.client.request.ODataEntityKey;
import com.sap.cloud.sdk.datamodel.odatav4.core.DecimalDescriptor;
import com.sap.cloud.sdk.datamodel.odatav4.core.SimpleProperty;
import com.sap.cloud.sdk.datamodel.odatav4.core.VdmEntity;
import com.sap.cloud.sdk.datamodel.odatav4.core.VdmEntitySet;
import com.sap.cloud.sdk.result.ElementName;
import com.sap.cloud.sdk.s4hana.datamodel.odatav4.services.ConditionContractService;

import io.vavr.control.Option;
import lombok.AccessLevel;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.Getter;
import lombok.NoArgsConstructor;
import lombok.Setter;
import lombok.ToString;

/**
 * Condition Record Scale
 * <p>
 * </p>
 * <p>
 * Original entity name from the Odata EDM: <b>CndnContrConditionRecordScaleType</b>
 * </p>
 * 
 */
@Builder
@Data
@NoArgsConstructor
@AllArgsConstructor
@ToString( doNotUseGetters = true, callSuper = true )
@EqualsAndHashCode( doNotUseGetters = true, callSuper = true )
@JsonAdapter( com.sap.cloud.sdk.datamodel.odatav4.adapter.GsonVdmAdapterFactory.class )
@JsonSerialize( using = com.sap.cloud.sdk.datamodel.odatav4.adapter.JacksonVdmObjectSerializer.class )
@JsonDeserialize( using = com.sap.cloud.sdk.datamodel.odatav4.adapter.JacksonVdmObjectDeserializer.class )
public class CndnContrConditionRecordScale extends VdmEntity<CndnContrConditionRecordScale> implements VdmEntitySet
{

    @Getter
    private final java.lang.String odataType =
        "com.sap.gateway.srvd_a2x.api_condition_contract.v0001.CndnContrConditionRecordScaleType";
    /**
     * Selector for all available fields of CndnContrConditionRecordScale.
     * 
     */
    public final static SimpleProperty<CndnContrConditionRecordScale> ALL_FIELDS = all();
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>ConditionContract</b>
     * </p>
     * 
     * @return Condition Contract
     */
    @Nullable
    @ElementName( "ConditionContract" )
    private java.lang.String conditionContract;
    public final static SimpleProperty.String<CndnContrConditionRecordScale> CONDITION_CONTRACT =
        new SimpleProperty.String<CndnContrConditionRecordScale>(
            CndnContrConditionRecordScale.class,
            "ConditionContract");
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>ConditionRecord</b>
     * </p>
     * 
     * @return Number of the Condition Record
     */
    @Nullable
    @ElementName( "ConditionRecord" )
    private java.lang.String conditionRecord;
    public final static SimpleProperty.String<CndnContrConditionRecordScale> CONDITION_RECORD =
        new SimpleProperty.String<CndnContrConditionRecordScale>(
            CndnContrConditionRecordScale.class,
            "ConditionRecord");
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>ConditionScaleLine</b>
     * </p>
     * 
     * @return Current number of the line scale
     */
    @Nullable
    @ElementName( "ConditionScaleLine" )
    private java.lang.String conditionScaleLine;
    public final static SimpleProperty.String<CndnContrConditionRecordScale> CONDITION_SCALE_LINE =
        new SimpleProperty.String<CndnContrConditionRecordScale>(
            CndnContrConditionRecordScale.class,
            "ConditionScaleLine");
    /**
     * Constraints: Not nullable, Precision: 15, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>ConditionScaleQuantity</b>
     * </p>
     * 
     * @return The conditionScaleQuantity contained in this {@link VdmEntity}.
     */
    @Nullable
    @ElementName( "ConditionScaleQuantity" )
    @DecimalDescriptor( precision = 15, scale = 3 )
    private BigDecimal conditionScaleQuantity;
    public final static SimpleProperty.NumericDecimal<CndnContrConditionRecordScale> CONDITION_SCALE_QUANTITY =
        new SimpleProperty.NumericDecimal<CndnContrConditionRecordScale>(
            CndnContrConditionRecordScale.class,
            "ConditionScaleQuantity");
    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>ConditionScaleQuantityUnit</b>
     * </p>
     * 
     * @return Condition Scale Unit of Measure
     */
    @Nullable
    @ElementName( "ConditionScaleQuantityUnit" )
    private java.lang.String conditionScaleQuantityUnit;
    public final static SimpleProperty.String<CndnContrConditionRecordScale> CONDITION_SCALE_QUANTITY_UNIT =
        new SimpleProperty.String<CndnContrConditionRecordScale>(
            CndnContrConditionRecordScale.class,
            "ConditionScaleQuantityUnit");
    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>CndnScaleQuantityUnitISOCode</b>
     * </p>
     * 
     * @return Condition Scale Unit of Measure in ISO Code
     */
    @Nullable
    @ElementName( "CndnScaleQuantityUnitISOCode" )
    private java.lang.String cndnScaleQuantityUnitISOCode;
    public final static SimpleProperty.String<CndnContrConditionRecordScale> CNDN_SCALE_QUANTITY_UNIT_ISO_CODE =
        new SimpleProperty.String<CndnContrConditionRecordScale>(
            CndnContrConditionRecordScale.class,
            "CndnScaleQuantityUnitISOCode");
    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>CndnScaleQuantityUnitSAPCode</b>
     * </p>
     * 
     * @return Condition Scale Unit of Measure in SAP Code
     */
    @Nullable
    @ElementName( "CndnScaleQuantityUnitSAPCode" )
    private java.lang.String cndnScaleQuantityUnitSAPCode;
    public final static SimpleProperty.String<CndnContrConditionRecordScale> CNDN_SCALE_QUANTITY_UNIT_SAP_CODE =
        new SimpleProperty.String<CndnContrConditionRecordScale>(
            CndnContrConditionRecordScale.class,
            "CndnScaleQuantityUnitSAPCode");
    /**
     * Constraints: Not nullable, Precision: 24, Scale: 9
     * <p>
     * Original property name from the Odata EDM: <b>ConditionScaleAmount</b>
     * </p>
     * 
     * @return The conditionScaleAmount contained in this {@link VdmEntity}.
     */
    @Nullable
    @ElementName( "ConditionScaleAmount" )
    @DecimalDescriptor( precision = 24, scale = 9 )
    private BigDecimal conditionScaleAmount;
    public final static SimpleProperty.NumericDecimal<CndnContrConditionRecordScale> CONDITION_SCALE_AMOUNT =
        new SimpleProperty.NumericDecimal<CndnContrConditionRecordScale>(
            CndnContrConditionRecordScale.class,
            "ConditionScaleAmount");
    /**
     * Constraints: Not nullable, Maximum length: 5
     * <p>
     * Original property name from the Odata EDM: <b>ConditionScaleAmountCurrency</b>
     * </p>
     * 
     * @return Scale Currency
     */
    @Nullable
    @ElementName( "ConditionScaleAmountCurrency" )
    private java.lang.String conditionScaleAmountCurrency;
    public final static SimpleProperty.String<CndnContrConditionRecordScale> CONDITION_SCALE_AMOUNT_CURRENCY =
        new SimpleProperty.String<CndnContrConditionRecordScale>(
            CndnContrConditionRecordScale.class,
            "ConditionScaleAmountCurrency");
    /**
     * Constraints: Not nullable, Precision: 24, Scale: 9
     * <p>
     * Original property name from the Odata EDM: <b>ConditionRateAmount</b>
     * </p>
     * 
     * @return The conditionRateAmount contained in this {@link VdmEntity}.
     */
    @Nullable
    @ElementName( "ConditionRateAmount" )
    @DecimalDescriptor( precision = 24, scale = 9 )
    private BigDecimal conditionRateAmount;
    public final static SimpleProperty.NumericDecimal<CndnContrConditionRecordScale> CONDITION_RATE_AMOUNT =
        new SimpleProperty.NumericDecimal<CndnContrConditionRecordScale>(
            CndnContrConditionRecordScale.class,
            "ConditionRateAmount");
    /**
     * Constraints: Not nullable, Maximum length: 5
     * <p>
     * Original property name from the Odata EDM: <b>ConditionCurrency</b>
     * </p>
     * 
     * @return Condition Unit (Currency or Percentage)
     */
    @Nullable
    @ElementName( "ConditionCurrency" )
    private java.lang.String conditionCurrency;
    public final static SimpleProperty.String<CndnContrConditionRecordScale> CONDITION_CURRENCY =
        new SimpleProperty.String<CndnContrConditionRecordScale>(
            CndnContrConditionRecordScale.class,
            "ConditionCurrency");
    /**
     * Constraints: Not nullable, Precision: 5
     * <p>
     * Original property name from the Odata EDM: <b>ConditionQuantity</b>
     * </p>
     * 
     * @return The conditionQuantity contained in this {@link VdmEntity}.
     */
    @Nullable
    @ElementName( "ConditionQuantity" )
    @DecimalDescriptor( precision = 5, scale = 0 )
    private BigDecimal conditionQuantity;
    public final static SimpleProperty.NumericDecimal<CndnContrConditionRecordScale> CONDITION_QUANTITY =
        new SimpleProperty.NumericDecimal<CndnContrConditionRecordScale>(
            CndnContrConditionRecordScale.class,
            "ConditionQuantity");
    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>ConditionQuantityUnit</b>
     * </p>
     * 
     * @return Condition Unit
     */
    @Nullable
    @ElementName( "ConditionQuantityUnit" )
    private java.lang.String conditionQuantityUnit;
    public final static SimpleProperty.String<CndnContrConditionRecordScale> CONDITION_QUANTITY_UNIT =
        new SimpleProperty.String<CndnContrConditionRecordScale>(
            CndnContrConditionRecordScale.class,
            "ConditionQuantityUnit");
    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>ConditionQuantityUnitISOCode</b>
     * </p>
     * 
     * @return Condition Quantity Unit in ISO code
     */
    @Nullable
    @ElementName( "ConditionQuantityUnitISOCode" )
    private java.lang.String conditionQuantityUnitISOCode;
    public final static SimpleProperty.String<CndnContrConditionRecordScale> CONDITION_QUANTITY_UNIT_ISO_CODE =
        new SimpleProperty.String<CndnContrConditionRecordScale>(
            CndnContrConditionRecordScale.class,
            "ConditionQuantityUnitISOCode");
    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>ConditionQuantityUnitSAPCode</b>
     * </p>
     * 
     * @return Condition Quantity Unit in SAP code
     */
    @Nullable
    @ElementName( "ConditionQuantityUnitSAPCode" )
    private java.lang.String conditionQuantityUnitSAPCode;
    public final static SimpleProperty.String<CndnContrConditionRecordScale> CONDITION_QUANTITY_UNIT_SAP_CODE =
        new SimpleProperty.String<CndnContrConditionRecordScale>(
            CndnContrConditionRecordScale.class,
            "ConditionQuantityUnitSAPCode");
    /**
     * Constraints: Not nullable, Precision: 24, Scale: 9
     * <p>
     * Original property name from the Odata EDM: <b>ConditionRateRatio</b>
     * </p>
     * 
     * @return The conditionRateRatio contained in this {@link VdmEntity}.
     */
    @Nullable
    @ElementName( "ConditionRateRatio" )
    @DecimalDescriptor( precision = 24, scale = 9 )
    private BigDecimal conditionRateRatio;
    public final static SimpleProperty.NumericDecimal<CndnContrConditionRecordScale> CONDITION_RATE_RATIO =
        new SimpleProperty.NumericDecimal<CndnContrConditionRecordScale>(
            CndnContrConditionRecordScale.class,
            "ConditionRateRatio");
    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>ConditionRateRatioUnit</b>
     * </p>
     * 
     * @return Percent Sign (Transactional Processing)
     */
    @Nullable
    @ElementName( "ConditionRateRatioUnit" )
    private java.lang.String conditionRateRatioUnit;
    public final static SimpleProperty.String<CndnContrConditionRecordScale> CONDITION_RATE_RATIO_UNIT =
        new SimpleProperty.String<CndnContrConditionRecordScale>(
            CndnContrConditionRecordScale.class,
            "ConditionRateRatioUnit");
    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>ConditionRateRatioUnitISOCode</b>
     * </p>
     * 
     * @return Percent Sign in ISO Code
     */
    @Nullable
    @ElementName( "ConditionRateRatioUnitISOCode" )
    private java.lang.String conditionRateRatioUnitISOCode;
    public final static SimpleProperty.String<CndnContrConditionRecordScale> CONDITION_RATE_RATIO_UNIT_ISO_CODE =
        new SimpleProperty.String<CndnContrConditionRecordScale>(
            CndnContrConditionRecordScale.class,
            "ConditionRateRatioUnitISOCode");
    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>ConditionRateRatioUnitSAPCode</b>
     * </p>
     * 
     * @return Percent Sign in SAP Code
     */
    @Nullable
    @ElementName( "ConditionRateRatioUnitSAPCode" )
    private java.lang.String conditionRateRatioUnitSAPCode;
    public final static SimpleProperty.String<CndnContrConditionRecordScale> CONDITION_RATE_RATIO_UNIT_SAP_CODE =
        new SimpleProperty.String<CndnContrConditionRecordScale>(
            CndnContrConditionRecordScale.class,
            "ConditionRateRatioUnitSAPCode");
    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>ConditionTable</b>
     * </p>
     * 
     * @return Condition Table
     */
    @Nullable
    @ElementName( "ConditionTable" )
    private java.lang.String conditionTable;
    public final static SimpleProperty.String<CndnContrConditionRecordScale> CONDITION_TABLE =
        new SimpleProperty.String<CndnContrConditionRecordScale>(CndnContrConditionRecordScale.class, "ConditionTable");
    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>ConditionApplication</b>
     * </p>
     * 
     * @return Application
     */
    @Nullable
    @ElementName( "ConditionApplication" )
    private java.lang.String conditionApplication;
    public final static SimpleProperty.String<CndnContrConditionRecordScale> CONDITION_APPLICATION =
        new SimpleProperty.String<CndnContrConditionRecordScale>(
            CndnContrConditionRecordScale.class,
            "ConditionApplication");
    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>ConditionType</b>
     * </p>
     * 
     * @return Condition Type
     */
    @Nullable
    @ElementName( "ConditionType" )
    private java.lang.String conditionType;
    public final static SimpleProperty.String<CndnContrConditionRecordScale> CONDITION_TYPE =
        new SimpleProperty.String<CndnContrConditionRecordScale>(CndnContrConditionRecordScale.class, "ConditionType");
    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>ConditionCalculationType</b>
     * </p>
     * 
     * @return Calculation Type for Condition
     */
    @Nullable
    @ElementName( "ConditionCalculationType" )
    private java.lang.String conditionCalculationType;
    public final static SimpleProperty.String<CndnContrConditionRecordScale> CONDITION_CALCULATION_TYPE =
        new SimpleProperty.String<CndnContrConditionRecordScale>(
            CndnContrConditionRecordScale.class,
            "ConditionCalculationType");
    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>PricingScaleBasis</b>
     * </p>
     * 
     * @return Scale Basis Indicator
     */
    @Nullable
    @ElementName( "PricingScaleBasis" )
    private java.lang.String pricingScaleBasis;
    public final static SimpleProperty.String<CndnContrConditionRecordScale> PRICING_SCALE_BASIS =
        new SimpleProperty.String<CndnContrConditionRecordScale>(
            CndnContrConditionRecordScale.class,
            "PricingScaleBasis");
    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>PricingScaleType</b>
     * </p>
     * 
     * @return Scale Type
     */
    @Nullable
    @ElementName( "PricingScaleType" )
    private java.lang.String pricingScaleType;
    public final static SimpleProperty.String<CndnContrConditionRecordScale> PRICING_SCALE_TYPE =
        new SimpleProperty.String<CndnContrConditionRecordScale>(
            CndnContrConditionRecordScale.class,
            "PricingScaleType");
    /**
     * Navigation property <b>_CndnContrCndnRecord</b> for <b>CndnContrConditionRecordScale</b> to single
     * <b>CndnContrConditionRecord</b>.
     * 
     */
    @ElementName( "_CndnContrCndnRecord" )
    @Nullable
    @Getter( AccessLevel.NONE )
    @Setter( AccessLevel.NONE )
    private CndnContrConditionRecord to_CndnContrCndnRecord;
    /**
     * Navigation property <b>_ConditionContract</b> for <b>CndnContrConditionRecordScale</b> to single
     * <b>ConditionContract</b>.
     * 
     */
    @ElementName( "_ConditionContract" )
    @Nullable
    @Getter( AccessLevel.NONE )
    @Setter( AccessLevel.NONE )
    private ConditionContract to_ConditionContract;
    /**
     * Use with available request builders to apply the <b>_CndnContrCndnRecord</b> navigation property to query
     * operations.
     * 
     */
    public final static com.sap.cloud.sdk.datamodel.odatav4.core.NavigationProperty.Single<CndnContrConditionRecordScale, CndnContrConditionRecord> TO__CNDN_CONTR_CNDN_RECORD =
        new com.sap.cloud.sdk.datamodel.odatav4.core.NavigationProperty.Single<CndnContrConditionRecordScale, CndnContrConditionRecord>(
            CndnContrConditionRecordScale.class,
            "_CndnContrCndnRecord",
            CndnContrConditionRecord.class);
    /**
     * Use with available request builders to apply the <b>_ConditionContract</b> navigation property to query
     * operations.
     * 
     */
    public final static com.sap.cloud.sdk.datamodel.odatav4.core.NavigationProperty.Single<CndnContrConditionRecordScale, ConditionContract> TO__CONDITION_CONTRACT =
        new com.sap.cloud.sdk.datamodel.odatav4.core.NavigationProperty.Single<CndnContrConditionRecordScale, ConditionContract>(
            CndnContrConditionRecordScale.class,
            "_ConditionContract",
            ConditionContract.class);

    /**
     * {@inheritDoc}
     * 
     */
    @Nonnull
    @Override
    public Class<CndnContrConditionRecordScale> getType()
    {
        return CndnContrConditionRecordScale.class;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>ConditionContract</b>
     * </p>
     * 
     * @param conditionContract
     *            Condition Contract
     */
    public void setConditionContract( @Nullable final java.lang.String conditionContract )
    {
        rememberChangedField("ConditionContract", this.conditionContract);
        this.conditionContract = conditionContract;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>ConditionRecord</b>
     * </p>
     * 
     * @param conditionRecord
     *            Number of the Condition Record
     */
    public void setConditionRecord( @Nullable final java.lang.String conditionRecord )
    {
        rememberChangedField("ConditionRecord", this.conditionRecord);
        this.conditionRecord = conditionRecord;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>ConditionScaleLine</b>
     * </p>
     * 
     * @param conditionScaleLine
     *            Current number of the line scale
     */
    public void setConditionScaleLine( @Nullable final java.lang.String conditionScaleLine )
    {
        rememberChangedField("ConditionScaleLine", this.conditionScaleLine);
        this.conditionScaleLine = conditionScaleLine;
    }

    /**
     * Constraints: Not nullable, Precision: 15, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>ConditionScaleQuantity</b>
     * </p>
     * 
     * @param conditionScaleQuantity
     *            The conditionScaleQuantity to set.
     */
    public void setConditionScaleQuantity( @Nullable final BigDecimal conditionScaleQuantity )
    {
        rememberChangedField("ConditionScaleQuantity", this.conditionScaleQuantity);
        this.conditionScaleQuantity = conditionScaleQuantity;
    }

    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>ConditionScaleQuantityUnit</b>
     * </p>
     * 
     * @param conditionScaleQuantityUnit
     *            Condition Scale Unit of Measure
     */
    public void setConditionScaleQuantityUnit( @Nullable final java.lang.String conditionScaleQuantityUnit )
    {
        rememberChangedField("ConditionScaleQuantityUnit", this.conditionScaleQuantityUnit);
        this.conditionScaleQuantityUnit = conditionScaleQuantityUnit;
    }

    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>CndnScaleQuantityUnitISOCode</b>
     * </p>
     * 
     * @param cndnScaleQuantityUnitISOCode
     *            Condition Scale Unit of Measure in ISO Code
     */
    public void setCndnScaleQuantityUnitISOCode( @Nullable final java.lang.String cndnScaleQuantityUnitISOCode )
    {
        rememberChangedField("CndnScaleQuantityUnitISOCode", this.cndnScaleQuantityUnitISOCode);
        this.cndnScaleQuantityUnitISOCode = cndnScaleQuantityUnitISOCode;
    }

    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>CndnScaleQuantityUnitSAPCode</b>
     * </p>
     * 
     * @param cndnScaleQuantityUnitSAPCode
     *            Condition Scale Unit of Measure in SAP Code
     */
    public void setCndnScaleQuantityUnitSAPCode( @Nullable final java.lang.String cndnScaleQuantityUnitSAPCode )
    {
        rememberChangedField("CndnScaleQuantityUnitSAPCode", this.cndnScaleQuantityUnitSAPCode);
        this.cndnScaleQuantityUnitSAPCode = cndnScaleQuantityUnitSAPCode;
    }

    /**
     * Constraints: Not nullable, Precision: 24, Scale: 9
     * <p>
     * Original property name from the Odata EDM: <b>ConditionScaleAmount</b>
     * </p>
     * 
     * @param conditionScaleAmount
     *            The conditionScaleAmount to set.
     */
    public void setConditionScaleAmount( @Nullable final BigDecimal conditionScaleAmount )
    {
        rememberChangedField("ConditionScaleAmount", this.conditionScaleAmount);
        this.conditionScaleAmount = conditionScaleAmount;
    }

    /**
     * Constraints: Not nullable, Maximum length: 5
     * <p>
     * Original property name from the Odata EDM: <b>ConditionScaleAmountCurrency</b>
     * </p>
     * 
     * @param conditionScaleAmountCurrency
     *            Scale Currency
     */
    public void setConditionScaleAmountCurrency( @Nullable final java.lang.String conditionScaleAmountCurrency )
    {
        rememberChangedField("ConditionScaleAmountCurrency", this.conditionScaleAmountCurrency);
        this.conditionScaleAmountCurrency = conditionScaleAmountCurrency;
    }

    /**
     * Constraints: Not nullable, Precision: 24, Scale: 9
     * <p>
     * Original property name from the Odata EDM: <b>ConditionRateAmount</b>
     * </p>
     * 
     * @param conditionRateAmount
     *            The conditionRateAmount to set.
     */
    public void setConditionRateAmount( @Nullable final BigDecimal conditionRateAmount )
    {
        rememberChangedField("ConditionRateAmount", this.conditionRateAmount);
        this.conditionRateAmount = conditionRateAmount;
    }

    /**
     * Constraints: Not nullable, Maximum length: 5
     * <p>
     * Original property name from the Odata EDM: <b>ConditionCurrency</b>
     * </p>
     * 
     * @param conditionCurrency
     *            Condition Unit (Currency or Percentage)
     */
    public void setConditionCurrency( @Nullable final java.lang.String conditionCurrency )
    {
        rememberChangedField("ConditionCurrency", this.conditionCurrency);
        this.conditionCurrency = conditionCurrency;
    }

    /**
     * Constraints: Not nullable, Precision: 5
     * <p>
     * Original property name from the Odata EDM: <b>ConditionQuantity</b>
     * </p>
     * 
     * @param conditionQuantity
     *            The conditionQuantity to set.
     */
    public void setConditionQuantity( @Nullable final BigDecimal conditionQuantity )
    {
        rememberChangedField("ConditionQuantity", this.conditionQuantity);
        this.conditionQuantity = conditionQuantity;
    }

    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>ConditionQuantityUnit</b>
     * </p>
     * 
     * @param conditionQuantityUnit
     *            Condition Unit
     */
    public void setConditionQuantityUnit( @Nullable final java.lang.String conditionQuantityUnit )
    {
        rememberChangedField("ConditionQuantityUnit", this.conditionQuantityUnit);
        this.conditionQuantityUnit = conditionQuantityUnit;
    }

    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>ConditionQuantityUnitISOCode</b>
     * </p>
     * 
     * @param conditionQuantityUnitISOCode
     *            Condition Quantity Unit in ISO code
     */
    public void setConditionQuantityUnitISOCode( @Nullable final java.lang.String conditionQuantityUnitISOCode )
    {
        rememberChangedField("ConditionQuantityUnitISOCode", this.conditionQuantityUnitISOCode);
        this.conditionQuantityUnitISOCode = conditionQuantityUnitISOCode;
    }

    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>ConditionQuantityUnitSAPCode</b>
     * </p>
     * 
     * @param conditionQuantityUnitSAPCode
     *            Condition Quantity Unit in SAP code
     */
    public void setConditionQuantityUnitSAPCode( @Nullable final java.lang.String conditionQuantityUnitSAPCode )
    {
        rememberChangedField("ConditionQuantityUnitSAPCode", this.conditionQuantityUnitSAPCode);
        this.conditionQuantityUnitSAPCode = conditionQuantityUnitSAPCode;
    }

    /**
     * Constraints: Not nullable, Precision: 24, Scale: 9
     * <p>
     * Original property name from the Odata EDM: <b>ConditionRateRatio</b>
     * </p>
     * 
     * @param conditionRateRatio
     *            The conditionRateRatio to set.
     */
    public void setConditionRateRatio( @Nullable final BigDecimal conditionRateRatio )
    {
        rememberChangedField("ConditionRateRatio", this.conditionRateRatio);
        this.conditionRateRatio = conditionRateRatio;
    }

    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>ConditionRateRatioUnit</b>
     * </p>
     * 
     * @param conditionRateRatioUnit
     *            Percent Sign (Transactional Processing)
     */
    public void setConditionRateRatioUnit( @Nullable final java.lang.String conditionRateRatioUnit )
    {
        rememberChangedField("ConditionRateRatioUnit", this.conditionRateRatioUnit);
        this.conditionRateRatioUnit = conditionRateRatioUnit;
    }

    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>ConditionRateRatioUnitISOCode</b>
     * </p>
     * 
     * @param conditionRateRatioUnitISOCode
     *            Percent Sign in ISO Code
     */
    public void setConditionRateRatioUnitISOCode( @Nullable final java.lang.String conditionRateRatioUnitISOCode )
    {
        rememberChangedField("ConditionRateRatioUnitISOCode", this.conditionRateRatioUnitISOCode);
        this.conditionRateRatioUnitISOCode = conditionRateRatioUnitISOCode;
    }

    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>ConditionRateRatioUnitSAPCode</b>
     * </p>
     * 
     * @param conditionRateRatioUnitSAPCode
     *            Percent Sign in SAP Code
     */
    public void setConditionRateRatioUnitSAPCode( @Nullable final java.lang.String conditionRateRatioUnitSAPCode )
    {
        rememberChangedField("ConditionRateRatioUnitSAPCode", this.conditionRateRatioUnitSAPCode);
        this.conditionRateRatioUnitSAPCode = conditionRateRatioUnitSAPCode;
    }

    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>ConditionTable</b>
     * </p>
     * 
     * @param conditionTable
     *            Condition Table
     */
    public void setConditionTable( @Nullable final java.lang.String conditionTable )
    {
        rememberChangedField("ConditionTable", this.conditionTable);
        this.conditionTable = conditionTable;
    }

    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>ConditionApplication</b>
     * </p>
     * 
     * @param conditionApplication
     *            Application
     */
    public void setConditionApplication( @Nullable final java.lang.String conditionApplication )
    {
        rememberChangedField("ConditionApplication", this.conditionApplication);
        this.conditionApplication = conditionApplication;
    }

    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>ConditionType</b>
     * </p>
     * 
     * @param conditionType
     *            Condition Type
     */
    public void setConditionType( @Nullable final java.lang.String conditionType )
    {
        rememberChangedField("ConditionType", this.conditionType);
        this.conditionType = conditionType;
    }

    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>ConditionCalculationType</b>
     * </p>
     * 
     * @param conditionCalculationType
     *            Calculation Type for Condition
     */
    public void setConditionCalculationType( @Nullable final java.lang.String conditionCalculationType )
    {
        rememberChangedField("ConditionCalculationType", this.conditionCalculationType);
        this.conditionCalculationType = conditionCalculationType;
    }

    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>PricingScaleBasis</b>
     * </p>
     * 
     * @param pricingScaleBasis
     *            Scale Basis Indicator
     */
    public void setPricingScaleBasis( @Nullable final java.lang.String pricingScaleBasis )
    {
        rememberChangedField("PricingScaleBasis", this.pricingScaleBasis);
        this.pricingScaleBasis = pricingScaleBasis;
    }

    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>PricingScaleType</b>
     * </p>
     * 
     * @param pricingScaleType
     *            Scale Type
     */
    public void setPricingScaleType( @Nullable final java.lang.String pricingScaleType )
    {
        rememberChangedField("PricingScaleType", this.pricingScaleType);
        this.pricingScaleType = pricingScaleType;
    }

    @Override
    protected java.lang.String getEntityCollection()
    {
        return "CndnContrConditionRecordScale";
    }

    @Nonnull
    @Override
    protected ODataEntityKey getKey()
    {
        final ODataEntityKey entityKey = super.getKey();
        entityKey.addKeyProperty("ConditionContract", getConditionContract());
        entityKey.addKeyProperty("ConditionRecord", getConditionRecord());
        entityKey.addKeyProperty("ConditionScaleLine", getConditionScaleLine());
        return entityKey;
    }

    @Nonnull
    @Override
    protected Map<java.lang.String, Object> toMapOfFields()
    {
        final Map<java.lang.String, Object> values = super.toMapOfFields();
        values.put("ConditionContract", getConditionContract());
        values.put("ConditionRecord", getConditionRecord());
        values.put("ConditionScaleLine", getConditionScaleLine());
        values.put("ConditionScaleQuantity", getConditionScaleQuantity());
        values.put("ConditionScaleQuantityUnit", getConditionScaleQuantityUnit());
        values.put("CndnScaleQuantityUnitISOCode", getCndnScaleQuantityUnitISOCode());
        values.put("CndnScaleQuantityUnitSAPCode", getCndnScaleQuantityUnitSAPCode());
        values.put("ConditionScaleAmount", getConditionScaleAmount());
        values.put("ConditionScaleAmountCurrency", getConditionScaleAmountCurrency());
        values.put("ConditionRateAmount", getConditionRateAmount());
        values.put("ConditionCurrency", getConditionCurrency());
        values.put("ConditionQuantity", getConditionQuantity());
        values.put("ConditionQuantityUnit", getConditionQuantityUnit());
        values.put("ConditionQuantityUnitISOCode", getConditionQuantityUnitISOCode());
        values.put("ConditionQuantityUnitSAPCode", getConditionQuantityUnitSAPCode());
        values.put("ConditionRateRatio", getConditionRateRatio());
        values.put("ConditionRateRatioUnit", getConditionRateRatioUnit());
        values.put("ConditionRateRatioUnitISOCode", getConditionRateRatioUnitISOCode());
        values.put("ConditionRateRatioUnitSAPCode", getConditionRateRatioUnitSAPCode());
        values.put("ConditionTable", getConditionTable());
        values.put("ConditionApplication", getConditionApplication());
        values.put("ConditionType", getConditionType());
        values.put("ConditionCalculationType", getConditionCalculationType());
        values.put("PricingScaleBasis", getPricingScaleBasis());
        values.put("PricingScaleType", getPricingScaleType());
        return values;
    }

    @Override
    protected void fromMap( final Map<java.lang.String, Object> inputValues )
    {
        final Map<java.lang.String, Object> values = Maps.newHashMap(inputValues);
        // simple properties
        {
            if( values.containsKey("ConditionContract") ) {
                final Object value = values.remove("ConditionContract");
                if( (value == null) || (!value.equals(getConditionContract())) ) {
                    setConditionContract(((java.lang.String) value));
                }
            }
            if( values.containsKey("ConditionRecord") ) {
                final Object value = values.remove("ConditionRecord");
                if( (value == null) || (!value.equals(getConditionRecord())) ) {
                    setConditionRecord(((java.lang.String) value));
                }
            }
            if( values.containsKey("ConditionScaleLine") ) {
                final Object value = values.remove("ConditionScaleLine");
                if( (value == null) || (!value.equals(getConditionScaleLine())) ) {
                    setConditionScaleLine(((java.lang.String) value));
                }
            }
            if( values.containsKey("ConditionScaleQuantity") ) {
                final Object value = values.remove("ConditionScaleQuantity");
                if( (value == null) || (!value.equals(getConditionScaleQuantity())) ) {
                    setConditionScaleQuantity(((BigDecimal) value));
                }
            }
            if( values.containsKey("ConditionScaleQuantityUnit") ) {
                final Object value = values.remove("ConditionScaleQuantityUnit");
                if( (value == null) || (!value.equals(getConditionScaleQuantityUnit())) ) {
                    setConditionScaleQuantityUnit(((java.lang.String) value));
                }
            }
            if( values.containsKey("CndnScaleQuantityUnitISOCode") ) {
                final Object value = values.remove("CndnScaleQuantityUnitISOCode");
                if( (value == null) || (!value.equals(getCndnScaleQuantityUnitISOCode())) ) {
                    setCndnScaleQuantityUnitISOCode(((java.lang.String) value));
                }
            }
            if( values.containsKey("CndnScaleQuantityUnitSAPCode") ) {
                final Object value = values.remove("CndnScaleQuantityUnitSAPCode");
                if( (value == null) || (!value.equals(getCndnScaleQuantityUnitSAPCode())) ) {
                    setCndnScaleQuantityUnitSAPCode(((java.lang.String) value));
                }
            }
            if( values.containsKey("ConditionScaleAmount") ) {
                final Object value = values.remove("ConditionScaleAmount");
                if( (value == null) || (!value.equals(getConditionScaleAmount())) ) {
                    setConditionScaleAmount(((BigDecimal) value));
                }
            }
            if( values.containsKey("ConditionScaleAmountCurrency") ) {
                final Object value = values.remove("ConditionScaleAmountCurrency");
                if( (value == null) || (!value.equals(getConditionScaleAmountCurrency())) ) {
                    setConditionScaleAmountCurrency(((java.lang.String) value));
                }
            }
            if( values.containsKey("ConditionRateAmount") ) {
                final Object value = values.remove("ConditionRateAmount");
                if( (value == null) || (!value.equals(getConditionRateAmount())) ) {
                    setConditionRateAmount(((BigDecimal) value));
                }
            }
            if( values.containsKey("ConditionCurrency") ) {
                final Object value = values.remove("ConditionCurrency");
                if( (value == null) || (!value.equals(getConditionCurrency())) ) {
                    setConditionCurrency(((java.lang.String) value));
                }
            }
            if( values.containsKey("ConditionQuantity") ) {
                final Object value = values.remove("ConditionQuantity");
                if( (value == null) || (!value.equals(getConditionQuantity())) ) {
                    setConditionQuantity(((BigDecimal) value));
                }
            }
            if( values.containsKey("ConditionQuantityUnit") ) {
                final Object value = values.remove("ConditionQuantityUnit");
                if( (value == null) || (!value.equals(getConditionQuantityUnit())) ) {
                    setConditionQuantityUnit(((java.lang.String) value));
                }
            }
            if( values.containsKey("ConditionQuantityUnitISOCode") ) {
                final Object value = values.remove("ConditionQuantityUnitISOCode");
                if( (value == null) || (!value.equals(getConditionQuantityUnitISOCode())) ) {
                    setConditionQuantityUnitISOCode(((java.lang.String) value));
                }
            }
            if( values.containsKey("ConditionQuantityUnitSAPCode") ) {
                final Object value = values.remove("ConditionQuantityUnitSAPCode");
                if( (value == null) || (!value.equals(getConditionQuantityUnitSAPCode())) ) {
                    setConditionQuantityUnitSAPCode(((java.lang.String) value));
                }
            }
            if( values.containsKey("ConditionRateRatio") ) {
                final Object value = values.remove("ConditionRateRatio");
                if( (value == null) || (!value.equals(getConditionRateRatio())) ) {
                    setConditionRateRatio(((BigDecimal) value));
                }
            }
            if( values.containsKey("ConditionRateRatioUnit") ) {
                final Object value = values.remove("ConditionRateRatioUnit");
                if( (value == null) || (!value.equals(getConditionRateRatioUnit())) ) {
                    setConditionRateRatioUnit(((java.lang.String) value));
                }
            }
            if( values.containsKey("ConditionRateRatioUnitISOCode") ) {
                final Object value = values.remove("ConditionRateRatioUnitISOCode");
                if( (value == null) || (!value.equals(getConditionRateRatioUnitISOCode())) ) {
                    setConditionRateRatioUnitISOCode(((java.lang.String) value));
                }
            }
            if( values.containsKey("ConditionRateRatioUnitSAPCode") ) {
                final Object value = values.remove("ConditionRateRatioUnitSAPCode");
                if( (value == null) || (!value.equals(getConditionRateRatioUnitSAPCode())) ) {
                    setConditionRateRatioUnitSAPCode(((java.lang.String) value));
                }
            }
            if( values.containsKey("ConditionTable") ) {
                final Object value = values.remove("ConditionTable");
                if( (value == null) || (!value.equals(getConditionTable())) ) {
                    setConditionTable(((java.lang.String) value));
                }
            }
            if( values.containsKey("ConditionApplication") ) {
                final Object value = values.remove("ConditionApplication");
                if( (value == null) || (!value.equals(getConditionApplication())) ) {
                    setConditionApplication(((java.lang.String) value));
                }
            }
            if( values.containsKey("ConditionType") ) {
                final Object value = values.remove("ConditionType");
                if( (value == null) || (!value.equals(getConditionType())) ) {
                    setConditionType(((java.lang.String) value));
                }
            }
            if( values.containsKey("ConditionCalculationType") ) {
                final Object value = values.remove("ConditionCalculationType");
                if( (value == null) || (!value.equals(getConditionCalculationType())) ) {
                    setConditionCalculationType(((java.lang.String) value));
                }
            }
            if( values.containsKey("PricingScaleBasis") ) {
                final Object value = values.remove("PricingScaleBasis");
                if( (value == null) || (!value.equals(getPricingScaleBasis())) ) {
                    setPricingScaleBasis(((java.lang.String) value));
                }
            }
            if( values.containsKey("PricingScaleType") ) {
                final Object value = values.remove("PricingScaleType");
                if( (value == null) || (!value.equals(getPricingScaleType())) ) {
                    setPricingScaleType(((java.lang.String) value));
                }
            }
        }
        // structured properties
        {
        }
        // navigation properties
        {
            if( (values).containsKey("_CndnContrCndnRecord") ) {
                final Object value = (values).remove("_CndnContrCndnRecord");
                if( value instanceof Map ) {
                    if( to_CndnContrCndnRecord == null ) {
                        to_CndnContrCndnRecord = new CndnContrConditionRecord();
                    }
                    @SuppressWarnings( "unchecked" )
                    final Map<java.lang.String, Object> inputMap = ((Map<java.lang.String, Object>) value);
                    to_CndnContrCndnRecord.fromMap(inputMap);
                }
            }
            if( (values).containsKey("_ConditionContract") ) {
                final Object value = (values).remove("_ConditionContract");
                if( value instanceof Map ) {
                    if( to_ConditionContract == null ) {
                        to_ConditionContract = new ConditionContract();
                    }
                    @SuppressWarnings( "unchecked" )
                    final Map<java.lang.String, Object> inputMap = ((Map<java.lang.String, Object>) value);
                    to_ConditionContract.fromMap(inputMap);
                }
            }
        }
        super.fromMap(values);
    }

    @Override
    protected java.lang.String getDefaultServicePath()
    {
        return ConditionContractService.DEFAULT_SERVICE_PATH;
    }

    @Nonnull
    @Override
    protected Map<java.lang.String, Object> toMapOfNavigationProperties()
    {
        final Map<java.lang.String, Object> values = super.toMapOfNavigationProperties();
        if( to_CndnContrCndnRecord != null ) {
            (values).put("_CndnContrCndnRecord", to_CndnContrCndnRecord);
        }
        if( to_ConditionContract != null ) {
            (values).put("_ConditionContract", to_ConditionContract);
        }
        return values;
    }

    /**
     * Retrieval of associated <b>CndnContrConditionRecord</b> entity (one to one). This corresponds to the OData
     * navigation property <b>_CndnContrCndnRecord</b>.
     * <p>
     * If the navigation property for an entity <b>CndnContrConditionRecordScale</b> has not been resolved yet, this
     * method will <b>not query</b> further information. Instead its <code>Option</code> result state will be
     * <code>empty</code>.
     * 
     * @return If the information for navigation property <b>_CndnContrCndnRecord</b> is already loaded, the result will
     *         contain the <b>CndnContrConditionRecord</b> entity. If not, an <code>Option</code> with result state
     *         <code>empty</code> is returned.
     */
    @Nonnull
    public Option<CndnContrConditionRecord> getCndnContrCndnRecordIfPresent()
    {
        return Option.of(to_CndnContrCndnRecord);
    }

    /**
     * Overwrites the associated <b>CndnContrConditionRecord</b> entity for the loaded navigation property
     * <b>_CndnContrCndnRecord</b>.
     * 
     * @param value
     *            New <b>CndnContrConditionRecord</b> entity.
     */
    public void setCndnContrCndnRecord( final CndnContrConditionRecord value )
    {
        to_CndnContrCndnRecord = value;
    }

    /**
     * Retrieval of associated <b>ConditionContract</b> entity (one to one). This corresponds to the OData navigation
     * property <b>_ConditionContract</b>.
     * <p>
     * If the navigation property for an entity <b>CndnContrConditionRecordScale</b> has not been resolved yet, this
     * method will <b>not query</b> further information. Instead its <code>Option</code> result state will be
     * <code>empty</code>.
     * 
     * @return If the information for navigation property <b>_ConditionContract</b> is already loaded, the result will
     *         contain the <b>ConditionContract</b> entity. If not, an <code>Option</code> with result state
     *         <code>empty</code> is returned.
     */
    @Nonnull
    public Option<ConditionContract> getConditionContractIfPresent()
    {
        return Option.of(to_ConditionContract);
    }

    /**
     * Overwrites the associated <b>ConditionContract</b> entity for the loaded navigation property
     * <b>_ConditionContract</b>.
     * 
     * @param value
     *            New <b>ConditionContract</b> entity.
     */
    public void setConditionContract( final ConditionContract value )
    {
        to_ConditionContract = value;
    }

    /**
     * Helper class to allow for fluent creation of CndnContrConditionRecordScale instances.
     * 
     */
    public final static class CndnContrConditionRecordScaleBuilder
    {

        private CndnContrConditionRecord to_CndnContrCndnRecord;
        private ConditionContract to_ConditionContract;
        private java.lang.String conditionContract = null;

        private CndnContrConditionRecordScale.CndnContrConditionRecordScaleBuilder to_CndnContrCndnRecord(
            final CndnContrConditionRecord value )
        {
            to_CndnContrCndnRecord = value;
            return this;
        }

        /**
         * Navigation property <b>_CndnContrCndnRecord</b> for <b>CndnContrConditionRecordScale</b> to single
         * <b>CndnContrConditionRecord</b>.
         * 
         * @param value
         *            The CndnContrConditionRecord to build this CndnContrConditionRecordScale with.
         * @return This Builder to allow for a fluent interface.
         */
        @Nonnull
        public CndnContrConditionRecordScale.CndnContrConditionRecordScaleBuilder cndnContrCndnRecord(
            final CndnContrConditionRecord value )
        {
            return to_CndnContrCndnRecord(value);
        }

        private CndnContrConditionRecordScale.CndnContrConditionRecordScaleBuilder to_ConditionContract(
            final ConditionContract value )
        {
            to_ConditionContract = value;
            return this;
        }

        /**
         * Navigation property <b>_ConditionContract</b> for <b>CndnContrConditionRecordScale</b> to single
         * <b>ConditionContract</b>.
         * 
         * @param value
         *            The ConditionContract to build this CndnContrConditionRecordScale with.
         * @return This Builder to allow for a fluent interface.
         */
        @Nonnull
        public CndnContrConditionRecordScale.CndnContrConditionRecordScaleBuilder conditionContract(
            final ConditionContract value )
        {
            return to_ConditionContract(value);
        }

        /**
         * (Key Field) Constraints: Not nullable, Maximum length: 10
         * <p>
         * Original property name from the Odata EDM: <b>ConditionContract</b>
         * </p>
         * 
         * @param value
         *            The conditionContract to build this CndnContrConditionRecordScale with.
         * @return This Builder to allow for a fluent interface.
         */
        @Nonnull
        public CndnContrConditionRecordScale.CndnContrConditionRecordScaleBuilder conditionContract(
            final java.lang.String value )
        {
            conditionContract = value;
            return this;
        }

    }

}
