/*
 * Copyright (c) 2021 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odatav4.namespaces.conditioncontract;

import java.time.LocalDate;
import java.util.Map;
import java.util.UUID;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;

import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.google.common.collect.Maps;
import com.google.gson.annotations.JsonAdapter;
import com.sap.cloud.sdk.datamodel.odata.client.request.ODataEntityKey;
import com.sap.cloud.sdk.datamodel.odatav4.core.SimpleProperty;
import com.sap.cloud.sdk.datamodel.odatav4.core.VdmEntity;
import com.sap.cloud.sdk.datamodel.odatav4.core.VdmEntitySet;
import com.sap.cloud.sdk.result.ElementName;
import com.sap.cloud.sdk.s4hana.datamodel.odatav4.services.ConditionContractService;

import io.vavr.control.Option;
import lombok.AccessLevel;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.Getter;
import lombok.NoArgsConstructor;
import lombok.Setter;
import lombok.ToString;

/**
 * Settlement Calendar
 * <p>
 * </p>
 * <p>
 * Original entity name from the Odata EDM: <b>CndnContrSettlementCalendarType</b>
 * </p>
 * 
 */
@Builder
@Data
@NoArgsConstructor
@AllArgsConstructor
@ToString( doNotUseGetters = true, callSuper = true )
@EqualsAndHashCode( doNotUseGetters = true, callSuper = true )
@JsonAdapter( com.sap.cloud.sdk.datamodel.odatav4.adapter.GsonVdmAdapterFactory.class )
@JsonSerialize( using = com.sap.cloud.sdk.datamodel.odatav4.adapter.JacksonVdmObjectSerializer.class )
@JsonDeserialize( using = com.sap.cloud.sdk.datamodel.odatav4.adapter.JacksonVdmObjectDeserializer.class )
public class CndnContrSettlementCalendar extends VdmEntity<CndnContrSettlementCalendar> implements VdmEntitySet
{

    @Getter
    private final java.lang.String odataType =
        "com.sap.gateway.srvd_a2x.api_condition_contract.v0001.CndnContrSettlementCalendarType";
    /**
     * Selector for all available fields of CndnContrSettlementCalendar.
     * 
     */
    public final static SimpleProperty<CndnContrSettlementCalendar> ALL_FIELDS = all();
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>ConditionContract</b>
     * </p>
     * 
     * @return Condition Contract
     */
    @Nullable
    @ElementName( "ConditionContract" )
    private java.lang.String conditionContract;
    public final static SimpleProperty.String<CndnContrSettlementCalendar> CONDITION_CONTRACT =
        new SimpleProperty.String<CndnContrSettlementCalendar>(CndnContrSettlementCalendar.class, "ConditionContract");
    /**
     * (Key Field) Constraints: Not nullable
     * <p>
     * Original property name from the Odata EDM: <b>SettlmtDate</b>
     * </p>
     * 
     * @return Rebates: Settlement Date
     */
    @Nullable
    @ElementName( "SettlmtDate" )
    private LocalDate settlmtDate;
    public final static SimpleProperty.Date<CndnContrSettlementCalendar> SETTLMT_DATE =
        new SimpleProperty.Date<CndnContrSettlementCalendar>(CndnContrSettlementCalendar.class, "SettlmtDate");
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>SettlmtDateCat</b>
     * </p>
     * 
     * @return Rebates: Settlement Date Type
     */
    @Nullable
    @ElementName( "SettlmtDateCat" )
    private java.lang.String settlmtDateCat;
    public final static SimpleProperty.String<CndnContrSettlementCalendar> SETTLMT_DATE_CAT =
        new SimpleProperty.String<CndnContrSettlementCalendar>(CndnContrSettlementCalendar.class, "SettlmtDateCat");
    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>SettlmtDateSequentialID</b>
     * </p>
     * 
     * @return Settlement Date - Sequential ID
     */
    @Nullable
    @ElementName( "SettlmtDateSequentialID" )
    private java.lang.String settlmtDateSequentialID;
    public final static SimpleProperty.String<CndnContrSettlementCalendar> SETTLMT_DATE_SEQUENTIAL_ID =
        new SimpleProperty.String<CndnContrSettlementCalendar>(
            CndnContrSettlementCalendar.class,
            "SettlmtDateSequentialID");
    /**
     * Constraints: Nullable
     * <p>
     * Original property name from the Odata EDM: <b>CndnContrCalItemUUID</b>
     * </p>
     * 
     * @return Condition Contract: Settlement Calendar item GUID
     */
    @Nullable
    @ElementName( "CndnContrCalItemUUID" )
    private UUID cndnContrCalItemUUID;
    public final static SimpleProperty.Guid<CndnContrSettlementCalendar> CNDN_CONTR_CAL_ITEM_UUID =
        new SimpleProperty.Guid<CndnContrSettlementCalendar>(CndnContrSettlementCalendar.class, "CndnContrCalItemUUID");
    /**
     * Constraints: Nullable
     * <p>
     * Original property name from the Odata EDM: <b>RefSettlmtDate</b>
     * </p>
     * 
     * @return Reference Date for a Delta Settlement
     */
    @Nullable
    @ElementName( "RefSettlmtDate" )
    private LocalDate refSettlmtDate;
    public final static SimpleProperty.Date<CndnContrSettlementCalendar> REF_SETTLMT_DATE =
        new SimpleProperty.Date<CndnContrSettlementCalendar>(CndnContrSettlementCalendar.class, "RefSettlmtDate");
    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>RefSettlmtDateSequentialID</b>
     * </p>
     * 
     * @return Reference Settlement Date - Sequential ID
     */
    @Nullable
    @ElementName( "RefSettlmtDateSequentialID" )
    private java.lang.String refSettlmtDateSequentialID;
    public final static SimpleProperty.String<CndnContrSettlementCalendar> REF_SETTLMT_DATE_SEQUENTIAL_ID =
        new SimpleProperty.String<CndnContrSettlementCalendar>(
            CndnContrSettlementCalendar.class,
            "RefSettlmtDateSequentialID");
    /**
     * Constraints: Nullable
     * <p>
     * Original property name from the Odata EDM: <b>SettlmtExecutionDate</b>
     * </p>
     * 
     * @return Settlement Execution Date
     */
    @Nullable
    @ElementName( "SettlmtExecutionDate" )
    private LocalDate settlmtExecutionDate;
    public final static SimpleProperty.Date<CndnContrSettlementCalendar> SETTLMT_EXECUTION_DATE =
        new SimpleProperty.Date<CndnContrSettlementCalendar>(CndnContrSettlementCalendar.class, "SettlmtExecutionDate");
    /**
     * Constraints: Nullable
     * <p>
     * Original property name from the Odata EDM: <b>SettlementFixedValueDate</b>
     * </p>
     * 
     * @return Fixed Value Date
     */
    @Nullable
    @ElementName( "SettlementFixedValueDate" )
    private LocalDate settlementFixedValueDate;
    public final static SimpleProperty.Date<CndnContrSettlementCalendar> SETTLEMENT_FIXED_VALUE_DATE =
        new SimpleProperty.Date<CndnContrSettlementCalendar>(
            CndnContrSettlementCalendar.class,
            "SettlementFixedValueDate");
    /**
     * Constraints: Nullable
     * <p>
     * Original property name from the Odata EDM: <b>BusVolDateFrom</b>
     * </p>
     * 
     * @return Business Volume Date From
     */
    @Nullable
    @ElementName( "BusVolDateFrom" )
    private LocalDate busVolDateFrom;
    public final static SimpleProperty.Date<CndnContrSettlementCalendar> BUS_VOL_DATE_FROM =
        new SimpleProperty.Date<CndnContrSettlementCalendar>(CndnContrSettlementCalendar.class, "BusVolDateFrom");
    /**
     * Constraints: Nullable
     * <p>
     * Original property name from the Odata EDM: <b>BusVolDateTo</b>
     * </p>
     * 
     * @return Business Volume Date To
     */
    @Nullable
    @ElementName( "BusVolDateTo" )
    private LocalDate busVolDateTo;
    public final static SimpleProperty.Date<CndnContrSettlementCalendar> BUS_VOL_DATE_TO =
        new SimpleProperty.Date<CndnContrSettlementCalendar>(CndnContrSettlementCalendar.class, "BusVolDateTo");
    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>SettlmtDateUsage</b>
     * </p>
     * 
     * @return Settlement Date Usage
     */
    @Nullable
    @ElementName( "SettlmtDateUsage" )
    private java.lang.String settlmtDateUsage;
    public final static SimpleProperty.String<CndnContrSettlementCalendar> SETTLMT_DATE_USAGE =
        new SimpleProperty.String<CndnContrSettlementCalendar>(CndnContrSettlementCalendar.class, "SettlmtDateUsage");
    /**
     * Constraints: Nullable
     * <p>
     * Original property name from the Odata EDM: <b>CndnContrSourceCalItemUUID</b>
     * </p>
     * 
     * @return External Calendar GUID
     */
    @Nullable
    @ElementName( "CndnContrSourceCalItemUUID" )
    private UUID cndnContrSourceCalItemUUID;
    public final static SimpleProperty.Guid<CndnContrSettlementCalendar> CNDN_CONTR_SOURCE_CAL_ITEM_UUID =
        new SimpleProperty.Guid<CndnContrSettlementCalendar>(
            CndnContrSettlementCalendar.class,
            "CndnContrSourceCalItemUUID");
    /**
     * Navigation property <b>_ConditionContract</b> for <b>CndnContrSettlementCalendar</b> to single
     * <b>ConditionContract</b>.
     * 
     */
    @ElementName( "_ConditionContract" )
    @Nullable
    @Getter( AccessLevel.NONE )
    @Setter( AccessLevel.NONE )
    private ConditionContract to_ConditionContract;
    /**
     * Use with available request builders to apply the <b>_ConditionContract</b> navigation property to query
     * operations.
     * 
     */
    public final static com.sap.cloud.sdk.datamodel.odatav4.core.NavigationProperty.Single<CndnContrSettlementCalendar, ConditionContract> TO__CONDITION_CONTRACT =
        new com.sap.cloud.sdk.datamodel.odatav4.core.NavigationProperty.Single<CndnContrSettlementCalendar, ConditionContract>(
            CndnContrSettlementCalendar.class,
            "_ConditionContract",
            ConditionContract.class);

    /**
     * {@inheritDoc}
     * 
     */
    @Nonnull
    @Override
    public Class<CndnContrSettlementCalendar> getType()
    {
        return CndnContrSettlementCalendar.class;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>ConditionContract</b>
     * </p>
     * 
     * @param conditionContract
     *            Condition Contract
     */
    public void setConditionContract( @Nullable final java.lang.String conditionContract )
    {
        rememberChangedField("ConditionContract", this.conditionContract);
        this.conditionContract = conditionContract;
    }

    /**
     * (Key Field) Constraints: Not nullable
     * <p>
     * Original property name from the Odata EDM: <b>SettlmtDate</b>
     * </p>
     * 
     * @param settlmtDate
     *            Rebates: Settlement Date
     */
    public void setSettlmtDate( @Nullable final LocalDate settlmtDate )
    {
        rememberChangedField("SettlmtDate", this.settlmtDate);
        this.settlmtDate = settlmtDate;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>SettlmtDateCat</b>
     * </p>
     * 
     * @param settlmtDateCat
     *            Rebates: Settlement Date Type
     */
    public void setSettlmtDateCat( @Nullable final java.lang.String settlmtDateCat )
    {
        rememberChangedField("SettlmtDateCat", this.settlmtDateCat);
        this.settlmtDateCat = settlmtDateCat;
    }

    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>SettlmtDateSequentialID</b>
     * </p>
     * 
     * @param settlmtDateSequentialID
     *            Settlement Date - Sequential ID
     */
    public void setSettlmtDateSequentialID( @Nullable final java.lang.String settlmtDateSequentialID )
    {
        rememberChangedField("SettlmtDateSequentialID", this.settlmtDateSequentialID);
        this.settlmtDateSequentialID = settlmtDateSequentialID;
    }

    /**
     * Constraints: Nullable
     * <p>
     * Original property name from the Odata EDM: <b>CndnContrCalItemUUID</b>
     * </p>
     * 
     * @param cndnContrCalItemUUID
     *            Condition Contract: Settlement Calendar item GUID
     */
    public void setCndnContrCalItemUUID( @Nullable final UUID cndnContrCalItemUUID )
    {
        rememberChangedField("CndnContrCalItemUUID", this.cndnContrCalItemUUID);
        this.cndnContrCalItemUUID = cndnContrCalItemUUID;
    }

    /**
     * Constraints: Nullable
     * <p>
     * Original property name from the Odata EDM: <b>RefSettlmtDate</b>
     * </p>
     * 
     * @param refSettlmtDate
     *            Reference Date for a Delta Settlement
     */
    public void setRefSettlmtDate( @Nullable final LocalDate refSettlmtDate )
    {
        rememberChangedField("RefSettlmtDate", this.refSettlmtDate);
        this.refSettlmtDate = refSettlmtDate;
    }

    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>RefSettlmtDateSequentialID</b>
     * </p>
     * 
     * @param refSettlmtDateSequentialID
     *            Reference Settlement Date - Sequential ID
     */
    public void setRefSettlmtDateSequentialID( @Nullable final java.lang.String refSettlmtDateSequentialID )
    {
        rememberChangedField("RefSettlmtDateSequentialID", this.refSettlmtDateSequentialID);
        this.refSettlmtDateSequentialID = refSettlmtDateSequentialID;
    }

    /**
     * Constraints: Nullable
     * <p>
     * Original property name from the Odata EDM: <b>SettlmtExecutionDate</b>
     * </p>
     * 
     * @param settlmtExecutionDate
     *            Settlement Execution Date
     */
    public void setSettlmtExecutionDate( @Nullable final LocalDate settlmtExecutionDate )
    {
        rememberChangedField("SettlmtExecutionDate", this.settlmtExecutionDate);
        this.settlmtExecutionDate = settlmtExecutionDate;
    }

    /**
     * Constraints: Nullable
     * <p>
     * Original property name from the Odata EDM: <b>SettlementFixedValueDate</b>
     * </p>
     * 
     * @param settlementFixedValueDate
     *            Fixed Value Date
     */
    public void setSettlementFixedValueDate( @Nullable final LocalDate settlementFixedValueDate )
    {
        rememberChangedField("SettlementFixedValueDate", this.settlementFixedValueDate);
        this.settlementFixedValueDate = settlementFixedValueDate;
    }

    /**
     * Constraints: Nullable
     * <p>
     * Original property name from the Odata EDM: <b>BusVolDateFrom</b>
     * </p>
     * 
     * @param busVolDateFrom
     *            Business Volume Date From
     */
    public void setBusVolDateFrom( @Nullable final LocalDate busVolDateFrom )
    {
        rememberChangedField("BusVolDateFrom", this.busVolDateFrom);
        this.busVolDateFrom = busVolDateFrom;
    }

    /**
     * Constraints: Nullable
     * <p>
     * Original property name from the Odata EDM: <b>BusVolDateTo</b>
     * </p>
     * 
     * @param busVolDateTo
     *            Business Volume Date To
     */
    public void setBusVolDateTo( @Nullable final LocalDate busVolDateTo )
    {
        rememberChangedField("BusVolDateTo", this.busVolDateTo);
        this.busVolDateTo = busVolDateTo;
    }

    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>SettlmtDateUsage</b>
     * </p>
     * 
     * @param settlmtDateUsage
     *            Settlement Date Usage
     */
    public void setSettlmtDateUsage( @Nullable final java.lang.String settlmtDateUsage )
    {
        rememberChangedField("SettlmtDateUsage", this.settlmtDateUsage);
        this.settlmtDateUsage = settlmtDateUsage;
    }

    /**
     * Constraints: Nullable
     * <p>
     * Original property name from the Odata EDM: <b>CndnContrSourceCalItemUUID</b>
     * </p>
     * 
     * @param cndnContrSourceCalItemUUID
     *            External Calendar GUID
     */
    public void setCndnContrSourceCalItemUUID( @Nullable final UUID cndnContrSourceCalItemUUID )
    {
        rememberChangedField("CndnContrSourceCalItemUUID", this.cndnContrSourceCalItemUUID);
        this.cndnContrSourceCalItemUUID = cndnContrSourceCalItemUUID;
    }

    @Override
    protected java.lang.String getEntityCollection()
    {
        return "CndnContrSettlementCalendar";
    }

    @Nonnull
    @Override
    protected ODataEntityKey getKey()
    {
        final ODataEntityKey entityKey = super.getKey();
        entityKey.addKeyProperty("ConditionContract", getConditionContract());
        entityKey.addKeyProperty("SettlmtDate", getSettlmtDate());
        entityKey.addKeyProperty("SettlmtDateCat", getSettlmtDateCat());
        return entityKey;
    }

    @Nonnull
    @Override
    protected Map<java.lang.String, Object> toMapOfFields()
    {
        final Map<java.lang.String, Object> values = super.toMapOfFields();
        values.put("ConditionContract", getConditionContract());
        values.put("SettlmtDate", getSettlmtDate());
        values.put("SettlmtDateCat", getSettlmtDateCat());
        values.put("SettlmtDateSequentialID", getSettlmtDateSequentialID());
        values.put("CndnContrCalItemUUID", getCndnContrCalItemUUID());
        values.put("RefSettlmtDate", getRefSettlmtDate());
        values.put("RefSettlmtDateSequentialID", getRefSettlmtDateSequentialID());
        values.put("SettlmtExecutionDate", getSettlmtExecutionDate());
        values.put("SettlementFixedValueDate", getSettlementFixedValueDate());
        values.put("BusVolDateFrom", getBusVolDateFrom());
        values.put("BusVolDateTo", getBusVolDateTo());
        values.put("SettlmtDateUsage", getSettlmtDateUsage());
        values.put("CndnContrSourceCalItemUUID", getCndnContrSourceCalItemUUID());
        return values;
    }

    @Override
    protected void fromMap( final Map<java.lang.String, Object> inputValues )
    {
        final Map<java.lang.String, Object> values = Maps.newHashMap(inputValues);
        // simple properties
        {
            if( values.containsKey("ConditionContract") ) {
                final Object value = values.remove("ConditionContract");
                if( (value == null) || (!value.equals(getConditionContract())) ) {
                    setConditionContract(((java.lang.String) value));
                }
            }
            if( values.containsKey("SettlmtDate") ) {
                final Object value = values.remove("SettlmtDate");
                if( (value == null) || (!value.equals(getSettlmtDate())) ) {
                    setSettlmtDate(((LocalDate) value));
                }
            }
            if( values.containsKey("SettlmtDateCat") ) {
                final Object value = values.remove("SettlmtDateCat");
                if( (value == null) || (!value.equals(getSettlmtDateCat())) ) {
                    setSettlmtDateCat(((java.lang.String) value));
                }
            }
            if( values.containsKey("SettlmtDateSequentialID") ) {
                final Object value = values.remove("SettlmtDateSequentialID");
                if( (value == null) || (!value.equals(getSettlmtDateSequentialID())) ) {
                    setSettlmtDateSequentialID(((java.lang.String) value));
                }
            }
            if( values.containsKey("CndnContrCalItemUUID") ) {
                final Object value = values.remove("CndnContrCalItemUUID");
                if( (value == null) || (!value.equals(getCndnContrCalItemUUID())) ) {
                    setCndnContrCalItemUUID(((UUID) value));
                }
            }
            if( values.containsKey("RefSettlmtDate") ) {
                final Object value = values.remove("RefSettlmtDate");
                if( (value == null) || (!value.equals(getRefSettlmtDate())) ) {
                    setRefSettlmtDate(((LocalDate) value));
                }
            }
            if( values.containsKey("RefSettlmtDateSequentialID") ) {
                final Object value = values.remove("RefSettlmtDateSequentialID");
                if( (value == null) || (!value.equals(getRefSettlmtDateSequentialID())) ) {
                    setRefSettlmtDateSequentialID(((java.lang.String) value));
                }
            }
            if( values.containsKey("SettlmtExecutionDate") ) {
                final Object value = values.remove("SettlmtExecutionDate");
                if( (value == null) || (!value.equals(getSettlmtExecutionDate())) ) {
                    setSettlmtExecutionDate(((LocalDate) value));
                }
            }
            if( values.containsKey("SettlementFixedValueDate") ) {
                final Object value = values.remove("SettlementFixedValueDate");
                if( (value == null) || (!value.equals(getSettlementFixedValueDate())) ) {
                    setSettlementFixedValueDate(((LocalDate) value));
                }
            }
            if( values.containsKey("BusVolDateFrom") ) {
                final Object value = values.remove("BusVolDateFrom");
                if( (value == null) || (!value.equals(getBusVolDateFrom())) ) {
                    setBusVolDateFrom(((LocalDate) value));
                }
            }
            if( values.containsKey("BusVolDateTo") ) {
                final Object value = values.remove("BusVolDateTo");
                if( (value == null) || (!value.equals(getBusVolDateTo())) ) {
                    setBusVolDateTo(((LocalDate) value));
                }
            }
            if( values.containsKey("SettlmtDateUsage") ) {
                final Object value = values.remove("SettlmtDateUsage");
                if( (value == null) || (!value.equals(getSettlmtDateUsage())) ) {
                    setSettlmtDateUsage(((java.lang.String) value));
                }
            }
            if( values.containsKey("CndnContrSourceCalItemUUID") ) {
                final Object value = values.remove("CndnContrSourceCalItemUUID");
                if( (value == null) || (!value.equals(getCndnContrSourceCalItemUUID())) ) {
                    setCndnContrSourceCalItemUUID(((UUID) value));
                }
            }
        }
        // structured properties
        {
        }
        // navigation properties
        {
            if( (values).containsKey("_ConditionContract") ) {
                final Object value = (values).remove("_ConditionContract");
                if( value instanceof Map ) {
                    if( to_ConditionContract == null ) {
                        to_ConditionContract = new ConditionContract();
                    }
                    @SuppressWarnings( "unchecked" )
                    final Map<java.lang.String, Object> inputMap = ((Map<java.lang.String, Object>) value);
                    to_ConditionContract.fromMap(inputMap);
                }
            }
        }
        super.fromMap(values);
    }

    @Override
    protected java.lang.String getDefaultServicePath()
    {
        return ConditionContractService.DEFAULT_SERVICE_PATH;
    }

    @Nonnull
    @Override
    protected Map<java.lang.String, Object> toMapOfNavigationProperties()
    {
        final Map<java.lang.String, Object> values = super.toMapOfNavigationProperties();
        if( to_ConditionContract != null ) {
            (values).put("_ConditionContract", to_ConditionContract);
        }
        return values;
    }

    /**
     * Retrieval of associated <b>ConditionContract</b> entity (one to one). This corresponds to the OData navigation
     * property <b>_ConditionContract</b>.
     * <p>
     * If the navigation property for an entity <b>CndnContrSettlementCalendar</b> has not been resolved yet, this
     * method will <b>not query</b> further information. Instead its <code>Option</code> result state will be
     * <code>empty</code>.
     * 
     * @return If the information for navigation property <b>_ConditionContract</b> is already loaded, the result will
     *         contain the <b>ConditionContract</b> entity. If not, an <code>Option</code> with result state
     *         <code>empty</code> is returned.
     */
    @Nonnull
    public Option<ConditionContract> getConditionContractIfPresent()
    {
        return Option.of(to_ConditionContract);
    }

    /**
     * Overwrites the associated <b>ConditionContract</b> entity for the loaded navigation property
     * <b>_ConditionContract</b>.
     * 
     * @param value
     *            New <b>ConditionContract</b> entity.
     */
    public void setConditionContract( final ConditionContract value )
    {
        to_ConditionContract = value;
    }

    /**
     * Helper class to allow for fluent creation of CndnContrSettlementCalendar instances.
     * 
     */
    public final static class CndnContrSettlementCalendarBuilder
    {

        private ConditionContract to_ConditionContract;
        private java.lang.String conditionContract = null;

        private CndnContrSettlementCalendar.CndnContrSettlementCalendarBuilder to_ConditionContract(
            final ConditionContract value )
        {
            to_ConditionContract = value;
            return this;
        }

        /**
         * Navigation property <b>_ConditionContract</b> for <b>CndnContrSettlementCalendar</b> to single
         * <b>ConditionContract</b>.
         * 
         * @param value
         *            The ConditionContract to build this CndnContrSettlementCalendar with.
         * @return This Builder to allow for a fluent interface.
         */
        @Nonnull
        public CndnContrSettlementCalendar.CndnContrSettlementCalendarBuilder conditionContract(
            final ConditionContract value )
        {
            return to_ConditionContract(value);
        }

        /**
         * (Key Field) Constraints: Not nullable, Maximum length: 10
         * <p>
         * Original property name from the Odata EDM: <b>ConditionContract</b>
         * </p>
         * 
         * @param value
         *            The conditionContract to build this CndnContrSettlementCalendar with.
         * @return This Builder to allow for a fluent interface.
         */
        @Nonnull
        public CndnContrSettlementCalendar.CndnContrSettlementCalendarBuilder conditionContract(
            final java.lang.String value )
        {
            conditionContract = value;
            return this;
        }

    }

}
